<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Bank;
use App\Models\Company;
use Illuminate\Support\Facades\Hash;

class BankController extends Controller {
    /**
    * Create a new controller instance.
    *
    * @return void
    */

    public function __construct() {
        $this->middleware( 'auth' );
    }

    /**
    * Show the application dashboard.
    *
    * @return \Illuminate\Contracts\Support\Renderable
    */

    public function index() {
        $banks = Bank::limit( 10 )
        ->get();
        //  dd( $vendors );
        return view( 'banks.index', compact( 'banks' ) );
    }

    public function create() {
        $companies = Company::orderBy( 'companyName' )->get();
        return view( 'banks.create', compact( 'companies' ) );
    }

    public function store( Request $request ) {

        $bank = new Bank();
        $bank->bankAccountTitle = $request->bankAccountTitle;
        $bank->bankAccountNo = $request->bankAccountNo;
        $bank->bankAba = $request->bankAba;
        $bank->bankSwift = $request->bankSwift;
        $bank->bankStatus = true;
        $bank->bankCompanyId = $request->bankCompanyId;
        $bank->bankName = $request->bankName;
        $bank->bankAddress = $request->bankAddress;
        $bank->save();

        if ( $bank ) {
            return redirect()->back()->with( 'success', 'Bank Saved Successfully.' );

        } else {
            return Redirect::back()->withErrors( [ 'msg' => 'There was some problem.' ] );
        }

    }

    public function edit( $id ) {
        $bank = Bank::find( $id );
        $companies = Company::orderBy( 'companyName' )->get();
        return view( 'banks.edit', compact( 'bank', 'companies' ) );
    }

    public function update( Request $request, $id ) {
        // dd( $request->all() );
        // Find the Customer
        $bank = Bank::find( $id );

        // Updating the Customer
        $bank->update( [
            'bankAccountTitle' => $request->bankAccountTitle,
            'bankAccountNo' => $request->bankAccountNo,
            'bankAba' => $request->bankAba,
            'bankSwift' => $request->bankSwift,
            'bankCompanyId' => $request->bankCompanyId,
            'bankName' => $request->bankName,
            'bankAddress' => $request->bankAddress,
        ] );

        // confirm message
        $request->session()->flash( 'msg', 'Bank has been updated' );

        // Redirect
        return redirect()->route( 'bank.index' );

    }


}
