<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Customer;
use App\Models\Country;
use App\Models\Company;
use Illuminate\Support\Facades\Hash;

class CompanyController extends Controller {

    use Traits\Functions;
    /**
    * Create a new controller instance.
    *
    * @return void
    */

    public function __construct() {
        $this->middleware( 'auth' );
    }

    /**
    * Show the application dashboard.
    *
    * @return \Illuminate\Contracts\Support\Renderable
    */

    public function index() {
      
        $companies = Company::orderBy('companyId', 'desc')->paginate(30);

        return view( 'companies.index', compact( 'companies' ) );
    }

    public function create() {

        $countries = Country::all();
        $businessTypes   = $this->companyBusinessType();
        return view('companies.create', compact( 'countries', 'businessTypes'));
    }

    public function store( Request $request ) {
     
        // dd( $hashedPassword );

        $company = new Company();
        $company->companyName = $request->companyName;
        $company->companyLogo = $request->companyLogo;
        $company->companyUrl = $request->companyUrl;
        $company->companyAddress = $request->companyAddress;
        $company->companyPhone = $request->companyPhone;
        $company->companyPrefix = $request->companyPrefix;
        $company->companyColorCode = $request->companyColorCode;
        $company->companyCurrency = $request->companyCurrency;
        $company->companyBusinessType = $request->companyBusinessType;
        $company->companyCountryId = $request->companyCountryId;
        $company->companyInvoiceText = $request->companyInvoiceText;
        $company->save();

        if ( $company ) {
            return redirect()->back()->with( 'success', 'Company Saved Successfully.' );

        } else {
            return redirect()->back()->withErrors(['msg' => 'There was some problem.']);
        }

    }

    public function edit( $id ) {
        
    
        $company = Company::find( $id );
        $countries = Country::all();
        $businessTypes   = $this->companyBusinessType();
        return view('companies.edit', compact('company', 'countries', 'businessTypes'));
    }

    public function update( Request $request, $id ) {
//         dd( $request->all() );
        // Find the Company
        $customer = Company::find( $id );

        // Updating the Customer
        $customer->update( [
            'companyName' => $request->companyName,
            'companyLogo' => $request->companyLogo,
            'companyUrl' => $request->companyUrl,
            'companyAddress' => $request->companyAddress,
            'companyPhone' => $request->companyPhone,
            'companyPrefix' => $request->companyPrefix,
            'companyColorCode' => $request->companyColorCode,
            'companyCurrency' => $request->companyCurrency,
            'companyBusinessType' => $request->companyBusinessType,
            'companyCountryId' => $request->companyCountryId,
            'companyInvoiceText' => $request->companyInvoiceText,
        ] );

        // confirm message
        $request->session()->flash( 'msg', 'Company has been updated' );

        // Redirect
        return redirect()->back();

    }


    public function admin_companies()
    {
        $companies = Company::all();
        return view('partials.companies', compact('companies'));
    }

}
