<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

use App\Models\CreditCards\CcApplication;

use App\Models\CreditCards\CcAuth;
use App\Models\CreditCards\CcAttachment;


use App\Models\Customer;

use Illuminate\Support\Facades\Hash;

class CreditApplicationController extends Controller {

    /**
    * Create a new controller instance.
    *
    * @return void
    */

    public function __construct() {
        $this->middleware( 'auth' );
    }

    /**
    * Show the application dashboard.
    *
    * @return \Illuminate\Contracts\Support\Renderable
    */

    public function applications_index() {
      
 
   
        $links = CcApplication::latest()->paginate(30);
        return view('credit-cards.applications', compact('links'));
    }

    public function application_view($slug) {
      
        $customerForm = CcApplication::where('slug', $slug)->first();
        return view('credit-cards.credit-card.index', compact(
            'customerForm','slug'
        ));
    }


    
    public function create_company_link( Request $request ) {
     
        $theslug = \Str::slug($request->companyName);


        $link = new CcApplication();
        $link->companyName = $request->companyName;
        $link->slug = \Str::slug($request->companyName);
        $link->companyId = auth()->user()->userCompanyId;
        $link->createdUserId = auth()->user()->userId;
        
        $link->save();

        if ($link) {
           // return redirect()->back()->with( 'success', 'Link Saved Successfully.' );
           return redirect()->to('http://localhost:7000/credit-card-form/'. $theslug);

        } else {
            return redirect()->back()->withErrors(['msg' => 'There was some problem.']);
        }

    }

    public function store( Request $request ) {
     


        $company = new CcApplication();
        
        $company->companyName = $request->companyName;

        $section_one['companyLogo'] = $request->companyLogo;
        $section_one['companyUrl'] = $request->companyUrl;
        $section_one['companyAddress'] = $request->companyAddress;
        $section_one['companyPhone'] = $request->companyPhone;
        $section_one['companyPrefix'] = $request->companyPrefix;
        $section_one['companyColorCode'] = $request->companyColorCode;
        $section_one['companyCurrency'] = $request->companyCurrency;
        $section_one['companyBusinessType'] = $request->companyBusinessType;
        $section_one['companyCountryId'] = $request->companyCountryId;
        $section_one['companyInvoiceText'] = $request->companyInvoiceText;
        $company->save();

        if ( $company ) {
            return redirect()->back()->with( 'success', 'Company Saved Successfully.' );

        } else {
            return redirect()->back()->withErrors(['msg' => 'There was some problem.']);
        }

    }

    public function authorizations_index() {
      
        $links = CcAuth::latest()->paginate(30);
        return view('credit-cards.authorizations', compact('links'));
    }

   

    
    public function create_authorization_link( Request $request ) {
     
        
        $theslug = \Str::slug($request->companyName);
        $link = new CcAuth();
        $link->companyName = $request->companyName;
        $link->slug = \Str::slug($request->companyName);
        $link->companyId = auth()->user()->userCompanyId;
        $link->createdUserId = auth()->user()->userId;
        
        $link->save();

        if ($link) {
           // return redirect()->back()->with( 'success', 'Link Saved Successfully.' );
           return redirect()->to('http://localhost:7000/credit-card-form/'. $theslug);


        } else {
            return redirect()->back()->withErrors(['msg' => 'There was some problem.']);
        }

    }

    public function store_contact( Request $request, $slug) {

        $request_user = CcApplication::where('slug', $slug)->first();
   
      

        $section_five = json_decode($request_user->ccaSectionFive);
        $principalEmail = $section_five->principalEmail;
        $request_email = Customer::where('email', $principalEmail)->exists();
        if($request_email){
            return redirect()->back()->with( 'error', 'Customer Already Exists' );

        }
        $contact = new Customer();
        $contact->email = $section_five->principalEmail;
        $contact->firstName = $section_five->principalName;
        $contact->lastName = $section_five->principalName;
        $contact->userCompany = $request_user->companyName;
        $contact->userFax = $request_user->userContactFax;
        $contact->assign_limit = $request->assign_limit;
        
        $contact->password = Hash::make('12345678');
        $contact->typeId = 4;
        $contact->userCompanyId = auth()->user()->userCompanyId;
        $contact->userIsActive = true;
        $contact->gender = 'M';

        $contact->userCreatedUserId = auth()->user()->userId;
      
       
        $contact->save();

        return redirect()->back()->with( 'success', ' Saved Successfully.' );


    }


    public function authorizations_attchments($slug) {
      
        $links = CcAttachment::latest()->paginate(5);
        return view('credit-cards.attachments', compact('links'));
    }
    
}
