<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Customer;
use App\Models\Country;
use App\Models\State;
use App\Models\Receivable;
use App\Models\UserAddress;
use App\Models\UserContact;
use App\Models\UserCard;
use App\Models\Deal;
use App\Models\Invoice;

use DB;
use Illuminate\Support\Facades\Hash;

class CustomerController extends Controller {
    /**
    * Create a new controller instance.
    *
    * @return void
    */
    use Traits\Functions;

    public function __construct() {
        $this->middleware( 'auth' );
    }

    /**
    * Show the application dashboard.
    *
    * @return \Illuminate\Contracts\Support\Renderable
    */

    public function index() {
      
        $customers = Customer::where( 'userType', '=', 'user')
        ->where('userCompanyId', auth()->user()->company->companyId)
        ->latest()
        ->paginate(30);
        return view( 'customers.index', compact( 'customers' ) );
    }

    public function create() {
       
        return view( 'customers.create');
    }

    public function store( Request $request ) {

        
        $hashedPassword = Hash::make('12345678');
        // dd( $hashedPassword );
        $countryId = $request->userCountry;
        $stateId = $request->userState;
        $country = Country::select('countryName')->where('countryId', '=', $countryId)->first();
        $state = State::select('stateName')->where('stateId', '=', $stateId)->first();
        $customer = new Customer();
        
        $customer->firstName = 'NA';
        $customer->lastName = 'NA';
        $customer->userCompany = $request->userCompany;
        $customer->userAddress = $request->userAddress;
        $customer->userType = 'user';
        
        // future convert name to id for normalization
        $customer->userCity = $request->userCity;
        $customer->userState = $state->stateName;
        $customer->userCountry = $country->countryName;
        $customer->userPostalCode = $request->userPostalCode;
        $customer->email = $request->email;
        $customer->phone = $request->phone;
        $customer->phone2 = $request->phone2;
        $customer->userWebsite = $request->userWebsite;
        $customer->userFax = $request->userFax;
        $customer->password = $hashedPassword;
        $customer->typeId = 4;
        $customer->userCompanyId = auth()->user()->userCompanyId;
        $customer->userIsActive = true;
        $customer->save();

        if ( $customer ) {
            
            return redirect()->route('customer.edit', $customer->userId);



        } else {
            return redirect()->back()->withErrors(['msg' => 'There was some problem.']);
        }

    }

    public function edit( $id ) {
        
    
        $customer = Customer::find( $id );
        $states = State::where('stateCountryId', auth()->user()->company->companyCountryId)->orderBy( 'stateName' )->get();
        $termTermsList   = $this->termTermsList();
        return view( 'customers.edit', compact( 'customer', 'states' ,'termTermsList') );
    }

    public function update( Request $request, $id ) {
        // dd( $request->all() );
        // Find the Customer
        $countryId = $request->userCountry;
        $stateId = $request->userState;
        $country = Country::select('countryName')->where('countryId', '=', $countryId)->first();
        $state = State::select('stateName')->where('stateId', '=', $stateId)->first();

        $customer = Customer::find( $id );

        // Updating the Customer
        $customer->update( [

            'phone' => $request->phone,
            'email' => $request->email,
            'userAddress' => $request->userAddress,
            'userCity' => $request->userCity,
            'userState' => $request->userState,
            'userPostalCode' => $request->userPostalCode,
            'userCompany' => $request->userCompany,
            'userAddress' => $request->userAddress,
            'userWebsite' => $request->userWebsite,
            'userFax' => $request->userFax,
            // future convert name to id for normalization
            'userCity' => $country->countryName,
            'userState' => $state->stateName,
            'userPostalCode' => $request->userPostalCode,
            'email' => $request->email,
            'phone' => $request->phone,
            'phone2' => $request->phone2,
        


        ] );

        // confirm message
        $request->session()->flash( 'msg', 'Customer has been updated' );

        // Redirect
        return redirect()->back();

    }

    public function existingCustomerSearch( Request $request ) {
        $customers = Customer::selectRaw( 'userId, email, firstName, lastName, userCompany, userAddress, userCity, userState, userPostalCode, userCountry, phone' )
        ->where( 'userCompany', 'LIKE', "%{$request->existing_customer_query}%" )
        ->where('userCompanyId', auth()->user()->company->companyId)
        ->take( 5 )
        ->get();
        // dd( $customers );
        echo json_encode( $customers );
    }

    public function getCustomerDetails( Request $request ) {
        $customers = Customer::selectRaw( 'userId, email, firstName, lastName, userCompany, userAddress, userCity, userState, userPostalCode, userCountry, phone' )
        ->where( 'userId', $request->customer_id )
        ->first();
        // dd( $customers );
        echo json_encode( $customers );
    }

    public function customerRemainingLimit( Request $request ) {
        $customerReceivable = Receivable::where( 'receivableCustomer', $request->customer_id )->sum( 'receivableTotal' );
        echo json_encode( $customerReceivable );
    }

    public function customerOrdersLimit( Request $request ) {

        $customerReceivable = Receivable::where( 'receivableCustomer', $request->customer_id )->sum( 'receivableTotal' );

        echo json_encode( $customerReceivable );
    }

  
    public function customer_contacts($customerid) {
      
        $contacts = UserContact::where('userContactCustomerId', '=', $customerid)
                                ->where('userContactCompanyId', auth()->user()->company->companyId)
                                ->orderBy('userContactId', 'desc')
                                ->get();
     
        return view( 'customers.partials.contacts', compact( 'contacts' ) );
    }


    public function store_contact( Request $request, $id) {

     

        $contact = new UserContact();
        $contact->userContactEmail = $request->userContactEmail;
        $contact->userContactFirstName = $request->userContactFirstName;
        $contact->userContactLastName = $request->userContactLastName;
        $contact->userContactCompany = $request->userContactCompany;
        $contact->userContactTitle = $request->userContactTitle;
        $contact->userContactPhone = $request->userContactPhone;
        $contact->userContactPhone2 = $request->userContactPhone2;
        $contact->userContactFax = $request->userContactFax;
        $contact->userContactGender = $request->userContactGender;
        $contact->userContactCompanyId = auth()->user()->userCompanyId;
        $contact->userContactCreatedUserId = auth()->user()->userId;
        $contact->userContactIsActive = true;
        $contact->userContactCustomerId = $id;
        $contact->save();

        if($contact) {
            return response()->json([
                'type' => 'success',
                'msg' => 'User Contact created successfully.',
            ]);
        } else {
            return response()->json([
                'type' => 'error',
                'msg' => 'There was an error. Please try again.',
            ]);
        }

    }
     
  
    public function customer_addresses($customerid) {
      
        $addresses = UserAddress::where( 'userAddressCustomerId', '=', $customerid)->where('userAddressCompanyId', auth()->user()->company->companyId)->get();
     
        return view( 'customers.partials.address', compact( 'addresses' ) );
    }

    
    public function store_address( Request $request, $id) {

        
      

        $address = new UserAddress();
        $address->userAddressLine1 = $request->userAddressLine1;
        $address->userAddressLine2 = $request->userAddressLine2;
        
        $address->userAddressCountry = $request->userAddressCountry;

        $address->userAddressCity = $request->userAddressCity;
        $address->userAddressState = $request->userAddressState;
        $address->userAddressZip = $request->userAddressZip;
 
        $address->userAddressTax = $request->userAddressTax;
        $address->userAddressCompanyId = auth()->user()->userCompanyId;
        $address->userAddressCreatedUserId = auth()->user()->userId;
        $address->userAddressIsActive = true;
        $address->userAddressCustomerId = $id;
        $address->save();

        if($address) {
            return response()->json([
                'type' => 'success',
                'msg' => 'User Address created successfully.',
            ]);
        } else {
            return response()->json([
                'type' => 'error',
                'msg' => 'There was an error. Please try again.',
            ]);
        }

    }

    public function address_edit($addressId) {
      
        $address = UserAddress::where('userAddressId', '=', $addressId)->first();
     
        return view( 'customers.edit.address', compact('address'));
    }


    public function address_update( Request $request, $id ) {
     
        // Find the Customer
        $customer = UserAddress::where('userAddressId', '=', $id)->first();;

        // Updating the Customer
        $customer->update( [
            'userAddressLine1' => $request->userAddressLine1,
            'userAddressLine2' => $request->userAddressLine2,
            'userAddressCountry' => $request->userAddressCountry,
            'userAddressState' => $request->userAddressState,
            'userAddressCity' => $request->userAddressCity,
            'userAddressZip' => $request->userAddressZip,
            'userAddressTax' => $request->userAddressTax
        ] );

        // confirm message
        $request->session()->flash( 'msg', 'Address has been updated' );

        // Redirect
        return redirect()->back();

    }

    
    public function contact_edit($contactId) {
      
        $contact = UserContact::where('userContactId', '=', $contactId)->first();
        return view( 'customers.edit.contact', compact('contact'));
    }


    public function contact_update( Request $request, $id ) {
     
        // Find the UserContact
       
        $customer = UserContact::where('userContactId', '=', $id)->first();;

        // Updating the Customer
        $customer->update( [
            'userContactEmail' => $request->userContactEmail,
            'userContactFirstName' => $request->userContactFirstName,
            'userContactLastName' => $request->userContactLastName,
            'userContactCompany' => $request->userContactCompany,
            'userContactTitle' => $request->userContactTitle,
            'userContactPhone' => $request->userContactPhone,
            'userContactPhone2' => $request->userContactPhone2,
            'userContactGender' => $request->userContactGender,
            'userContactFax' => $request->userContactFax,
        ] );

        // confirm message
        $request->session()->flash('success', 'User Contact has been updated' );

        // Redirect
        return redirect()->back();

    }
    public function customer_payment_update( Request $request, $id ) {
     
      
       
        $payment = UserCard::where('userCardId', '=', $id)->first();;

        $payment->userCardHolderName = $request->userCardHolderName;
        $payment->userCardNo = $request->userCardNo ? $request->userCardNo : $request->userCardPaymentMethod;
        $payment->userCardPaymentMethod = $request->userCardPaymentMethod;
        $payment->userCardCountry = $request->userCardCountry;
        $payment->userCardState = $request->userCardState;
        $payment->userCardCity = $request->userCardCity;
        $payment->userCardAddress1 = $request->userCardAddress1;
        $payment->userCardAddress2 = $request->userCardAddress2;
        $payment->userCardZip = $request->userCardZip;
        $payment->userCardPayable = $request->userCardPayable;
        $payment->userCardEmail = $request->userCardEmail;
        $payment->userCardPhone = $request->userCardPhone;
        $payment->userCardLimit = $request->userCardLimit;
        $payment->userCardExpireMonth = $request->userCardExpireMonth;
        $payment->userCardExpireYear = $request->userCardExpireYear;
        $payment->update();

  
        // confirm message
        $request->session()->flash('success', 'User Payment  has been updated' );

        // Redirect
        return redirect()->back();

    }
    
    public function customer_cards($customerid) {
      
        $cards = UserCard::where('userCardCustomerId', '=', $customerid)->get();
     
        return view( 'customers.partials.payments', compact( 'cards' ) );
    }

     
    public function card_edit($userCardId) {
        $termTermsList   = $this->termTermsList();

        $card = UserCard::where('userCardId', '=', $userCardId)->first();

        $countries = Country::select('countryId','countryName')->get();

        if($card == 'cc'){
            return view( 'customers.edit.card', compact('card'));
        }
        return view( 'customers.edit.net-term', compact('card', 'termTermsList', 'countries'));
    }

    public function customer_history($customerid) {
      
        $sales = Deal::selectRaw( 'COUNT(dealId) as totalDeals, SUM(dealTaxValue) as dealTaxValue, SUM(dealCreditCardCharges) as dealCreditCardCharges, SUM(dealShippingCharges) as dealShippingCharges, dealItemQuantity, dealItemUnitCost, SUM(dealItemQuantity * dealItemUnitCost) as totalcost, MONTH(dealEndDateTime) as month' )
        ->leftJoin( 'deal_items', 'deal_items.dealItemDealId', '=', 'deals.dealId' )
        ->where( 'deals.dealUserId', $customerid)
        ->where( 'deals.dealStatus', 'closed' )
        ->where( 'deals.dealType', 'chatOremail' )
        ->groupBy(DB::raw('MONTH(dealEndDateTime)'))
        ->get();
    
        return view('customers.partials.history', compact('sales'));
    }



    public function store_card( Request $request, $id) {

       
    

        $payment = new UserCard();
        $payment->userCardHolderName = $request->userCardHolderName;
        $payment->userCardNo = $request->userCardNo ? $request->userCardNo : $request->userCardPaymentMethod;
        $payment->userCardPaymentMethod = $request->userCardPaymentMethod;
        $payment->userCardCountry = $request->userCardCountry;
        $payment->userCardState = $request->userCardState;
        $payment->userCardCity = $request->userCardCity;

        $payment->userCardAddress1 = $request->userCardAddress1;
        $payment->userCardAddress2 = $request->userCardAddress2;

        $payment->userCardZip = $request->userCardZip;
        $payment->userCardPayable = $request->userCardPayable;

        $payment->userCardEmail = $request->userCardEmail;
        $payment->userCardPhone = $request->userCardPhone;

        $payment->userCardLimit = $request->userCardLimit;


        $payment->userCardExpireMonth = $request->userCardExpireMonth;
        $payment->userCardExpireYear = $request->userCardExpireYear;


        $payment->userCardCreatedUserId = auth()->user()->userId;
 
        $payment->userCardCustomerId = $id;
        $payment->save();

        if($payment) {
            return response()->json([
                'type' => 'success',
                'msg' => 'Payment Method created successfully.',
            ]);
        } else {
            return response()->json([
                'type' => 'error',
                'msg' => 'There was an error. Please try again.',
            ]);
        }

    }


      public function customer_sales(){



        // $customers = DB::table('invoices')
        // ->select('invoices.invoiceBillingCompany',  
        // DB::raw('COUNT(DISTINCT invoices.invoiceId) as totalInvoices'),
        // DB::raw('SUM(DISTINCT invoices.invoiceShippingCharges) as invoiceShippingCharges'),
        // DB::raw('SUM(DISTINCT invoices.invoiceTaxValue) as invoiceTaxValue'),
        // DB::raw('SUM(DISTINCT invoices.invoiceCreditCardCharges) as invoiceCreditCardCharges'),
        // DB::raw('SUM(DISTINCT invoices.invoiceChargeAmount) as invoiceChargeAmount'),
        // DB::raw('SUM(invoiceItemQuantity * invoiceItemUnitCost) as total'))
        // ->join('invoice_items', 'invoices.invoiceId', '=', 'invoice_items.invoiceItemInvoiceId')  
        // ->where('invoices.invoiceStatusType', 'default')
        //     ->where('invoices.invoiceCompanyId', auth()->user()->userCompanyId)
        //     ->groupBy('invoices.invoiceBillingCompany')
        //     ->paginate(100);

        $customers = DB::table('invoices')
        ->select(
            'invoices.invoiceBillingCompany',
            DB::raw('COUNT(DISTINCT CASE WHEN invoices.invoiceType = "sale" THEN invoices.invoiceId END) - COUNT(DISTINCT CASE WHEN invoices.invoiceType = "return" THEN invoices.invoiceId END) as totalInvoices'),
            DB::raw('SUM(DISTINCT CASE WHEN invoices.invoiceType = "sale" THEN invoices.invoiceShippingCharges ELSE -invoices.invoiceShippingCharges END) as invoiceShippingCharges'),
            DB::raw('SUM(DISTINCT CASE WHEN invoices.invoiceType = "sale" THEN invoices.invoiceTaxValue ELSE -invoices.invoiceTaxValue END) as invoiceTaxValue'),
            DB::raw('SUM(DISTINCT CASE WHEN invoices.invoiceType = "sale" THEN invoices.invoiceCreditCardCharges ELSE -invoices.invoiceCreditCardCharges END) as invoiceCreditCardCharges'),
            DB::raw('SUM(DISTINCT CASE WHEN invoices.invoiceType = "sale" THEN invoices.invoiceChargeAmount ELSE -invoices.invoiceChargeAmount END) as invoiceChargeAmount'),
            DB::raw('SUM(CASE WHEN invoices.invoiceType = "sale" THEN invoiceItemQuantity * invoiceItemUnitCost ELSE -invoiceItemQuantity * invoiceItemUnitCost END) as total')
        )
        ->join('invoice_items', 'invoices.invoiceId', '=', 'invoice_items.invoiceItemInvoiceId')  
       // ->where('invoices.invoiceStatusType', 'default')
        ->where('invoices.invoiceCompanyId', auth()->user()->userCompanyId)
        ->groupBy('invoices.invoiceBillingCompany')
        ->paginate(100);

       return response()->json($customers);

          // return view('customers.sales', compact('customers'));


    }

          public function customer_sales_view(){
          return view('customers.sales');
          }


          public function customer_invoices(){
            $company = request()->get('company');
       
           
            $invoices = DB::table('invoices')
            ->select('invoices.invoiceStatusType',
            'invoiceSoId', 'invoiceSoSerial', 'invoiceId',  'invoiceEndDateTime', 'invoiceType', 'invoiceDueDate', 

            DB::raw('invoices.invoiceShippingCharges'),
            DB::raw('invoices.invoiceTaxValue'),
            DB::raw('invoices.invoiceCreditCardCharges'),
            DB::raw('invoices.invoiceChargeAmount'),
            DB::raw('(SELECT SUM(invoiceItemQuantity * invoiceItemUnitCost) FROM invoice_items WHERE invoice_items.invoiceItemInvoiceId = invoices.invoiceId) as total '))
              
                ->where('invoices.invoiceCompanyId', auth()->user()->userCompanyId)
                ->where('invoiceBillingCompany', '=', $company)
                ->orderBy('invoiceEndDateTime', 'desc')
               ->paginate(100);
            //   $invoices = Invoice::where('invoiceCompanyId', auth()->user()->userCompanyId)
            //   ->where('invoiceBillingCompany', '=', $company)
            //   ->orderBy('invoiceEndDateTime', 'desc')
            //   ->paginate(100);
         
             return response()->json($invoices);
    
              // return view('customers.sales', compact('customers'));
    
    
        }
    
              public function customer_invoices_view(){
              return view('customers.invoices');
              }
    
    
    


    
}
