<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Deal;
use App\Models\Customer;
use App\Models\DealItem;
use App\Models\User;
use Hash;
class DealController extends Controller {
    /**
    * Create a new controller instance.
    *
    * @return void
    */

    public function __construct() {
        $this->middleware( 'auth' );
    }

    /**
    * Show the application dashboard.
    *
    * @return \Illuminate\Contracts\Support\Renderable
    */

    public function store(Request $request) {


        $userexist = User::where('email', $request->dealEmail)->where('email', $request->dealEmail)->exists();
         if($userexist){
             $customer = User::select('userId')->where('email', $request->dealEmail)->where('email', $request->dealEmail)->first();
           
         }else{
            $customerData = array(

                'email' => $request->dealEmail,
                'password' => Hash::make(123456),
                'firstName' => $request->dealPrimaryContact,
                'lastName' => '',
                'userCompany' => $request->dealCompanyName,
                'userAddress' => $request->dealAddress,
                'userCity' => $request->dealCity,
                'userState' => $request->dealState,
                'userPostalCode' => $request->dealPostalCode,
                'phone' => $request->dealPhone,
                'userCountry' => auth()->user()->userCountry,
                'typeId' => 3,
                'userIsActive' => 1,
                'gender' => 0,
                'userActivationToken' => '1122',
                'userCreatedUserId' => auth()->user()->userId,

            );
            $customer = User::Create($customerData);

       }

    

       $deal['dealCompanyId'] = auth()->user()->userCompanyId;
       $deal['dealUserId'] = $customer->userId;
       $deal['dealName'] = $request->dealName;
       $deal['dealCompanyName'] = $request->dealCompanyName;
       $deal['dealPrimaryContact'] = $request->dealPrimaryContact;
       $deal['dealEmail'] = $request->dealEmail;
       $deal['dealPhone'] = $request->dealPhone;
       $deal['dealAddress'] = $request->dealAddress;
       $deal['dealCity'] = $request->dealCity;
       $deal['dealState'] = $request->dealState;
       $deal['dealPostalCode'] = $request->dealPostalCode;
       $deal['dealCountry'] = $request->dealCountry;
       $deal['dealPaymentMethod'] = $request->dealPaymentMethod;
       $deal['dealCreditCardCharges'] = $request->dealCreditCardCharges;
       $deal['dealShippingType'] = $request->dealShippingType;
       $deal['dealShippingCharges'] = $request->dealShippingCharges;
       $deal['dealDepartment'] = $request->dealDepartment;
       $deal['dealChargeType'] = $request->dealChargeType;
       $deal['dealChargeAmount'] = $request->dealChargeAmount;
       $deal['dealAmount'] = 0;
       $deal['dealEndDateTime'] = $request->dealEndDateTime;
      // $deal['dealExpiryDate'] = $request->dealExpiryDate;
       $deal['dealIsDeleted'] = 0;
       $deal['dealShippingCompany'] = $request->dealShippingCompany;
       $deal['dealShippingContact'] = $request->dealShippingContact;
       $deal['dealShippingAddress'] = $request->dealShippingAddress;
       $deal['dealShippingCity'] = $request->dealShippingCity;
       $deal['dealShippingState'] = $request->dealShippingState;
       $deal['dealShippingZip'] = $request->dealShippingZip;
       $deal['dealShippingCountry'] = $request->dealShippingCountry;
       $deal['dealShippingPhone'] = $request->dealShippingPhone;


       $deal['dealShippingEmail'] = $request->dealShippingEmail;
       $deal['dealType'] = $request->dealType;
       $deal['dealStatus'] = 'pending';
       $deal['dealType'] = 'chatOremail';
       $deal['dealRef'] = $request->dealRef;
       $deal['dealRevised'] = 0;
       $deal['dealShippingAccount'] = $request->dealShippingAccount;
       $deal['dealShippingComment'] = $request->dealShippingComment;


       $deal['dealRefrenceText'] = $request->dealRefrenceText;
        $deal['dealCreatedUserId'] = $request->dealsalePerson;
        $deal['dealCompanyUserId'] = auth()->user()->userId;
        $deal['dealDepartment'] = $request->dealDepartment;
        $deal['dealShippingAccount'] = $request->dealShippingAccount;
        $deal['dealShippingComment'] = $request->dealShippingComment;
        $deal['dealCreditCardCharges'] = $request->dealCreditCardCharges;
        $deal['dealShippingCharges'] = $request->dealShippingCharges;
        $deal['dealChargeAmount'] = $request->dealChargeAmount;
       
       $dealCreate = Deal::Create($deal);

        $dealItems = array();
        $dealItemName = $request->dealItemName;
        $dealItemDescription = $request->dealItemDescription;
        $dealItemUnitCost = $request->dealItemUnitCost;
        $dealItemQuantity = $request->dealItemQuantity;
        $dealItemBrand = $request->dealItemBrand;
    

       foreach($request->dealItemId as $key => $value){

        $dealItems[] = array(
            'dealItemDealId' => $dealCreate->dealId,
            'dealItemName' => $dealItemName[$key],
            'dealItemDescription' => $dealItemDescription[$key],
            'dealItemQuantity' => $dealItemQuantity[$key],
            'dealItemUnitCost' => $dealItemUnitCost[$key],
            'dealItemBrand' => $dealItemBrand[$key],
            'dealItemCreatedUserId' => auth()->user()->userId
        );

       }
      
       $dealItemsCreate = DealItem::insert($dealItems);

    //    $deal = new Deal();

    //    $deal->dealName = $request->dealName;
    //    $deal->dealCompanyName = $request->dealName;
    //    $deal->dealPrimaryContact = $request->dealName;
    //    $deal->dealEmail = $request->dealName;
    //    $deal->dealPhone = $request->dealName;
    //    $deal->dealAddress = $request->dealName;
    //    $deal->dealCity = $request->dealName;
    //    $deal->dealState = $request->dealName;
    //    $deal->dealPostalCode = $request->dealName;
    //    $deal->dealCountry = $request->dealName;
      
    //    $deal->dealPaymentMethod = $request->dealName;
    //    $deal->dealCreditCardCharges = $request->dealName;
    //    $deal->dealShippingType = $request->dealName;
    //    $deal->dealShippingCharges = $request->dealName;
       
    //    $deal->dealChargeType = $request->dealName;
    //    $deal->dealChargeAmount = $request->dealName;
    //    $deal->dealAmount = 0;
    //    $deal->dealEndDateTime = $request->dealName;
    //    $deal->dealExpiryDate = $request->dealName;
    //    $deal->dealIsDeleted = 0;
    //    $deal->dealShippingCompany = $request->dealName;
    //    $deal->dealShippingContact = $request->dealName;
    //    $deal->dealShippingAddress = $request->dealName;
    //    $deal->dealShippingCity = $request->dealName;
    //    $deal->dealShippingState = $request->dealName;
    //    $deal->dealShippingZip = $request->dealName;
    //    $deal->dealShippingCountry = $request->dealName;
    //    $deal->dealShippingPhone = $request->dealName;


    //    $deal->dealShippingEmail = $request->dealName;
    //    $deal->dealType = $request->dealName;
    //    $deal->dealStatus = $request->dealName;
    //    $deal->dealTermBy = $request->dealName;
    //    $deal->dealRef = $request->dealName;
    //    $deal->dealRevised = 0;
    //    $deal->dealShippingAccount = $request->dealName;
    //    $deal->dealShippingComment = $request->dealName;


    //    $deal->dealRefrenceText = $request->dealRefrenceText;
    //     $deal->dealCreatedUserId = auth()->user()->id;
    //     $deal->dealShippingAccount = $request->dealShippingAccount;
    //     $deal->dealShippingComment = $request->dealShippingComment;
    //     $deal->dealCreditCardCharges = $request->dealCreditCardCharges;
    //     $deal->dealShippingCharges = $request->dealShippingCharges;
    //     $deal->dealChargeAmount = $request->dealChargeAmount;



     //  $deal->save();

     return redirect()->route('orders.show', bin2hex($dealCreate->dealName));
    }


    public function get_companies() {
        $search = \Request::get('keyword');
        $companies = User::select('email', 'userCompany', 'userId')->where('userCompany', 'LIKE', '%'.$search.'%')->where('userCreatedUserId', auth()->user()->userId)->get();
        
        return $companies;
    }


    public function get_user() {
        $search = \Request::get('keyword');
        $user = User::where('userId', $search)->first();
        
        return $user;
    }


    public function get_suggestionpart() {
        $search = \Request::get('keyword');
        $companies = DealItem::where('dealItemName', 'LIKE', '%'.$search.'%')->limit(7)->get();
        
        return $companies;
    }

    public function order_shipping_company(){
        $search = \Request::get('keyword');
        if($search){
            $deals = Deal::where('dealShippingCompany', 'LIKE', '%'.$search.'%')
                            ->orWhere('dealShippingContact', 'LIKE', '%'.$search.'%')
                            ->orWhere('dealRef', 'LIKE', '%'.$search.'%')
                            ->where('dealCompanyId', auth()->user()->company->companyId)
                            ->paginate(30);
        }else{
        $deals = Deal::where('dealCompanyId', auth()->user()->company->companyId)->paginate(30);
        }
        return view( 'orders.extras.order-shipping-company', compact( 'deals' ) );



    }
    
}
