<?php
namespace App\Http\Controllers\Auth;
namespace App\Http\Controllers;


use Illuminate\Http\Request;
use App\Models\User;
use App\Models\Company;
use Auth;
use Session;
class HomeController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Contracts\Support\Renderable
     */
    public function index()
    {
        return view('dashboard');
    }

    public function updateUserCompany(Request $request)
    {
      
        $userId = Auth::user()->userId;
        User::where('userId', Auth::user()->userId)->update(['userCompanyId' => $request->company_id]);
        
        Auth::logout();
        Auth::loginUsingId($userId);

        return response()->json([
          
            'msg' => 'There should be atleast one Line Item in PO.',
        ]);

        
       

    }

    public function updateUserCompanyForm(Request $request)
    {
      
        $userId = Auth::user()->userId;
        User::where('userId', Auth::user()->userId)->update(['userCompanyId' => $request->company_id]);
        
        Auth::logout();
        Auth::loginUsingId($userId);
      
        request()->session()->put('showModal', 'no');

       
        return redirect()->back()->with( 'success', 'Saved Successfully.' );

       

    }

    
}
