<?php

namespace App\Http\Controllers;

use App\Models\Deal;
use App\Models\DealItem;
use App\Models\Invoice;
use App\Models\InvoiceItem;
use App\Models\Purchase;
use App\Models\SalesOrder;
use App\Models\ReportingBank;
use App\Models\Reportingcc;
use App\Models\ReportingPaypal;

use Illuminate\Http\Request;


class InvoiceController extends Controller {
    /**
    * Create a new controller instance.
    *
    * @return void
    */
    use Traits\Functions;

    public function __construct() {
        $this->middleware('auth');
    }

    public function index()
    {
        

    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create($slug)
    {

        $inv_type = \Request::get('inv_type');


        // if(($inv_type != 'RETURN') || ($inv_type != 'INVOICE')){
        //     abort(404);
        // }

        
        $order = Deal::where( 'dealSO', '=', hex2bin($slug) )->with( 'company' )->first();
        $dealItems = DealItem::where(['dealItemDealId' => $order->dealId, 'dealItemIsActive' => true])->get();
        $invoiceSoSerial = 1;
        $invoiceExists = Invoice::where( 'invoiceSoId', '=', hex2bin($slug) )->exists();
        
       
               if($invoiceExists)
            {
                $invoice = Invoice::where( 'invoiceSoId', '=', hex2bin($slug) )->orderBy('invoiceSoSerial', 'DESC')->limit(1)->get();
                $invoice = $invoice[0];
                $invoiceSoSerial = $invoice->invoiceSoSerial+1;
            }
           
            

         $invoiceItems = InvoiceItem::select('invoiceItemItemId', 'invoiceItemQuantity')->where('invoiceSoId', hex2bin($slug))->get();
        $existingItems = array();
        foreach($invoiceItems as $item){
            $itemId = $item->invoiceItemItemId;
            if (array_key_exists($itemId, $existingItems))
            {
             
                $existingItems[$itemId] = $existingItems[$itemId]+$item->invoiceItemQuantity;
            }
            else
            {
                $existingItems[$itemId] = $item->invoiceItemQuantity;
            
            }


           
          
        }

       
        return view( 'orders.invoices.create', compact( 'order' , 'dealItems', 'invoiceSoSerial', 'existingItems', 'inv_type') );
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request, $soid)
    {

       

        $order = Deal::select('dealId', 'dealUserId')->where( 'dealSO', '=', hex2bin($soid) )->first();
        $request->validate( [
            
            'invoiceReference' => 'required',
                   'invoicePaymentMethod' => 'required',
                   'invoiceBillingCompany' => 'required',
                    'invoiceBillingContact' => 'required',
                    'invoiceBillingAddress' => 'required',
                    'invoiceBillingCity' => 'required',
                    'invoiceBillingState' => 'required',
                    'invoiceBillingZip' => 'required',
                    'invoiceBillingPhone' => 'required',
                    'invoiceBillingEmail' => 'required',
                    'invoiceShippingCompany' => 'required',
                    'invoiceShippingContact' => 'required',
                    'invoiceShippingAddress' => 'required',
                    'invoiceShippingCity' => 'required',
                    'invoiceShippingState' => 'required',
                    'invoiceShippingZip' => 'required',
                    'invoiceShippingPhone' => 'required',
                    'invoiceShippingEmail' => 'required',
                    'invoiceShippingType' => 'required',
                    'invoiceShippingCharges' => 'required',
                    'invoiceTaxName' => 'required',
                    'invoiceTaxValue' => 'required',
                    'invoiceDueDate' => 'required',
                    'invoiceEndDateTime' => 'required',
                    'invoiceTracking' => 'required',
                    'invoiceSerial' => 'required',
                    'invoiceSoSerial' => 'required',
                  
        ]);
        
        $invoiceSoSerial =$request->invoiceSoSerial;
        $invoiceTaxName =$request->invoiceTaxName;
        $invoiceTaxValue =$request->invoiceTaxValue;
          
        $invoiceShippingType =$request->invoiceShippingType;
        $invoiceShippingCharges =$request->invoiceShippingCharges;

        $invoiceDealId = $order->dealId;
        $invoiceUserId = $order->dealUserId;
        $invoiceSoId = hex2bin($soid);

            
           $createData = array(
                   'invoiceReference' => $request->invoiceReference,
                   'invoicePaymentMethod' => $request->invoicePaymentMethod,
                   'invoiceBillingCompany' => $request->invoiceBillingCompany,
                    'invoiceBillingContact' => $request->invoiceBillingContact,
                    'invoiceBillingAddress' => $request->invoiceBillingAddress,
                    'invoiceBillingCity' => $request->invoiceBillingCity,
                    'invoiceBillingState' => $request->invoiceBillingState,
                    'invoiceBillingZip' => $request->invoiceBillingZip,
                    'invoiceBillingPhone' => $request->invoiceBillingPhone,
                    'invoiceBillingEmail' => $request->invoiceBillingEmail,
                    'invoiceShippingCompany' => $request->invoiceShippingCompany,
                    'invoiceShippingContact' => $request->invoiceShippingContact,
                    'invoiceShippingAddress' => $request->invoiceShippingAddress,
                    'invoiceShippingCity' => $request->invoiceShippingCity,
                    'invoiceShippingState' => $request->invoiceShippingState,
                    'invoiceShippingZip' => $request->invoiceShippingZip,
                    'invoiceShippingPhone' => $request->invoiceShippingPhone,
                    'invoiceShippingEmail' => $request->invoiceShippingEmail,
                    'invoiceShippingType' => $invoiceShippingType,
                    'invoiceShippingCharges' => $invoiceShippingCharges,
                    'invoiceTaxName' => $invoiceTaxName,
                    'invoiceTaxValue' => $invoiceTaxValue,
                    'invoiceDueDate' => $request->invoiceDueDate,
                    'invoiceEndDateTime' => $request->invoiceEndDateTime,
                    'invoiceTracking' => $request->invoiceTracking,
                    'invoiceSerial' => $request->invoiceSerial,
                    'invoiceSoSerial' => $invoiceSoSerial,
                    'invoiceDealId' => $invoiceDealId,
                    'invoiceUserId' =>  $invoiceUserId,
                    'invoiceSoId' => $invoiceSoId,
                    'invoiceCreatedUserId' => auth()->user()->userId
                    
                     );
                     
                    $inv = Invoice::insertGetId($createData);
                   
                    $invoiceItemName = $request->invoiceItemName;
                    $invoiceItemDescription = $request->invoiceItemDescription;
                    $invoiceItemQuantity = $request->invoiceItemQuantity;
                    $invoiceItemUnitCost = $request->invoiceItemUnitCost;

                    foreach($request->invoiceItemItemId as $ke => $invoiceItem){

                    $createItemData = array(
                        'invoiceItemInvoiceId' => $inv,
                        'invoiceItemItemId' => $invoiceItem,
                        'invoiceItemName' => $invoiceItemName[$ke],
                         'invoiceItemDescription' => $invoiceItemDescription[$ke],
                         'invoiceSoId' => $invoiceSoId,
                         'invoiceItemQuantity' => $invoiceItemQuantity[$ke],
                         'invoiceItemUnitCost' => $invoiceItemUnitCost[$ke],
                         'invoiceItemCreatedUserId' => auth()->user()->userId
                      
                         
                          );
                          
                        InvoiceItem::insert($createItemData);

                         }

                         return redirect()->back()->with( 'success', 'Invoice Saved Successfully.' );

    }

    /**
     * Display the specified resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function show($slug)
    {   

   
    }

    
    public function edit($slug)
    {
        
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $slug)
    {
 
    }

    /**
     * Remove the specified resource from storage.
     *
   
     * @return \Illuminate\Http\Response
     */
    public function destroy(Request $request)
    {
        //
    }

    
    public function unallocated_invoices(){

        $invoiceYearArray   = $this->yearsList();
        $invoiceMonthArray   = $this->monthsList();
  
        $invoiceYear = request()->get('invoiceYear') ? request()->get('invoiceYear') : date("Y");
        $invoiceMonth = request()->get('invoiceMonth') ? request()->get('invoiceMonth') : date("m");
       
        $rawQuery= '';
        //year selection 
       
  
        if($invoiceMonth != 'all'){
  
          
        $rawQuery .= '  MONTH(invoiceEndDateTime) = '.$invoiceMonth.' AND ';
       
        }
  
        
        //month selection 
        $rawQuery .= 'YEAR(invoiceEndDateTime) = '.$invoiceYear;
        // $invoices = Invoice::query()
        //           ->whereHas('saleorder', function ($query) {
        //               $rawQuery= 'salesorderBlock = 0';
        //               return $query->whereRaw($rawQuery);
        //           })
        //           ->where('invoiceCompanyId', '=', auth()->user()->userCompanyId)
        //           ->where('invoiceStatusType', '=', 'default')
        //           //->whereRaw($rawQuery)
        //           ->paginate();

                  $invoices = Invoice::join('deals', 'invoices.invoiceSoId', '=', 'deals.dealSO')
                  ->select('invoices.invoiceSoId', 
                  'invoices.invoiceSoSerial', 
                  'invoices.invoiceBillingCompany', 
                  'deals.dealUserId')
                  ->whereHas('saleorder', function ($query) {
                      $query->where('salesorderBlock', 0);
                  })
                  ->where('invoiceCompanyId', auth()->user()->userCompanyId)
                  ->where('invoiceStatusType', 'default')
                   ->whereRaw($rawQuery)
                  ->paginate();

               
  
          return view('reporting.invoices.unallocated-invoices', compact('invoices','invoiceYearArray','invoiceMonthArray','invoiceYear','invoiceMonth') );
  
    }

    public function invoice_transaction($id){
        $invoice = Invoice::select('invoiceId', 'invoiceSoId', 'invoiceSoSerial')
                            ->where('invoiceId', '=', $id)
                            ->first();
         $reportRefrence = 'Invoice # ('.$invoice->invoiceSoId.'-'.$invoice->invoiceSoSerial.')';
         $transactions = ReportingBank::where('reportBankCompanyId', auth()->user()->userCompanyId)
           ->where('reportBankRefrence', 'LIKE', '%' . $reportRefrence . '%')
           ->whereRaw("FIND_IN_SET('$id', reportBankDetail) > 0")
           ->paginate(10);
           
          if($transactions->isNotEmpty()){
            return view('banks.transaction', compact('transactions'));
          }
         
          $transactions = ReportingPaypal::where('paypalPaymentCompanyId', auth()->user()->userCompanyId)
          ->where('paypalPaymentReference', 'LIKE', '%' . $reportRefrence . '%')
          ->whereRaw("FIND_IN_SET('$id', paypalPaymentDetail) > 0")
          ->paginate(10);
         if($transactions->isNotEmpty()){
           return view('credit-cards.paypal-transaction', compact('transactions'));
         }

          echo '<h1 style="text-align:center; margin-top:80;">At the moment, Bank & Paypal transactions are available. 
          <br>
          Credit card transactions will be added upon request from the Accounts Team.  </h1>';
           
    }
}
