<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Invoice;
use App\Models\State;
use App\Models\User;
use App\Models\ShippingAccount;
use App\Models\InvoiceItem;
use Auth;

class InvoiceModifyController extends Controller {
    /**
    * Create a new controller instance.
    *
    * @return void
    */

    public function __construct() {
        $this->middleware( 'auth' );
    }

    /**
    * Show the application dashboard.
    *
    * @return \Illuminate\Contracts\Support\Renderable
    */

    public function edit($slug){
        // dd(hex2bin( $slug ));
        $invoice = Invoice::where( 'invoiceId', '=', hex2bin( $slug ) )->with( 'invoiceItems' )->first();
        $invoiceItems = InvoiceItem::where(['invoiceItemInvoiceId' => hex2bin( $slug ), 'invoiceItemIsActive' => 1])->get();
        $data[ 'states' ] = State::all();
        $data[ 'sales_persons' ] = User::where(['typeId' => 3,'roleId' => 1, 'userCompanyId' => Auth::user()->userCompanyId])->get();
        $data[ 'shipping_accounts' ] = ShippingAccount::where(['company_id' => Auth::user()->userCompanyId])->orWhere('company_id', 0)->get();
        // dd( $order );
        return view( 'orders.invoices.edit', compact( 'invoice' , 'invoiceItems', 'data') );
    }

    public function updateInvoiceLineItem(Request $request) {
        // dd($request->all());

        $invoiceItem = InvoiceItem::find($request->invoiceItemId);
        $invoiceItem['invoiceItemName'] = $request->invoiceItemName;
        $invoiceItem['invoiceItemDescription'] = $request->invoiceItemDescription;
        $invoiceItem['invoiceItemUnitCost'] = $request->invoiceItemUnitCost;
        $invoiceItem['invoiceItemQuantity'] = $request->invoiceItemQuantity;
        // $dealItem['brand] = $request->brand;
        $invoiceItem->save();

        if($invoiceItem) {
            return "success";
        } else {
            return "error";
        }

    }

    public function updateInvoice(Request $request) {
            // dd($request->all());

            $invoice = Invoice::find($request->invoiceId);
            $invoice[$request->column_name] = $request->input_value;
            $invoice->save();


            if($invoice) {
                return "success";
            } else {
                return "error";

        }
    }

    public function department_update(Request $request) {
       

        $invoice = Invoice::find($request->invoiceId);
        $invoice['invoiceDepartmentId'] = $request->selecteddept;
        $invoice->save();


        if($invoice) {
            return response()->json([
                'type' => 'success',
                'msg' => 'Department updated successfully!',
            ]);
        } else {
            return response()->json([
                'type' => 'error',
                'msg' => 'There was an error. Please try again.',
            ]);
        }
}

    public function insertInvoiceLineItem(Request $request) {
        // dd($request->all());

        $invoiceItem = new InvoiceItem();
        $invoiceItem->invoiceItemName = $request->invoiceItemName;
        $invoiceItem->invoiceItemDescription = $request->invoiceItemDescription;
        $invoiceItem->invoiceItemUnitCost = $request->invoiceItemUnitCost;
        $invoiceItem->invoiceItemQuantity = $request->invoiceItemQuantity;
        $invoiceItem->invoiceItemInvoiceId = $request->invoiceItemInvoiceId;
        $invoiceItem->invoiceItemIsActive = 1;
        // $dealItem->brand = $request->brand;
        $invoiceItem->save();
// dd($dealItem->id);
        if($invoiceItem) {
            return "success";
        } else {
            return "error";
        }

    }


    public function itemDelete(Request $request)
    {
        $items_count = InvoiceItem::where(['invoiceItemInvoiceId' => $request->invoiceId, 'invoiceItemIsActive' => true])->count();
        // dd($items_count);
        if($items_count > 1) {
            $invoiceItem = InvoiceItem::find($request->invoiceItemId);
            $invoiceItem->invoiceItemIsActive = false;
            $invoiceItem->save();

            if($invoiceItem) {
                return response()->json([
                    'type' => 'success',
                    'msg' => 'Item Removed successfully.',
                ]);
            } else {
                return response()->json([
                    'type' => 'error',
                    'msg' => 'There was an error. Please try again.',
                ]);
            }
        } else {
            return response()->json([
                'type' => 'error',
                'msg' => 'There should be atleast one Line Item in Invoice.',
            ]);
        }

    }
}
