<?php


namespace App\Http\Controllers\Loan;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

use App\Models\Loan;
use App\Models\LoanUser;
use App\Models\Bank;
use App\Models\ReportingBank;
use App\Models\Vendor;

use Illuminate\Support\Facades\DB;
use Auth;
class LoanController extends Controller {
    /**
    * Create a new controller instance.
    *
    * @return void
    */
    use \App\Http\Controllers\Traits\Functions;


    public function __construct() {
        $this->middleware( 'auth' );
    }

    public function create(){
        $userCompanyId = auth()->user()->userCompanyId;
        $loanusers = LoanUser::where('loanUserCompanyId',  $userCompanyId)->get();
        $banks = Bank::select('bankId', 'bankAccountTitle')
        ->where('bankCompanyId', $userCompanyId)
        ->get();

        return view('loans.create', compact('loanusers', 'banks'));

    }
    public function other_receivables_loans(){
        $userCompanyId = auth()->user()->userCompanyId;
        $currentYear = date('Y');
        $currentMonth = date('M');

        $overall = Loan::where('loanCompanyId',  $userCompanyId)
        ->where('loans.loanCategory', 1)
        ->sum('loanTotalAmount');


        $sumByYear = Loan::whereYear('loanDate', $currentYear)
        ->where('loanCompanyId',  $userCompanyId)
        ->where('loans.loanCategory', 1)

        ->sum('loanTotalAmount');

        $sumByMonth = Loan::whereYear('loanDate', $currentMonth)
        ->where('loanCompanyId',  $userCompanyId)
        ->where('loans.loanCategory', 1)

        ->sum('loanTotalAmount');

        $loans = DB::table('loan_users')
        ->select('loan_users.loanUserFirstName', 'loan_users.loanUserId',DB::raw('SUM(loans.loanTotalAmount) as total'))
        ->join('loans', 'loans.loanUserId', '=', 'loan_users.loanUserId')
        ->where('loans.loanCategory', 1)
        ->where('loan_users.loanUserCompanyId',  $userCompanyId)
        ->groupBy('loan_users.loanUserId')
        ->paginate(30);
        return view('loans.receivables-loans', compact('loans', 'overall', 'sumByYear', 'sumByMonth'));

    }


    public function loan_history($id){
        $user = LoanUser::where('loanUserId', $id)
        ->select('loanUserFirstName')->first();
        $currentYear = date('Y');
        $currentMonth = date('M');
        $overall = Loan::where('loanCompanyId', auth()->user()->userCompanyId)
        ->where('loanUserId', $id)
        ->sum('loanTotalAmount');
        $sumByYear = Loan::whereYear('loanDate', $currentYear)
        ->where('loanUserId', $id)
        ->where('loanCompanyId', auth()->user()->userCompanyId)
        ->sum('loanTotalAmount');
        $sumByMonth = Loan::whereYear('loanDate', $currentMonth)
        ->where('loanUserId', $id)
        ->where('loanCompanyId', auth()->user()->userCompanyId)
        ->sum('loanTotalAmount');

        $loans = Loan::where('loanCompanyId', auth()->user()->userCompanyId)
        ->where('loanUserId', $id)
        ->paginate(30);    
        return view('loans.history', compact('user', 'loans', 'overall', 'sumByYear', 'sumByMonth'));

    }





    public function loan(Request $request)

    {
       
        $loanAmount= $request->loanAmount;
        $loanCategory= $request->loanCategory;
        $loanCategoryType = $request->loanCategoryType;
        $loanDescription = $request->loanDescription;
        $loanDate = $request->loanDate;
       

            $loan = new Loan();
            $loan->loanUserId = $request->loanUserId;
            $loan->loanDate = $loanDate;
            $loan->loanAmount= $loanAmount;
            $loan->loanDescription = $loanDescription;
            $loan->loanCategory= $loanCategory;
            $loan->loanCategoryType = $loanCategoryType;
            $loan->save();
           
            $bankId = $request->bankId;
            if($loan){

                $user = LoanUser::where('loanUserId', $request->loanUserId)->select('loanUserFirstName')->first();
                $loanuserCompany =  $user->loanUserFirstName;
            $loanDate = date_create($request->loanDate);

              $bankDebit = 0;
              $bankCredit = 0;
              $loantype = '';

              if($loanCategory == 1){
                $bankDebit = $loanAmount;
                $loantype = 'LOAN';

            }else{
                $bankCredit = $loanAmount;
                $loantype = 'LOAN RETURN';

            }

        
               $bank_entry = new ReportingBank();
   
               $bank_entry->reportBankDescription = $loanDescription;
               $bank_entry->reportBankCategory = $loantype;
               $bank_entry->reportBankDebit = (double)$bankDebit;
               $bank_entry->reportBankCredit = (double)$bankCredit;
               $bank_entry->reportBankAllocation = $loanCategoryType;
               $bank_entry->reportBankCharges = 0;
               $bank_entry->reportBankRefrence = $loantype.' # '. $loanuserCompany;
               $bank_entry->reportBankDate = date_format($loanDate,"Y/m/d H:i:s");
               $bank_entry->reportBankYear = (int)date_format($loanDate,"Y");
               $bank_entry->bank_entry = (int)$bankId;
               $bank_entry->reportBankCompanyId = auth()->user()->userCompanyId;
               $bank_entry->reportBankCreatedUserId = auth()->user()->userId;
               $bank_entry->reportBankDetail = $loan->loanId;
            
               $bank_entry->save();
                


            }

      return redirect()->back()->with('success','Transaction Successful.');;

        }



    

  

}
