<?php

namespace App\Http\Controllers;

use App\Facades\Activity;
use App\Models\Company;
use Illuminate\Http\Request;
use App\Models\SalesOrder;
use App\Models\User;
use App\Models\Deal;
use App\Models\DealItem;
use App\Models\Invoice;
use App\Models\ShippingAccount;
use App\Models\Purchase;
use App\Models\Receivable;
use App\Models\SaleAttachment;
use App\Models\Vendor;
use App\Models\State;
use App\Models\Brand;
use SplFileObject;

use Illuminate\Support\Facades\DB;
use Auth;

class OrderController extends Controller {
    /**
    * Create a new controller instance.
    *
    * @return void
    */
    use Traits\Functions;
    public function __construct() {
        $this->middleware( 'auth' );
    }

    /**
    * Show the application dashboard.
    *
    * @return \Illuminate\Contracts\Support\Renderable
    */
  public function order_net_terms() {
      $dealYear = request()->get('dealYear') ? request()->get('dealYear') : date("Y");
        $dealMonth = request()->get('dealMonth') ? request()->get('dealMonth') : date("m");
        $rawQuery= '';
        //year selection 
       

        if($dealMonth != 'all'){

          
        $rawQuery .= '  MONTH(dealEndDateTime) = '.$dealMonth;
       
        }

        
        //month selection 
        $rawQuery .= ' AND YEAR(dealEndDateTime) = '.$dealYear;
       $orders = Deal::select('dealTermBy', 'dealPaymentMethod', 'dealSO')
       ->whereNotNull('dealTermBy')
       ->whereRaw($rawQuery)->get();
        $dealYearArray   = $this->yearsList();
            $dealMonthArray   = $this->monthsList();
        return view( 'reporting.net-terms.index', compact('orders','dealYearArray', 'dealMonthArray','dealYear', 'dealMonth' ));
  }

      public function unclosed_orders() {
      
          $dealYear = request()->get('dealYear') ? request()->get('dealYear') : date("Y");
        $dealMonth = request()->get('dealMonth') ? request()->get('dealMonth') : date("m");

            $dealYearArray   = $this->yearsList();
            $dealMonthArray   = $this->monthsList();
    //    $orders = Deal::where('dealCompanyId', '=', auth()->user()->userCompanyId)->paginate(20);
            $rawQuery= '';

        $rawQuery .=' dealCompanyId = '.auth()->user()->userCompanyId;

       $orders = Deal::select('dealSO' ,'dealPaymentMethod', 'dealTaxName', 'dealTaxValue', 'dealChargeType', 'dealChargeAmount')
      ->whereNotNull('dealSO')

      ->where('deals.dealRevised', 0)
      ->whereHas('saleorder', function ($query) {
        $dealYear = request()->get('dealYear') ? request()->get('dealYear') : date("Y");
        $dealMonth = request()->get('dealMonth') ? request()->get('dealMonth') : date("m");
        $rawQuery= 'closeOrder = 0';
        //year selection 
        if(!request()->get('sonumber')){

        if($dealMonth != 'all'){

          
        $rawQuery .= ' AND MONTH(salesorderMonthYear) = '.$dealMonth;
       
        }

        
        //month selection 
        $rawQuery .= ' AND YEAR(salesorderMonthYear) = '.$dealYear;

      }
        return $query->whereRaw($rawQuery);
    })->whereRaw($rawQuery)

      ->get();


        return view('unclosed-orders', compact('orders','dealYearArray', 'dealMonthArray','dealYear', 'dealMonth' ));
    }

    public function index(Request $request) {
       
        
        // if(auth()->user()->userId == 2){
        //     echo 'faizan here!';
        //     echo '<br>';
        //     echo $_SERVER['DOCUMENT_ROOT'];
        // die;
        // }   

        

        $dealYear = request()->get('dealYear') ? request()->get('dealYear') : date("Y");
        $dealMonth = request()->get('dealMonth') ? request()->get('dealMonth') : date("m");
        $dealStatus = request()->get('dealStatus') ? request()->get('dealStatus') : 'pending';


        $rawQuery= '';
      
        $rawQuery .= 'dealType = "chatOremail" AND ';
        //year selection 
        $rawQuery .= 'MONTH(dealEndDateTime) = '.$dealMonth.' AND ';
        //month selection 
        $rawQuery .= 'YEAR(dealEndDateTime) = '.$dealYear;
        if($dealStatus && $dealStatus != 'all'){
            $rawQuery .= ' AND dealStatus = "'.$dealStatus.'"';
        }
      
        $salesOrders = Deal::select(
            'dealSO', 'dealEndDateTime','dealCompanyName','dealPaymentMethod',
            'dealStatus','dealName', 'dealCompanyId','dealTaxValue','dealCreditCardCharges',
            'dealShippingCharges', 'dealChargeAmount', 'dealId','dealRef'

            )
        ->latest()
        ->with(['dealItems', 'company:companyId,companyPrefix'])
        ->where('dealCompanyId', '=', auth()->user()->userCompanyId)
        ->whereRaw($rawQuery)
        ->get();
        $dealYearArray   = $this->yearsList();
        $dealMonthArray   = $this->monthsList();
        $dealTermByArray   = $this->termList();
        return view( 'orders.index', compact( 
            'salesOrders', 
            'dealYearArray',
            'dealMonthArray',
            'dealTermByArray',
            'dealStatus'
             ) );
    }

    public function create() {

        //Activity::save('save');

     
        $orderCompany = Company::where('companyId', Auth::user()->userCompanyId)->first();
     
        $companyCountryId = $orderCompany->companyCountryId;
       $customers = [];
       $currentUserId = Auth::user()->userId;
       $query = Deal::select(DB::raw('count(dealId) as total'))->where('dealCreatedUserId', $currentUserId)->first();
       $incre = $query->total + 1;
       $deal_reference = $currentUserId.''.$incre;
   
       $states = State::where('stateCountryId', $companyCountryId)->get();
       $salereps = User::where(['typeId' => 3,'roleId' => 1, 'userCompanyId' => Auth::user()->userCompanyId])->get();
       $data[ 'shipping_accounts' ] = ShippingAccount::where(['company_id' => Auth::user()->userCompanyId])->orWhere('company_id', 0)->get();
     
        
       return view('orders.create-order', compact( 'customers',
        'data', 
        'orderCompany', 
        'states', 
        'salereps', 
        'deal_reference'));
    }

    public function show( $slug ) {
         $order_deal = Deal::select('dealRefrenceText')
         ->where( 'dealName', '=',hex2bin( $slug ))
         ->with( 'created_users' )
         ->with( 'company' )
         ->with( 'dealItems' )
         ->first();
         
        return view( 'orders.view', compact( 'slug' , 'order_deal') );
    }

    public function customerOrdersLimit( Request $request ) {
        $customer_order_limit = Deal::selectRaw( 'dealId, COUNT(dealId) as totalDeals, SUM(dealTaxValue) as dealTaxValue, SUM(dealCreditCardCharges) as dealCreditCardCharges, SUM(dealShippingCharges) as dealShippingCharges, dealItemQuantity, dealItemUnitCost, SUM(dealItemQuantity * dealItemUnitCost) as totalcost' )
        ->leftJoin( 'deal_items', 'deal_items.dealItemDealId', '=', 'deals.dealId' )
        ->where( 'deals.dealUserId', $request->customer_id )
        ->where( 'deals.dealStatus', 'pending' )
        ->where( 'deals.dealType', 'chatOremail' )
        ->get();
        dd( $customer_order_limit );
        echo json_encode( $customers );
    }

    //Section for API's

    public function details($slug) {

        $order = Deal::where('dealName', '=',hex2bin($slug))
        ->where('dealCompanyId', '=', auth()->user()->userCompanyId)->exists();

        if ($order == false) {
        echo json_encode('Order Not Found');
        }else{

        $order = Deal::where('dealName', '=', hex2bin($slug))
        ->where('dealCompanyId', '=', auth()->user()->userCompanyId)
        ->with( 'created_users' )->with( 'company' )->with( 'dealItems' )->first();
        $soid = $order->dealSO;
        $purchases = Purchase::select('purchaseTracking', 'purchaseSerial')->where('purchaseSoId', '=', $soid)
        ->orderBy('purchaseGroupBy', 'desc')
        ->get();
        return view('orders.ajax.view', compact( 'order' ,'purchases') );

        }
    }

    public function modify($slug) {
        
        $order = Deal::where( 'dealName', '=', hex2bin( $slug ) )->with( 'created_users' )->with( 'company' )->with( 'dealItems' )->first();
        $dealItems = DealItem::where(['dealItemDealId' => $order->dealId, 'dealItemIsActive' => true])->get();
        // dd( $order );
        return view( 'orders.ajax.modify', compact( 'order' , 'dealItems') );
    }

    public function attachments($slug) {
        $order = Deal::select('dealId')
        ->where( 'dealName', '=', hex2bin($slug))
        ->first();
        $dealId = $order->dealId;

        $dealAttachments = SaleAttachment::where('saleAttachmentDealId', '=', $dealId)->get();
        // dd( $dealAttachments );
        return view( 'orders.ajax.attachments', compact('order', 'slug', 'dealAttachments' ) );
    }

    public function purchases($slug) {
        $order = Deal::select('dealId', 'dealSO', 'dealCompanyId')
        ->where( 'dealName', '=', hex2bin($slug))
        ->with('company')
        ->first();
        $dealId = $order->dealId;
        $soid = $order->dealSO;
        $dealItems = DealItem::where('dealItemDealId', '=', $dealId)
        ->where('dealItemIsActive','=', 1)
        ->get();

        $purchases = Purchase::where('purchaseSoId', '=', $soid)
        ->orderBy('purchaseGroupBy', 'desc')
        ->get();
       return view('orders.ajax.purchases', compact('order', 'purchases', 'dealItems'));
    }

    public function purchase_form(Request $request, $slug) {

        $purchaseids = explode(",", $request->purchaseids);
        $order = Deal::select('dealId', 'dealSO', 'dealCompanyId')
        ->where( 'dealName', '=', hex2bin($slug))
        ->with('company')
        ->first();
        $dealId = $order->dealId;
        $dealItems = DealItem::where('dealItemDealId', '=', $dealId)
        ->whereIn('dealItemId', $purchaseids)
        ->where('dealItemIsActive','=', 1)
        ->get();


        $vendors = Vendor::where('vendorCompanyId','=', 1)
        ->get();
       return view('orders.ajax.purchase-form', compact('order', 'dealItems', 'vendors'));
    }


    public function invoices($slug) {
        $order = Deal::select('dealId', 'dealSO', 'dealCompanyId')
        ->where( 'dealName', '=', hex2bin($slug))
        ->with('company')
        ->first();
        $soid = $order->dealSO;

        // $invoices = Invoice::select('invoiceSoId', 'invoiceSoSerial', 'invoiceId')

        // ->get();

        $invoices = DB::table('invoices')
            //->select('invoiceReference', 'invoiceShippingCompany',  'invoiceId',  'invoiceTaxValue',  'invoiceShippingCharges',  'SUM(invoiceItemQuantity*invoiceItemUnitCost) as total',  'invoices.invoiceSoId',  'invoiceSoSerial',  'invoices.invoiceReceivable')
            ->select('invoices.invoiceReference', 'invoices.invoiceShippingCompany',  'invoices.invoiceId',  'invoices.invoiceTaxValue',  'invoices.invoiceShippingCharges', DB::raw('SUM(invoiceItemQuantity) as qtyTotal'), DB::raw('SUM(invoice_items.invoiceItemQuantity*invoice_items.invoiceItemUnitCost) as total'),  'invoices.invoiceSoId',  'invoices.invoiceSoSerial')
            ->join('invoice_items', 'invoice_items.invoiceItemInvoiceId', '=', 'invoices.invoiceId')
             ->where('invoices.invoiceSoId', '=', $soid)
             ->where('invoices.invoiceType', '=','sale')
             ->groupBy('invoices.invoiceId')
            ->get();
            $inv_type = 'INVOICE'; 
       return view('orders.ajax.invoices', compact('order', 'invoices', 'inv_type'));
    }

    public function receivables($slug) {
        $order = Deal::select('dealId', 'dealSO', 'dealCompanyId', 'dealCompanyName')
        ->where( 'dealName', '=', hex2bin($slug))
        ->with('company')
        ->first();
        $dealId = $order->dealId;
        $soid = $order->dealSO;

        $receivables = Receivable::where('receivableSaleorderId', '=', $soid)->get();

        return view( 'orders.ajax.receivables', compact('order', 'slug', 'receivables' ) );
    }

    public function receivable_form(Request $request, $slug) {



        $purchase = Purchase::where('purchaseSoId', '=', hex2bin($slug))
        ->where('purchaseGroupBy', '=', $request->purchaseGroupBy)->with('order')->first();
       return view('orders.ajax.receivables-form', compact('purchase'));
    }

    public function activities($slug) {
        $order = Deal::select('dealId', 'dealSO', 'dealCompanyId', 'dealCompanyName')
        ->where( 'dealName', '=', hex2bin($slug))
        ->with('company')
        ->first();
        $dealId = $order->dealId;
        //dd($dealId);
        $soid = $order->dealSO;

        $activities = [];

        return view( 'orders.ajax.activity', compact('order', 'slug', 'activities' ) );
    }

    public function proceed_order(Request $request, $slug){
        $order = Deal::select('dealId', 'dealSO', 'dealCompanyId', 'dealUserId')
        ->where( 'dealName', '=', hex2bin($slug))
        ->with('company')
        ->first();
        $newSalesOrder = 0;
        $orderStatus = $request->orderStatus;
        $dealId = $order->dealId;
        if(empty($order->dealSO)){

            $sale = new SalesOrder();
            $sale->salesorderDealId =  $dealId;
            $sale->salesorderCustomerId = $order->dealUserId;
            $sale->saleorderStatus = 1;
            $sale->save();
            $newSalesOrder = $sale->salesorderId;

            Deal::where('dealId', $dealId)->update(['dealSO'=>$newSalesOrder, 'dealStatus'=> $orderStatus]);

        }else{
            Deal::where('dealId', $dealId)->update(['dealStatus'=> $orderStatus]);

        }

        return redirect()->back()->with( 'success', 'Order Saved Successfully.' );


    }

    public function edit($slug){
        $order = Deal::where('dealName', '=', hex2bin($slug))
        ->where('dealCompanyId', '=', \Auth::user()->userCompanyId)->exists();
        if ($order == false) {
            echo json_encode('Order Not Found');
            die();
            }
        $order = Deal::where( 'dealName', '=', hex2bin( $slug ) )->with( 'created_users' )->with( 'company' )->with( 'dealItems' )->first();
        $dealItems = DealItem::where(['dealItemDealId' => $order->dealId, 'dealItemIsActive' => true])->get();
        $data[ 'states' ] = State::all();
        $data[ 'sales_persons' ] = User::where(['typeId' => 3,'roleId' => 1, 'userCompanyId' => Auth::user()->userCompanyId])->get();
        $data[ 'shipping_accounts' ] = ShippingAccount::where(['company_id' => Auth::user()->userCompanyId])->orWhere('company_id', 0)->get();
        // dd( $order );
        $orderCompany = Company::where('companyId', Auth::user()->userCompanyId)->first();
        $data[ 'shipping_accounts' ] = ShippingAccount::where(['company_id' => Auth::user()->userCompanyId])->orWhere('company_id', 0)->get();

        return view( 'orders.edit', compact( 'order' , 'dealItems', 'data', 'orderCompany') );
    }


    public function order_returns($slug) {
        $order = Deal::select('dealId', 'dealSO', 'dealCompanyId')
        ->where( 'dealName', '=', hex2bin($slug))
        ->with('company')
        ->first();
        $soid = $order->dealSO;

        // $invoices = Invoice::select('invoiceSoId', 'invoiceSoSerial', 'invoiceId')

        // ->get();

        $invoices = DB::table('invoices')
            //->select('invoiceReference', 'invoiceShippingCompany',  'invoiceId',  'invoiceTaxValue',  'invoiceShippingCharges',  'SUM(invoiceItemQuantity*invoiceItemUnitCost) as total',  'invoices.invoiceSoId',  'invoiceSoSerial',  'invoices.invoiceReceivable')
            ->select('invoices.invoiceReference', 'invoices.invoiceShippingCompany',  'invoices.invoiceId',  'invoices.invoiceTaxValue',  'invoices.invoiceShippingCharges', DB::raw('SUM(invoiceItemQuantity) as qtyTotal'), DB::raw('SUM(invoice_items.invoiceItemQuantity*invoice_items.invoiceItemUnitCost) as total'),  'invoices.invoiceSoId',  'invoices.invoiceSoSerial')
            ->join('invoice_items', 'invoice_items.invoiceItemInvoiceId', '=', 'invoices.invoiceId')
             ->where('invoices.invoiceSoId', '=', $soid)
             ->where('invoices.invoiceType', '=','return')
             ->groupBy('invoices.invoiceId')
            ->get();

        $inv_type = 'RETURN'; 
       return view('orders.ajax.invoices', compact('order', 'invoices', 'inv_type'));
    }

    public function getDealByNumber(Request $request) {

        // dd($request->all());
        $order = Deal::where('dealSO', '=', $request->so_number)->exists();
        if ($order == false) {

            echo '<h1>Not Found!';
        }
        else{

        $order = Deal::where('dealSO', '=', $request->so_number)
        ->where('dealCompanyId', '=', \Auth::user()->userCompanyId)
        ->with( 'created_users' )->with( 'company' )->with( 'dealItems' )->first();
        $slug = bin2hex($order->dealName);
        return redirect()->route('orders.show', bin2hex($order->dealName));
       
      //  return view( 'orders.view', compact('slug') );

        }


        
    }


 


    public function order_brands(Request $request) {
        $brands = Brand::where('brandName', 'LIKE', '%'.$request->keyword.'%')->limit(6)->get();
        
        echo json_encode($brands);
    }


    public function order_parts(Request $request) {
        $items = DealItem::where('dealItemName', 'LIKE', '%'.$request->keyword.'%')->groupBy('dealItemName')->limit(6)->get();
        
        echo json_encode($items);
    }

    public function deal_items($slug){
        $order = Deal::where( 'dealName', '=', hex2bin( $slug ) )->first();
        $dealItems = DealItem::where(['dealItemDealId' => $order->dealId])->get();
        return view( 'orders.ajax.items', compact( 'order' , 'dealItems') );
    }
    
    public function no_inv_so(){
        $orders = Deal::has('invoices', '>' , 10)->withCount('invoices')->get();
       
      return view('orders.so-inv-count', compact('orders') );
        
    }


    public function uninvoiced_orders(){
      //  $orders = Deal::query()->has('invoices', '<' , 1)->paginate();
      $orderYearArray   = $this->yearsList();
      $orderMonthArray   = $this->monthsList();

      $orderYear = request()->get('orderYear') ? request()->get('orderYear') : date("Y");
      $orderMonth = request()->get('orderMonth') ? request()->get('orderMonth') : date("m");
     
      $rawQuery= '';
      //year selection 
     

      if($orderMonth != 'all'){

        
      $rawQuery .= '  MONTH(dealEndDateTime) = '.$orderMonth.' AND ';
     
      }

      
      //month selection 
      $rawQuery .= 'YEAR(dealEndDateTime) = '.$orderYear;


     $orders = DB::table('deals')
            ->leftJoin('invoices', 'deals.dealSO', '=', 'invoices.invoiceId')
            ->select('dealSO', 'dealEndDateTime', 'dealCompanyName', 'dealCompanyId')
            ->whereNull('invoices.invoiceId')
             ->whereNotNull('dealSO')
             ->where('dealCompanyId', '=', auth()->user()->userCompanyId)
             ->whereRaw($rawQuery)
            ->paginate(50);


        return view('reporting.invoices.uninvoiced-orders', compact('orders','orderYearArray','orderMonthArray','orderYear','orderMonth') );

    }




     public function list_check(Request $request) {
       

        

        $dealYear = request()->get('dealYear') ? request()->get('dealYear') : date("Y");
        $dealMonth = request()->get('dealMonth') ? request()->get('dealMonth') : date("m");
        $dealStatus = request()->get('dealStatus') ? request()->get('dealStatus') : 'pending';
        $showZero = request()->get('showZero') ? request()->get('showZero') : 0;


        $rawQueryConditions = [];
$rawQueryConditions[] = ['dealType', '=', 'chatOremail'];

if ($dealMonth && $dealMonth !== 'all') {
   $rawQueryConditions[] = [DB::raw('MONTH(dealEndDateTime)'), '=', $dealMonth];
}


$rawQueryConditions[] = [DB::raw('YEAR(dealEndDateTime)'), '=', $dealYear];

if ($dealStatus && $dealStatus !== 'all') {
    $rawQueryConditions[] = ['dealStatus', '=', $dealStatus];
}

$query = Deal::select(
        'dealSO', 'dealEndDateTime', 'dealCompanyName', 'dealPaymentMethod',
        'dealStatus', 'dealName', 'dealCompanyId', 'dealTaxValue',
        'dealCreditCardCharges', 'dealShippingCharges',
        'dealChargeAmount', 'dealId', 'dealRef'
    )
    ->latest()
    
    ->with(['dealItems', 'company:companyId,companyPrefix'])
    ->where('dealCompanyId', '=', auth()->user()->userCompanyId)
    ->whereHas('saleorder', function ($query) {
        $query->where('salesorderBlock', '=', 0);
    })
    ->where($rawQueryConditions);

if ($showZero == 1) {
    $query->doesntHave('invoices');
}

$salesOrders = $query->get();




        $dealYearArray   = $this->yearsList();
        $dealMonthArray   = $this->monthsList();
        $dealTermByArray   = $this->termList();
        return view( 'orders.list-check', compact( 
            'salesOrders', 
            'dealYearArray',
            'dealMonthArray',
            'dealTermByArray',
            'dealStatus'
             ) );

    }



        public function processCSV(Request $request)
    {

        if ($request->hasFile('csv_file')) {
                      $file = $request->file('csv_file');

                  // Open the CSV file for reading
            $csvFile = new SplFileObject($file->getPathname());
            $csvFile->setFlags(SplFileObject::READ_CSV);
            
         
            $notInOrders = [];

        
            $dealRefArray = ['NA', 'N/A', 'na', 'n/a', ''];

            foreach ($csvFile as $row) {


                $dealSO = $row[0] ?? null;
                $dealRef = $row[1] ?? null;

               
        

                $query = DB::table('deals');
                
                if(!in_array($dealSO, $dealRefArray)){  $query->whereRaw("CAST(dealSO AS CHAR) = '".preg_replace('/^1000/', '', $dealSO)."'"); }

                
                if(!in_array($dealRef, $dealRefArray)){  $query->orWhere('dealRef', $dealRef); }

                $exists = $query->exists();
               

             
                if (!$exists) {
                    if($dealSO != null){
                    $notInOrders[] = [
                        'dealSO' => $dealSO,
                        'dealRef' => $dealRef // Assuming customer name is in the third column (index 2)
                    ];
                }
                }
            }
  
            return view('orders.not-in', compact('notInOrders'));
        } else {
            return redirect()->back()->with('error', 'No CSV file uploaded.');
        }
    }


}
