<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Deal;
use App\Models\DealItem;
use DB;
class OrderModifyController extends Controller {
    /**
    * Create a new controller instance.
    *
    * @return void
    */

    public function __construct() {
        $this->middleware( 'auth' );
    }

    /**
    * Show the application dashboard.
    *
    * @return \Illuminate\Contracts\Support\Renderable
    */

    public function updateDealLineItem(Request $request) {
 

        $dealItem = DealItem::find($request->dealItemId);
        $dealItem['dealItemName'] = $request->dealItemName;
        $dealItem['dealItemDescription'] = $request->dealItemDescription;
        $dealItem['dealItemUnitCost'] = $request->dealItemUnitCost;
        $dealItem['dealItemQuantity'] = $request->dealItemQuantity;
        $dealItem['dealItemBrand'] = $request->dealItemBrand;
        
        // $dealItem['brand] = $request->brand;
        $dealItem->save();

        if($dealItem) {
            return "success";
        } else {
            return "error";
        }

    }

    public function updateDeal(Request $request) {
          
            $deal = Deal::find($request->dealId);
            $deal[$request->column_name] = $request->input_value;
            $deal->save();


            if($deal) {
                return "success";
            } else {
                return "error";

        }
    }


    public function salesorder_month_year_update(Request $request)
    {
        
        $request->validate([
            'salesorderMonthYear' => 'required',
            'invid' => 'required',
        ]);
        $soid = explode("-",$request->invid);
       // $dateformat = 
       $date=date_create($request->salesorderMonthYear);
       $updateso = DB::table('salesorder')->select('closeOrderDate')->where('salesorderId', $soid[0])->update(['salesorderMonthYear' => date_format($date,"Y-m-d H:i:s")]);

       if($updateso) {
        return response()->json([
            'type' => 'success',
            'msg' => 'Month updated successfully. Please Refresh!',
        ]);
    } else {
        return response()->json([
            'type' => 'error',
            'msg' => 'There was an error. Please try again.',
        ]);
    }
    }
    public function insertDealLineItem(Request $request, $slug) {
      
        $order = Deal::where( 'dealName', '=', hex2bin( $slug ) )->first();

        $dealItem = new DealItem();
        $dealItem->dealItemName = $request->dealItemName;
        $dealItem->dealItemDescription = $request->dealItemDescription;
        $dealItem->dealItemUnitCost = $request->dealItemUnitCost;
        $dealItem->dealItemQuantity = $request->dealItemQuantity;
        $dealItem->dealItemDealId = $order->dealId;
        $dealItem->dealItemIsActive = 1;
         $dealItem->dealItemBrand = $request->dealItemBrand;
        $dealItem->save();

        return redirect()->back();

    }


    public function itemDelete(Request $request)
    {
        //$items_count = DealItem::where(['dealItemDealId' => $request->dealId, 'dealItemIsActive' => true])->count();
        // dd($items_count);
       // if($items_count > 1) {

      
            $dealItem = DealItem::select('dealItemDescription')->where('dealItemId', $request->dealItemId)->first();
        
            $dealItemDescription = $dealItem->dealItemDescription.'~~'.$request->dealId;
            $dealItemd = DB::table('deal_items')->select('dealItemDealId', 'dealItemDescription')->where('dealItemId', $request->dealItemId)->update(['dealItemDealId'=>0, 'dealItemDescription' => $dealItemDescription]);;

            if($dealItemd) {
                return response()->json([
                    'type' => 'success',
                    'msg' => 'Item Removed successfully.',
                ]);
            } else {
                return response()->json([
                    'type' => 'error',
                    'msg' => 'There was an error. Please try again.',
                ]);
            }
        // } else {
        //     return response()->json([
        //         'type' => 'error',
        //         'msg' => 'There should be atleast one Line Item in PO.',
        //     ]);
        // }

    }

    public function updateShippingInfo(Request $request, $slug) {
      
        $order = Deal::where( 'dealName', '=', hex2bin( $slug ) )->first();

        $order->dealShippingAccount = $request->dealShippingAccount;
        $order->dealShippingComment = $request->dealShippingComment;
        $order->save();

        return redirect()->back();

    }


    public function updateShippingMethod(Request $request, $slug) {
      
        $order = Deal::where( 'dealName', '=', hex2bin( $slug ) )->first();

        $order->dealShippingType = $request->dealShippingType;
        $order->dealShippingCharges = $request->dealShippingCharges;
        $order->save();

        return redirect()->back();

    }


    public function updateChargesMethod(Request $request, $slug) {
      
        $order = Deal::where( 'dealName', '=', hex2bin( $slug ) )->first();

        $order->dealChargeType = $request->dealChargeType;
        $order->dealChargeAmount = $request->dealChargeAmount;
        $order->save();

        return redirect()->back();

    }


    public function updatePaymentMethod(Request $request, $slug) {
      
        $order = Deal::where( 'dealName', '=', hex2bin( $slug ) )->first();

        $order->dealPaymentMethod = $request->dealPaymentMethod;
        $order->save();

   
        if($order) {
            return response()->json([
                'type' => 'success',
                'msg' => 'Payment Method Updated successfully.',
            ]);
        } else {
            return response()->json([
                'type' => 'error',
                'msg' => 'There was an error. Please try again.',
            ]);
        }

    }

    public function updateSalePerson(Request $request, $slug) {
      
        $order = Deal::where( 'dealName', '=', hex2bin( $slug ) )->first();

        $order->dealCreatedUserId = $request->dealsalePerson;
        $order->save();

        if($order) {
            return response()->json([
                'type' => 'success',
                'msg' => 'Sale Person Updated successfully.',
            ]);
        } else {
            return response()->json([
                'type' => 'error',
                'msg' => 'There was an error. Please try again.',
            ]);
        }

    }
    
}
