<?php


namespace App\Http\Controllers\Orders;
use App\Http\Controllers\Controller;
use App\Facades\Activity;

use App\Models\UserCard;
use App\Models\UserAddress;
use App\Models\UserContact;

use Illuminate\Support\Facades\DB;
use Auth;

class GeneralController extends Controller {
    /**
    * Create a new controller instance.
    *
    * @return void
    */
    use \App\Http\Controllers\Traits\Functions;
    public function __construct() {
        $this->middleware( 'auth' );
    }

    /**
    * Show the application dashboard.
    *
    * @return \Illuminate\Contracts\Support\Renderable
    */
    

    public function payment_methods($id) {

        $userpayments = UserCard::select('userCardNo')
        ->where('userCardCustomerId', '=', $id)
        ->latest()
        ->get();
        return view('orders.ajax.payment-methods', compact( 'userpayments' ) );

        
    }
    public function shipping_contact($id) {
        $contact = UserContact::FindorFail($id);
        return view('orders.ajax.shipping-contact', compact( 'contact' ) );
    }

    public function shipping_address($id) {
        $address = UserAddress::FindorFail($id);
        return view('orders.ajax.shipping-address', compact( 'address' ) );
    }


}
