<?php


namespace App\Http\Controllers\Orders;
use App\Http\Controllers\Controller;
use App\Facades\Activity;
use App\Models\Company;
use Illuminate\Http\Request;
use App\Models\SalesOrder;
use App\Models\User;
use App\Models\Deal;
use App\Models\DealItem;
use App\Models\Invoice;
use App\Models\ShippingAccount;

use App\Models\SaleAttachment;
use App\Models\Vendor;
use App\Models\State;
use App\Models\UserAddress;
use App\Models\UserContact;

use Illuminate\Support\Facades\DB;
use Auth;

class OrderController extends Controller {
    /**
    * Create a new controller instance.
    *
    * @return void
    */
    use \App\Http\Controllers\Traits\Functions;

    
    public function __construct() {
        $this->middleware( 'auth' );
    }

    /**
    * Show the application dashboard.
    *
    * @return \Illuminate\Contracts\Support\Renderable
    */
    public function dashboard() {
        echo 'ffd';
    }
 

    public function autocomplete(Request $request)
    {
        $data = [];
  
        if($request->filled('q')){
            $data = User::where('userCompany', 'LIKE', '%'. $request->get('q'). '%')
                        ->orWhere('phone', 'LIKE', '%'. $request->get('q'). '%')
                        ->orWhere('email', 'LIKE', '%'. $request->get('q'). '%')
                        ->where('userCompanyId', auth()->user()->company->companyId)
                        ->limit(5)
                        ->get();
        }
    
        return response()->json($data);
    }


    public function create() {

       $currentUserId = Auth::user()->userId;
       $query = Deal::select(DB::raw('count(dealId) as total'))->where('dealCreatedUserId', $currentUserId)->first();
       $incre = $query->total + 1;
       $deal_reference = Auth::user()->firstName[0] . Auth::user()->lastName[0].''.$currentUserId.''.$incre;
       return redirect()->route('orders.create-basic', $deal_reference);
    }



    public function create_basic($slug) {

        //dd($slug);
       // $order_deal = Deal::select('dealRefrenceText')->where( 'dealName', '=', hex2bin( $slug ) )->with( 'created_users' )->with( 'company' )->with( 'dealItems' )->first();
        $deal = [];
        //Activity::save('save');
        $orderCompany = Company::where('companyId', Auth::user()->userCompanyId)->first();
       $deal_reference = $slug;
       $salereps = User::where(['typeId' => 3,'roleId' => 1, 'userCompanyId' => Auth::user()->userCompanyId])->get();
        
       return view('orders.wizard-order', compact('orderCompany', 
        'salereps', 
        'deal',
        'slug',
        'deal_reference'));
    }

    public function create_address($slug) {

        $dexists = Deal::select('dealUserId')->where('dealName', $slug)->exists();
        if(!$dexists){
            abort(404);
        }
     $deal = Deal::select('dealUserId')->where('dealName', $slug)->first();

     $userAddressCustomerId = $deal->dealUserId;
     $customer = User::where('userId', $userAddressCustomerId)->first();
     
     $contacts = UserContact::where(['userContactCustomerId' => $userAddressCustomerId, 'userContactCompanyId' => Auth::user()->userCompanyId])
     ->limit(30)->get();
     $addresses = UserAddress::where(['userAddressCustomerId' => $userAddressCustomerId, 'userAddressCompanyId' => Auth::user()->userCompanyId])
     ->limit(30)->get();
       return view('orders.wizard-order', compact(
        'deal',
        'customer',
        'contacts',
        'addresses',
        'slug',));
    }
    public function create_line_items($slug) {

        $dexists = Deal::select('dealUserId')->where('dealName', $slug)->exists();
        if(!$dexists){
            abort(404);
        }
    
        $deal = Deal::select('dealId', 'dealUserId')->where('dealName', $slug)->first();
        $dealId = $deal->dealId;
        $dealItems=DealItem::where('dealItemDealId', $dealId)->get();
        
       
          return view('orders.wizard-order', compact(
           'deal',
           'dealItems',
           'slug',));
       }

       public function create_other_charges($slug) {

        $dexists = Deal::select('dealUserId')->where('dealName', $slug)->exists();
        if(!$dexists){
            abort(404);
        }
    
        $deal = Deal::select(
            'dealId', 'dealUserId', 'dealShippingAccount','dealShippingComment','dealCreditCardCharges','dealShippingType','dealShippingCharges',
           'dealChargeType',
           'dealChargeAmount',
           'dealTaxName',
           'dealTaxValue')->where('dealName', $slug)->first();
        $dealId = $deal->dealId;
        $dealItem =DealItem::select(DB::raw('SUM(dealItemQuantity*dealItemUnitCost) as subtotal'))
        ->where('dealItemDealId', $dealId)
        ->first();
        
        $dealItemTotal = $dealItem->subtotal;
          return view('orders.wizard-order', compact(
           'deal',
           'dealItemTotal',
           'slug',));
       }

       
       public function create_references($slug) {

        $dexists = Deal::select('dealUserId')->where('dealName', $slug)->exists();
        if(!$dexists){
            abort(404);
        }
        $deal = Deal::select('dealId', 'dealUserId', 'dealRefrenceText')->where('dealName', $slug)->first();
       $dealId = $deal->dealId;
        $attachments = SaleAttachment::where('saleAttachmentDealId', $dealId)->get();

        
        
       
          return view('orders.wizard-order', compact(
           'deal',
           'attachments',
           'slug'));
       }


       public function update_line_items(Request $request, $slug){
      
        $deal = Deal::select('dealId')->where('dealName', $slug)->first();
        $dealId = $deal->dealId;
        foreach($request->dealItems as $item){
            $dealItemName = $item['dealItemName'];
            $dealItemDescription = $item['dealItemDescription'];
            $dealItemQuantity = $item['dealItemQuantity'];
            $dealItemUnitCost = $item['dealItemUnitCost'];
         
            $item_exists = DealItem::where(['dealItemName' => $dealItemName, 'dealItemDealId' => $dealId])->exists();
            $deal = array();

            $deal['dealItemName'] = $dealItemName;
            $deal['dealItemDescription'] = $dealItemDescription;
            $deal['dealItemQuantity'] = $dealItemQuantity;
            $deal['dealItemUnitCost'] = $dealItemUnitCost;
     
     
           
            if($item_exists){
                DealItem::where(['dealItemName' => $dealItemName, 'dealItemDealId' => $dealId])->update($deal);
            }else{
                $deal['dealItemDealId'] = $dealId;
                
                $deal['dealItemIsActive'] = 1;
                $deal['dealItemRevised'] = 0;
                $deal['dealItemsPurchaseable'] = 0;
                $deal['dealItemCreatedUserId'] = auth()->user()->userId;
                DealItem::insert($deal);
            }

        }

        return redirect()->route('orders.create-other-charges', $slug);

        // $request->validate([
        //     'dealCompanyName' => 'required',
        //     'dealPrimaryContact' => 'required',
        //     'dealEmail' => 'required',
        //     'dealPhone' => 'required',
        //     'dealAddress' => 'required',
        //     'dealCity' => 'required',
        //     'dealState' => 'required',
        //     'dealPostalCode' => 'required',
        //     'dealCountry' => 'required',
     
        // ]);


       }
    

    public function update_address(Request $request, $slug) {

        $request->validate([
            'dealCompanyName' => 'required',
            'dealPrimaryContact' => 'required',
            'dealEmail' => 'required',
            'dealPhone' => 'required',
            'dealAddress' => 'required',
            'dealCity' => 'required',
            'dealState' => 'required',
            'dealPostalCode' => 'required',
            'dealCountry' => 'required',
     

            'dealShippingCompany' => 'required',
            'dealShippingContact' => 'required',
            'dealShippingAddress' => 'required',
            'dealShippingCity' => 'required',
            'dealShippingState' => 'required',
            'dealShippingZip' => 'required',
            'dealShippingCountry' => 'required',
            'dealShippingPhone' => 'required',
            'dealShippingEmail' => 'required',
        ]);
       


       $deal = array();

       $deal['dealCompanyName'] = $request->dealCompanyName;
       $deal['dealPrimaryContact'] = $request->dealPrimaryContact;
       $deal['dealEmail'] = $request->dealEmail;
       $deal['dealPhone'] = $request->dealPhone;
       $deal['dealAddress'] = $request->dealAddress;
       $deal['dealCity'] = $request->dealCity;
       $deal['dealState'] = $request->dealState;
       $deal['dealPostalCode'] = $request->dealPostalCode;
       $deal['dealCountry'] = $request->dealCountry;

       $deal['dealShippingCompany'] = $request->dealShippingCompany;
       $deal['dealShippingContact'] = $request->dealShippingContact;
       $deal['dealShippingAddress'] = $request->dealShippingAddress;
       $deal['dealShippingCity'] = $request->dealShippingCity;
       $deal['dealShippingState'] = $request->dealShippingState;
       $deal['dealShippingZip'] = $request->dealShippingZip;
       $deal['dealShippingCountry'] = $request->dealShippingCountry;
       $deal['dealShippingPhone'] = $request->dealShippingPhone;
       $deal['dealShippingEmail'] = $request->dealShippingEmail;


       $address = Deal::where('dealName', $slug)->update($deal);

  
        if($address){
            return redirect()->route('orders.create-line-items', $slug);
        }

    }

    public function update_other_charges(Request $request, $slug){
       

        $request->validate([
            // 'dealShippingAccount' => 'required',
            // 'dealShippingComment' => 'required',
            'dealCreditCardCharges' => 'required',
            'dealShippingType' => 'required',
            'dealShippingCharges' => 'required',
            'dealChargeType' => 'required',
            'dealChargeAmount' => 'required',
            'dealTaxName' => 'required',
            'dealTaxValue' => 'required'
        ]);
       


       $deal = array();

       $deal['dealShippingAccount'] = $request->dealShippingAccount;
       $deal['dealShippingComment'] = $request->dealShippingComment;
       $deal['dealCreditCardCharges'] = $request->dealCreditCardCharges;
       $deal['dealShippingType'] = $request->dealShippingType;
       $deal['dealShippingCharges'] = $request->dealShippingCharges;
       $deal['dealChargeType'] = $request->dealChargeType;
       $deal['dealChargeAmount'] = $request->dealChargeAmount;
       $deal['dealTaxName'] = $request->dealTaxName;
       $deal['dealTaxValue'] = $request->dealTaxValue;

   
       $charges = Deal::where('dealName', $slug)->update($deal);
       return redirect()->back();

  
        // if($address){
        //     return redirect()->route('orders.create-line-items', $slug);
        // }




    }


    public function store_basic(Request $request, $slug) {

        $request->validate([
            'dealDepartmentId' => 'required',
            'dealUserId' => 'required',
            'dealName' => 'required',
            'dealRef' => 'required',
            'dealEndDateTime' => 'required',
            'dealPaymentMethod' => 'required',
            'dealsalePerson' => 'required',
        ]);
       

        $dealexists = Deal::Create($deal);



       $deal = array();
       $deal['dealCompanyId'] = auth()->user()->userCompanyId;
       $deal['dealUserId'] = $request->dealUserId;
       $deal['dealName'] = $request->dealName;
       $deal['dealCompanyName'] = 'TBA';
       $deal['dealPrimaryContact'] = 'TBA';
       $deal['dealEmail'] = 'TBA';
       $deal['dealPhone'] = 'TBA';
       $deal['dealAddress'] = 'TBA';
       $deal['dealCity'] = 'TBA';
       $deal['dealState'] = 'TBA';
       $deal['dealPostalCode'] = 'TBA';
       $deal['dealCountry'] = 'TBA';
       $deal['dealPaymentMethod'] = $request->dealPaymentMethod;
       $deal['dealCreditCardCharges'] = 0;
       $deal['dealShippingType'] = 'None';
       $deal['dealShippingCharges'] = 0;
       $deal['dealDepartmentId'] = $request->dealDepartmentId;
       $deal['dealChargeType'] = 'None';
       $deal['dealChargeAmount'] = 0;
       $deal['dealTaxName'] = 'None';
       $deal['dealTaxValue'] = 0;
       
       $deal['dealAmount'] = 0;
       $deal['dealEndDateTime'] = $request->dealEndDateTime;
      // $deal['dealExpiryDate'] = $request->dealExpiryDate;
       $deal['dealIsDeleted'] = 0;
       $deal['dealShippingCompany'] = 'TBA';
       $deal['dealShippingContact'] = 'TBA';
       $deal['dealShippingAddress'] = 'TBA';
       $deal['dealShippingCity'] = 'TBA';
       $deal['dealShippingState'] = 'TBA';
       $deal['dealShippingZip'] = 'TBA';
       $deal['dealShippingCountry'] = 'TBA';
       $deal['dealShippingPhone'] = 'TBA';


       $deal['dealShippingEmail'] = 'TBA';

       $deal['dealStatus'] = 'pending';
       $deal['dealType'] = 'chatOremail';
       $deal['dealRef'] = $request->dealRef;
       $deal['dealRevised'] = 0;
       $deal['dealShippingAccount'] = 'TBA';
       $deal['dealShippingComment'] = 'TBA';


       $deal['dealRefrenceText'] = ' ';
        $deal['dealCreatedUserId'] = auth()->user()->userId;
        $deal['dealSaleUserId'] =  $request->dealsalePerson;


       $dealCreate = Deal::Create($deal);
        
       return redirect()->route('orders.create-address', $request->dealName);

    }







    public function invoices($slug) {
        $order = Deal::select('dealId', 'dealSO', 'dealCompanyId')
        ->where( 'dealName', '=', hex2bin($slug))
        ->with('company')
        ->first();
        $soid = $order->dealSO;

        // $invoices = Invoice::select('invoiceSoId', 'invoiceSoSerial', 'invoiceId')

        // ->get();

        $invoices = DB::table('invoices')
            //->select('invoiceReference', 'invoiceShippingCompany',  'invoiceId',  'invoiceTaxValue',  'invoiceShippingCharges',  'SUM(invoiceItemQuantity*invoiceItemUnitCost) as total',  'invoices.invoiceSoId',  'invoiceSoSerial',  'invoices.invoiceReceivable')
            ->select('invoices.invoiceReference', 'invoices.invoiceShippingCompany',  'invoices.invoiceId',  'invoices.invoiceTaxValue',  'invoices.invoiceShippingCharges', DB::raw('SUM(invoiceItemQuantity) as qtyTotal'), DB::raw('SUM(invoice_items.invoiceItemQuantity*invoice_items.invoiceItemUnitCost) as total'),  'invoices.invoiceSoId',  'invoices.invoiceSoSerial')
            ->join('invoice_items', 'invoice_items.invoiceItemInvoiceId', '=', 'invoices.invoiceId')
             ->where('invoices.invoiceSoId', '=', $soid)
             ->where('invoices.invoiceType', '=','sale')
             ->groupBy('invoices.invoiceId')
            ->get();
            $inv_type = 'INVOICE'; 
       return view('orders.ajax.invoices', compact('order', 'invoices', 'inv_type'));
    }

    public function receivables($slug) {
        $order = Deal::select('dealId', 'dealSO', 'dealCompanyId', 'dealCompanyName')
        ->where( 'dealName', '=', hex2bin($slug))
        ->with('company')
        ->first();
        $dealId = $order->dealId;
        $soid = $order->dealSO;

        $receivables = Receivable::where('receivableSaleorderId', '=', $soid)->get();

        return view( 'orders.ajax.receivables', compact('order', 'slug', 'receivables' ) );
    }

 





}
