<?php

namespace App\Http\Controllers;


use App\Models\Payable;
use Illuminate\Http\Request;

use Illuminate\Support\Facades\Hash;
use DB;
class PayableController extends Controller {
    /**
    * Create a new controller instance.
    *
    * @return void
    */
    use Traits\Functions;

    public function __construct() {
        $this->middleware('auth');
    }

    /**
    * Show the application dashboard.
    *
    * @return \Illuminate\Contracts\Support\Renderable
    */

    public function index() {

        $payableYear = request()->get('payableYear') ? request()->get('payableYear') : date("Y");
        $payableMonth = request()->get('payableMonth') ? request()->get('payableMonth') : date("m");
        $rawQuery= '';
      

        //year selection 
        if($payableMonth != 'all'){
        $rawQuery .= 'MONTH(payables.payableInvoiceDate) = '.$payableMonth.' AND ';
        }
        //month selection 
        $rawQuery .= 'YEAR(payables.payableInvoiceDate) = '.$payableYear;
        $rawQuery .=' AND payables.payableCompanyId = '.auth()->user()->userCompanyId;
        $rawQuery .=' AND payables.payableIsDeleted = 0';

        $payableYearArray   = $this->yearsList();
        $payableMonthArray   = $this->monthsList();
        $payables = Payable::whereRaw($rawQuery)->orderBy('payableId', 'desc')->get();
        return view( 'payables.index', compact( 'payables', 'payableYearArray', 'payableMonthArray', 'payableYear', 'payableMonth') );

    }


    public function index_two() {

        $payableYear = request()->get('payableYear') ? request()->get('payableYear') : date("Y");
        $payableMonth = request()->get('payableMonth') ? request()->get('payableMonth') : date("m");
        $rawQuery= '';
      

        //year selection 
        if($payableMonth != 'all'){
        $rawQuery .= 'MONTH(payables.payableInvoiceDate) = '.$payableMonth.' AND ';
        }
        //month selection 
        $rawQuery .= 'YEAR(payables.payableInvoiceDate) = '.$payableYear;
       // $rawQuery .=' AND payables.payableCompanyId = '.auth()->user()->userCompanyId;
        //$rawQuery .=' AND payables.payableIsDeleted = 0';

        $payableYearArray   = $this->yearsList();
        $payableMonthArray   = $this->monthsList();
        $payables = Payable::whereRaw($rawQuery)->whereNull('payableSoId')->orderBy('payableId', 'desc')->get();
        return view( 'payables.index-two', compact( 'payables', 'payableYearArray', 'payableMonthArray', 'payableYear', 'payableMonth') );

    }
     
    public function create() {
        
    }

    public function store( Request $request ) {

      

    }

    public function edit( $id ) {
        $payable = Payable::where('payableId', $id)->where('payableIsDeleted', 0)->first();
        return view( 'payables.edit', compact('payable') );


    }

    public function update( Request $request, $id) {

     
      
    //    $payable = Payable::where('payableId', $id)->first();
    //    $payable->payableTrackingNumber = ;
     
    //    $payable->update();
       $payableTrackingNumber = $request->payableTrackingNumber;
       $payableInvoiceNumber = $request->payableInvoiceNumber;
       $payableReturn = $request->payableReturn;
       DB::table('payables')
       ->where('payableId', $id)
       ->update([
         'payableTrackingNumber' => $payableTrackingNumber,
         'payableInvoiceNumber' => $payableInvoiceNumber,
         'payableReturn' => $payableReturn
         //'ClientPhone' => $ClientPhone
       ]);


        return redirect()->back()->with( 'success', 'Updated Successfully.' );




    }


    public function update2( Request $request) {

        //dd($request->all());
        $id = $request->payableId;
        $soid = $request->soId;
        $payable = Payable::where('payableId', $id)->update(['payableSoId' => $soid]);
        echo json_encode($payable);
    }


    public function remove($id) {
        $payablee = Payable::where('payableId', $id)->where('payableIsDeleted', 1)->exists();
        if($payablee){
            abort(404);
        }
        $payable = Payable::where('payableId', $id)->update(['payableIsDeleted' => 1]);
        return redirect()->back()->with( 'success', 'Deleted Successfully.' );

    }

}
