<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\PaymentGateway;
use App\Models\Bank;
use App\Models\Purchase;
use App\Models\ReportingBank;
use App\Models\ReportingPaypal;
use App\Models\Reportingcc;

use Illuminate\Support\Facades\Hash;

class PaymentGatewayController extends Controller {
    /**
    * Create a new controller instance.
    *
    * @return void
    */

    public function __construct() {
        $this->middleware('auth');
    }

    /**
    * Show the application dashboard.
    *
    * @return \Illuminate\Contracts\Support\Renderable
    */

    public function index() {
        $gateways = PaymentGateway::where('paymentGatewayCompanyId','=', auth()->user()->userCompanyId)->latest()->paginate(30);
        return view('gateways.index', compact('gateways') );
    }

    public function create() {
     
        return view('gateways.create');
    }


    protected function store_bank($information){
        $bank = new Bank();
        $bank->bankAccountTitle = $information['gatewayName'];
        $bank->bankAccountNo ='NA';
        $bank->bankAba = 'NA';
        $bank->bankSwift = 'NA';
        $bank->bankStatus = 1;
        $bank->bankName = 'NA';
        $bank->bankCompanyId = auth()->user()->userCompanyId;
        $bank->bankAddress = 'NA';
        $bank->bankCreatedUserId = auth()->user()->userId;


        $bank->save();
     
        if($bank){
        $bank_entry = new ReportingBank();

        $bank_entry->reportBankDescription = 'New Bank ('.$information["gatewayName"].')';
        $bank_entry->reportBankCategory = 'OPENING BALANCE';
        $bank_entry->reportBankDebit = (double)$information['gatewayDebit'];
        $bank_entry->reportBankCredit = (double)$information['gatewayCredit'];
        $bank_entry->reportBankAllocation = 'NA';
        $bank_entry->reportBankRefrence = 'NA';
        $bank_entry->reportBankDate = date('Y/m/d H:i:s');
        $bank_entry->reportBankYear = (int)date('Y');
        $bank_entry->bank_entry = (int)$bank->bankId;
        $bank_entry->reportBankCompanyId = auth()->user()->userCompanyId;
        $bank_entry->reportBankCreatedUserId = auth()->user()->userId;
        $bank_entry->reportBankDetail = '';
     
        $bank_entry->save();
      
        }
    
        return $bank_entry;
    }

    protected function store_card($information){
        $card = new PaymentGateway();
        $card->paymentGatewayType = 'Credit Card';
        $card->paymentGatewayName = $information['gatewayName'];
        $card->paymentGatewayLimit = 0;
        $card->paymentForPurchase = 0;
        $card->paymentGatewayCompanyId = auth()->user()->userCompanyId;
        $card->save();

        $card_entry = new Reportingcc();
    
        $card_entry->reportingccDescription = 'New Credit Card ('.$information["gatewayName"].')';
        $card_entry->reportingccCategory = 'OPENING BALANCE';


        $card_entry->reportingccDebit = (double)$information['gatewayDebit'];
        $card_entry->reportingccCredit = (double)$information['gatewayCredit'];

        $card_entry->reportingccAllocation = 'NA';
        $card_entry->reportingccReference =  'NA';
        $card_entry->reportingccDate = date('Y/m/d H:i:s');
        $card_entry->reportingccCardId = (int)$card->paymentGatewayId;
        $card_entry->reportingccCompanyId = auth()->user()->userCompanyId;
        $card_entry->reportingccUserId = auth()->user()->userId;
        $card_entry->reportingccDetail = '';
        $card_entry->save();
    
 

        return $card_entry;
    }


    protected function store_paypal($information){
        $paypal = new PaymentGateway();
        $paypal->paymentGatewayType = 'Paypal';
        $paypal->paymentGatewayName = $information['gatewayName'];
        $paypal->paymentGatewayLimit = 0;
        $paypal->paymentForPurchase = 0;
        $paypal->paymentGatewayCompanyId = auth()->user()->userCompanyId;
        $paypal->save();


        $paypal_entry = new ReportingPaypal();
    
        $paypal_entry->paypalPaymentDescription = 'New Paypal ('.$information["gatewayName"].')';
        $paypal_entry->paypalPaymentGateway = 'paypal';

        $paypal_entry->paypalPaymentCharges = 0;
        $paypal_entry->paypalPaymentCategory = 'OPENING BALANCE';
        $paypal_entry->paypalTotalCharges = (double)$information['gatewayDebit']+(double)$information['gatewayCredit'];
        $paypal_entry->paypalPaymentDebit = (double)$information['gatewayDebit'];
        $paypal_entry->paypalPaymentCredit = (double)$information['gatewayCredit'];
        $paypal_entry->paypalPaymentAllocation = 'NA';
        $paypal_entry->paypalPaymentReference =  'NA';
        $paypal_entry->paypalPaymentDate = date('Y/m/d H:i:s');
        $paypal_entry->paypalPaymentCardId = (int)$paypal->paymentGatewayId;
        $paypal_entry->paypalPaymentCompanyId = auth()->user()->userCompanyId;
        $paypal_entry->paypalPaymentUserId = auth()->user()->userId;
        $paypal_entry->paypalPaymentDetail = '';
        $paypal_entry->save();
        return $paypal_entry;
    }

    public function store_gateway(Request $request) {
        
        

        $request->validate([
            'gatewayName' => 'required',
            'gatewayType' => 'required',
            'gatewayCredit' => 'required',
            'gatewayDebit' => 'required',

        ]);
        
        $information = $request->all();




        if($request->gatewayType == 'bank'){
            $this->store_bank($information);
        }
        if($request->gatewayType == 'card'){
            $this->store_card($information);
        }

        if($request->gatewayType == 'paypal'){
            $this->store_paypal($information);
        }

        // if ( $vendor ) {
           return redirect()->back()->with( 'success', 'Gateway Saved Successfully.' );

        // } else {
        //     return Redirect::back()->withErrors( [ 'msg' => 'There was some problem.' ] );
        // }

    }

    public function edit( $id ) {
        $vendor = Vendor::find( $id );
        $states = State::orderBy( 'stateName' )->get();
        return view( 'vendors.edit', compact( 'vendor', 'states' ) );
    }

    public function update( Request $request, $id ) {
        // dd( $request->all() );
        // Find the Customer
        $vendor = Vendor::find( $id );

        // Updating the Customer
        $vendor->update( [
            'vendorEmail' => $request->vendorEmail,
            'vendorFirstName' => $request->vendorFirstName,
            'vendorLastName' => $request->vendorLastName,
            'vendorCompany' => $request->vendorCompany,
            'vendorWebsite' => $request->vendorWebsite,
            'vendorAddress' => $request->vendorAddress,
            'vendorState' => $request->vendorState,
            'vendorPostalCode' => $request->vendorPostalCode,
            'vendorCity' => $request->vendorCity,
            'vendorCountry' => $request->vendorCountry,
            'vendorPhone' => $request->vendorPhone,
        ] );

        // confirm message
        $request->session()->flash( 'msg', 'Vendor has been updated' );

        // Redirect
        return redirect()->route( 'vendor.index' );

    }

    public function show($id) {
        $gateway = PaymentGateway::where('paymentGatewayId', '=', hex2bin($id))->first();

        $gatewayPurchases = Purchase::where('purchasePyamentCard', '=', $gateway->paymentGatewayName)->with('item')->get();

        return view( 'gateways.show', compact( 'gatewayPurchases' ) );

    }


}
