<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Customer;
use App\Models\Deal;
use App\Models\Invoice;
use App\Models\Purchase;
use App\Models\ReturnOrder;
use PDF;
use DB;
class PdfController extends Controller {
    /**
    * Create a new controller instance.
    *
    * @return void
    */

    public function __construct() {
        $this->middleware( 'auth' );
    }

    /**
    * Show the application dashboard.
    *
    * @return \Illuminate\Contracts\Support\Renderable
    */

    public function order($slug) {

        $order = Deal::where('dealName', '=', hex2bin($slug))
        ->where('dealCompanyId', '=', \Auth::user()->userCompanyId)->exists();

        if ($order == false) {
        echo json_encode('Order Not Found');
        }else{

        $data['order'] = Deal::where('dealName', '=', hex2bin($slug))
        ->where('dealCompanyId', '=', \Auth::user()->userCompanyId)
        ->with( 'created_users' )->with( 'company' )->with( 'dealItems' )->first();

        $soid =  $data['order']->dealSO;
        $data['purchases'] = Purchase::select('purchaseTracking', 'purchaseSerial')->where('purchaseSoId', '=', $soid)
        ->orderBy('purchaseGroupBy', 'desc')
        ->get();
        $pdf = PDF::loadView('pdf.order', $data);


        return $pdf->stream();


        }
    }

    public function view($slug) {

        $order = Deal::where('dealName', '=', hex2bin($slug))
        ->where('dealCompanyId', '=', \Auth::user()->userCompanyId)->exists();

        if ($order == false) {
        echo json_encode('Order Not Found');
        }else{

        $order = Deal::where('dealName', '=', hex2bin($slug))
        ->where('dealCompanyId', '=', \Auth::user()->userCompanyId)
        ->with( 'created_users' )->with( 'company' )->with( 'dealItems' )->first();

        return view('pdf.view', compact('order'));

        }
    }

    public function purchase_view($slug, $groupId) {

        $purchaseorder = Purchase::where('purchaseSoId', '=', hex2bin($slug))
        ->where('purchaseGroupBy', '=', $groupId)->exists();

        if(!Purchase::where('purchaseSoId', '=', hex2bin($slug))
        ->where('purchaseGroupBy', '=', $groupId)->exists()) {
        echo json_encode('Order Not Found');
        }else{

            // $purchases = Purchase::where('purchaseSoId', '=', hex2bin($slug))
            // ->where('purchaseGroupBy', '=', $groupId)
            // ->with(['item', 'vendor'])
            // ->get();
        $data['purchase'] = Purchase::where('purchaseSoId', '=', hex2bin($slug))
        ->where('purchaseGroupBy', '=', $groupId)->with('order')->first();

        $purchase = $data['purchase'];
        return view('pdf.purchase_view', compact('purchase'));

        // $pdf = PDF::loadView('pdf.purchase_view', $data);
        // return $pdf->stream();

        }
    }


    public function invoice($slug) {

        $invoice = Invoice::where('invoiceId', '=', hex2bin($slug))->exists();

        if ($invoice == false) {
        echo json_encode('Invoice Not Found');
        }else{

        $data['invoice'] = Invoice::where('invoiceId', '=', hex2bin($slug))->with( 'invoiceItems' )->with( 'deal' )->first();

        $invoice = $data['invoice'];
        return view('pdf.invoice', compact('invoice'));

        // $pdf = PDF::loadView('pdf.purchase_view', $data);
        // return $pdf->stream();

        }
    }

    public function order_return($slug) {

        $invoice = ReturnOrder::where('returnId', '=', hex2bin($slug))->exists();

        if ($invoice == false) {
        echo json_encode('Return Not Found');
        }else{

        $data['return'] = ReturnOrder::where('returnId', '=', hex2bin($slug))->with( 'returnItems' )->first();

        $invoice = $data['return'];

        return view('pdf.return', compact('invoice'));

        // $pdf = PDF::loadView('pdf.purchase_view', $data);
        // return $pdf->stream();

        }
    }
}
