<?php

namespace App\Http\Controllers;

use App\Models\Permission;
use App\Models\Role;
use App\Models\User;
use Illuminate\Http\Request;

class PermissionController extends Controller
{
    public function index() {
        $permissions = Permission::paginate( 10 );
        //  dd( $vendors );
        return view( 'permissions.index', compact( 'permissions' ) );
    }

    public function create() {
        // $states = State::orderBy( 'stateName' )->get();
        return view( 'permissions.create');
    }

    public function store( Request $request ) {

        $slug = str_replace(" ", "-", strtolower($request->name));

        $permission = new Permission();
		$permission->slug = $slug;
		$permission->name = $request->name;
		$permission->save();


        if ( $permission ) {
            return redirect()->back()->with( 'success', 'Permission Saved Successfully.' );

        } else {
            return Redirect::back()->withErrors( [ 'msg' => 'There was some problem.' ] );
        }

    }

    public function edit( $id ) {
        $permission = Permission::find( $id );
        return view( 'permissions.edit', compact( 'permission' ) );
    }

    public function update( Request $request, $id ) {
        // dd( $request->all() );
        // Find the Permission
        $permission = Permission::find( $id );
        $slug = str_replace(" ", "-", strtolower($request->name));
        // Updating the Permission
        $permission->update( [
            'name' => $request->name,
            'slug' => $slug,
        ] );

        // confirm message
        $request->session()->flash( 'msg', 'Permission has been updated' );

        // Redirect
        return redirect()->route( 'permission.index' );

    }


    public function Permission()
    {
    	$user_permission = Permission::where('slug','create-tasks')->first();
		$admin_permission = Permission::where('slug', 'edit-users')->first();

		//RoleTableSeeder.php
		$user_role = new Role();
		$user_role->slug = 'user';
		$user_role->name = 'User_Name';
		$user_role->save();
		$user_role->permissions()->attach($user_permission);

		$admin_role = new Role();
		$admin_role->slug = 'admin';
		$admin_role->name = 'Admin_Name';
		$admin_role->save();
		$admin_role->permissions()->attach($admin_permission);

		$user_role = Role::where('slug','user')->first();
		$admin_role = Role::where('slug', 'admin')->first();

		$createTasks = new Permission();
		$createTasks->slug = 'create-tasks';
		$createTasks->name = 'Create Tasks';
		$createTasks->save();
		$createTasks->roles()->attach($user_role);

		$editUsers = new Permission();
		$editUsers->slug = 'edit-users';
		$editUsers->name = 'Edit Users';
		$editUsers->save();
		$editUsers->roles()->attach($admin_role);

		$user_role = Role::where('slug','user')->first();
		$admin_role = Role::where('slug', 'admin')->first();
		$user_perm = Permission::where('slug','create-tasks')->first();
		$admin_perm = Permission::where('slug','edit-users')->first();

		$user = new User();
		$user->firstName = 'Test_User';
		$user->email = 'test_user@gmail.com';
		$user->password = bcrypt('1234567');
		$user->save();
		$user->roles()->attach($user_role);
		$user->permissions()->attach($user_perm);

		$admin = new User();
		$admin->firstName = 'Test_Admin';
		$admin->email = 'test_admin@gmail.com';
		$admin->password = bcrypt('admin1234');
		$admin->save();
		$admin->roles()->attach($admin_role);
		$admin->permissions()->attach($admin_perm);

        die();
		return redirect()->back();
    }
}
