<?php


namespace App\Http\Controllers\Purchase;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

use App\Models\Purchase;
use App\Models\Deal;
use App\Models\InvoiceItem;
use App\Models\PaymentGateway;
use App\Models\Vendor;

use Illuminate\Support\Facades\DB;
use Auth;

class PurchaseController extends Controller {
    /**
    * Create a new controller instance.
    *
    * @return void
    */
    use \App\Http\Controllers\Traits\Functions;


    public function __construct() {
        $this->middleware( 'auth' );
    }


    public function index(){

        $purchaseYear = request()->get('purchaseYear') ? request()->get('purchaseYear') : date("Y");
        $purchaseMonth = request()->get('purchaseMonth') ? request()->get('purchaseMonth') : date("m");
        $purchaseVendor = request()->get('purchaseVendor') ? request()->get('purchaseVendor') : 'all';

        //year selection 
    $rawQuery ='';
    if($purchaseMonth != 'all'){
        $rawQuery .= 'MONTH(purchase.purchaseCreatedAt) = '.$purchaseMonth.' AND ';
        }
        if($purchaseVendor != 'all'){
         $rawQuery .= 'purchase.purchaseVendorId = '.$purchaseVendor.' AND ';
        }
    
        
        //month selection 
        $rawQuery .= 'YEAR(purchase.purchaseCreatedAt) = '.$purchaseYear;

        $vendors = Vendor::select('vendorId', 'vendorCompany')->where('vendorCompanyId', auth()->user()->userCompanyId)->get();

        $purchases = Purchase::select('purchaseVendorId',
        'purchaseSoId',
        'purchaseEmailCount',
        'purchaseRecieved',
        'purchaseTax',
        'purchaseShipping',
        'purchasePyamentCard',
        'purchaseGroupBy', 
        'purchaseCreatedAt',
        DB::raw('SUM(purchasePrice*purchaseActualItems) as total'))
        ->whereRaw($rawQuery)
        ->orderBy('purchaseCreatedAt', 'desc')
        ->groupBy(['purchaseSoId', 'purchaseGroupBy'])
        ->paginate(10);
        $purchaseYearArray   = $this->yearsList();
        $purchaseMonthArray   = $this->monthsList();
        return view('purchase.index', compact('vendors', 'purchases', 'purchaseYearArray', 'purchaseMonthArray', 'purchaseYear', 'purchaseMonth', 'purchaseVendor'));

    }

    public function edit_purchase($soid, $groupid){
     
        $creditcards = PaymentGateway::where('paymentGatewayCompanyId', auth()->user()->userCompanyId)
        ->where('paymentGatewayType', 'Credit Card')
        ->get();
        $vendors = Vendor::where('vendorCompanyId', auth()->user()->userCompanyId)
        ->get();
        $deal = Deal::where('dealSO', $soid)->first();
        $purchases = Purchase::where(['purchaseSoId' => $soid, 'purchaseGroupBy' => $groupid])->get();
        return view( 'purchase.edit', compact( 'deal' , 'purchases', 'soid', 'groupid', 'creditcards', 'vendors') );

    } 

    public function update_purchase(Request $request){
      
                
                    $purcharseComments = $request->purcharseComments;
                    $purchaseTax = $request->purchaseTax;
                    $purchaseShipping = $request->purchaseShipping;
                    $purchasePyamentCard = $request->purchasePyamentCard;
                    $purchaseActualItems = $request->purchaseActualItems;
                    $purchasePrice = $request->purchasePrice;
                    $soid = $request->soid;
                    $groupid = $request->groupid;
                    $ftyp = $request->ftyp;

           


                
                    $iftyp = $ftyp;

                    switch ($iftyp) {
                    case "payment":
                        $purchasePyamentCard = $request->purchasePyamentCard;
                       $updateArray = ['purchasePyamentCard' => $purchasePyamentCard];
                        break;

                    case "comment":
                        $purcharseComments = $request->purcharseComments;
                        $updateArray = ['purcharseComments' => $purcharseComments];
                        break;

                    case "tax":
                        $purchaseTax = $request->purchaseTax;
                        $updateArray = ['purchaseTax' => $purchaseTax];
                        break;

                    case "shipping":
                         $purchaseShipping = $request->purchaseShipping;
                         $updateArray = ['purchaseShipping' => $purchaseShipping];
                         break;

                     case "vendor":
                         $purchaseVendorId = $request->purchaseVendorId;
                         $updateArray = ['purchaseVendorId' => $purchaseVendorId];
                         break;
                    default:
                        echo "Your favorite color is neither red, blue, nor green!";
                    }


                    Purchase::where(['purchaseSoId' => $soid, 'purchaseGroupBy' => $groupid])->update($updateArray);




     return redirect()->back()->with( 'success', 'Purchase Updated Successfully.' );

    } 

    public function delete_item($id) {
        InvoiceItem::destroy($id);
        return redirect()->back()->with( 'success', 'Invoice Item Deleted Successfully.' );

    }
    /**
    * Show the application dashboard.
    *
    * @return \Illuminate\Contracts\Support\Renderable
    */
    

  

}
