<?php

namespace App\Http\Controllers;

use App\Models\DealItem;
use App\Models\Purchase;
use Illuminate\Http\Request;


class PurchaseController extends Controller {
    /**
    * Create a new controller instance.
    *
    * @return void
    */

    public function __construct() {
        $this->middleware( 'auth' );
    }

    public function index()
    {
        

    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request, $soid)
    {
   
        if(!Purchase::select('purchaseGroupBy')
        ->where('purchaseSoId', '=', $soid)
        ->exists()){
            $currentId = 1;
        }else{
            $groupId = Purchase::select('purchaseGroupBy')
            ->where('purchaseSoId', '=', $soid)
            ->first();
            $currentId = $groupId->purchaseGroupBy+1;
        }

     

     $items = $request->itemId;  
     $price = $request->dealItemUnitCost; 
     $qty = $request->dealItemQuantity; 
     $vendorId = $request->vendorId;
     $tax = $request->tax;
     $shipping = $request->shipping;
     
     $data = array();
     
     foreach ($items as $key => $value) 
     {
        
     $data[] = array(
     'purchaseSoId'=> $soid, 
     'purchaseGroupBy' => $currentId, 
     'purchaseItemId' => $value , 
     'purchaseVendorId' => $vendorId, 
     'purchaseShipping' => $shipping, 
     'purchaseTax' => $tax, 
     'purchasePrice' => $price[$key], 
     'purchaseActualItems' => $qty[$key], 
     'purchaseCreatedUserId' => auth()->user()->userId);
     }

    
     Purchase::insert($data);


        foreach ($items as $key => $value) {


        $resultItem = DealItem::select('dealItemsPurchased')
        ->where('dealItemId', '=', $value)
        ->first();

        $dealItemsPurchased = $resultItem->dealItemsPurchased + $qty[$key];

        $dealItemModifiedUserId = auth()->user()->userId;

        DealItem::where('dealItemId', $value)->update(['dealItemsPurchased'=>$dealItemsPurchased, 'dealItemModifiedUserId'=> $dealItemModifiedUserId]);

            

        }
      
        return redirect()->back()->with( 'success', 'Purchase Saved Successfully.' );


    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\Purchase  $purchase
     * @return \Illuminate\Http\Response
     */
    public function show($slug)
    {   

   
    }

    public function purchase_item_show(Request $request)
    {   

        $id = $request->pid;
        $purchase = Purchase::where('purchaseId', $id)->first();
        return view('purchase.ajax.purchase-item', compact('purchase') );

   
    }
    public function purchase_item_update(Request $request, $id)
    {   

        $purchase = Purchase::find($id);

        // Updating the Customer
        $purchase->update( [
            'purchasePrice' => $request->purchasePrice,
          
        ] );


        return redirect()->back()->with( 'success', 'Purchase Saved Successfully.' );

    }
  
    public function edit($slug)
    {
        
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\Team  $team
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $slug)
    {
 
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\ContentPage  $team
     * @return \Illuminate\Http\Response
     */
    public function destroy(ContentPage $team)
    {
        //
    }

  
}
