<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\PaymentGateway;
use App\Models\Reportingcc;
use App\Models\ReportingBank;
use App\Models\Bank;
use App\Models\Payable;
use App\Models\Invoice;
use App\Models\Deal;
use App\Models\Purchase;

use Illuminate\Support\Str;

use DB;

use Illuminate\Support\Facades\Hash;

class ReportingController extends Controller {
    /**
    * Create a new controller instance.
    *
    * @return void
    */
    use \App\Http\Controllers\Traits\Functions;

    public function __construct() {
        $this->middleware('auth');
    }

    /**
    * Show the application dashboard.
    *
    * @return \Illuminate\Contracts\Support\Renderable
    */


    public function get_receivable_aged($whereConditionArray)
    {
        $receivables_status = request()->get('receivables_status') ? request()->get('receivables_status') : 'default';

        $days = DB::table('invoices')
        ->select('deals.dealUserId', 'users.userCompany', 'deals.dealCompanyId',
        DB::raw('SUM(invoices.invoiceShippingCharges) as invoiceShippingCharges'),
        DB::raw('SUM(invoices.invoiceTaxValue) as invoiceTaxValue'),
        DB::raw('SUM(invoices.invoiceCreditCardCharges) as invoiceCreditCardCharges'),
        DB::raw('SUM(invoices.invoiceChargeAmount) as invoiceChargeAmount'),
        DB::raw('(SELECT SUM(invoiceItemQuantity*invoiceItemUnitCost) FROM invoice_items WHERE invoice_items.invoiceSoId = deals.dealSO group by deals.dealUserId) as total'))
        ->join('deals', 'deals.dealSO', '=', 'invoices.invoiceSoId')
        ->join('users', 'users.userId', '=', 'deals.dealUserId')
        ->where('deals.dealCompanyId', auth()->user()->userCompanyId)

        ->where('invoices.invoiceStatusType', $receivables_status)
        ->whereRaw('DATEDIFF(invoices.invoiceEndDateTime, CURDATE()) > '.$whereConditionArray['min_day'])
        ->whereRaw('DATEDIFF(invoices.invoiceEndDateTime, CURDATE()) < '.$whereConditionArray['max_day']) 
        ->groupBy('deals.dealUserId')
            ->get();

            $customers = array();
            
            foreach($days as $day){
                $dealUserId = $day->dealUserId;
                $userCompany = $day->userCompany;
                $invoiceShippingCharges = (double)$day->invoiceShippingCharges;
                $invoiceTaxValue = (double)$day->invoiceTaxValue;
                $invoiceChargeAmount = (double)$day->invoiceChargeAmount;
                $invoiceCreditCardCharges = (double)$day->invoiceCreditCardCharges;
                $total = (double)$day->total;
                // if(array_key_exists($dealUserId, $getTotal)){
                // $total = (double)$getTotal[$dealUserId];
                // }else{
                //     $total = 0;
                // }
                $netvalue = $invoiceShippingCharges+$invoiceChargeAmount+$invoiceCreditCardCharges+$invoiceTaxValue+$total;
                
            

              

                if (!array_key_exists($dealUserId, $this->customers))
                {
                    $this->customers[$dealUserId] = ['dealUserId' => $dealUserId, 'userCompany' => $userCompany, 'net_30' => 0, 'net_60' => 0
                    , 'net_90' => 0, 'over_90' => 0];
                }

                switch ($whereConditionArray['dayis']) {
                    case 30:
                        $this->customers[$dealUserId]['net_30'] = $netvalue;
                      break;
                    case 60:
                        if (array_key_exists($dealUserId, $this->customers))
                        {
                            $this->customers[$dealUserId]['net_60'] = $netvalue;
                        }
                        else
                        {
                            $this->customers[$dealUserId]['net_60'] = $netvalue;
                        }
                      break;
                    case 90:
                        if (array_key_exists($dealUserId, $this->customers))
                        {
                            $this->customers[$dealUserId]['net_90'] = $netvalue;
                        }
                        else
                        {
                            $this->customers[$dealUserId]['net_90'] = $netvalue;
                        }
                      break;
                      case 91:
                        if (array_key_exists($dealUserId, $this->customers))
                        {
                            $this->customers[$dealUserId]['over_90'] = $netvalue;
                        }
                        else
                        {
                            $this->customers[$dealUserId]['over_90'] = $netvalue;
                        }
                      break;
                    default:
                      echo "-";
                  }

                
                     
                }

          
          
    }

    public function index() {

  

       

      $payables['due_over_30'] = Payable::whereRaw('DATEDIFF(payableInvoiceDate, CURDATE()) BETWEEN  -30 AND -1')
                                  ->whereNotIn('payableTerm', ['cc'])
                                  ->selectRaw("COALESCE(SUM(payableProductCost),0) as payableProductCost,
                                  COALESCE(SUM(payableFrieght),0) as payableFrieght,
                                  COALESCE(SUM(payableTax),0) as payableTax,
                                  COALESCE(SUM(payableECW),0) as payableECW")
                                  ->where('payableCompanyId', '=', auth()->user()->userCompanyId)
                                ->first();


     $payables['due_over_60'] = Payable::whereRaw('DATEDIFF(payableInvoiceDate, CURDATE()) BETWEEN  -60 AND -31')
                                ->whereNotIn('payableTerm', ['cc'])
                                  ->selectRaw("COALESCE(SUM(payableProductCost),0) as payableProductCost,
                                  COALESCE(SUM(payableFrieght),0) as payableFrieght,
                                  COALESCE(SUM(payableTax),0) as payableTax,
                                  COALESCE(SUM(payableECW),0) as payableECW")
                                  ->where('payableCompanyId', '=', auth()->user()->userCompanyId)
                                ->first();

    
     $payables['due_over_90'] = Payable::whereRaw('DATEDIFF(payableInvoiceDate, CURDATE()) BETWEEN  -90 AND -61')
                                ->whereNotIn('payableTerm', ['cc'])
                                ->selectRaw("COALESCE(SUM(payableProductCost),0) as payableProductCost,
                                  COALESCE(SUM(payableFrieght),0) as payableFrieght,
                                  COALESCE(SUM(payableTax),0) as payableTax,
                                  COALESCE(SUM(payableECW),0) as payableECW")
                                  ->where('payableCompanyId', '=', auth()->user()->userCompanyId)
                                ->first();

     $payables['due_over_91'] = Payable::whereRaw('DATEDIFF(payableInvoiceDate, CURDATE()) <  -91')
                                ->whereNotIn('payableTerm', ['cc'])
                                ->selectRaw("COALESCE(SUM(payableProductCost),0) as payableProductCost,
                                COALESCE(SUM(payableFrieght),0) as payableFrieght,
                                COALESCE(SUM(payableTax),0) as payableTax,
                                COALESCE(SUM(payableECW),0) as payableECW")
                                ->where('payableCompanyId', '=', auth()->user()->userCompanyId)
                              ->first();


          //ages receivables

        $whereCompanyIdIs = "invoiceCompanyId = ".auth()->user()->userCompanyId;
          $receivables['due_over_30']= DB::select("SELECT COALESCE(SUM(invoices.invoiceTaxValue),0) as invoiceTaxValue, 
                                                    COALESCE(SUM(invoices.invoiceShippingCharges),0) as invoiceShippingCharges, 
                                                    COALESCE(SUM(invoice_items.invoiceItemQuantity*invoice_items.invoiceItemUnitCost),0) as subtotal
                                                    FROM invoices
                                                    INNER JOIN invoice_items ON invoice_items.invoiceItemInvoiceId=invoices.invoiceId 
                                                    WHERE invoicePaymentMethod NOT IN ('Credit Card') 
                                                    AND invoicePaid = 0
                                                    AND ".$whereCompanyIdIs."
                                                    AND DATEDIFF(invoiceEndDateTime, CURDATE()) 
                                                    BETWEEN  -30 AND -1");

        $receivables['due_over_30'] = $receivables['due_over_30'][0];
        $receivables['due_over_60']= DB::select("SELECT COALESCE(SUM(invoices.invoiceTaxValue),0) as invoiceTaxValue, 
                            COALESCE(SUM(invoices.invoiceShippingCharges),0) as invoiceShippingCharges, 
                            COALESCE(SUM(invoice_items.invoiceItemQuantity*invoice_items.invoiceItemUnitCost),0) as subtotal
                            FROM invoices
                            INNER JOIN invoice_items ON invoice_items.invoiceItemInvoiceId=invoices.invoiceId 
                            WHERE invoicePaymentMethod NOT IN ('Credit Card') 
                            AND invoicePaid = 0
                            AND ".$whereCompanyIdIs."
                            AND DATEDIFF(invoiceEndDateTime, CURDATE()) 
                            BETWEEN  -90 AND -61");                        

    $receivables['due_over_60'] = $receivables['due_over_60'][0];

    $receivables['due_over_90']= DB::select("SELECT COALESCE(SUM(invoices.invoiceTaxValue),0) as invoiceTaxValue, 
                                                  COALESCE(SUM(invoices.invoiceShippingCharges),0) as invoiceShippingCharges, 
                                                  COALESCE(SUM(invoice_items.invoiceItemQuantity*invoice_items.invoiceItemUnitCost),0) as subtotal
                                                  FROM invoices
                                                  INNER JOIN invoice_items ON invoice_items.invoiceItemInvoiceId=invoices.invoiceId 
                                                  WHERE invoicePaymentMethod NOT IN ('Credit Card') 
                                                  AND invoicePaid = 0
                                                  AND ".$whereCompanyIdIs."
                                                  AND DATEDIFF(invoiceEndDateTime, CURDATE()) 
                                                  BETWEEN  -90 AND -61");

      $receivables['due_over_90'] = $receivables['due_over_90'][0];

    $receivables['due_over_91']= DB::select("SELECT COALESCE(SUM(invoices.invoiceTaxValue),0) as invoiceTaxValue, 
                                COALESCE(SUM(invoices.invoiceShippingCharges),0) as invoiceShippingCharges, 
                                COALESCE(SUM(invoice_items.invoiceItemQuantity*invoice_items.invoiceItemUnitCost),0) as subtotal
                                FROM invoices
                                INNER JOIN invoice_items ON invoice_items.invoiceItemInvoiceId=invoices.invoiceId 
                                WHERE invoicePaymentMethod NOT IN ('Credit Card') 
                                AND invoicePaid = 0
                                AND ".$whereCompanyIdIs."
                                AND DATEDIFF(invoiceEndDateTime, CURDATE()) <  -91");

       $receivables['due_over_91'] = $receivables['due_over_91'][0];
     
      
        return view('reporting.index');
    }



    public function account_balances() {


 

    
  
      //Account Balances

        $payment_gateways = PaymentGateway::select('paymentGatewayId', 'paymentGatewayName')
                              ->where('paymentGatewayCompanyId', '=', auth()->user()->userCompanyId)
                              ->get();
        $banks = Bank::select('bankId', 'bankAccountTitle')
                ->where('bankCompanyId', '=', auth()->user()->userCompanyId)
                ->get();

            $accountBalances = [];

            foreach($payment_gateways as $payment_gateway){

            $reportingccCardId = $payment_gateway->paymentGatewayId;
            $reportingccCardName = $payment_gateway->paymentGatewayName;
            $reportingcc = Reportingcc::where('reportingccCardId', $reportingccCardId)
            ->selectRaw("COALESCE(SUM(reportingccDebit),0) as total_debit")
            ->selectRaw("COALESCE(SUM(reportingccCredit),0) as total_credit")
            ->groupBy('reportingccCardId')
            ->get();

            foreach($reportingcc as $reportingc){
            $total_debit = $reportingc->total_debit;
            $total_credit = $reportingc->total_credit;
            $accountBalances[] = ['cardId' => $reportingccCardId, 'cardName' => $reportingccCardName, 'paytype' => 'card', 'total_debit' => $total_debit , 'total_credit' => $total_credit ];
            }

          }

          foreach($banks as $bank){

            $reportingccCardId = $bank->bankId;
            $reportingccCardName = $bank->bankAccountTitle;

            $reportingBank = ReportingBank::where('bank_entry', $reportingccCardId)
            ->selectRaw("COALESCE(SUM(reportBankDebit),0) as total_debit")
            ->selectRaw("COALESCE(SUM(reportBankCredit),0) as total_credit")
            ->groupBy('bank_entry')
            ->get();

            foreach($reportingBank as $reportingc){
            $total_debit = $reportingc->total_debit;
            $total_credit = $reportingc->total_credit;
            $accountBalances[] = ['cardId' => $reportingccCardId,'cardName' => $reportingccCardName, 'paytype' => 'bank', 'total_debit' => $total_debit , 'total_credit' => $total_credit ];
            }

          }

          

     

        return view('reporting.partials.account-balances', compact('accountBalances'));
    }

    public function profit_loss()
    {


     
  
          $selectedYearArray   = $this->yearsList();
          $selectedMonthArray   = $this->monthsList();

          $selectedYear = request()->get('selectedYear') ? request()->get('selectedYear') : date("Y");
          $selectedMonth = request()->get('selectedMonth') ? request()->get('selectedMonth') : date("m");


          $rawQuery= '';



      if($selectedMonth != 'all'){
      $rawQuery .= 'MONTH(invoiceEndDateTime) = '.$selectedMonth.' AND ';
      }
  
      $rawQuery .= 'YEAR(invoiceEndDateTime) = '.$selectedYear;
      $rawQuery .=' AND invoiceCompanyId = '.auth()->user()->userCompanyId;

      $rawQuery .=' AND invoiceIsDeleted = 0';

      
     $all_invoices = Invoice::whereRaw($rawQuery)->count();

      $rawQuery .=' AND invoiceStatusType = "credit"';
 
      $credit_invoices = Invoice::whereRaw($rawQuery)->count();




      $rawQuery= '';



      if($selectedMonth != 'all'){
      $rawQuery .= 'MONTH(payableInvoiceDate) = '.$selectedMonth.' AND ';
      }
  
      $rawQuery .= 'YEAR(payableInvoiceDate) = '.$selectedYear;
      $rawQuery .=' AND payableCompanyId = '.auth()->user()->userCompanyId;

      $rawQuery .=' AND payableIsDeleted = 0';

      
     $all_payables = Payable::whereRaw($rawQuery)->count();

      $rawQuery .=' AND proceedType = "bank debit"';
 
      $debit_payables = Payable::whereRaw($rawQuery)->count();



      







      return view('reports.profit-loss.index', compact('all_invoices', 'credit_invoices', 'selectedMonth', 'selectedYear', 'selectedYearArray', 'selectedMonthArray' , 'all_payables', 'debit_payables'));

    }
    
    public function profit_loss_sheet(Request $request)
    {

$companyPrefix = auth()->user()->company->companyPrefix;
$dealYearArray   = $this->yearsList();
$dealMonthArray   = $this->monthsList();
$departments   = $this->departments();

// $dealYear = request()->get('dealYear') ? request()->get('dealYear') : date("Y");
// $dealMonth = request()->get('dealMonth') ? request()->get('dealMonth') : date("m");


 $rawQuery= '';



// //year selection 
// if($dealMonth != 'all'){
// $rawQuery .= 'MONTH(dealEndDateTime) = '.$dealMonth.' AND ';
// }
// //month selection 
// $rawQuery .= 'YEAR(dealEndDateTime) = '.$dealYear;

$rawQuery .=' dealCompanyId = '.auth()->user()->userCompanyId;


if(request()->get('onlysheet') == 'amazon'){

  $rawQuery .= ' AND dealPaymentMethod = "Amazon" ';
}
if(request()->get('sonumber')){
  $rawQuery = '';
  $rawQuery = 'dealSO ='.request()->get('sonumber');
  $rawQuery .=' AND dealCompanyId = '.auth()->user()->userCompanyId;
}

      $orders = Deal::select('dealSO' ,'dealPaymentMethod', 'dealTaxName', 'dealTaxValue', 'dealChargeType', 'dealChargeAmount')
      ->whereNotNull('dealSO')
      ->where('deals.dealRevised', 0)
      ->whereHas('saleorder', function ($query) {
        $dealYear = request()->get('dealYear') ? request()->get('dealYear') : date("Y");
        $dealMonth = request()->get('dealMonth') ? request()->get('dealMonth') : date("m");
        $rawQuery= 'closeOrder = 1';
        //year selection 
        if(!request()->get('sonumber')){

        if($dealMonth != 'all'){

          
        $rawQuery .= ' AND MONTH(salesorderMonthYear) = '.$dealMonth;
       
        }

        
        //month selection 
        $rawQuery .= ' AND YEAR(salesorderMonthYear) = '.$dealYear;

      }
        return $query->whereRaw($rawQuery);
    })
      ->has('creditInvoices')

    ->whereRaw($rawQuery)

      ->get();

//    $dealCreditCardChargesArray = [];
    $dealccAmazonArray = [];
    $dealtaxAmazonArray = [];
    $dealtaxAmazonDeductionArray = [];


 

      $all_records = [];
     
      $cinvr = 0;
      $cpayr = 0;
      foreach($orders as $order){

        $invoicesforcharges = [];
        $cc_amazonsum = [0];
        foreach($order->creditInvoices as $invoice){ $invoicesforcharges[] = $invoice->invoiceId; }
        
          
            $paypal_payments = DB::table('paypal_payment')
                    ->select('paypalPaymentCharges')
                    ->where('paypalPaymentDetail',implode(",",$invoicesforcharges))
                        ->get();
        foreach($paypal_payments as $paypal_payment){ $cc_amazonsum[] = $paypal_payment->paypalPaymentCharges; }
                      
   
        $so_record = [];
        $po_record = [];
        $addrows = 0;
        $whatincrease = '';
        $countInvoices = $order->creditInvoices->count(); 
        $countPayables = $order->debitPayables->count(); 
       $dealCreditCardCharges = $order->dealCreditCardCharges?$order->dealCreditCardCharges:0;
       $dealTaxName = $order->dealTaxName;
       $dealChargeType = $order->dealChargeType;

      // $paypalCharges = $order->paypal?$order->paypal->salesorderPaymentCharges:0;
      $paypalCharges = array_sum($cc_amazonsum);
       //$amazonTax = 0;

      // if($dealTaxName == 'Amazon Tax'){
      //   $amazonTax = $order->dealTaxValue?$order->dealTaxValue:0;

      // }

      // if($dealChargeType == 'Amazon Charges'){
      //   $paypalCharges = $order->dealChargeAmount?$order->dealChargeAmount:0;

      // }


       
        if($countInvoices > $countPayables)
        {
          $addrows = $countInvoices-$countPayables;
        
          $whatincrease = 'payables';

        }else{
          
          $whatincrease = 'invoices';
          $addrows = $countPayables-$countInvoices;
        }
        

        $invoices = [];

     

        foreach($order->creditInvoices as $keyi => $invoice):

        $invoiceReturn = 1;
        $isReturnText ='';
        if($invoice->invoiceType == 'return'){
          $invoiceReturn = -1;
          $isReturnText ='(Return)';

        }

        $invoice_frieght =  (double)$invoice->invoiceShippingCharges*$invoiceReturn;

        // if(!in_array($order->dealSO, $dealtaxAmazonArray)){
         
        //   $invoice_tax = (double)$amazonTax*$invoiceReturn;

        //   $dealtaxAmazonArray[] = $order->dealSO;
        // }else{
        //   $invoice_tax = (double)$invoice->invoiceTaxValue*$invoiceReturn;

        // }

        

        $invoice_tax =  (double)$invoice->invoiceTaxValue*$invoiceReturn;


        $invoice_gross_sale = ((double)$invoice->invSum->total+(double)$invoice->invoiceChargeAmount+(double)$invoice->invoiceCreditCardCharges)*$invoiceReturn;
        
        $idate = date_create($invoice->invoiceEndDateTime);
        $saleorderdate = date_create($order->saleorder->salesorderMonthYear);

        $invoices['invoiceId'] =  $invoice->invoiceId;
        $invoices['thetype'] =  $invoice->invoiceDepartmentId;
        $invoices['month'] = date_format($saleorderdate,"M").$isReturnText;
        $invoices['invoice'] = $invoice->invoiceSoId.'-'.$invoice->invoiceSoSerial;
        $invoices['invoice_date'] =date_format($idate,"M,d Y");
        $invoices['reference'] = $invoice->invoiceReference;
        $invoices['customer'] =$invoice->invoiceBillingCompany; 
        $invoices['state'] =$invoice->invoiceBillingState; 
        $invoices['gross_sale'] =  $invoice_gross_sale;
        $invoices['frieght'] =  $invoice_frieght;

      
    

        $invoices['tax'] = $invoice_tax;
       
        // if(!in_array($order->dealSO, $dealCreditCardChargesArray)){
        //   $invoiceCreditCardCharges =  $dealCreditCardCharges;
        // }else{
        // $invoiceCreditCardCharges =  0;
        // }
        $subtotal = ($invoice->invSum->total+$invoice_frieght+$invoice_tax+$invoice->invoiceChargeAmount+$invoice->invoiceCreditCardCharges)*$invoiceReturn;

        $invoices['invoice_total'] =$subtotal;
       

        if(!in_array($order->dealSO, $dealccAmazonArray)){
          $cc_amazon =  $paypalCharges;
          $dealccAmazonArray[] = $order->dealSO;
        }else{
        $cc_amazon =  0;
        }

        
       

     

        if($cc_amazon > 0){
          $cc_amazon = $cc_amazon*-1;
        }

        $invoices['cc_amazon'] =$cc_amazon;
        $deductTax = 0;
        // if(!in_array($order->dealSO, $dealtaxAmazonDeductionArray)){
         
        //   if($order->dealPaymentMethod == 'Amazon'){
        //     $deductTax = $invoice_tax;
        //   }
          
        //   $dealtaxAmazonDeductionArray[] = $order->dealSO;
        // }
       

        $invoices['net_sale_amount'] =$subtotal+$cc_amazon-$deductTax; 
        $so_record[] = $invoices;
     

      endforeach;

 
   if($whatincrease == 'invoices'):
    for($i = 1; $i <= $addrows; $i++):
      
      $invoices['thetype'] = '';
      $invoices['month'] = '';
      $invoices['invoice'] = '';
      $invoices['invoice_date'] ='';
      $invoices['reference'] = '';
      $invoices['customer'] = '';
      $invoices['state'] ='';
      $invoices['gross_sale'] = '';
      $invoices['frieght'] =  '';
      $invoices['tax'] = '';
      
      $invoices['invoice_total'] ='';

      $invoices['cc_amazon'] ='';
      $invoices['net_sale_amount'] ='';

      $so_record[] = $invoices;
      endfor;



    endif;
  
    $payables = [];
    foreach($order->debitPayables as $kp =>  $payable):
      $payableReturn = 1;
      if($payable->payableReturn == 1){
        $payableReturn = -1;
      }
      $payablesBankRecord = explode(",",$payable->payablesBankRecord);
      $pdate=date_create($payable->payableInvoiceDate);

      $payables['po_number'] = $payablesBankRecord[0];
      $payables['vendor'] = $payablesBankRecord[1];
      $payables['invoice_no'] = $payable->payableInvoiceNumber;
      $payables['pinvoice_date'] =date_format($pdate,"M,d Y");
      $payableProductCost = (double)$payable->payableProductCost*$payableReturn;
      $payableFrieght = (double)$payable->payableFrieght*$payableReturn;
      $payableTax = (double)$payable->payableTax*$payableReturn;
      $payableECW = (double)$payable->payableECW*$payableReturn;
         
      $payables['payable_product_cost'] =$payableProductCost;
      $payables['payable_frieght'] =$payableFrieght;
      $payables['payable_tax'] =$payableTax;
      $payables['payable_ecw'] =$payableECW;

      $payables['invoice_amount'] =$payableProductCost+$payableFrieght+$payableTax+$payableECW;

      $payables['payable_tracking'] = $payable->payableTrackingNumber;


      $payables['gross_profit'] =0;
            


      $po_record[] = $payables;

    
   
    endforeach;
          if($whatincrease == 'payables'):
          for($i = 1; $i <= $addrows; $i++):

            $payables['po_number'] = '';
            $payables['vendor'] = '';
            $payables['invoice_no'] = '';
            $payables['pinvoice_date'] ='';
            $payables['payable_product_cost'] ='';
            $payables['payable_frieght'] ='';
            $payables['payable_tax'] ='';
            $payables['payable_ecw'] ='';
              
            $payables['invoice_amount'] ='';

            $payables['payable_tracking'] = '';


            $payables['gross_profit'] =0;
                  
            $po_record[] = $payables;

          endfor;
          endif;

          
          foreach($po_record as $key => $po_recor){
           $all_records[] =  array_merge($so_record[$key],$po_recor);
          }
          
        //  $dealCreditCardChargesArray[] = $order->dealSO;
          
      }
     $dealYear = request()->get('dealYear') ? request()->get('dealYear') : date("Y");
$dealMonth = request()->get('dealMonth') ? request()->get('dealMonth') : date("m");

      
      return view('reports.profit-loss.profit-loss-sheet', compact('all_records', 'dealYearArray', 'dealMonthArray' , 'dealYear', 'dealMonth',  'departments'));

    }



   public function receivables_payables(Request $request){



    $dealYearArray   = $this->yearsList();
    $dealMonthArray   = $this->monthsList();
    
    $dealYear = request()->get('dealYear') ? request()->get('dealYear') : date("Y");
    $dealMonth = request()->get('dealMonth') ? request()->get('dealMonth') : date("m");
    
    
    $rawQuery= '';
    
    
    
    //year selection 
    if($dealMonth != 'all'){
    $rawQuery .= 'MONTH(dealEndDateTime) = '.$dealMonth.' AND ';
    }
    //month selection 
    $rawQuery .= 'YEAR(dealEndDateTime) = '.$dealYear;
    $rawQuery .=' AND dealCompanyId = '.auth()->user()->userCompanyId;
    
    
    
    if(request()->get('sonumber')){
      $rawQuery = '';
      $rawQuery = 'dealSO ='.request()->get('sonumber');
      $rawQuery .=' AND dealCompanyId = '.auth()->user()->userCompanyId;
    }
    
          $orders = Deal::select('dealSO')
          ->whereNotNull('dealSO')
          ->whereRaw($rawQuery)
    
          ->paginate(100);
    

    return view('reports.receivables-payables', compact('orders', 'dealYearArray', 'dealMonthArray' , 'dealYear', 'dealMonth'));


   }


   public function invoice_register_sheet(Request $request)
   {

 



      $dealYearArray   = $this->yearsList();
      $dealMonthArray   = $this->monthsList();

      $dealYear = request()->get('dealYear') ? request()->get('dealYear') : date("Y");
      $dealMonth = request()->get('dealMonth') ? request()->get('dealMonth') : date("m");


//       $rawQuery= '';



// //year selection 
// if($dealMonth != 'all'){
// $rawQuery .= 'MONTH(dealEndDateTime) = '.$dealMonth.' AND ';
// }
// //month selection 
// $rawQuery .= 'YEAR(dealEndDateTime) = '.$dealYear;
// $rawQuery .=' AND dealCompanyId = '.auth()->user()->userCompanyId;
// if(request()->get('testingmode')){
//     $rawQuery .= ' LIMIT 1 ';
// }


// if(request()->get('sonumber')){
//  $rawQuery = '';
//  $rawQuery = 'dealSO ='.request()->get('sonumber');
//  $rawQuery .=' AND dealCompanyId = '.auth()->user()->userCompanyId;
// }

//      $orders = Deal::select('dealSO')
//      ->whereNotNull('dealSO')
//      ->has('invoices')
//    ->whereRaw($rawQuery)
//      ->get();

     return view('reports.invoice-register-sheet', compact('dealYearArray', 'dealMonthArray' , 'dealYear', 'dealMonth'));

   }



   public function invoice_register_ajax(Request $request)
   {

 



      $dealYearArray   = $this->yearsList();
      $dealMonthArray   = $this->monthsList();

      $dealYear = request()->get('dealYear') ? request()->get('dealYear') : date("Y");
      $dealMonth = request()->get('dealMonth') ? request()->get('dealMonth') : date("m");


      $rawQuery= '';



//year selection 
if($dealMonth != 'all'){
$rawQuery .= 'MONTH(dealEndDateTime) = '.$dealMonth.' AND ';
}
//month selection 
$rawQuery .= 'YEAR(dealEndDateTime) = '.$dealYear;
$rawQuery .=' AND dealCompanyId = '.auth()->user()->userCompanyId;



if(request()->get('sonumber')){
 $rawQuery = '';
 $rawQuery = 'dealSO ='.request()->get('sonumber');
 $rawQuery .=' AND dealCompanyId = '.auth()->user()->userCompanyId;
}

     $orders = Deal::select('dealSO')
     ->whereNotNull('dealSO')
     ->has('invoices')
   ->whereRaw($rawQuery)
   
     ->get();

     return view('reports.invoice-register-ajax', compact('orders', 'dealYearArray', 'dealMonthArray' , 'dealYear', 'dealMonth'));

   }



   public function profit_loss_amazon(Request $request)
   {

 

$dealYearArray   = $this->yearsList();
$dealMonthArray   = $this->monthsList();

$dealYear = request()->get('dealYear') ? request()->get('dealYear') : date("Y");
$dealMonth = request()->get('dealMonth') ? request()->get('dealMonth') : date("m");


$rawQuery= '';



//year selection 
if($dealMonth != 'all'){
$rawQuery .= 'MONTH(dealEndDateTime) = '.$dealMonth.' AND ';
}
//month selection 
$rawQuery .= 'YEAR(dealEndDateTime) = '.$dealYear;
$rawQuery .=' AND dealCompanyId = '.auth()->user()->userCompanyId;



if(request()->get('sonumber')){
 $rawQuery = '';
 $rawQuery = 'dealSO ='.request()->get('sonumber');
 $rawQuery .=' AND dealCompanyId = '.auth()->user()->userCompanyId;
}

     $orders = Deal::select('dealSO' ,'dealPaymentMethod', 'dealTaxName', 'dealTaxValue', 'dealChargeType', 'dealChargeAmount')
     ->whereNotNull('dealSO')
     ->where('deals.dealRevised', 0)
     ->where('deals.dealPaymentMethod', 'Amazon')
     ->has('creditInvoices')
   //->whereMonth('dealEndDateTime', 11)
    //->where('dealPaymentMethod', 'Amazon')
   // ->whereYear('dealEndDateTime', 2022)

   ->whereRaw($rawQuery)

     ->get();

//    $dealCreditCardChargesArray = [];
   $dealccAmazonArray = [];

   
     $all_records = [];
    
     $cinvr = 0;
     $cpayr = 0;
     foreach($orders as $order){

       $so_record = [];
       $po_record = [];
       $addrows = 0;
       $whatincrease = '';
       $countInvoices = $order->creditInvoices->count(); 
       $countPayables = $order->debitPayables->count(); 
      $dealCreditCardCharges = $order->dealCreditCardCharges?$order->dealCreditCardCharges:0;
      $dealTaxName = $order->dealTaxName;
      $dealChargeType = $order->dealChargeType;

      $paypalCharges = $order->paypal?$order->paypal->salesorderPaymentCharges:0;

     // if($dealTaxName == 'Amazon Tax'){
     //   $paypalCharges = $order->dealTaxValue?$order->dealTaxValue:0;

     // }

    //  if($dealChargeType == 'Amazon Charges'){
    //    $paypalCharges = $order->dealChargeAmount?$order->dealChargeAmount:0;

    //  }
      
       if($countInvoices > $countPayables)
       {
         $addrows = $countInvoices-$countPayables;
       
         $whatincrease = 'payables';

       }else{
         
         $whatincrease = 'invoices';
         $addrows = $countPayables-$countInvoices;
       }
       

       $invoices = [];

    

       foreach($order->creditInvoices as $keyi => $invoice):

  
       $idate = date_create($invoice->invoiceEndDateTime);

       $invoices['thetype'] = '-';
       $invoices['month'] = date_format($idate,"M");
       $invoices['invoice'] = $invoice->invoiceSoId.'-'.$invoice->invoiceSoSerial;
       $invoices['invoice_date'] =date_format($idate,"M,d Y");
       $invoices['reference'] = $invoice->invoiceReference;
       $invoices['customer'] =$invoice->invoiceBillingCompany; 
       $invoices['state'] =$invoice->invoiceBillingState; 
       $invoices['gross_sale'] = (double)$invoice->invSum->total+(double)$invoice->invoiceChargeAmount+(double)$invoice->invoiceCreditCardCharges; 
       $invoices['frieght'] =  (double)$invoice->invoiceShippingCharges;
       $invoices['tax'] = (double)$invoice->invoiceTaxValue;
      
       // if(!in_array($order->dealSO, $dealCreditCardChargesArray)){
       //   $invoiceCreditCardCharges =  $dealCreditCardCharges;
       // }else{
       // $invoiceCreditCardCharges =  0;
       // }
       $subtotal = $invoice->invSum->total+$invoice->invoiceShippingCharges+$invoice->invoiceTaxValue+$invoice->invoiceChargeAmount+$invoice->invoiceCreditCardCharges;

       $invoices['invoice_total'] =$subtotal;
      

       if(!in_array($order->dealSO, $dealccAmazonArray)){
         $cc_amazon =  $paypalCharges;
       }else{
       $cc_amazon =  0;
       }

       

       if($cc_amazon > 0){
         $cc_amazon = $cc_amazon*-1;
       }

       $invoices['cc_amazon'] =$cc_amazon;
      
       $invoices['net_sale_amount'] =$subtotal+$cc_amazon; 
       $so_record[] = $invoices;

     endforeach;


  if($whatincrease == 'invoices'):
   for($i = 1; $i <= $addrows; $i++):
     
     $invoices['thetype'] = '';
     $invoices['month'] = '';
     $invoices['invoice'] = '';
     $invoices['invoice_date'] ='';
     $invoices['reference'] = '';
     $invoices['customer'] = '';
     $invoices['state'] ='';
     $invoices['gross_sale'] = '';
     $invoices['frieght'] =  '';
     $invoices['tax'] = '';
     
     $invoices['invoice_total'] ='';

     $invoices['cc_amazon'] ='';
     $invoices['net_sale_amount'] ='';

     $so_record[] = $invoices;
     endfor;



   endif;
 
   $payables = [];
   foreach($order->debitPayables as $kp =>  $payable):
 
     $payablesBankRecord = explode(",",$payable->payablesBankRecord);
     $pdate=date_create($payable->payableInvoiceDate);

     $payables['po_number'] = $payablesBankRecord[0];
     $payables['vendor'] = $payablesBankRecord[1];
     $payables['invoice_no'] = $payable->payableInvoiceNumber;
     $payables['pinvoice_date'] =date_format($pdate,"M,d Y");
     $payableProductCost = $payable->payableProductCost;
     $payableFrieght = $payable->payableFrieght;
     $payableTax = $payable->payableTax;
     $payableECW = $payable->payableECW;
        
     $payables['payable_product_cost'] =(double)$payableProductCost;
     $payables['payable_frieght'] =(double)$payableFrieght;
     $payables['payable_tax'] =(double)$payableTax;
     $payables['payable_ecw'] =(double)$payableECW;

     $payables['invoice_amount'] =(double)$payableProductCost+(double)$payableFrieght+(double)$payableTax+(double)$payableECW;

     $payables['payable_tracking'] = $payable->payableTrackingNumber;


     $payables['gross_profit'] =0;
           


     $po_record[] = $payables;

   
  
   endforeach;
         if($whatincrease == 'payables'):
         for($i = 1; $i <= $addrows; $i++):

           $payables['po_number'] = '';
           $payables['vendor'] = '';
           $payables['invoice_no'] = '';
           $payables['pinvoice_date'] ='';
           $payables['payable_product_cost'] ='';
           $payables['payable_frieght'] ='';
           $payables['payable_tax'] ='';
           $payables['payable_ecw'] ='';
             
           $payables['invoice_amount'] ='';

           $payables['payable_tracking'] = '';


           $payables['gross_profit'] =0;
                 
           $po_record[] = $payables;

         endfor;
         endif;

         
         foreach($po_record as $key => $po_recor){
          $all_records[] =  array_merge($so_record[$key],$po_recor);
         }
         
       //  $dealCreditCardChargesArray[] = $order->dealSO;
         $dealccAmazonArray[] = $order->dealSO;
         
     }
    
     return view('reports.profit-loss.profit-loss-sheet', compact('all_records', 'dealYearArray', 'dealMonthArray' , 'dealYear', 'dealMonth'));

   }


   public function return_deal_dateetc(){

      $invoiceId = request()->get('invoiceId');
      $ssid = explode("-",$invoiceId);
      $deal = Deal::select('dealTaxValue','dealChargeAmount', 'dealEndDateTime')->where('dealSO', $ssid[0])->first();
        $showarray = array('TaxValue' =>  $deal->dealTaxValue, 'ChargeAmount' =>  $deal->dealChargeAmount, 'DateTime' =>   date_format(date_create($deal->dealEndDateTime),"d M Y"));
       echo json_encode($showarray);
  


   }

public function sales_register()
{

      $selectedYearArray   = $this->yearsList();
          $selectedMonthArray   = $this->monthsList();

    $dealYear = request()->get('dealYear') ? request()->get('dealYear') : date("Y");
$dealMonth = request()->get('dealMonth') ? request()->get('dealMonth') : date("m");


$rawQuery= '';
if($dealMonth != 'all'){
$rawQuery .= 'MONTH(dealEndDateTime) = '.$dealMonth.' AND ';
}
$rawQuery .= 'YEAR(dealEndDateTime) = '.$dealYear;
$rawQuery .=' AND dealCompanyId = '.auth()->user()->userCompanyId;
     $orders = Deal::whereNotNull('dealSO')->whereRaw($rawQuery)->paginate(10000);
          return view('reports.sales-register', compact('orders', 'selectedYearArray', 'selectedMonthArray'));


}


public function purchase_register()
{

    $purchaseYear = request()->get('purchaseYear') ? request()->get('purchaseYear') : date("Y");
        $purchaseMonth = request()->get('purchaseMonth') ? request()->get('purchaseMonth') : date("m");

        //year selection 
    $rawQuery ='';
    if($purchaseMonth != 'all'){
        $rawQuery .= 'MONTH(purchase.purchaseCreatedAt) = '.$purchaseMonth.' AND ';
        }
       
    
        
        //month selection 
        $rawQuery .= 'YEAR(purchase.purchaseCreatedAt) = '.$purchaseYear;

      

        $orders = Purchase::select('purchaseVendorId',
        'purchaseSoId',
        'purchaseEmailCount',
        'purchaseRecieved',
        'purchaseTax',
        'purchaseShipping',
        'purchasePyamentCard',
        'purchaseGroupBy', 
        'purchaseCreatedAt',
        DB::raw('SUM(purchasePrice*purchaseActualItems) as total'))
        ->whereRaw($rawQuery)
        ->orderBy('purchaseCreatedAt', 'asc')
        ->groupBy(['purchaseSoId', 'purchaseGroupBy'])
        ->paginate(1000);
        $purchaseYearArray   = $this->yearsList();
        $purchaseMonthArray   = $this->monthsList();
        
        return view('reports.purchase-register', compact('orders', 'purchaseYearArray', 'purchaseMonthArray', 'purchaseYear', 'purchaseMonth'));


}

}
