<?php

namespace App\Http\Controllers\Reports;
use App\Http\Controllers\Controller;

use Illuminate\Http\Request;
use App\Models\Deal;
use App\Models\Invoice;
use DB;
use Illuminate\Support\Facades\Hash;

class AuditController extends Controller {
    use \App\Http\Controllers\Traits\Functions;


    /**
    * Create a new controller instance.
    *
    * @return void
    */

    public function __construct() {
        $this->middleware('auth');
    }

    /**
    * Show the application dashboard.
    *
    * @return \Illuminate\Contracts\Support\Renderable
    */



    public function index(Request $request)
    {

$companyPrefix = auth()->user()->company->companyPrefix;
$dealYearArray   = $this->yearsList();
$dealMonthArray   = $this->monthsList();
$departments   = $this->departments();
$dealYear = request()->get('dealYear') ? request()->get('dealYear') : date("Y");
$dealMonth = request()->get('dealMonth') ? request()->get('dealMonth') : date("m");
$rawQuery= '';


//year selection 
if($dealMonth != 'all'){
$rawQuery .= 'MONTH(invoiceEndDateTime) = '.$dealMonth.' AND ';
}
//month selection 
$rawQuery .= 'YEAR(invoiceEndDateTime) = '.$dealYear;
$rawQuery .=' AND invoiceCompanyId = '.auth()->user()->userCompanyId;

 $invoices = Invoice::whereRaw($rawQuery)->get();
       
  $all_records = [];

  foreach($invoices as $invoice){
    $single_record = [];
    foreach($invoice->invoiceItems as $itemkey => $item){
      
      if($itemkey == 0){
      $idate = date_create($invoice->invoiceEndDateTime);

      $single_record['thetype'] = $invoice->invoiceDepartmentId;
      $single_record['month'] = date_format($idate,"M");
      $single_record['invoice'] = $invoice->invoiceSoId.'-'.$invoice->invoiceSoSerial;
      $single_record['invoice_date'] =date_format($idate,"M,d Y");
      $single_record['thesin'] = $invoice->invoiceSin;
      $single_record['po_number'] = $invoice->invoiceReference;
      $single_record['bill_to'] =$invoice->invoiceBillingCompany; 
      $single_record['ship_to'] =$invoice->invoiceShippingContact; 
      $single_record['gross_sale'] = (double)$invoice->invSum->total+(double)$invoice->invoiceChargeAmount+(double)$invoice->invoiceCreditCardCharges+(double)$invoice->invoiceShippingCharges+(double)$invoice->invoiceShippingTax; 
      $single_record['frieght'] =  $invoice->invoiceShippingCharges ?  $invoice->invoiceShippingCharges : 0;
      //invoiceitems
      $single_record['invoiceItemName'] =  $item->invoiceItemName;
      $single_record['invoiceItemDescription'] =  $item->invoiceItemDescription;
      $single_record['invoiceItemQuantity'] =  $item->invoiceItemQuantity;
      $single_record['invoiceItemUnitCost'] =  $item->invoiceItemUnitCost;
    
    }else{
      $single_record['thetype'] = '-';
      $single_record['thetype'] = '-';
      $single_record['month'] = '-';
      $single_record['invoice'] ='-';
      $single_record['invoice_date'] ='-';
      $single_record['thesin'] = '-';
      $single_record['po_number'] = '-';
      $single_record['bill_to'] = '-';
      $single_record['ship_to'] = '-';
      $single_record['gross_sale'] ='-';
      $single_record['frieght'] =  '-';
      //invoiceitems
      $single_record['invoiceItemName'] =  $item->invoiceItemName;
      $single_record['invoiceItemDescription'] =  $item->invoiceItemDescription;
      $single_record['invoiceItemQuantity'] =  $item->invoiceItemQuantity;
      $single_record['invoiceItemUnitCost'] =  $item->invoiceItemUnitCost;
     
    } 

  }
      $all_records[] = $single_record;
  }
 
       
    
      return view('reports.audit.index', compact('all_records', 'dealYearArray', 'dealMonthArray' , 'dealYear', 'dealMonth',  'departments'));

    }





 


  



  

}
