<?php

namespace App\Http\Controllers\Reports;
use App\Http\Controllers\Controller;

use Illuminate\Http\Request;
use App\Models\PaymentGateway;
use App\Models\Reportingcc;
use App\Models\ReportingBank;
use App\Models\Bank;
use App\Models\Invoice;
use PDF;
use DB;
use Illuminate\Support\Facades\Hash;

class BankController extends Controller {
    /**
    * Create a new controller instance.
    *
    * @return void
    */
    use \App\Http\Controllers\Traits\Functions;

    public function __construct() {
        $this->middleware( 'auth' );
    }

    /**
    * Show the application dashboard.
    *
    * @return \Illuminate\Contracts\Support\Renderable
    */

    public function index() {
        if(!(request()->get('selected_bank'))){
          abort(404);
        }
        $selected_bank = hex2bin(request()->get('selected_bank'));

        $bankYearArray   = $this->yearsList();
        $bankMonthArray   = $this->monthsList();

        $bankYear = request()->get('bankYear') ? request()->get('bankYear') : date("Y");
        $bankMonth = request()->get('bankMonth') ? request()->get('bankMonth') : date("m");
       
       
        $rawQuery= '';
      

        //year selection 
        if($bankMonth != 'all'){
        $rawQuery .= 'MONTH(reportBankDate) = '.$bankMonth.' AND ';
        }
        //month selection 
        $rawQuery .= 'YEAR(reportBankDate) = '.$bankYear;

        $bank = Bank::select('bankAccountTitle')
                    ->where('bankCompanyId', auth()->user()->userCompanyId)
                    ->where('bankId', $selected_bank)
                    ->first();
                    $summary = ReportingBank::selectRaw("COALESCE(SUM(reportBankDebit),0) as total_debit")
                    ->selectRaw("COALESCE(SUM(reportBankCredit),0) as total_credit")
                    ->where('bank_entry', $selected_bank)
                    ->whereRaw($rawQuery)
                    ->first();
        $transactions = ReportingBank::query()
                            ->where('reportBankCompanyId', auth()->user()->userCompanyId)
                            ->orderBy('reportBankId', 'desc')
                            ->whereRaw($rawQuery)
                            ->where('bank_entry', $selected_bank)
                            ->paginate();
    
        return view('banks.transactions', compact('transactions', 
        'bankYearArray','bankMonthArray','bankYear','bankMonth', 'bank', 'summary'));
    }

    public function show($slug) {

      $payment_gateway = Bank::where('bankId', hex2bin($slug))->first();
      $q =  ReportingBank::query();
                        if(\Request::get('category_name')){
                            if(\Request::get('category_name') != 'all'){
                            $q->where('reportBankCategory', \Request::get('category_name'));
                            }
                        }
                    $q =  $q->where('bank_entry', hex2bin($slug))
                        ->orderBy('reportBankId', 'desc')
                        ->paginate(50);  
        $bank_details = $q;
       $categories =  ReportingBank::select('reportBankCategory')
                        ->where('bank_entry', hex2bin($slug))
                        ->groupBy('reportBankCategory')
                        ->get(); 
      return view('reporting.bank.show', compact('payment_gateway', 'bank_details', 'categories'));
  }

  public function bank_pdf() {
    if(!(request()->get('selected_bank') || !request()->get('from_date') || !request()->get('to_date'))){
      abort(404);
    }

    $selected_bank = hex2bin(request()->get('selected_bank'));
    $bank = Bank::where('bankCompanyId', auth()->user()->userCompanyId)
    ->where('bankId', $selected_bank)
    ->first();


 

    $q =  ReportingBank::query();
                        if(\Request::get('select_type')){
                            if(\Request::get('select_type') != 'all'){
                            $q->where('reportBankCategory', \Request::get('select_type'));
                            }
                        }
                        if(\Request::get('from_date')){
                          
                            $q->whereDate('reportBankDate','>=', \Request::get('from_date'));
                            
                        }

                        if(\Request::get('to_date')){
                          
                            $q->whereDate('reportBankDate','<=', \Request::get('to_date'));
                            
                        }
                    $q = $q->where('reportBankCompanyId', auth()->user()->userCompanyId)
                    ->orderBy('reportBankId', 'desc')
                    ->where('bank_entry', $selected_bank)
                        ->get();  
       
                $data['transactions'] = $q;
                $data['bank'] = $bank;
                    $pdf = PDF::loadView('pdf.bank-transactions', $data);
                    return $pdf->stream();

}


public function update_transaction(Request $request, $id)
{
    
    $transaction = ReportingBank::where('reportBankId', $id)->first();
  
    $transaction->reportBankCategory = $request->reportBankCategory;
    $transaction->reportBankAllocation = $request->reportBankAllocation;
    $transaction->reportBankRefrence = $request->reportBankRefrence;
    $transaction->update();
    return back()->with('message', 'Record Successfully Updated!');
}


public function detail_invoices(Request $request) {
    $invs =  explode(',', $request->getinvs);

    $invoices = DB::table('invoices')
                ->select('invoices.invoiceId', 'invoices.invoiceDueDate','invoices.invoiceSoId', 'invoices.invoiceSoSerial',
                DB::raw('SUM(invoices.invoiceShippingCharges) as invoiceShippingCharges'),
                DB::raw('SUM(invoices.invoiceTaxValue) as invoiceTaxValue'),
                DB::raw('SUM(invoices.invoiceChargeAmount) as invoiceChargeAmount'),
                DB::raw('SUM(invoices.invoiceCreditCardCharges) as invoiceCreditCardCharges'),
                DB::raw('SUM(invoice_items.invoiceItemQuantity*invoice_items.invoiceItemUnitCost) as total'))
                ->join('invoice_items', 'invoice_items.invoiceItemInvoiceId', '=', 'invoices.invoiceId')
                ->whereIn('invoices.invoiceId', $invs)
                ->groupBy('invoices.invoiceId')
                    ->get();
return view('reporting.receivables.ajax.unpresented', compact('invoices'));

}

public function detail_payables(Request $request) {
    $invs =  explode(',', $request->getinvs);

    
                    $invoices = DB::table('payables')
                    ->where('payables.payableReturn', 0)
                    ->where('payables.payableIsDeleted', 0)
                    ->whereIn('payables.payableId', $invs)
                        ->get();
return view('reporting.payables.ajax.selected-invoices', compact('invoices'));

}


public function transaction_details($id){
    $transaction = ReportingBank::where('reportBankCompanyId', auth()->user()->userCompanyId)
    ->where('reportBankId', $id)
    ->select('reportBankDetail', 'reportBankCategory')->first();
    
    if($transaction->reportBankCategory == 'INCOME'){
       $invoices = $this->showInvoices($transaction->reportBankDetail);
       return view('banks.partials.invoices', compact('invoices'));
    }
    if($transaction->reportBankCategory == 'PURCHASE'){
        $payables = $this->showPayables($transaction->reportBankDetail);
        return view('banks.partials.payables', compact('payables'));
     }

     if($transaction->reportBankCategory == 'EXPENSE'){
        $expenses = $this->showExpenses($transaction->reportBankDetail);
        
        return view('banks.partials.expenses', compact('expenses'));
     }
}


protected function showExpenses($reportBankDetail){
    $expenses = DB::table('expenses')
    ->select('expenses.expenseVendorId', 'expenses.expenseInvoiceNo', 'expenses.expenseId',
    'expenseEndDateTime', 'expenseDueDate',
    'expenseReference',
    DB::raw('SUM(DISTINCT expenses.expenseTax) as expenseTax'),
    DB::raw('SUM(expense_items.expenseItemQuantity*expense_items.expenseItemUnitCost) as total'))
    ->join('expense_items', 'expense_items.expenseItemExpenseId', '=', 'expenses.expenseId')

    ->where('expenses.expenseCompanyId', auth()->user()->userCompanyId)
    ->whereIn('expenses.expenseId', explode(',', $reportBankDetail))
    ->groupBy('expenses.expenseId')
    ->orderBy('expenses.expenseId', 'desc')
    ->get();
 
    return $expenses;

}

protected function showPayables($reportBankDetail){

    $payables = DB::table('payables')
    ->select('payables.payableId', 
    'payables.payableInvoiceNumber',
    'payables.payableTrackingNumber',
    'payables.payableInvoiceDate',
    'payables.payableProductCost', 
    'payables.payableFrieght', 
    'payables.payableTax',
    'payables.payableECW')
    ->where('payables.payableCompanyId', auth()->user()->userCompanyId)
    ->where('payables.payableIsDeleted', 0)
    ->whereIn('payables.payableId',  explode(',', $reportBankDetail))
        ->get();

        return $payables;

}

protected function showInvoices($reportBankDetail){
    

    $results = DB::table('invoices')
    ->select('invoices.invoiceId','invoices.invoiceSoId', 'invoices.invoiceSoSerial', 'invoiceBillingCompany',
    DB::raw('IFNULL(invoiceShippingCharges, 0) as invoiceShippingCharges'), 
    DB::raw('IFNULL(invoiceTaxValue, 0) as invoiceTaxValue'),
    DB::raw('IFNULL(invoiceChargeAmount, 0) as invoiceChargeAmount'),
    DB::raw('IFNULL(invoiceCreditCardCharges, 0) as invoiceCreditCardCharges'),
    DB::raw('SUM(invoice_items.invoiceItemQuantity*invoice_items.invoiceItemUnitCost) as total'))
    ->join('invoice_items', 'invoice_items.invoiceItemInvoiceId', '=', 'invoices.invoiceId')
    ->where('invoices.invoiceCompanyId', auth()->user()->userCompanyId)
    ->whereIn('invoices.invoiceId',  explode(',', $reportBankDetail))
    ->groupBy('invoices.invoiceId')
    ->orderBy('invoices.invoiceId', 'desc')
    ->get();
    
    return $results;
}

public function destroy($id)
{
   
    try {
        $transaction = ReportingBank::where('reportBankCompanyId', auth()->user()->userCompanyId)
            ->where('reportBankId', $id)
            ->select('reportBankDetail', 'reportBankCategory')
            ->firstOrFail();
        
        $details = $transaction->reportBankDetail;
       
        $destroyed = ReportingBank::destroy($id);
    
        if ($destroyed) {
            if($transaction->reportBankCategory == 'INCOME'){
                DB::table('invoices')->whereIn('invoiceId', explode(',', $details))->update(['invoiceStatusType'=>'default']);
            }
            if($transaction->reportBankCategory == 'PURCHASE'){
                DB::table('payables')->whereIn('payableId', explode(',', $details))->update(['proceedType'=>'default']);
            }
            if($transaction->reportBankCategory == 'EXPENSE'){
                DB::table('expenses')->whereIn('expenseId', explode(',', $details))->update(['expenseStatusType'=>'default']);
            }
       }
  
      return response()->json(['success' => true]);   
    
    } catch (\Throwable $e) {
        // Handle the exception here
        echo "Error updating invoices: " . $e->getMessage();

    }
    
    
    
    
    
    
    
}

}
