<?php

namespace App\Http\Controllers\Reports;
use App\Http\Controllers\Controller;

use Illuminate\Http\Request;
use App\Models\PaymentGateway;
use App\Models\Reportingcc;
use App\Models\ReportingBank;
use App\Models\Bank;
use App\Models\ReportingPaypal;


use Illuminate\Support\Facades\Hash;

class CreditCardController extends Controller {
    /**
    * Create a new controller instance.
    *
    * @return void
    */

    public function __construct() {
        $this->middleware( 'auth' );
    }

    /**
    * Show the application dashboard.
    *
    * @return \Illuminate\Contracts\Support\Renderable
    */

    public function index() {

        $payment_gateways = PaymentGateway::select('paymentGatewayId', 'paymentGatewayName')
                                            ->get();
        $banks = Bank::select('bankId', 'bankAccountTitle')
                  ->where('bankCompanyId', auth()->user()->userCompanyId)
                  ->get();

            $accountBalances = [];

            foreach($payment_gateways as $payment_gateway){

            $reportingccCardId = $payment_gateway->paymentGatewayId;
            $reportingccCardName = $payment_gateway->paymentGatewayName;
            $reportingcc = Reportingcc::where('reportingccCardId', $reportingccCardId)
            ->selectRaw("COALESCE(SUM(reportingccDebit),0) as total_debit")
            ->selectRaw("COALESCE(SUM(reportingccCredit),0) as total_credit")
            ->groupBy('reportingccCardId')
            ->get();

            foreach($reportingcc as $reportingc){
            $total_debit = $reportingc->total_debit;
            $total_credit = $reportingc->total_credit;
            $accountBalances[] = ['cardId' => $reportingccCardId, 'cardName' => $reportingccCardName, 'paytype' => 'card', 'total_debit' => $total_debit , 'total_credit' => $total_credit ];
            }

          }

          foreach($banks as $bank){

            $reportingccCardId = $bank->bankId;
            $reportingccCardName = $bank->bankAccountTitle;

            $reportingBank = ReportingBank::where('bank_entry', $reportingccCardId)
            ->selectRaw("COALESCE(SUM(reportBankDebit),0) as total_debit")
            ->selectRaw("COALESCE(SUM(reportBankCredit),0) as total_credit")
            ->groupBy('bank_entry')
            ->get();

            foreach($reportingBank as $reportingc){
            $total_debit = $reportingc->total_debit;
            $total_credit = $reportingc->total_credit;
            $accountBalances[] = ['cardId' => $reportingccCardId,'cardName' => $reportingccCardName, 'paytype' => 'bank', 'total_debit' => $total_debit , 'total_credit' => $total_credit ];
            }

          }
        return view('reporting.index', compact('accountBalances'));
    }

    public function show($slug) {

      $payment_gateway = PaymentGateway::where('paymentGatewayId', hex2bin($slug))->first();
      $bank_details = Reportingcc::where('reportingccCardId', hex2bin($slug))
                                  ->orderBy('reportingccId', 'desc')
                                  ->paginate(50);  

                                  $categories =  Reportingcc::select('reportingccCategory')
                                  ->where('reportingccCardId', hex2bin($slug))
                                  ->groupBy('reportingccCategory')
                                  ->get();      
                                               
      return view('reporting.credit-cards.show', compact('payment_gateway', 'bank_details', 'categories'));
  }

  public function transactions() {
  
    if(request()->get('selected_card')){

    $selected_card = hex2bin(request()->get('selected_card'));
    $gateway = PaymentGateway::where('paymentGatewayCompanyId', auth()->user()->userCompanyId)
    ->where('paymentGatewayId', $selected_card)
    ->first();
    $summary = Reportingcc::selectRaw("COALESCE(SUM(reportingccDebit),0) as total_debit")
    ->selectRaw("COALESCE(SUM(reportingccCredit),0) as total_credit")
    ->where('reportingccCardId', $selected_card)
    ->first();
    
    $transactions = Reportingcc::where('reportingccCardId', $selected_card)
    ->orderBy('reportingccId', 'desc')
    ->paginate(10);

    return view('credit-cards.transactions', compact('transactions', 'gateway', 'summary'));

    }

    if(request()->get('selected_paypal')){

      $selected_card = hex2bin(request()->get('selected_paypal'));
      $gateway = PaymentGateway::where('paymentGatewayCompanyId', auth()->user()->userCompanyId)
      ->where('paymentGatewayId', $selected_card)
      ->first();
  
      $transactions = ReportingPaypal::where('paypalPaymentCardId', $selected_card)
      ->orderBy('paypalPaymentId', 'desc')
      ->paginate(50);

      $summary = ReportingPaypal::selectRaw("COALESCE(SUM(paypalPaymentDebit),0) as total_debit")
      ->selectRaw("COALESCE(SUM(paypalPaymentCredit),0) as total_credit")
      ->where('paypalPaymentCardId', $selected_card)
      ->first();
      
      $banks = Bank::select('bankId', 'bankAccountTitle')
      ->where('bankCompanyId', auth()->user()->userCompanyId)
      ->get();
      

      return view('credit-cards.paypal-transactions', compact('transactions', 'gateway', 'banks', 'summary'));
  
      }else{
        abort(404);
      }

     
}
public function paypal_store(Request $request, $id){
  
  

  $date = date_create($request->paypalDate); 
  $paypalBankId = $request->bank_entry;
  $paypalCredit = (double)$request->paypalCredit;
  $fdate = date_format($date,"Y/m/d H:i:s");
  $byear = date_format($date,"Y");
  $paypalDescription = $request->paypalDescription;
  $paypalCategory = $request->paypalCategory;

  $bank = Bank::select('bankAccountTitle')
  ->where('bankId', $paypalBankId)
  ->first();
  
  $card = new ReportingPaypal();
  $userId = auth()->user()->userId;
  $card->paypalPaymentDescription = $paypalDescription;
  $card->paypalPaymentGateway = 'Paypal';
  $card->paypalPaymentCategory = $request->paypalCategory;
  $card->paypalPaymentCharges = 0;
  $card->paypalTotalCharges = 0;
  $card->paypalPaymentDebit = 0;
  $card->paypalPaymentCredit = $paypalCredit;
  $card->paypalPaymentAllocation = $request->paypalCategory;
  $card->paypalPaymentReference =  $bank->bankAccountTitle;
  $card->paypalPaymentDate = $fdate;
  $card->paypalPaymentCardId = $id;
  $card->paypalPaymentCompanyId = auth()->user()->userCompanyId;
  $card->paypalPaymentUserId = auth()->user()->userId;
  $card->paypalPaymentDetail = NULL;
  $card->save();

  if($card){

    if($paypalCategory == "fee")
    {
       
      
           
            // $expenseData = array(
            // 'reportBankCategory' => 'EXPENSE',
            // 'reportBankDescription' => 'source(paypal)',
            // 'reportBankDebit'=> $paypalCredit,
            // 'reportBankAllocation' => 'NONE',
            // 'reportBankRefrence' => 'NONE',
            // 'reportBankYear' => $byear,
            // 'bank_entry' => $paypalBankId,
            // 'reportBankCreatedUserId' => $userId

            //  );


    }

   if($paypalCategory == "transfer to bank")
    {

    
             $bank_entry = new ReportingBank();
             $bank_entry->reportBankDescription = $paypalDescription;
             $bank_entry->reportBankCategory = 'PAYPAL';
             $bank_entry->reportBankDebit = 0;
             $bank_entry->reportBankCredit = $paypalCredit;
             $bank_entry->reportBankAllocation = 'PAYPAL TO BANK';
             $bank_entry->reportBankRefrence = 'BANK';
             $bank_entry->reportBankDate = $fdate;
             $bank_entry->reportBankYear = $byear;
             $bank_entry->bank_entry = (int)$paypalBankId;
             $bank_entry->reportBankCompanyId = auth()->user()->userCompanyId;
             $bank_entry->reportBankCreatedUserId = $userId;
             $bank_entry->reportBankDetail = NULL;
             $bank_entry->save();

    }



  }

  return redirect()->back()->with('success','Transaction Successful.');;

}




public function transaction_details($id){
  $transaction = Reportingcc::where('reportingccCompanyId', auth()->user()->userCompanyId)
  ->where('reportingccId', $id)
  ->select('reportingccDetail', 'reportingccCategory')->first();
  dd($transaction);
  $category = $transaction->reportingccCategory;
  $detail = $transaction->reportingccDetail;
  if($category == 'INCOME'){
     $invoices = $this->showInvoices($detail);
     return view('banks.partials.invoices', compact('invoices'));
  }
  if($category == 'PURCHASE'){
      $payables = $this->showPayables($detail);
      return view('banks.partials.payables', compact('payables'));
   }

   if($category == 'EXPENSE'){
      $expenses = $this->showExpenses($detail);
      
      return view('banks.partials.expenses', compact('expenses'));
   }
}


protected function showExpenses($reportBankDetail){
  $expenses = DB::table('expenses')
  ->select('expenses.expenseVendorId', 'expenses.expenseInvoiceNo', 'expenses.expenseId',
  'expenseEndDateTime', 'expenseDueDate',
  'expenseReference',
  DB::raw('SUM(DISTINCT expenses.expenseTax) as expenseTax'),
  DB::raw('SUM(expense_items.expenseItemQuantity*expense_items.expenseItemUnitCost) as total'))
  ->join('expense_items', 'expense_items.expenseItemExpenseId', '=', 'expenses.expenseId')

  ->where('expenses.expenseCompanyId', auth()->user()->userCompanyId)
  ->whereIn('expenses.expenseId', explode(',', $reportBankDetail))
  ->groupBy('expenses.expenseId')
  ->orderBy('expenses.expenseId', 'desc')
  ->get();

  return $expenses;

}

protected function showPayables($reportBankDetail){

  $payables = DB::table('payables')
  ->select('payables.payableId', 
  'payables.payableInvoiceNumber',
  'payables.payableTrackingNumber',
  'payables.payableInvoiceDate',
  'payables.payableProductCost', 
  'payables.payableFrieght', 
  'payables.payableTax',
  'payables.payableECW')
  ->where('payables.payableCompanyId', auth()->user()->userCompanyId)
  ->where('payables.payableIsDeleted', 0)
  ->whereIn('payables.payableId',  explode(',', $reportBankDetail))
      ->get();

      return $payables;

}

protected function showInvoices($reportBankDetail){
  

  $results = DB::table('invoices')
  ->select('invoices.invoiceId','invoices.invoiceSoId', 'invoices.invoiceSoSerial', 'invoiceBillingCompany',
  DB::raw('IFNULL(invoiceShippingCharges, 0) as invoiceShippingCharges'), 
  DB::raw('IFNULL(invoiceTaxValue, 0) as invoiceTaxValue'),
  DB::raw('IFNULL(invoiceChargeAmount, 0) as invoiceChargeAmount'),
  DB::raw('IFNULL(invoiceCreditCardCharges, 0) as invoiceCreditCardCharges'),
  DB::raw('SUM(invoice_items.invoiceItemQuantity*invoice_items.invoiceItemUnitCost) as total'))
  ->join('invoice_items', 'invoice_items.invoiceItemInvoiceId', '=', 'invoices.invoiceId')
  ->where('invoices.invoiceCompanyId', auth()->user()->userCompanyId)
  ->whereIn('invoices.invoiceId',  explode(',', $reportBankDetail))
  ->groupBy('invoices.invoiceId')
  ->orderBy('invoices.invoiceId', 'desc')
  ->get();
  
  return $results;
}

public function destroy($id)
{
 
  try {
      
          $transaction = Reportingcc::where('reportingccCompanyId', auth()->user()->userCompanyId)
          ->where('reportingccId', $id)
          ->select('reportingccId','reportingccDetail', 'reportingccCategory')->first();
      
      $details = $transaction->reportingccDetail;
     
      $destroyed = $transaction->destroy($id);
  
      if ($destroyed) {
          if($transaction->reportBankCategory == 'INCOME'){
              DB::table('invoices')->whereIn('invoiceId', explode(',', $details))->update(['invoiceStatusType'=>'default']);
          }
          if($transaction->reportBankCategory == 'PURCHASE'){
              DB::table('payables')->whereIn('payableId', explode(',', $details))->update(['proceedType'=>'default']);
          }
          if($transaction->reportBankCategory == 'EXPENSE'){
              DB::table('expenses')->whereIn('expenseId', explode(',', $details))->update(['expenseStatusType'=>'default']);
          }
     }

    return response()->json(['success' => true]);   
  
  } catch (\Throwable $e) {
      // Handle the exception here
      echo "Error updating invoices: " . $e->getMessage();

  }
  
  



}

}