<?php

namespace App\Http\Controllers\Reports;
use App\Http\Controllers\Controller;

use Illuminate\Http\Request;
use App\Models\Expense;
use App\Models\ExpenseItem;
use App\Models\Bank;
use App\Models\PaymentGateway;
use App\Models\ReportingBank;
use App\Models\Reportingcc;
use Carbon\Carbon;


use Illuminate\Support\Str;


use App\Models\Hoav;
use DB;
use Illuminate\Support\Facades\Hash;

class ExpenseController extends Controller {
    /**
    * Create a new controller instance.
    *
    * @return void
    */

    public $vendors = [];
    public $vendor_invs = [];
    public function __construct() {
        $this->middleware( 'auth' );
    }

    /**
    * Show the application dashboard.
    *
    * @return \Illuminate\Contracts\Support\Renderable
    */
    use \App\Http\Controllers\Traits\Functions;

    public function index() {

        $expenseYearArray   = $this->yearsList();
        $expenseMonthArray   = $this->monthsList();

        $expenseYear = request()->get('expenseYear') ? request()->get('expenseYear') : date("Y");
        $expenseMonth = request()->get('expenseMonth') ? request()->get('expenseMonth') : date("m");
       
       
        $rawQuery= '';
      

        //year selection 
        if($expenseMonth != 'all'){
        $rawQuery .= 'MONTH(expenses.expenseEndDateTime) = '.$expenseMonth.' AND ';
        }
        //month selection 
        $rawQuery .= 'YEAR(expenses.expenseEndDateTime) = '.$expenseYear;
        $rawQuery .=' AND expenses.expenseCompanyId = '.auth()->user()->userCompanyId;
        
        $expenses = DB::table('expenses')
        ->select('expenses.expenseReference',
        'expenses.expenseId', 
        'expenses.expensePaymentMethod', 
        'expenses.expenseEndDateTime', 
        'expenses.expenseDueDate',
        'expenses.expenseInvoiceNo',
        'expenses.expenseStatusType',
        'expenses.expenseGateway',
        'expense_hoav.hoavName',
        'expenses.expenseTax', DB::raw('SUM(expenseItemQuantity) as
        qtyTotal'), DB::raw('SUM(expense_items.expenseItemQuantity*expense_items.expenseItemUnitCost) as total'))
        ->join('expense_items', 'expense_items.expenseItemExpenseId', '=', 'expenses.expenseId')
        ->join('expense_hoav', 'expense_hoav.hoavId', '=', 'expenses.expenseHoaId')
        ->whereRaw($rawQuery)
        ->groupBy('expenses.expenseId')
        ->orderBy('expenses.expenseId', 'desc')
        ->get();


        $overalltotal = DB::table('expenses')
        ->select('expenses.expenseEndDateTime', DB::raw('SUM(expenseTax) as
        expenseTax'), DB::raw('SUM(expenseItemQuantity) as
        qtyTotal'), DB::raw('SUM(expense_items.expenseItemQuantity*expense_items.expenseItemUnitCost) as total'))
        ->join('expense_items', 'expense_items.expenseItemExpenseId', '=', 'expenses.expenseId')
        ->where('expenses.expenseCompanyId', auth()->user()->userCompanyId)
        ->whereRaw($rawQuery)
        ->first();

    
        

        $daily = DB::table('expenses')
        ->select(DB::raw('SUM(expenses.expenseTax) as
        expenseTax'), DB::raw('SUM(expense_items.expenseItemQuantity*expense_items.expenseItemUnitCost) as total'))
        ->join('expense_items', 'expense_items.expenseItemExpenseId', '=', 'expenses.expenseId')
        ->whereDate('expenseDueDate', Carbon::today())
         ->where('expenses.expenseCompanyId', auth()->user()->userCompanyId)

        ->first();

        $monthly  = DB::table('expenses')
        ->select('expenses.expenseEndDateTime', 'expenses.expenseStatusType', 'expenses.expenseDueDate', DB::raw('SUM(expenses.expenseTax) as
        expenseTax'), DB::raw('SUM(expense_items.expenseItemQuantity*expense_items.expenseItemUnitCost) as total'))
        ->join('expense_items', 'expense_items.expenseItemExpenseId', '=', 'expenses.expenseId')
        ->whereMonth('expenseDueDate', date('m'))
        ->whereYear('expenseDueDate', date('Y'))
        ->where('expenseStatusType', 'default')
        ->where('expenses.expenseCompanyId', auth()->user()->userCompanyId)
        ->first();
        $monthlye  = DB::table('expenses')
        ->select('expenses.expenseEndDateTime', 'expenses.expenseDueDate', DB::raw('SUM(expenses.expenseTax) as
        expenseTax'), DB::raw('SUM(expense_items.expenseItemQuantity*expense_items.expenseItemUnitCost) as total'))
        ->join('expense_items', 'expense_items.expenseItemExpenseId', '=', 'expenses.expenseId')
        ->whereRaw($rawQuery)
        ->first();

        $yearlye = DB::table('expenses')
        ->select('expenses.expenseEndDateTime', 'expenses.expenseDueDate',DB::raw('SUM(expenses.expenseTax) as expenseTax'), DB::raw('SUM(expense_items.expenseItemQuantity*expense_items.expenseItemUnitCost) as total'))
        ->join('expense_items', 'expense_items.expenseItemExpenseId', '=', 'expenses.expenseId')
        ->whereRaw($rawQuery)
        ->first();

        $yearly = DB::table('expenses')
        ->select('expenses.expenseStatusType','expenses.expenseDueDate',DB::raw('SUM(expenses.expenseTax) as expenseTax'), DB::raw('SUM(expense_items.expenseItemQuantity*expense_items.expenseItemUnitCost) as total'))
        ->join('expense_items', 'expense_items.expenseItemExpenseId', '=', 'expenses.expenseId')
        ->whereYear('expenses.expenseDueDate',  date('Y'))
        ->where('expenses.expenseStatusType', 'default')
        ->where('expenses.expenseCompanyId', auth()->user()->userCompanyId)
        ->first();

   
        return view('reporting.expenses.index', compact(
            'expenses', 'overalltotal', 'daily', 'monthly', 'yearly', 
            'expenseYearArray', 'expenseMonthArray',
            'expenseYear', 'expenseMonth','yearlye', 'monthlye'
        ));
    }


    public function detail_search($slug) {
        
        $expenses = DB::table('expenses')
        ->select('expenses.expenseReference',
        'expenses.expenseId', 
        'expenses.expensePaymentMethod', 
        'expenses.expenseEndDateTime', 
        'expenses.expenseDueDate',
        'expenses.expenseInvoiceNo',
        'expenses.expenseStatusType',
        'expenseGateway',
        'expenses.expenseTax', DB::raw('SUM(expenseItemQuantity) as
        qtyTotal'), DB::raw('SUM(expense_items.expenseItemQuantity*expense_items.expenseItemUnitCost) as total'))
        ->join('expense_items', 'expense_items.expenseItemExpenseId', '=', 'expenses.expenseId')
        ->where('expenses.expenseCompanyId', auth()->user()->userCompanyId)

        ->where('expenses.expenseReference', 'LIKE','%' . rtrim($slug, ", ") . '%')
        ->groupBy('expenses.expenseId')
        ->orderBy('expenses.expenseId', 'desc')
        ->paginate(50);
        
        
        return view('reporting.expenses.index', compact('expenses'));
    }

    public function create() {


        $vendors = Hoav::where(['hoavType' => 'vendor', 'hoavCategory' => 'expense'])->get();
        $hoas = Hoav::where(['hoavType' => 'hoa', 'hoavCategory' => 'expense'])->get();

        return view( 'reporting.expenses.create', compact( 'hoas', 'vendors' ) );
    }

    public function store( Request $request ) {
     
    
       
        $expense = new Expense();
        $expense->expenseHoaId	 = $request->expenseHoaId;
        $expense->expenseVendorId = $request->expenseVendorId;
        $expense->expenseInvoiceNo = $request->expenseInvoiceNo;
        $expense->expensePaymentMethod = $request->expensePaymentMethod;
        $expense->expenseEndDateTime = $request->expenseEndDateTime;
        $expense->expenseDueDate = $request->expenseDueDate;
        $expense->expenseReference = $request->expenseReference;
        $expense->expenseCompanyId = auth()->user()->userCompanyId;
        $expense->expenseCreatedUserId = auth()->user()->userId;


        if($request->file('expenseAttachment')){
            $file= $request->file('expenseAttachment');
            $filename= time().'.'.$file->getClientOriginalExtension();
            $file->move(public_path('assets/expense_attachments'), $filename);
            $expense->expenseAttachment = $filename;
        }

       
        $expense->expenseStatusType = 'default';
        $expense->save();

        if ( $expense ) {

               
        $expenseItems = [];
        foreach($request->expenseItem as $expenseItem){
            
            $expenseItemDescription = $expenseItem['expenseItemDescription'];
            $expenseItemQuantity = $expenseItem['expenseItemQuantity'];
            $expenseItemUnitCost = $expenseItem['expenseItemUnitCost'];
            $expenseId = $expense->expenseId;
            $expenseItemCreatedUserId = auth()->user()->userId;
            
            $expenseItems[] = array(
            
            'expenseItemDescription' => $expenseItemDescription, 
            'expenseItemQuantity' => $expenseItemQuantity, 
            'expenseItemUnitCost' => $expenseItemUnitCost, 
            'expenseItemExpenseId' => $expenseId,
            'expenseItemCreatedUserId' => $expenseItemCreatedUserId
        );
            
        }

        ExpenseItem::insert($expenseItems);

            return redirect()->back()->with( 'success', 'Expense Saved Successfully.' );

        } else {
            return Redirect::back()->withErrors( [ 'msg' => 'There was some problem.' ] );
        }

    }

    public function edit( $id ) {
        $expense = Expense::where('expenseId', $id)->first();
        $vendors = Hoav::where('hoavType', 'vendor')->get();
        $hoas = Hoav::where('hoavType', 'hoa')->get();
        return view('reporting.expenses.edit', compact('expense', 'hoas', 'vendors'));
    }

    public function update( Request $request, $id ) {
        // dd( $request->all() );
        // Find the Customer
        $bank = Bank::find( $id );

        // Updating the Customer
        $bank->update( [
            'bankAccountTitle' => $request->bankAccountTitle,
            'bankAccountNo' => $request->bankAccountNo,
            'bankAba' => $request->bankAba,
            'bankSwift' => $request->bankSwift,
            'bankCompanyId' => $request->bankCompanyId,
            'bankName' => $request->bankName,
            'bankAddress' => $request->bankAddress,
        ] );

        // confirm message
        $request->session()->flash( 'msg', 'Bank has been updated' );

        // Redirect
        return redirect()->route( 'bank.index' );

    }

    public function update_info(Request $request, $id){
              //dd($request->all());
              $expense =  Expense::findOrFail($id);
              $expense->expenseHoaId	 = $request->expenseHoaId;
              $expense->expenseVendorId = $request->expenseVendorId;
              $expense->expenseInvoiceNo = $request->expenseInvoiceNo;
              $expense->expensePaymentMethod = $request->expensePaymentMethod;
              $expense->expenseEndDateTime = $request->expenseEndDateTime;
              $expense->expenseDueDate = $request->expenseDueDate;
              $expense->expenseReference = $request->expenseReference;
      
      
              if($request->file('expenseAttachment')){
                  $file= $request->file('expenseAttachment');
                  $filename= time().'.'.$file->getClientOriginalExtension();
                  $file->move(public_path('assets/expense_attachments'), $filename);
                  $expense->expenseAttachment = $filename;
              }
      
             
              $expense->save();
      
              if ( $expense ) {

                  return redirect()->back()->with( 'success', 'Expense Saved Successfully.' );
      
              } else {
                  return redirect()->back()->withErrors( [ 'msg' => 'There was some problem.' ] );
              }
    }
    public function update_item(Request $request, $id){

        $expense =  ExpenseItem::findOrFail($id);
        $expense->expenseItemDescription	 = $request->expenseItemDescription;
        $expense->expenseItemQuantity = $request->expenseItemQuantity;
        $expense->expenseItemUnitCost = $request->expenseItemUnitCost;


    
       
        $expense->save();

        if ( $expense ) {

            return redirect()->back()->with( 'success', 'Expense Item Saved Successfully.' );

        } else {
            return redirect()->back()->withErrors( [ 'msg' => 'There was some problem.' ] );
        }
    }
    

    public function create_item(Request $request, $id){

        $expense =  new ExpenseItem();
        $expense->expenseItemDescription	 = $request->expenseItemDescription;
        $expense->expenseItemQuantity = $request->expenseItemQuantity;
        $expense->expenseItemUnitCost = $request->expenseItemUnitCost;
        $expense->expenseItemExpenseId = $id;
        $expense->expenseItemCreatedUserId = auth()->user()->userId;

        $expense->save();

        if ( $expense ) {

            return redirect()->back()->with( 'success', 'Expense Item Saved Successfully.' );

        } else {
            return redirect()->back()->withErrors( [ 'msg' => 'There was some problem.' ] );
        }
    }
    
    public function delete_item($id) {
        ExpenseItem::destroy($id);
        return redirect()->back()->with( 'success', 'Expense Item Deleted Successfully.' );

    }
    public function detail($id) {
        $expense = Expense::where('expenseId', $id)->first();
        return view('reporting.expenses.detail', compact('expense'));
    }

    public function vendors() {
      

        $filterType = 'Vendors';
        $hoavs = DB::table('expenses')
        ->select('hoavId', 'hoavName', DB::raw('SUM(expenseTax) as
        expenseTax'), DB::raw('SUM(expenseItemQuantity) as
        qtyTotal'), DB::raw('SUM(expense_items.expenseItemQuantity*expense_items.expenseItemUnitCost) as total'))
        ->join('expense_items', 'expense_items.expenseItemExpenseId', '=', 'expenses.expenseId')
        ->join('expense_hoav', 'expense_hoav.hoavId', '=', 'expenses.expenseVendorId')
        ->where('expenses.expenseCompanyId', auth()->user()->userCompanyId)
        ->where('expense_hoav.hoavType', 'vendor')
        ->groupBy('expense_hoav.hoavId')
        ->paginate(50);
        
         $overalltotal = DB::table('expenses')
        ->select(DB::raw('SUM(expenseTax) as
        expenseTax'), DB::raw('SUM(expenseItemQuantity) as
        qtyTotal'), DB::raw('SUM(expense_items.expenseItemQuantity*expense_items.expenseItemUnitCost) as total'))
        ->join('expense_items', 'expense_items.expenseItemExpenseId', '=', 'expenses.expenseId')
        ->join('expense_hoav', 'expense_hoav.hoavId', '=', 'expenses.expenseVendorId')
        ->where('expenses.expenseCompanyId', auth()->user()->userCompanyId)
        ->where('expense_hoav.hoavType', 'vendor')
        ->first();
        
        return view('reporting.expenses.filter', compact('hoavs', 'filterType','overalltotal'));
    }

    public function headofaccounts() {
       
        $filterType = 'Head of Accounts';

        $hoavs = DB::table('expenses')
        ->select('hoavId', 'hoavName', DB::raw('SUM(DISTINCT expenseTax) as
        expenseTax'), DB::raw('SUM(expenseItemQuantity) as
        qtyTotal'), DB::raw('SUM(expense_items.expenseItemQuantity*expense_items.expenseItemUnitCost) as total'))
        ->join('expense_items', 'expense_items.expenseItemExpenseId', '=', 'expenses.expenseId')
        ->join('expense_hoav', 'expense_hoav.hoavId', '=', 'expenses.expenseHoaId')
        ->where('expenses.expenseCompanyId', auth()->user()->userCompanyId)
        ->where('expense_hoav.hoavType', 'hoa')
        ->groupBy('expense_hoav.hoavName')
         ->paginate(50);

         $overalltotal = DB::table('expenses')
        ->select(DB::raw('SUM(DISTINCT expenseTax) as
        expenseTax'),DB::raw('SUM(expense_items.expenseItemQuantity*expense_items.expenseItemUnitCost) as total'))
        ->join('expense_items', 'expense_items.expenseItemExpenseId', '=', 'expenses.expenseId')
        ->join('expense_hoav', 'expense_hoav.hoavId', '=', 'expenses.expenseHoaId')
        ->where('expenses.expenseCompanyId', auth()->user()->userCompanyId)
        ->where('expense_hoav.hoavType', 'hoa')
        ->first();
        return view('reporting.expenses.filter', compact('hoavs', 'filterType', 'overalltotal'));
    }


                   
    protected function aged_expense($whereConditionArray)
    {
        $expense_status = request()->get('expense_status') ? request()->get('expense_status') : 'default';

        $days = DB::table('expenses')
        ->select('expenses.expenseVendorId', 'expense_hoav.hoavName',
        DB::raw('SUM(DISTINCT expenses.expenseTax) as expenseTax'),
        DB::raw('SUM(expense_items.expenseItemQuantity*expense_items.expenseItemUnitCost) as total'))
        ->join('expense_items', 'expense_items.expenseItemExpenseId', '=', 'expenses.expenseId')
        ->join('expense_hoav', 'expense_hoav.hoavId', '=', 'expenses.expenseVendorId')
        ->where('expenses.expenseStatusType', $expense_status)
        ->where('expenses.expenseCompanyId', auth()->user()->userCompanyId)
        ->whereRaw('DATEDIFF(expenses.expenseEndDateTime, CURDATE()) >= '.$whereConditionArray['min_day'])
        ->whereRaw('DATEDIFF(expenses.expenseEndDateTime, CURDATE()) <= '.$whereConditionArray['max_day']) 
        ->groupBy('expenses.expenseVendorId')
         ->get();
        $vendors = array();
            foreach($days as $day){
            $hoavName = $day->hoavName;
            $expenseVendorId = $day->expenseVendorId;
            $expenseTax = (double)$day->expenseTax;
            $total = (double)$day->total;
            $netvalue = $total+$expenseTax;
    
            
          
            if (!array_key_exists($expenseVendorId, $this->vendors))
            {
                $this->vendors[$expenseVendorId] = [
                'expenseVendorId' => $expenseVendorId, 
                'hoavName' => $hoavName, 
                'net_30' => 0,
                'net_60' => 0,
                'net_90' => 0, 
                'net_120' => 0, 
                'over_120' => 0
            ];
            }
         

                
   

                
            switch ($whereConditionArray['dayis']) {
                case 30:
            
                    if (array_key_exists($expenseVendorId, $this->vendors))
                    {
                        $this->vendors[$expenseVendorId]['net_30'] = $netvalue;
                    }
                    else
                    {
                        $this->vendors[$expenseVendorId]['net_30'] = $netvalue;
                    }

                  
                  break;
                case 60:
                    if (array_key_exists($expenseVendorId,  $this->vendors))
                    {
                        $this->vendors[$expenseVendorId]['net_60'] = $netvalue;
                        
                    }
                    else
                    {
                        $this->vendors[$expenseVendorId]['net_60'] = $netvalue;
                    }
                 

                  break;
                case 90:
                    if (array_key_exists($expenseVendorId, $this->vendors))
                    {
                        $this->vendors[$expenseVendorId]['net_90'] = $netvalue;
                    }
                    else
                    {
                        $this->vendors[$expenseVendorId]['net_90'] = $netvalue;
                    }
                  
                  break;
                  case 120:
                    if (array_key_exists($expenseVendorId, $this->vendors))
                    {
                        $this->vendors[$expenseVendorId]['net_120'] = $netvalue;
                    }
                    else
                    {
                        $this->vendors[$expenseVendorId]['net_120'] = $netvalue;
                    }
                 
                  break;
                  case 121:
                    if (array_key_exists($expenseVendorId, $this->vendors))
                    {
                        $this->vendors[$expenseVendorId]['over_120'] = $netvalue;
                    }
                    else
                    {
                        $this->vendors[$expenseVendorId]['over_120'] = $netvalue;
                    }
                 
                  break;
                default:
                  echo "-";
              }
            
            }

    }

    public function aged() {

         $banks = Bank::where('bankCompanyId', auth()->user()->userCompanyId)->get();
         $credit_cards = PaymentGateway::where('paymentGatewayCompanyId', auth()->user()->userCompanyId)
                                    ->where('paymentGatewayType', 'Credit Card')
                                    ->get();
                                
          $expense_status = request()->get('expense_status') ? request()->get('expense_status') : 'default';
                                
           $vendors = array();
                                
            $whereConditionArray = [
                'min_day' => -30, 
                'max_day' => 3, 
                'isdual' => true,
                'dayis' => 30
            ];
        
            $this->aged_expense($whereConditionArray);

            $whereConditionArray = [
                'min_day' => -60, 
                'max_day' => -31, 
                'isdual' => true,
                'dayis' => 60
            ];
        
            $this->aged_expense($whereConditionArray);

            $whereConditionArray = [
                'min_day' => -90, 
                'max_day' => -61, 
                'isdual' => true,
                'dayis' => 90
            ];
    
         $this->aged_expense($whereConditionArray);

            $whereConditionArray = [
                'min_day' => -120, 
                'max_day' => -91, 
                'isdual' => true,
                'dayis' => 120
            ];
        
            $this->aged_expense($whereConditionArray);

            $whereConditionArray = [
                'min_day' => -3000, 
                'max_day' => -121, 
                'isdual' => true,
                'dayis' => 121
            ];
    
           $this->aged_expense($whereConditionArray);
          
           $vendors = $this->vendors;
        return view('reporting.expenses.aged', compact('vendors','banks', 'credit_cards'));

 }


 protected function single_aged($whereConditionArray){
  
    $expense_status = request()->get('expense_status') ? request()->get('expense_status') : 'default';

    $days = DB::table('expenses')
    ->select('expenses.expenseVendorId', 'expenses.expenseInvoiceNo', 'expenses.expenseId',
    'expenseEndDateTime', 'expenseDueDate',
    DB::raw('SUM(DISTINCT expenses.expenseTax) as expenseTax'),
    DB::raw('SUM(expense_items.expenseItemQuantity*expense_items.expenseItemUnitCost) as total'))
    ->join('expense_items', 'expense_items.expenseItemExpenseId', '=', 'expenses.expenseId')
    ->where('expenses.expenseStatusType', $expense_status)
    ->where('expenses.expenseCompanyId', auth()->user()->userCompanyId)
    ->whereRaw('DATEDIFF(expenses.expenseEndDateTime, CURDATE()) >= '.$whereConditionArray['min_day'])
    ->whereRaw('DATEDIFF(expenses.expenseEndDateTime, CURDATE()) <= '.$whereConditionArray['max_day']) 
    ->where('expenses.expenseVendorId', $whereConditionArray['vendor_id'])
    ->groupBy('expenses.expenseId')

     ->get();

     if(isset($days[0]->expenseId)){

                                   
        foreach($days as $day){
        $expenseInvoiceNo = $day->expenseInvoiceNo;
        $expenseId = $day->expenseId;
        $expenseEndDateTime = $day->expenseEndDateTime;
        $expenseDueDate = $day->expenseDueDate;
        $expenseTax = (double)$day->expenseTax;
        $total = (double)$day->total;
        $netvalue = $total+$expenseTax;

  

      

        if (!array_key_exists($expenseId, $this->vendor_invs))
        {
       
            $this->vendor_invs[$expenseId] = ['expenseId' => $expenseId, 'expenseInvoiceNo' => $expenseInvoiceNo, 
            'expenseEndDateTime' => $expenseEndDateTime, 'expenseDueDate' => $expenseDueDate, 
            'net_30' =>  0, 'net_60' => 0,'net_90' => 0, 'net_120' => 0, 'over_120' => 0];
   
        }
                 
          switch ($whereConditionArray['dayis']) {
            case 30:
        
                if (array_key_exists($expenseId, $this->vendor_invs))
                {
                    $this->vendor_invs[$expenseId]['net_30'] = $netvalue;
    
                }
                

              
              break;
            case 60:
                if (array_key_exists($expenseId,  $this->vendor_invs))
                {
                    $this->vendor_invs[$expenseId]['net_60'] = $netvalue;
                    
                }
             

              break;
            case 90:
                if (array_key_exists($expenseId, $this->vendor_invs))
                {
                    $this->vendor_invs[$expenseId]['net_90'] = $netvalue;
                }
              
              break;
              case 120:
                if (array_key_exists($expenseId, $this->vendor_invs))
                {
                    $this->vendor_invs[$expenseId]['net_120'] = $netvalue;
                }
             
              break;
              case 121:
                if (array_key_exists($expenseId, $this->vendor_invs))
                {
                    $this->vendor_invs[$expenseId]['over_120'] = $netvalue;
                }
             
              break;
            default:
              echo "-";
          }
    }

    }



 }

                                public function aged_invoices($id) {
                                   
                                
                                    $expense_status = request()->get('expense_status') ? request()->get('expense_status') : 'default';
                                
                                    
                                
                                   
                                    $whereConditionArray = [
                                        'min_day' => -30, 
                                        'max_day' => 3, 
                                        'isdual' => true,
                                        'dayis' => 30,
                                        'vendor_id' => $id
                                    ];
                                
                                    $this->single_aged($whereConditionArray);
                                    $whereConditionArray = [
                                        'min_day' => -60, 
                                        'max_day' => -31, 
                                        'isdual' => true,
                                        'dayis' => 60,
                                        'vendor_id' => $id
                                    ];
                                
                                    $this->single_aged($whereConditionArray);

                                    $whereConditionArray = [
                                        'min_day' => -90, 
                                        'max_day' => -61, 
                                        'isdual' => true,
                                        'dayis' => 90,
                                        'vendor_id' => $id
                                    ];
                                
                                    $this->single_aged($whereConditionArray);

                                    $whereConditionArray = [
                                        'min_day' => -120, 
                                        'max_day' => -91, 
                                        'isdual' => true,
                                        'dayis' => 120,
                                        'vendor_id' => $id
                                    ];
                                
                                    $this->single_aged($whereConditionArray);


                                    $whereConditionArray = [
                                        'min_day' => -3000, 
                                        'max_day' => -121, 
                                        'isdual' => true,
                                        'dayis' => 121,
                                        'vendor_id' => $id
                                    ];
                                
                                    $this->single_aged($whereConditionArray);

                                
                                    $vendors = $this->vendor_invs;
                                    return view('reporting.expenses.ajax.aged', compact('vendors', 'id'));

                          
                                    }

                               
                          

                            
                                   


                              
                    
                                public function selected_invoices(Request $request) {
                                    $invs =  explode(',', $request->getinvs);
                          

                            $invoices = DB::table('expenses')
                            ->select('expenses.expenseVendorId', 'expenses.expenseInvoiceNo', 'expenses.expenseId',
                            'expenseEndDateTime', 'expenseDueDate',
                            'expenseReference',
                            DB::raw('SUM(DISTINCT expenses.expenseTax) as expenseTax'),
                            DB::raw('SUM(expense_items.expenseItemQuantity*expense_items.expenseItemUnitCost) as total'))
                            ->join('expense_items', 'expense_items.expenseItemExpenseId', '=', 'expenses.expenseId')
                        
                            ->where('expenses.expenseCompanyId', auth()->user()->userCompanyId)
                            ->whereIn('expenses.expenseId', $invs)
                            ->groupBy('expenses.expenseId')
                            ->get();

                            return view('reporting.expenses.ajax.selected-invoices', compact('invoices'));
                            
                                }

                                public function single_transaction(Request $request){
                                    $egateway = $request->egateway;
                                    $id = $request->id;
                                    $isbank = Bank::where('bankAccountTitle', $egateway)->exists();
                                    $findid = 'FIND_IN_SET('.$id.',reportBankDetail)';
                                    if($isbank){
                                        $bank = Bank::select('bankId')->where('bankAccountTitle', $egateway)->first();

                                        $transactions = ReportingBank::where('reportBankCategory', 'EXPENSE')
                                        ->where('bank_entry', $bank->bankId)
                                        ->whereRaw($findid)
                                        ->where('reportBankCompanyId', auth()->user()->userCompanyId)
                                        ->get();
                                        return view('reporting.expenses.ajax.single-transaction-bank', compact('transactions'));

                                    }

                                    $isgateway = PaymentGateway::where('paymentGatewayName', $egateway)->exists();

                                    if($isgateway){
                                        $card = PaymentGateway::select('paymentGatewayId')->where('paymentGatewayName', $egateway)->first();
                                        
                                        $cindid = 'FIND_IN_SET('.$id.',reportingccDetail)';

                                        $transactions = Reportingcc::where('reportingccCardId', $card->paymentGatewayId)
                                        ->where('reportingccCompanyId', auth()->user()->userCompanyId)
                                        ->whereRaw($cindid)
                                        ->get();
                                        return view('reporting.expenses.ajax.single-transaction-card', compact('transactions'));

                                    }
                                }

                                public function delete_transaction(Request $request){
                                    $id = $request->delid;
                                    if($request->gateway == 'bank'){

                                    
                                   
                                    $transaction = ReportingBank::where('reportBankCategory', 'EXPENSE')
                                        ->where('reportBankId', $id)
                                        ->where('reportBankCompanyId', auth()->user()->userCompanyId)
                                        ->first();
                                        $eids = explode(',', $transaction->reportBankDetail);
                                        $transaction->delete();
                                        Expense::whereIn('expenseId', $eids)->update(['expenseStatusType' => 'default', 'expenseGateway' => '']);
                                        
                                       
                                    }

                                    if($request->gateway == 'card'){

                                        
                                      
                                       


                                            $transaction = Reportingcc::where('reportingccCompanyId', auth()->user()->userCompanyId)
                                            ->where('reportingccCategory', 'EXPENSE')
                                            ->where('reportingccId', $id)
                                            ->first();
                                           
                                            $eids = explode(',', $transaction->reportingccDetail);
                                            $transaction->delete();

                                           Expense::whereIn('expenseId', $eids)->update(['expenseStatusType' => 'default', 'expenseGateway' => '']);
                                            

                                    }

                                    return redirect()->back()->with( 'success', 'Expense Transaction Successfully.' );


                                }

                                public function delete_expense($id){
                                  
                                 $expenseItems =   ExpenseItem::where('expenseItemExpenseId', $id)->delete();
                                 if($expenseItems){
                                 Expense::where('expenseId', $id)->delete();
                                 }

                                 return redirect()->back()->with( 'success', 'Expense Delete Successfully.' );

                                }
}