<?php

namespace App\Http\Controllers\Reports;
use App\Http\Controllers\Controller;

use Illuminate\Http\Request;
use App\Models\PaymentGateway;
use App\Models\Reportingcc;
use App\Models\ReportingBank;
use App\Models\Bank;
use App\Models\Hoav;


use Illuminate\Support\Facades\Hash;

class HoavController extends Controller {
    /**
    * Create a new controller instance.
    *
    * @return void
    */

    public function __construct() {
        $this->middleware( 'auth' );
    }

    /**
    * Show the application dashboard.
    *
    * @return \Illuminate\Contracts\Support\Renderable
    */

    public function list($type) {

        $hoavs = Hoav::get();

        return view('reporting.index', compact('hoavs', 'type'));
    }

    public function create($type){
        return view('reporting.expenses.hoav.create', compact('type'));
    }


    public function store( Request $request ) {
     
    
   
        $hoav = new Hoav();
        $hoav->hoavName	 = $request->hoavName;
        $hoav->hoavNature = $request->hoavNature;
        $hoav->hoavType = $request->hoavType;
        $hoav->hoavAccount = $request->hoavAccount;
        $hoav->hoavAddress = $request->hoavAddress;
        $hoav->hoavPhone = $request->hoavPhone;
        $hoav->hoavCategory = $request->hoavCategory;
        $hoav->hoavIsActive = 1;
        $hoav->hoavCompanyId = auth()->user()->userCompanyId;
        $hoav->hoavCreatedUserId = auth()->user()->userId;
        $hoav->hoavModifiedUserId = auth()->user()->userId;
        $hoav->save();

        if ( $hoav ) {

            return redirect()->back()->with( 'success', 'Saved Successfully.' );

        } else {
            return Redirect::back()->withErrors( [ 'msg' => 'There was some problem.' ] );
        }

    }



}
