<?php

namespace App\Http\Controllers\Reports;
use App\Http\Controllers\Controller;

use Illuminate\Http\Request;
use App\Models\Income;
use App\Models\IncomeItem;
use App\Models\Bank;
use App\Models\PaymentGateway;
use App\Models\ReportingBank;
use App\Models\Reportingcc;
use Carbon\Carbon;


use Illuminate\Support\Str;


use App\Models\Hoav;
use DB;
use Illuminate\Support\Facades\Hash;

class IncomeController extends Controller {
    /**
    * Create a new controller instance.
    *
    * @return void
    */

    public $vendors = [];
    public $vendor_invs = [];
    public function __construct() {
        $this->middleware( 'auth' );
    }

    /**
    * Show the application dashboard.
    *
    * @return \Illuminate\Contracts\Support\Renderable
    */

    public function index() {

        $incomes = DB::table('incomes')
        ->select('incomes.incomeReference',
        'incomes.incomeId', 
        'incomes.incomePaymentMethod', 
        'incomes.incomeEndDateTime', 
        'incomes.incomeDueDate',
        'incomes.incomeInvoiceNo',
        'incomes.incomeStatusType',
        'incomeGateway',
        'incomes.incomeTax', DB::raw('SUM(incomeItemQuantity) as
        qtyTotal'), DB::raw('SUM(income_items.incomeItemQuantity*income_items.incomeItemUnitCost) as total'))
        ->join('income_items', 'income_items.incomeItemIncomeId', '=', 'incomes.incomeId')
        ->where('incomes.incomeCompanyId', auth()->user()->userCompanyId)
       
        ->groupBy('incomes.incomeId')
        ->orderBy('incomes.incomeId', 'desc')
        ->paginate(50);


        $overalltotal = DB::table('incomes')
        ->select(DB::raw('SUM(incomeTax) as
        incomeTax'), DB::raw('SUM(incomeItemQuantity) as
        qtyTotal'), DB::raw('SUM(income_items.incomeItemQuantity*income_items.incomeItemUnitCost) as total'))
        ->join('income_items', 'income_items.incomeItemIncomeId', '=', 'incomes.incomeId')
        ->where('incomes.incomeCompanyId', auth()->user()->userCompanyId)
        ->first();



        $daily = DB::table('incomes')
        ->select(DB::raw('SUM(incomeTax) as
        incomeTax'), DB::raw('SUM(income_items.incomeItemQuantity*income_items.incomeItemUnitCost) as total'))
        ->join('income_items', 'income_items.incomeItemIncomeId', '=', 'incomes.incomeId')
        ->whereDate('incomeDueDate', Carbon::today())
         ->where('incomes.incomeCompanyId', auth()->user()->userCompanyId)

        ->first();


        $monthly  = DB::table('incomes')
        ->select(DB::raw('SUM(incomeTax) as
        incomeTax'), DB::raw('SUM(income_items.incomeItemQuantity*income_items.incomeItemUnitCost) as total'))
        ->join('income_items', 'income_items.incomeItemIncomeId', '=', 'incomes.incomeId')
        ->whereMonth('incomeDueDate', date('m'))
        ->whereYear('incomeDueDate', date('Y'))
        ->where('incomes.incomeCompanyId', auth()->user()->userCompanyId)

        ->first();

        $yearly = DB::table('incomes')
        ->select(DB::raw('SUM(incomeTax) as
        incomeTax'), DB::raw('SUM(income_items.incomeItemQuantity*income_items.incomeItemUnitCost) as total'))
        ->join('income_items', 'income_items.incomeItemIncomeId', '=', 'incomes.incomeId')
        ->whereYear('incomeDueDate', date('Y'))
                ->where('incomes.incomeCompanyId', auth()->user()->userCompanyId)

        ->first();
       
        
        return view('reporting.incomes.index', compact('incomes', 'overalltotal', 'daily', 'monthly', 'yearly'));
    }


    public function detail_search($slug) {
        
        $incomes = DB::table('incomes')
        ->select('incomes.incomeReference',
        'incomes.incomeId', 
        'incomes.incomePaymentMethod', 
        'incomes.incomeEndDateTime', 
        'incomes.incomeDueDate',
        'incomes.incomeInvoiceNo',
        'incomes.incomeStatusType',
        'incomeGateway',
        'incomes.incomeTax', DB::raw('SUM(incomeItemQuantity) as
        qtyTotal'), DB::raw('SUM(income_items.incomeItemQuantity*income_items.incomeItemUnitCost) as total'))
        ->join('income_items', 'income_items.incomeItemIncomeId', '=', 'incomes.incomeId')
        ->where('incomes.incomeCompanyId', auth()->user()->userCompanyId)

        ->where('incomes.incomeReference', 'LIKE','%' . rtrim($slug, ", ") . '%')
        ->groupBy('incomes.incomeId')
        ->orderBy('incomes.incomeId', 'desc')
        ->paginate(50);
        
        
        return view('reporting.incomes.index', compact('incomes'));
    }

    public function create() {
        $vendors = Hoav::where(['hoavType' => 'vendor', 'hoavCategory' => 'income'])->get();
        $hoas = Hoav::where(['hoavType' => 'hoa', 'hoavCategory' => 'income'])->get();
        return view( 'reporting.incomes.create', compact( 'hoas', 'vendors' ) );
    }

    public function store( Request $request ) {
     
    
        //dd($request->all());
        $income = new Income();
        $income->incomeHoaId	 = $request->incomeHoaId;
        $income->incomeVendorId = $request->incomeVendorId;
        $income->incomeInvoiceNo = $request->incomeInvoiceNo;
        $income->incomePaymentMethod = $request->incomePaymentMethod;
        $income->incomeEndDateTime = $request->incomeEndDateTime;
        $income->incomeDueDate = $request->incomeDueDate;
        $income->incomeReference = $request->incomeReference;
        $income->incomeCompanyId = auth()->user()->userCompanyId;
        $income->incomeCreatedUserId = auth()->user()->userId;


        if($request->file('incomeAttachment')){
            $file= $request->file('incomeAttachment');
            $filename= time().'.'.$file->getClientOriginalExtension();
            $file->move(public_path('assets/income_attachments'), $filename);
            $income->incomeAttachment = $filename;
        }

       
        $income->incomeStatusType = 'default';
        $income->save();

        if ( $income ) {

               
        $incomeItems = [];
        foreach($request->incomeItem as $incomeItem){
            
            $incomeItemDescription = $incomeItem['incomeItemDescription'];
            $incomeItemQuantity = $incomeItem['incomeItemQuantity'];
            $incomeItemUnitCost = $incomeItem['incomeItemUnitCost'];
            $incomeId = $income->incomeId;
            $incomeItemCreatedUserId = auth()->user()->userId;
            
            $incomeItems[] = array(
            
            'incomeItemDescription' => $incomeItemDescription, 
            'incomeItemQuantity' => $incomeItemQuantity, 
            'incomeItemUnitCost' => $incomeItemUnitCost, 
            'incomeItemIncomeId' => $incomeId,
            'incomeItemCreatedUserId' => $incomeItemCreatedUserId
        );
            
        }

        IncomeItem::insert($incomeItems);

            return redirect()->back()->with( 'success', 'Income Saved Successfully.' );

        } else {
            return Redirect::back()->withErrors( [ 'msg' => 'There was some problem.' ] );
        }

    }

    public function edit( $id ) {
        $income = Income::where('incomeId', $id)->first();
        $vendors = Hoav::where('hoavType', 'vendor')->get();
        $hoas = Hoav::where('hoavType', 'hoa')->get();
        return view('reporting.incomes.edit', compact('income', 'hoas', 'vendors'));
    }

    public function update( Request $request, $id ) {
        // dd( $request->all() );
        // Find the Customer
        $bank = Bank::find( $id );

        // Updating the Customer
        $bank->update( [
            'bankAccountTitle' => $request->bankAccountTitle,
            'bankAccountNo' => $request->bankAccountNo,
            'bankAba' => $request->bankAba,
            'bankSwift' => $request->bankSwift,
            'bankCompanyId' => $request->bankCompanyId,
            'bankName' => $request->bankName,
            'bankAddress' => $request->bankAddress,
        ] );

        // confirm message
        $request->session()->flash( 'msg', 'Bank has been updated' );

        // Redirect
        return redirect()->route( 'bank.index' );

    }

    public function update_info(Request $request, $id){
              //dd($request->all());
              $income =  Income::findOrFail($id);
              $income->incomeHoaId	 = $request->incomeHoaId;
              $income->incomeVendorId = $request->incomeVendorId;
              $income->incomeInvoiceNo = $request->incomeInvoiceNo;
              $income->incomePaymentMethod = $request->incomePaymentMethod;
              $income->incomeEndDateTime = $request->incomeEndDateTime;
              $income->incomeDueDate = $request->incomeDueDate;
              $income->incomeReference = $request->incomeReference;
      
      
              if($request->file('incomeAttachment')){
                  $file= $request->file('incomeAttachment');
                  $filename= time().'.'.$file->getClientOriginalExtension();
                  $file->move(public_path('assets/income_attachments'), $filename);
                  $income->incomeAttachment = $filename;
              }
      
             
              $income->save();
      
              if ( $income ) {

                  return redirect()->back()->with( 'success', 'Income Saved Successfully.' );
      
              } else {
                  return redirect()->back()->withErrors( [ 'msg' => 'There was some problem.' ] );
              }
    }
    public function update_item(Request $request, $id){

        $income =  IncomeItem::findOrFail($id);
        $income->incomeItemDescription	 = $request->incomeItemDescription;
        $income->incomeItemQuantity = $request->incomeItemQuantity;
        $income->incomeItemUnitCost = $request->incomeItemUnitCost;


    
       
        $income->save();

        if ( $income ) {

            return redirect()->back()->with( 'success', 'Income Item Saved Successfully.' );

        } else {
            return redirect()->back()->withErrors( [ 'msg' => 'There was some problem.' ] );
        }
    }
    

    public function create_item(Request $request, $id){

        $income =  new IncomeItem();
        $income->incomeItemDescription	 = $request->incomeItemDescription;
        $income->incomeItemQuantity = $request->incomeItemQuantity;
        $income->incomeItemUnitCost = $request->incomeItemUnitCost;
        $income->incomeItemIncomeId = $id;
        $income->incomeItemCreatedUserId = auth()->user()->userId;

        $income->save();

        if ( $income ) {

            return redirect()->back()->with( 'success', 'income Item Saved Successfully.' );

        } else {
            return redirect()->back()->withErrors( [ 'msg' => 'There was some problem.' ] );
        }
    }
    
    public function delete_item($id) {
        IncomeItem::destroy($id);
        return redirect()->back()->with( 'success', 'income Item Deleted Successfully.' );

    }
    public function detail($id) {
        $income = Income::where('incomeId', $id)->first();
        return view('reporting.incomes.detail', compact('income'));
    }

    public function vendors() {
      

        $filterType = 'Vendors';
        $hoavs = DB::table('incomes')
        ->select('hoavId', 'hoavName', DB::raw('SUM(incomeTax) as
        incomeTax'), DB::raw('SUM(incomeItemQuantity) as
        qtyTotal'), DB::raw('SUM(income_items.incomeItemQuantity*income_items.incomeItemUnitCost) as total'))
        ->join('income_items', 'income_items.incomeItemIncomeId', '=', 'incomes.incomeId')
        ->join('expense_hoav', 'expense_hoav.hoavId', '=', 'incomes.incomeVendorId')
        ->where('incomes.incomeCompanyId', auth()->user()->userCompanyId)
        ->where('expense_hoav.hoavType', 'vendor')
        ->groupBy('expense_hoav.hoavId')
        ->paginate(50);
        
         $overalltotal = DB::table('incomes')
        ->select(DB::raw('SUM(incomeTax) as
        incomeTax'), DB::raw('SUM(incomeItemQuantity) as
        qtyTotal'), DB::raw('SUM(income_items.incomeItemQuantity*income_items.incomeItemUnitCost) as total'))
        ->join('income_items', 'income_items.incomeItemIncomeId', '=', 'incomes.incomeId')
        ->join('expense_hoav', 'expense_hoav.hoavId', '=', 'incomes.incomeVendorId')
        ->where('incomes.incomeCompanyId', auth()->user()->userCompanyId)
        ->where('expense_hoav.hoavType', 'vendor')
        ->first();
        
        return view('reporting.incomes.filter', compact('hoavs', 'filterType','overalltotal'));
    }

    public function headofaccounts() {
       
        $filterType = 'Head of Accounts';

        $hoavs = DB::table('incomes')
        ->select('hoavId', 'hoavName', DB::raw('SUM(DISTINCT incomeTax) as
        incomeTax'), DB::raw('SUM(incomeItemQuantity) as
        qtyTotal'), DB::raw('SUM(income_items.incomeItemQuantity*income_items.incomeItemUnitCost) as total'))
        ->join('income_items', 'income_items.incomeItemIncomeId', '=', 'incomes.incomeId')
        ->join('expense_hoav', 'expense_hoav.hoavId', '=', 'incomes.incomeHoaId')
        ->where('incomes.incomeCompanyId', auth()->user()->userCompanyId)
        ->where('expense_hoav.hoavType', 'hoa')
        ->groupBy('expense_hoav.hoavName')
         ->paginate(50);

         $overalltotal = DB::table('incomes')
        ->select(DB::raw('SUM(DISTINCT incomeTax) as
        incomeTax'),DB::raw('SUM(income_items.incomeItemQuantity*income_items.incomeItemUnitCost) as total'))
        ->join('income_items', 'income_items.incomeItemIncomeId', '=', 'incomes.incomeId')
        ->join('expense_hoav', 'expense_hoav.hoavId', '=', 'incomes.incomeHoaId')
        ->where('incomes.incomeCompanyId', auth()->user()->userCompanyId)
        ->where('expense_hoav.hoavType', 'hoa')
        ->first();
        return view('reporting.incomes.filter', compact('hoavs', 'filterType', 'overalltotal'));
    }


                   
    protected function aged_income($whereConditionArray)
    {
        $income_status = request()->get('income_status') ? request()->get('income_status') : 'default';

        $days = DB::table('incomes')
        ->select('incomes.incomeVendorId', 'expense_hoav.hoavName',
        DB::raw('SUM(DISTINCT incomes.incomeTax) as incomeTax'),
        DB::raw('SUM(income_items.incomeItemQuantity*income_items.incomeItemUnitCost) as total'))
        ->join('income_items', 'income_items.incomeItemIncomeId', '=', 'incomes.incomeId')
        ->join('expense_hoav', 'expense_hoav.hoavId', '=', 'incomes.incomeVendorId')
        ->where('incomes.incomeStatusType', $income_status)
        ->where('incomes.incomeCompanyId', auth()->user()->userCompanyId)
        ->whereRaw('DATEDIFF(incomes.incomeEndDateTime, CURDATE()) > '.$whereConditionArray['min_day'])
        ->whereRaw('DATEDIFF(incomes.incomeEndDateTime, CURDATE()) < '.$whereConditionArray['max_day']) 
        ->groupBy('incomes.incomeVendorId')
         ->get();
        $vendors = array();
            foreach($days as $day){
            $hoavName = $day->hoavName;
            $incomeVendorId = $day->incomeVendorId;
            $incomeTax = (double)$day->incomeTax;
            $total = (double)$day->total;
            $netvalue = $total+$incomeTax;
    
            
          
            if (!array_key_exists($incomeVendorId, $this->vendors))
            {
                $this->vendors[$incomeVendorId] = [
                'incomeVendorId' => $incomeVendorId, 
                'hoavName' => $hoavName, 
                'net_30' => 0,
                'net_60' => 0,
                'net_90' => 0, 
                'net_120' => 0, 
                'over_120' => 0
            ];
            }
         

                
   

                
            switch ($whereConditionArray['dayis']) {
                case 30:
            
                    if (array_key_exists($incomeVendorId, $this->vendors))
                    {
                        $this->vendors[$incomeVendorId]['net_30'] = $netvalue;
                    }
                    else
                    {
                        $this->vendors[$incomeVendorId]['net_30'] = $netvalue;
                    }

                  
                  break;
                case 60:
                    if (array_key_exists($incomeVendorId,  $this->vendors))
                    {
                        $this->vendors[$incomeVendorId]['net_60'] = $netvalue;
                        
                    }
                    else
                    {
                        $this->vendors[$incomeVendorId]['net_60'] = $netvalue;
                    }
                 

                  break;
                case 90:
                    if (array_key_exists($incomeVendorId, $this->vendors))
                    {
                        $this->vendors[$incomeVendorId]['net_90'] = $netvalue;
                    }
                    else
                    {
                        $this->vendors[$incomeVendorId]['net_90'] = $netvalue;
                    }
                  
                  break;
                  case 120:
                    if (array_key_exists($incomeVendorId, $this->vendors))
                    {
                        $this->vendors[$incomeVendorId]['net_120'] = $netvalue;
                    }
                    else
                    {
                        $this->vendors[$incomeVendorId]['net_120'] = $netvalue;
                    }
                 
                  break;
                  case 121:
                    if (array_key_exists($incomeVendorId, $this->vendors))
                    {
                        $this->vendors[$incomeVendorId]['over_120'] = $netvalue;
                    }
                    else
                    {
                        $this->vendors[$incomeVendorId]['over_120'] = $netvalue;
                    }
                 
                  break;
                default:
                  echo "-";
              }
            
            }

    }

    public function aged() {

         $banks = Bank::where('bankCompanyId', auth()->user()->userCompanyId)->get();
         $paypals = PaymentGateway::where('paymentGatewayCompanyId', auth()->user()->userCompanyId)
         ->where('paymentGatewayType', 'Paypal')
         ->get();
                                
          $income_status = request()->get('income_status') ? request()->get('income_status') : 'default';
                                
           $vendors = array();
                                
            $whereConditionArray = [
                'min_day' => -30, 
                'max_day' => 3, 
                'isdual' => true,
                'dayis' => 30
            ];
        
            $this->aged_income($whereConditionArray);

            $whereConditionArray = [
                'min_day' => -60, 
                'max_day' => -31, 
                'isdual' => true,
                'dayis' => 60
            ];
        
            $this->aged_income($whereConditionArray);

            $whereConditionArray = [
                'min_day' => -90, 
                'max_day' => -61, 
                'isdual' => true,
                'dayis' => 90
            ];
    
         $this->aged_income($whereConditionArray);

            $whereConditionArray = [
                'min_day' => -120, 
                'max_day' => -91, 
                'isdual' => true,
                'dayis' => 120
            ];
        
            $this->aged_income($whereConditionArray);

            $whereConditionArray = [
                'min_day' => -3000, 
                'max_day' => -121, 
                'isdual' => true,
                'dayis' => 121
            ];
    
           $this->aged_income($whereConditionArray);
          
           $vendors = $this->vendors;
        return view('reporting.incomes.aged', compact('vendors','banks', 'paypals'));

 }


 protected function single_aged($whereConditionArray){
  
    $income_status = request()->get('income_status') ? request()->get('income_status') : 'default';

    $days = DB::table('incomes')
    ->select('incomes.incomeVendorId', 'incomes.incomeInvoiceNo', 'incomes.incomeId',
    'incomeEndDateTime', 'incomeDueDate',
    DB::raw('SUM(DISTINCT incomes.incomeTax) as incomeTax'),
    DB::raw('SUM(income_items.incomeItemQuantity*income_items.incomeItemUnitCost) as total'))
    ->join('income_items', 'income_items.incomeItemIncomeId', '=', 'incomes.incomeId')
    ->where('incomes.incomeStatusType', $income_status)
    ->where('incomes.incomeCompanyId', auth()->user()->userCompanyId)
    ->whereRaw('DATEDIFF(incomes.incomeEndDateTime, CURDATE()) > '.$whereConditionArray['min_day'])
    ->whereRaw('DATEDIFF(incomes.incomeEndDateTime, CURDATE()) < '.$whereConditionArray['max_day']) 
    ->where('incomes.incomeVendorId', $whereConditionArray['vendor_id'])
    ->groupBy('incomes.incomeId')

     ->get();

     if(isset($days[0]->incomeId)){

                                   
        foreach($days as $day){
        $incomeInvoiceNo = $day->incomeInvoiceNo;
        $incomeId = $day->incomeId;
        $incomeEndDateTime = $day->incomeEndDateTime;
        $incomeDueDate = $day->incomeDueDate;
        $incomeTax = (double)$day->incomeTax;
        $total = (double)$day->total;
        $netvalue = $total+$incomeTax;

  

      

        if (!array_key_exists($incomeId, $this->vendor_invs))
        {
       
            $this->vendor_invs[$incomeId] = ['incomeId' => $incomeId, 'incomeInvoiceNo' => $incomeInvoiceNo, 
            'incomeEndDateTime' => $incomeEndDateTime, 'incomeDueDate' => $incomeDueDate, 
            'net_30' =>  0, 'net_60' => 0,'net_90' => 0, 'net_120' => 0, 'over_120' => 0];
   
        }
                 
          switch ($whereConditionArray['dayis']) {
            case 30:
        
                if (array_key_exists($incomeId, $this->vendor_invs))
                {
                    $this->vendor_invs[$incomeId]['net_30'] = $netvalue;
    
                }
                

              
              break;
            case 60:
                if (array_key_exists($incomeId,  $this->vendor_invs))
                {
                    $this->vendor_invs[$incomeId]['net_60'] = $netvalue;
                    
                }
             

              break;
            case 90:
                if (array_key_exists($incomeId, $this->vendor_invs))
                {
                    $this->vendor_invs[$incomeId]['net_90'] = $netvalue;
                }
              
              break;
              case 120:
                if (array_key_exists($incomeId, $this->vendor_invs))
                {
                    $this->vendor_invs[$incomeId]['net_120'] = $netvalue;
                }
             
              break;
              case 121:
                if (array_key_exists($incomeId, $this->vendor_invs))
                {
                    $this->vendor_invs[$incomeId]['over_120'] = $netvalue;
                }
             
              break;
            default:
              echo "-";
          }
    }

    }



 }

                                public function aged_invoices($id) {
                                   
                                
                                    $income_status = request()->get('income_status') ? request()->get('income_status') : 'default';
                                
                                    
                                
                                   
                                    $whereConditionArray = [
                                        'min_day' => -30, 
                                        'max_day' => 3, 
                                        'isdual' => true,
                                        'dayis' => 30,
                                        'vendor_id' => $id
                                    ];
                                
                                    $this->single_aged($whereConditionArray);
                                    $whereConditionArray = [
                                        'min_day' => -60, 
                                        'max_day' => -31, 
                                        'isdual' => true,
                                        'dayis' => 60,
                                        'vendor_id' => $id
                                    ];
                                
                                    $this->single_aged($whereConditionArray);

                                    $whereConditionArray = [
                                        'min_day' => -90, 
                                        'max_day' => -61, 
                                        'isdual' => true,
                                        'dayis' => 90,
                                        'vendor_id' => $id
                                    ];
                                
                                    $this->single_aged($whereConditionArray);

                                    $whereConditionArray = [
                                        'min_day' => -120, 
                                        'max_day' => -91, 
                                        'isdual' => true,
                                        'dayis' => 120,
                                        'vendor_id' => $id
                                    ];
                                
                                    $this->single_aged($whereConditionArray);


                                    $whereConditionArray = [
                                        'min_day' => -3000, 
                                        'max_day' => -121, 
                                        'isdual' => true,
                                        'dayis' => 121,
                                        'vendor_id' => $id
                                    ];
                                
                                    $this->single_aged($whereConditionArray);

                                
                                    $vendors = $this->vendor_invs;
                                    return view('reporting.incomes.ajax.aged', compact('vendors', 'id'));

                          
                                    }

                               
                          

                            
                                   


                              
                    
                                public function selected_invoices(Request $request) {
                                    $invs =  explode(',', $request->getinvs);
                          

                            $invoices = DB::table('incomes')
                            ->select('incomes.incomeVendorId', 'incomes.incomeInvoiceNo', 'incomes.incomeId',
                            'incomeEndDateTime', 'incomeDueDate',
                            'incomeReference',
                            DB::raw('SUM(DISTINCT incomes.incomeTax) as incomeTax'),
                            DB::raw('SUM(income_items.incomeItemQuantity*income_items.incomeItemUnitCost) as total'))
                            ->join('income_items', 'income_items.incomeItemIncomeId', '=', 'incomes.incomeId')
                        
                            ->where('incomes.incomeCompanyId', auth()->user()->userCompanyId)
                            ->whereIn('incomes.incomeId', $invs)
                            ->groupBy('incomes.incomeId')
                            ->get();

                            return view('reporting.incomes.ajax.selected-invoices', compact('invoices'));
                            
                                }

                                public function single_transaction(Request $request){
                                    $egateway = $request->egateway;
                                    $id = $request->id;
                                    $isbank = Bank::where('bankAccountTitle', $egateway)->exists();
                                    $findid = 'FIND_IN_SET('.$id.',reportBankDetail)';
                                    if($isbank){
                                        $bank = Bank::select('bankId')->where('bankAccountTitle', $egateway)->first();

                                        $transactions = ReportingBank::where('reportBankCategory', 'income')
                                        ->where('bank_entry', $bank->bankId)
                                        ->whereRaw($findid)
                                        ->where('reportBankCompanyId', auth()->user()->userCompanyId)
                                        ->get();
                                        return view('reporting.incomes.ajax.single-transaction-bank', compact('transactions'));

                                    }

                                    $isgateway = PaymentGateway::where('paymentGatewayName', $egateway)->exists();

                                    if($isgateway){
                                        $card = PaymentGateway::select('paymentGatewayId')->where('paymentGatewayName', $egateway)->first();
                                        
                                        $cindid = 'FIND_IN_SET('.$id.',reportingccDetail)';

                                        $transactions = Reportingcc::where('reportingccCardId', $card->paymentGatewayId)
                                        ->where('reportingccCompanyId', auth()->user()->userCompanyId)
                                        ->whereRaw($cindid)
                                        ->get();
                                        return view('reporting.incomes.ajax.single-transaction-card', compact('transactions'));

                                    }
                                }

                                public function delete_transaction(Request $request){
                                    $id = $request->delid;
                                    if($request->gateway == 'bank'){

                                    
                                   
                                    $transaction = ReportingBank::where('reportBankCategory', 'income')
                                        ->where('reportBankId', $id)
                                        ->where('reportBankCompanyId', auth()->user()->userCompanyId)
                                        ->first();
                                        $eids = explode(',', $transaction->reportBankDetail);
                                        $transaction->delete();
                                        Income::whereIn('incomeId', $eids)->update(['incomeStatusType' => 'default', 'incomeGateway' => '']);
                                        
                                       
                                    }

                                    if($request->gateway == 'card'){

                                        
                                      
                                       


                                            $transaction = Reportingcc::where('reportingccCompanyId', auth()->user()->userCompanyId)
                                            ->where('reportingccCategory', 'income')
                                            ->where('reportingccId', $id)
                                            ->first();
                                           
                                            $eids = explode(',', $transaction->reportingccDetail);
                                            $transaction->delete();

                                            Income::whereIn('incomeId', $eids)->update(['incomeStatusType' => 'default', 'incomeGateway' => '']);
                                            

                                    }

                                    return redirect()->back()->with( 'success', 'income Transaction Successfully.' );


                                }

                                public function delete_income($id){
                                  
                                 $incomeItems =   IncomeItem::where('incomeItemIncomeId', $id)->delete();
                                 if($incomeItems){
                                    Income::where('incomeId', $id)->delete();
                                 }

                                 return redirect()->back()->with( 'success', 'income Delete Successfully.' );

                                }
}