<?php

namespace App\Http\Controllers\Reports;
use App\Http\Controllers\Controller;

use Illuminate\Http\Request;
use App\Models\PaymentGateway;
use App\Models\JournalEntry;
use App\Models\Journal;
use App\Models\Bank;
use App\Models\ReportingBank;
use App\Models\Reportingcc;

use App\Models\ReportingPaypal;
use PDF;
use DB;
use Illuminate\Support\Facades\Hash;

class JournalController extends Controller {
    /**
    * Create a new controller instance.
    *
    * @return void
    */
    use \App\Http\Controllers\Traits\Functions;

    public function __construct() {
        $this->middleware('auth');
    }

    /**
    * Show the application dashboard.
    *
    * @return \Illuminate\Contracts\Support\Renderable
    */

    public function index() {
       
      

        $journalYearArray   = $this->yearsList();
        $journalMonthArray   = $this->monthsList();

        $journalYear = request()->get('journalYear') ? request()->get('journalYear') : date("Y");
        $journalMonth = request()->get('journalMonth') ? request()->get('journalMonth') : date("m");
       
       
        $rawQuery= '';
      

        //year selection 
        if($journalMonth != 'all'){
        $rawQuery .= 'MONTH(journalDate) = '.$journalMonth.' AND ';
        }
        //month selection 
        $rawQuery .= 'YEAR(journalDate) = '.$journalYear;

      

        $journals = Journal::where('journalCompanyId', auth()->user()->userCompanyId)
        ->orderBy('journalId', 'desc')
       // ->whereRaw($rawQuery)
        ->get();
    
        return view('reporting.journal-entry.index', compact('journals',
        'journalYearArray','journalMonthArray','journalYear','journalMonth'));
    }




    public function create(){



        $banks = \App\Models\Bank::select('bankId', 'bankAccountTitle')->where('bankCompanyId', auth()->user()->userCompanyId)->get();
        $cards = \App\Models\PaymentGateway::select('paymentGatewayId', 'paymentGatewayName','paymentGatewayType')->where('paymentGatewayCompanyId', auth()->user()->userCompanyId)->get();


        return view('reporting.journal-entry.create', compact('banks', 'cards'));
    }


    public function store(Request $request, Journal $journalModel)
{


    
    $validatedData = $request->validate([
        'journalDate' => ['required', 'date'],
        'journalReference' => ['required', 'string'],
        'journalEntryGateway.*' => ['required', 'integer'],
        'journalEntryNarration.*' => ['nullable', 'string'],
        'journalEntryDebit.*' => ['required', 'numeric', 'min:0'],
        'journalEntryCredit.*' => ['required', 'numeric', 'min:0'],
    ]);

    $the_amount = 0;
    if($request->journalEntryDebit[0] > 0){
        $the_amount = $request->journalEntryDebit[0];
    }else{
        $the_amount = $request->journalEntryDebit[1];
    }
    $journalEntryGatewayOne = $request->journalEntryGateway[0];
    $journalEntryGatewayTwo = $request->journalEntryGateway[1];
    $journalDate = $request->journalDate;
    $journalReference = $request->journalReference;
    $fromArray = [
    'journalDate' =>$journalDate, 
    'journalEntryGateway' => $journalEntryGatewayOne, 
    'journalReference' =>$journalReference,
    'amount' => $the_amount
   ];
   $toArray = [
    'journalDate' =>$journalDate, 
    'journalEntryGateway' => $journalEntryGatewayTwo, 
    'journalReference' =>$journalReference,
    'amount' => $the_amount
   ];

//    print_r($toArray);
//    echo '<br>';
//    print_r($fromArray);
//    die;
    $journalItems = collect($validatedData['journalEntryGateway'])
        ->map(function ($gateway, $key) use ($validatedData, $journalModel) {
            return [
                'journalEntryGatewayId' => $gateway,
                'journalEntryNarration' => $validatedData['journalEntryNarration'][$key] ?? null,
                'journalEntryDebit' => $validatedData['journalEntryDebit'][$key],
                'journalEntryCredit' => $validatedData['journalEntryCredit'][$key],
                'journalEntryjournalId' => 0,
                'journalEntryCreatedUserId' => auth()->user()->userId,
            ];
        })
        ->toArray();
       
    try {
        DB::transaction(function () use ($validatedData, $journalModel, $journalItems, $request, $fromArray, $toArray) {
            $journalModel->journalDate = $validatedData['journalDate'];
            $journalModel->journalReference = $validatedData['journalReference'];
            $journalModel->journalCompanyId = auth()->user()->userCompanyId;
            $journalModel->journalCreatedUserId = auth()->user()->userId;
            $journalModel->journalStatusType = 'default';
            $journalModel->save();

            foreach($journalItems as $key => $item){ $journalItems[$key]['journalEntryjournalId'] = $journalModel->journalId;}
            JournalEntry::insert($journalItems);
            $transactionId = $journalModel->journalId;
           //1) from bank to paypal
           if(($request->pay_one == 'paypal') && ($request->pay_two == 'bank')){
            $this->paypal_to_bank($fromArray, $toArray, $transactionId);
             }
            //2) from paypal to bank
           if(($request->pay_one == 'bank') && ($request->pay_two == 'paypal')){
            $this->bank_to_paypal($fromArray, $toArray, $transactionId);
             }
           //3) from bank to bank
           if(($request->pay_one == 'bank') && ($request->pay_two == 'bank')){
            $this->bank_to_bank($fromArray, $toArray, $transactionId);
             }

             //4) from credit-card to paypal
           if(($request->pay_one == 'credit-card') && ($request->pay_two == 'paypal')){
            $this->credit_to_paypal($fromArray, $toArray, $transactionId);
             }

          //5) from credit-card to bank
           if(($request->pay_one == 'credit-card') && ($request->pay_two == 'bank')){
            $this->credit_to_bank($fromArray, $toArray, $transactionId);
             }
          
          //6) from credit-card to bank
           if(($request->pay_one == 'bank') && ($request->pay_two == 'credit-card')){
            $this->bank_to_credit($fromArray, $toArray, $transactionId);
             }

          //7) from paypal to credit-card
           if(($request->pay_one == 'paypal') && ($request->pay_two == 'credit-card')){
            $this->paypal_to_credit($fromArray, $toArray, $transactionId);
             }

                //8) from credit-card to redit-card
           if(($request->pay_one == 'credit-card') && ($request->pay_two == 'credit-card')){
            $this->credit_to_credit($fromArray, $toArray, $transactionId);
             }

                     //8) from paypal to paypal
           if(($request->pay_one == 'paypal') && ($request->pay_two == 'paypal')){
            $this->paypal_to_paypal($fromArray, $toArray, $transactionId);
             }
       
        });

        return redirect()->back()->with('success', 'Journal Entry saved successfully.');
    } catch (Exception $e) {
        return redirect()->back()->withErrors('error' , 'There was some problem.');
    }
}



protected function paypal_to_bank($fromArray, $toArray, $transactionId){
    
    $this->insert_reporting_paypal($fromArray, $transactionId, 'debit');
    $this->insert_reporting_bank($toArray, $transactionId, 'credit');
}

protected function bank_to_bank($fromArray, $toArray, $transactionId){
    
    $this->insert_reporting_bank($fromArray, $transactionId, 'credit');
    $this->insert_reporting_bank($toArray, $transactionId, 'debit');

}

protected function bank_to_paypal($fromArray, $toArray, $transactionId){

    $this->insert_reporting_bank($fromArray, $transactionId, 'debit');
    $this->insert_reporting_paypal($toArray, $transactionId, 'credit');
}





protected function credit_to_paypal($fromArray, $toArray, $transactionId){
    
    $this->insert_reporting_creditcard($fromArray, $transactionId, 'credit');
    $this->insert_reporting_paypal($toArray, $transactionId, 'debit');

}

protected function credit_to_bank($fromArray, $toArray, $transactionId){
    
    $this->insert_reporting_creditcard($fromArray, $transactionId, 'credit');
    $this->insert_reporting_bank($toArray, $transactionId, 'debit');

}


protected function bank_to_credit($fromArray, $toArray, $transactionId){
    $this->insert_reporting_bank($fromArray, $transactionId, 'credit');
    $this->insert_reporting_creditcard($toArray, $transactionId, 'debit');
   

}

protected function paypal_to_credit($fromArray, $toArray, $transactionId){
   
    $this->insert_reporting_paypal($fromArray, $transactionId, 'credit');
    $this->insert_reporting_creditcard($toArray, $transactionId, 'debit');
   

}
protected function credit_to_credit($fromArray, $toArray, $transactionId){
    
    $this->insert_reporting_creditcard($fromArray, $transactionId, 'credit');
    $this->insert_reporting_creditcard($toArray, $transactionId, 'debit');

}

protected function paypal_to_paypal($fromArray, $toArray, $transactionId){
    
    $this->insert_reporting_paypal($fromArray, $transactionId, 'credit');
    $this->insert_reporting_paypal($toArray, $transactionId, 'debit');

}
private function insert_reporting_bank($journal, $transactionId, $debitOrCredit) {

    $journalDate = $journal['journalDate'];
    $isdebit = 0;
    $iscredit = 0;
    if($debitOrCredit == 'debit'){
        $isdebit = $journal['amount'];
    }else{
        $iscredit = $journal['amount'];
    }
    $bankArray = [
        'reportBankDescription' => $journal['journalReference'],
        'reportBankCategory' => 'INCOME',
        'reportBankDebit' => $isdebit,
        'reportBankCredit' => $iscredit,
        'reportBankAllocation' => 'NA',
        'reportBankCharges' => 0,
        'reportBankRefrence' => 'NA',
        'reportBankDate' => date('Y/m/d H:i:s', strtotime($journalDate)),
        'reportBankYear' => (int) date('Y', strtotime($journalDate)),
        'bank_entry' => $journal['journalEntryGateway'],
        'reportBankCompanyId' => auth()->user()->userCompanyId,
        'reportBankCreatedUserId' => auth()->user()->userId,
        'reportBankDetail' => $transactionId,
    ];
    
    ReportingBank::insert($bankArray);
}

private function insert_reporting_paypal($journal, $transactionId, $debitOrCredit) {
   
    $journalDate = $journal['journalDate'];

    $isdebit = 0;
    $iscredit = 0;
    if($debitOrCredit == 'debit'){
        $isdebit = $journal['amount'];
    }else{
        $iscredit = $journal['amount'];
    }
    $paypalArray = [
        'paypalPaymentDescription' => $journal['journalReference'],
        'paypalPaymentCategory' => 'INCOME',
        'paypalPaymentDebit' =>  $isdebit,
        'paypalPaymentCredit' => $iscredit,
        'paypalPaymentAllocation' => 'NA',
        'paypalPaymentCharges' => 0,
        'paypalPaymentCardId' => $journal['journalEntryGateway'],
        'paypalPaymentReference' => 'NA',
        'paypalPaymentDate' => date_format(date_create($journalDate),"Y/m/d H:i:s"),
        'paypalPaymentGateway' => 'paypal',
        'paypalPaymentCompanyId' => auth()->user()->userCompanyId,
        'paypalPaymentUserId' => auth()->user()->userId,
        'paypalPaymentDetail' => $transactionId,
    ];
    ReportingPaypal::insert($paypalArray);


}



private function insert_reporting_creditcard($journal, $transactionId, $debitOrCredit) {
   
    $journalDate = $journal['journalDate'];
  
    $isdebit = 0;
    $iscredit = 0;
    if($debitOrCredit == 'debit'){
        $isdebit = $journal['amount'];
    }else{
        $iscredit = $journal['amount'];
    }
    $cardArray = [
        'reportingccDescription' => $journal['journalReference'],
        'reportingccCategory' => 'PURCHASE',
        'reportingccDebit' =>  (double)$isdebit,
        'reportingccCredit' => (double)$iscredit,
        'reportingccAllocation' => 'NA',
        'reportingccCardId' => (int)$journal['journalEntryGateway'],
        'reportingccReference' => 'NA',
        'reportingccDate' => date_format(date_create($journalDate),"Y/m/d H:i:s"),
        'reportingccCompanyId' => auth()->user()->userCompanyId,
        'reportingccUserId' => auth()->user()->userId,
        'reportingccDetail' => $transactionId,
    ];
   
    Reportingcc::insert($cardArray);


}



}
