<?php

namespace App\Http\Controllers\Reports;
use App\Http\Controllers\Controller;

use Illuminate\Http\Request;
use App\Models\PaymentGateway;
use App\Models\Reportingcc;
use App\Models\ReportingBank;
use App\Models\Bank;
use App\Models\Payable;
use App\Models\Expense;

use PDF;
use DB;
use Illuminate\Support\Facades\Hash;

class PayableController extends Controller {
    /**
    * Create a new controller instance.
    *
    * @return void
    */
    public $vendors = [];
    public $inv_vendors = [];
    public function __construct() {
        $this->middleware('auth');
    }

    /**
    * Show the application dashboard.
    *
    * @return \Illuminate\Contracts\Support\Renderable
    */

    public function index() {

     
    }

    public function show($slug) {

  }


  protected function payable_record($whereConditionArray){

    
    $payables_status = request()->get('payables_status') ? request()->get('payables_status') : 'default';

    $payables_year = request()->get('payables_year') ? request()->get('payables_year') : date('Y');

    $days = DB::table('payables')
    ->select('vendors.vendorCompany',
    DB::raw('SUM(payables.payableProductCost) as payableProductCost'),
    DB::raw('SUM(payables.payableFrieght) as payableFrieght'),
    DB::raw('SUM(payables.payableTax) as payableTax'),
    DB::raw('SUM(payables.payableECW) as payableECW'),
    'payables.payableCompanyId', 
    'payables.payableVendorId')
    ->join('vendors', 'vendors.vendorId', '=', 'payables.payableVendorId')
    ->where('payables.payableCompanyId', auth()->user()->userCompanyId)
   // ->where('payables.payableReturn', 0)
    ->where('payables.payableIsDeleted', 0)
    ->where('payables.proceedType', $payables_status)
    ->whereRaw('DATEDIFF(payables.payableInvoiceDate, CURDATE()) >= '.$whereConditionArray['min_day'])
    ->whereRaw('DATEDIFF(payables.payableInvoiceDate, CURDATE()) <= '.$whereConditionArray['max_day'])
    ->groupBy('payables.payableVendorId')
        ->get();

        
       
        foreach($days as $day){
            $payableVendorId = $day->payableVendorId;
            $vendorCompany = $day->vendorCompany;
            $payableFrieght = (double)$day->payableFrieght;
            $payableTax = (double)$day->payableTax;
            $payableECW = (double)$day->payableECW;
            $payableProductCost = (double)$day->payableProductCost;
            $netvalue = $payableFrieght+$payableTax+$payableProductCost+$payableECW;
            
            if (!array_key_exists($payableVendorId, $this->vendors))
            {
            $this->vendors[$payableVendorId] = ['payableVendorId' => $payableVendorId, 'vendorCompany' => $vendorCompany, 'net_30' => 0,
            'net_60' =>  0, 'net_90' => 0, 'net_120' => 0, 'over_120' => 0];
            }
      
            switch ($whereConditionArray['dayis']) {
                case 30:
            
                    if (array_key_exists($payableVendorId, $this->vendors))
                    {
                        $this->vendors[$payableVendorId]['net_30'] = $netvalue;
        
                    }
                    

                  
                  break;
                case 60:
                    if (array_key_exists($payableVendorId,  $this->vendors))
                    {
                        $this->vendors[$payableVendorId]['net_60'] = $netvalue;
                        
                    }
                 

                  break;
                case 90:
                    if (array_key_exists($payableVendorId, $this->vendors))
                    {
                        $this->vendors[$payableVendorId]['net_90'] = $netvalue;
                    }
                  
                  break;
                  case 120:
                    if (array_key_exists($payableVendorId, $this->vendors))
                    {
                        $this->vendors[$payableVendorId]['net_120'] = $netvalue;
                    }
                 
                  break;
                  case 121:
                    if (array_key_exists($payableVendorId, $this->vendors))
                    {
                        $this->vendors[$payableVendorId]['over_120'] = $netvalue;
                    }
                 
                  break;
                default:
                  echo "-";
              }
            
            }


  }

  public function aged() {
    $banks = Bank::where('bankCompanyId', auth()->user()->userCompanyId)->get();
    $credit_cards = PaymentGateway::where('paymentGatewayCompanyId', auth()->user()->userCompanyId)
    ->where('paymentGatewayType', 'Credit Card')
    ->get();

    $payables_status = request()->get('payables_status') ? request()->get('payables_status') : 'default';

  

    $whereConditionArray = [
        'min_day' => -30, 
        'max_day' => 3, 
        'isdual' => true,
        'dayis' => 30
    ];

    $this->payable_record($whereConditionArray);

  


    $whereConditionArray = [
        'min_day' => -60, 
        'max_day' => -31, 
        'isdual' => true,
        'dayis' => 60
    ];

     $this->payable_record($whereConditionArray);

            $whereConditionArray = [
                'min_day' => -90, 
                'max_day' => -61, 
                'isdual' => true,
                'dayis' => 90
            ];
        
    $this->payable_record($whereConditionArray);

    $whereConditionArray = [
                    'min_day' => -120, 
                    'max_day' => -91, 
                    'isdual' => true,
                    'dayis' => 120
                ];
            
    $this->payable_record($whereConditionArray);

                $whereConditionArray = [
                    'min_day' => -3000, 
                    'max_day' => -121, 
                    'isdual' => true,
                    'dayis' => 121
                ];
            
                $this->payable_record($whereConditionArray);
        $vendors = $this->vendors;

                    return view('reporting.payables.aged', compact('vendors','banks', 'credit_cards'));
}


    public function aged_invoice_query($whereConditionArray)
    {
        $payables_status = request()->get('payables_status') ? request()->get('payables_status') : 'default';

      

        $days = DB::table('payables')
        ->select('payables.payableId', 
        'payables.payableInvoiceNumber',
        'payables.payableInvoiceDate',
        'payables.payableProductCost', 
        'payables.payableFrieght', 
        'payables.payableTax',
        'payables.payableECW', 
        'payables.payableCompanyId',
        'payables.payableReturn', 
        'payables.payableVendorId')
        ->where('payables.payableCompanyId', auth()->user()->userCompanyId)
//        ->where('payables.payableReturn', 0)
        ->where('payables.payableIsDeleted', 0)
        ->where('payables.payableVendorId', $whereConditionArray['vendor_id'])
        ->where('payables.proceedType', $payables_status)
        ->whereRaw('DATEDIFF(payables.payableInvoiceDate, CURDATE()) >= '.$whereConditionArray['min_day'])
        ->whereRaw('DATEDIFF(payables.payableInvoiceDate, CURDATE()) <= '.$whereConditionArray['max_day'])
        ->orderBy('payables.payableInvoiceDate', 'desc')
            ->get();
   
                // if(isset($days[0]->payableId)){
       
            if(isset($days[0]->payableId)){
                //echo $whereConditionArray['dayis'];
               
             foreach($days as $day){
               
                $payableId = $day->payableId;
             
                 $payableInvoiceNumber = $day->payableInvoiceNumber;
                $payableInvoiceDate = $day->payableInvoiceDate;
                $payableVendorId = $day->payableVendorId;
                $payableReturn  =  $day->payableReturn; 
                $payableFrieght = (double)$day->payableFrieght;
                $payableTax = (double)$day->payableTax;
                $payableECW = (double)$day->payableECW;
                $payableProductCost = (double)$day->payableProductCost;
                $netvalue = $payableFrieght+$payableTax+$payableProductCost+$payableECW;


                if (!array_key_exists($payableId, $this->inv_vendors))
                {
               
                $this->inv_vendors[$payableId] = ['payableVendorId' => $payableVendorId, 
                  'payableId' => $payableId,
                  'payableReturn' => $payableReturn,
                  'payableInvoiceNumber' => $payableInvoiceNumber, 
                  'payableInvoiceDate' => $payableInvoiceDate, 
                  'net_30' => 0, 'net_60' => 0,'net_90' => 0, 
                  'net_120' => 0, 'over_120' => 0];
                }
          
                switch ($whereConditionArray['dayis']) {
                    case 30:
                
                        if (array_key_exists($payableId, $this->inv_vendors))
                        {
                            $this->inv_vendors[$payableId]['net_30'] = $netvalue;
            
                        }
                        
    
                      
                      break;
                    case 60:
                        if (array_key_exists($payableId,  $this->inv_vendors))
                        {
                            $this->inv_vendors[$payableId]['net_60'] = $netvalue;
                            
                        }
                     
    
                      break;
                    case 90:
                        if (array_key_exists($payableId, $this->inv_vendors))
                        {
                            $this->inv_vendors[$payableId]['net_90'] = $netvalue;
                        }
                      
                      break;
                      case 120:
                        if (array_key_exists($payableId, $this->inv_vendors))
                        {
                            $this->inv_vendors[$payableId]['net_120'] = $netvalue;
                        }
                     
                      break;
                      case 121:
                        if (array_key_exists($payableId, $this->inv_vendors))
                        {
                            $this->inv_vendors[$payableId]['over_120'] = $netvalue;
                        }
                     
                      break;
                    default:
                      echo "-";
                  }
                
               
                // $net_30 = 0;
                // $net_60 = 0;
                // $net_90 = 0;
                // $net_120 = 0;
                // $net_121 = 0;

            //     switch ($whereConditionArray['dayis']) {
            //         case 30:
            //             $net_30 = $netvalue;
            //           break;
            //         case 60:
            //             $net_60 = $netvalue;
            //           break;
            //         case 90:
            //             $net_90 = $netvalue;
            //           break;
            //           case 120:
            //             $net_120 = $netvalue;
            //           break;
            //           case 121:
            //             $net_121 = $netvalue;
            //           break;
            //         default:
            //           echo "-";
            //       }

                  
                 
                 }
                
          
            }
            //print_r($this->inv_vendors);
        }
                public function aged_invoices($id) {
                    
                $banks = Bank::where('bankCompanyId', auth()->user()->userCompanyId)->get();

                $payables_status = request()->get('payables_status') ? request()->get('payables_status') : 'default';

                $vendors = array();

                $whereConditionArray = [
                    'min_day' => -30, 
                    'max_day' => 3, 
                    'isdual' => true,
                    'vendor_id'  => $id,
                    'dayis' => 30
                ];
            
                $this->aged_invoice_query($whereConditionArray);

                $whereConditionArray = [
                    'min_day' => -60, 
                    'max_day' => -31, 
                    'isdual' => true,
                    'vendor_id'  => $id,
                    'dayis' => 60
                ];
            
                $this->aged_invoice_query($whereConditionArray);

                $whereConditionArray = [
                    'min_day' => -90, 
                    'max_day' => -61, 
                    'isdual' => true,
                    'vendor_id'  => $id,
                    'dayis' => 90
                ];
            
                $this->aged_invoice_query($whereConditionArray);

                $whereConditionArray = [
                    'min_day' => -120, 
                    'max_day' => -91, 
                    'isdual' => true,
                    'vendor_id'  => $id,
                    'dayis' => 120
                ];
            
                $this->aged_invoice_query($whereConditionArray);

                $whereConditionArray = [
                    'min_day' => -3000, 
                    'max_day' => -121, 
                    'isdual' => true,
                    'vendor_id'  => $id,
                    'dayis' => 121
                ];
            
                $this->aged_invoice_query($whereConditionArray);


                              
                                $invoices = $this->inv_vendors;

                        
                                return view('reporting.payables.ajax.aged', compact('invoices', 'id'));

                                }

                                public function selected_invoices(Request $request) {
                                    $invs =  explode(',', $request->getinvs);
                                $invoices =        DB::table('payables')
                            ->select('payables.payableId', 
                            'payables.payableInvoiceNumber',
                            'payables.payableInvoiceDate',
                            'payables.payableProductCost', 
                            'payables.payableFrieght', 
                            'payables.payableTax',
                            'payables.payableECW', 
                            'payables.payableCompanyId', 
                            'payables.payableReturn',
                            'payableSubtime',
                            'payables.payableVendorId')
                            ->where('payables.payableCompanyId', auth()->user()->userCompanyId)
                           // ->where('payables.payableReturn', 0)
                            ->where('payables.payableIsDeleted', 0)
                            ->whereIn('payables.payableId', $invs)->get();
                            return view('reporting.payables.ajax.selected-invoices', compact('invoices'));
                            
                                }

                            

                                public function aged_pdf(){
                                   
                                    echo '<h1>Working on PDF. will available in 2-3 days</h1>';
                                    die;
                                    $banks = Bank::where('bankCompanyId', 1)->get();

                                    $payables_status = request()->get('payables_status') ? request()->get('payables_status') : 'default';
                                
                                    $vendors = array();
                                
                                    $days_30 = DB::table('payables')
                                    ->select('vendors.vendorCompany',
                                    DB::raw('SUM(payables.payableProductCost) as payableProductCost'),
                                    DB::raw('SUM(payables.payableFrieght) as payableFrieght'),
                                    DB::raw('SUM(payables.payableTax) as payableTax'),
                                    DB::raw('SUM(payables.payableECW) as payableECW'),
                                    'payables.payableCompanyId', 
                                    'payables.payableVendorId')
                                    ->join('vendors', 'vendors.vendorId', '=', 'payables.payableVendorId')
                                    ->where('payables.payableCompanyId', auth()->user()->userCompanyId)
                                   // ->where('payables.payableReturn', 0)
                                    ->where('payables.payableIsDeleted', 0)
                                    ->where('payables.proceedType', $payables_status)
                                    ->whereRaw('DATEDIFF(payables.payableInvoiceDate, CURDATE()) > -30')
                                    ->whereRaw('DATEDIFF(payables.payableInvoiceDate, CURDATE()) < 0')
                                    ->groupBy('payables.payableVendorId')
                                        ->get();
                                
                                        foreach($days_30 as $day_30){
                                        $payableVendorId = $day_30->payableVendorId;
                                        $vendorCompany = $day_30->vendorCompany;
                                        $payableFrieght = (double)$day_30->payableFrieght;
                                        $payableTax = (double)$day_30->payableTax;
                                        $payableECW = (double)$day_30->payableECW;
                                        $payableProductCost = (double)$day_30->payableProductCost;
                                        $net_30 = $payableFrieght+$payableTax+$payableProductCost+$payableECW;
                                
                                        $vendors[$payableVendorId] = ['payableVendorId' => $payableVendorId, 'vendorCompany' => $vendorCompany, 'net_30' => $net_30,
                                        'net_60' => 0,'net_90' => 0, 'net_120' => 0, 'over_120' => 0];
                                        }
                                
                                
                                
                                    $days_60 = DB::table('payables')
                                    ->select('vendors.vendorCompany',
                                    DB::raw('SUM(payables.payableProductCost) as payableProductCost'),
                                    DB::raw('SUM(payables.payableFrieght) as payableFrieght'),
                                    DB::raw('SUM(payables.payableTax) as payableTax'),
                                    DB::raw('SUM(payables.payableECW) as payableECW'),
                                    'payables.payableCompanyId', 
                                    'payables.payableVendorId')
                                    ->join('vendors', 'vendors.vendorId', '=', 'payables.payableVendorId')
                                    ->where('payables.payableCompanyId', auth()->user()->userCompanyId)
                                    //->where('payables.payableReturn', 0)
                                    ->where('payables.payableIsDeleted', 0)
                                    ->where('payables.proceedType', $payables_status)
                                    ->whereRaw('DATEDIFF(payables.payableInvoiceDate, CURDATE()) > -60')
                                    ->whereRaw('DATEDIFF(payables.payableInvoiceDate, CURDATE()) < -31') ->groupBy('payables.payableVendorId')
                                    ->get();
                                
                                
                                            foreach($days_60 as $day_60){
                                            $payableVendorId = $day_60->payableVendorId;
                                            $vendorCompany = $day_60->vendorCompany;
                                            $payableFrieght = (double)$day_60->payableFrieght;
                                            $payableTax = (double)$day_60->payableTax;
                                            $payableECW = (double)$day_60->payableECW;
                                            $payableProductCost = (double)$day_60->payableProductCost;
                                            $net_60 = $payableFrieght+$payableTax+$payableProductCost+$payableECW;
                                
                                            if (array_key_exists($payableVendorId, $vendors))
                                            {
                                            $vendors[$payableVendorId]['net_60'] = $net_60;
                                            }
                                            else
                                            {
                                            $vendors[$payableVendorId] = ['payableVendorId' => $payableVendorId, 'vendorCompany' => $vendorCompany, 'net_30' => 0,
                                            'net_60' =>
                                            $net_60, 'net_90' => 0, 'net_120' => 0, 'over_120' => 0];
                                
                                            }
                                            }
                                
                                
                                            $days_90 = DB::table('payables')
                                            ->select('vendors.vendorCompany',
                                            DB::raw('SUM(payables.payableProductCost) as payableProductCost'),
                                            DB::raw('SUM(payables.payableFrieght) as payableFrieght'),
                                            DB::raw('SUM(payables.payableTax) as payableTax'),
                                            DB::raw('SUM(payables.payableECW) as payableECW'),
                                            'payables.payableCompanyId', 
                                            'payables.payableVendorId')
                                            ->join('vendors', 'vendors.vendorId', '=', 'payables.payableVendorId')
                                            ->where('payables.payableCompanyId', auth()->user()->userCompanyId)
                                          //  ->where('payables.payableReturn', 0)
                                            ->where('payables.payableIsDeleted', 0)
                                            ->where('payables.proceedType', $payables_status)
                                
                                            ->whereRaw('DATEDIFF(payables.payableInvoiceDate, CURDATE()) > -90')
                                            ->whereRaw('DATEDIFF(payables.payableInvoiceDate, CURDATE()) < -61') ->groupBy('payables.payableVendorId')
                                                ->get();
                                
                                                foreach($days_90 as $day_90){
                                                $payableVendorId = $day_90->payableVendorId;
                                                $vendorCompany = $day_90->vendorCompany;
                                                $payableFrieght = (double)$day_90->payableFrieght;
                                                $payableECW = (double)$day_90->payableECW;
                                                $payableTax = (double)$day_90->payableTax;
                                                $payableProductCost = (double)$day_90->payableProductCost;
                                                $net_90 = $payableFrieght+$payableTax+$payableProductCost+$payableECW;
                                
                                                if (array_key_exists($payableVendorId, $vendors))
                                                {
                                                $vendors[$payableVendorId]['net_90'] = $net_90;
                                                }
                                                else
                                                {
                                                $vendors[$payableVendorId] = ['payableVendorId' => $payableVendorId, 'vendorCompany' => $vendorCompany, 'net_30' =>
                                                0, 'net_60' => 0, 'net_90' => $net_90, 'net_120' => 0, 'over_120' => 0];
                                
                                                }
                                                }

                                                $days_120 = DB::table('payables')
                                                ->select('vendors.vendorCompany',
                                                DB::raw('SUM(payables.payableProductCost) as payableProductCost'),
                                                DB::raw('SUM(payables.payableFrieght) as payableFrieght'),
                                                DB::raw('SUM(payables.payableTax) as payableTax'),
                                                DB::raw('SUM(payables.payableECW) as payableECW'),
                                                'payables.payableCompanyId', 
                                                'payables.payableVendorId')
                                                ->join('vendors', 'vendors.vendorId', '=', 'payables.payableVendorId')
                                                ->where('payables.payableCompanyId', auth()->user()->userCompanyId)
                                               // ->where('payables.payableReturn', 0)
                                                ->where('payables.payableIsDeleted', 0)
                                                ->where('payables.proceedType', $payables_status)
                                    
                                                ->whereRaw('DATEDIFF(payables.payableInvoiceDate, CURDATE()) > -120')
                                                ->whereRaw('DATEDIFF(payables.payableInvoiceDate, CURDATE()) < -91') ->groupBy('payables.payableVendorId')
                                                    ->get();
                                    
                                                    foreach($days_120 as $day_120){
                                                    $payableVendorId = $day_120->payableVendorId;
                                                    $vendorCompany = $day_120->vendorCompany;
                                                    $payableFrieght = (double)$day_120->payableFrieght;
                                                    $payableECW = (double)$day_120->payableECW;
                                                    $payableTax = (double)$day_120->payableTax;
                                                    $payableProductCost = (double)$day_120->payableProductCost;
                                                    $net_120 = $payableFrieght+$payableTax+$payableProductCost+$payableECW;
                                    
                                                    if (array_key_exists($payableVendorId, $vendors))
                                                    {
                                                    $vendors[$payableVendorId]['net_120'] = $net_120;
                                                    }
                                                    else
                                                    {
                                                    $vendors[$payableVendorId] = ['payableVendorId' => $payableVendorId, 'vendorCompany' => $vendorCompany, 'net_30' =>
                                                    0, 'net_60' => 0, 'net_90' => 0, 'net_120' => $net_120, 'over_120' => 0];
                                    
                                                    }
                                                    }

                                
                                                $days_over_90 = DB::table('payables')
                                                ->select('vendors.vendorCompany',
                                                DB::raw('SUM(payables.payableProductCost) as payableProductCost'),
                                                DB::raw('SUM(payables.payableFrieght) as payableFrieght'),
                                                DB::raw('SUM(payables.payableTax) as payableTax'),
                                                DB::raw('SUM(payables.payableECW) as payableECW'),
                                                'payables.payableCompanyId', 
                                                'payables.payableVendorId')
                                                ->join('vendors', 'vendors.vendorId', '=', 'payables.payableVendorId')
                                                ->where('payables.payableCompanyId', auth()->user()->userCompanyId)
                                                //->where('payables.payableReturn', 0)
                                                ->where('payables.payableIsDeleted', 0)
                                                ->where('payables.proceedType', $payables_status)
                                
                                                ->whereRaw('DATEDIFF(payables.payableInvoiceDate, CURDATE()) < -91') ->groupBy('payables.payableVendorId')
                                                    ->get();
                                
                                                    foreach($days_over_90 as $over_90){
                                                    $payableVendorId = $over_90->payableVendorId;
                                                    $vendorCompany = $over_90->vendorCompany;
                                                    $payableFrieght = (double)$over_90->payableFrieght;
                                                    $payableTax = (double)$over_90->payableTax;
                                                    $payableECW = (double)$over_90->payableECW;
                                                    $payableProductCost = (double)$over_90->payableProductCost;
                                                    $netover_90 = $payableFrieght+$payableTax+$payableProductCost+$payableECW;
                                
                                                    if (array_key_exists($payableVendorId, $vendors))
                                                    {
                                                    $vendors[$payableVendorId]['over_90'] = $netover_90;
                                                    }
                                                    else
                                                    {
                                                    $vendors[$payableVendorId] = ['payableVendorId' => $payableVendorId, 'vendorCompany' => $vendorCompany, 'net_30'
                                                    => 0, 'net_60' => 0, 'net_90' => 0, 'over_90' => $netover_90];
                                
                                                    }
                                                    }
                                
                                                    $data['banks'] = $banks;
                                                    $data['customers'] = $vendors;
                                                    $pdf = PDF::loadView('pdf.payables-aged', $data);
                                                    return $pdf->stream();


                                }


    public function aged_pdf_single($vendor_id) {
        echo '<h1>Working on PDF. will available in 2-3 days</h1>';
        die;
    $banks = Bank::where('bankCompanyId', 1)->get();
    $credit_cards = PaymentGateway::where('paymentGatewayCompanyId', 1)->get();

    $payables_status = request()->get('payables_status') ? request()->get('payables_status') : 'default';

    $vendors = array();

    $days_30 = DB::table('payables')
    ->select('vendors.vendorCompany',
    DB::raw('SUM(payables.payableProductCost) as payableProductCost'),
    DB::raw('SUM(payables.payableFrieght) as payableFrieght'),
    DB::raw('SUM(payables.payableTax) as payableTax'),
    DB::raw('SUM(payables.payableECW) as payableECW'),
    'payables.payableCompanyId', 
    'payables.payableVendorId')
    ->join('vendors', 'vendors.vendorId', '=', 'payables.payableVendorId')
    ->where('payables.payableCompanyId', auth()->user()->userCompanyId)
    //->where('payables.payableReturn', 0)
    ->where('payables.payableIsDeleted', 0)
    ->where('payables.payableVendorId', $vendor_id)
    ->where('payables.proceedType', $payables_status)
    ->whereRaw('DATEDIFF(payables.payableInvoiceDate, CURDATE()) > -30')
    ->whereRaw('DATEDIFF(payables.payableInvoiceDate, CURDATE()) < 0')
    ->groupBy('payables.payableVendorId')
        ->get();

        foreach($days_30 as $day_30){
        $payableVendorId = $day_30->payableVendorId;
        $vendorCompany = $day_30->vendorCompany;
        $payableFrieght = (double)$day_30->payableFrieght;
        $payableTax = (double)$day_30->payableTax;
        $payableECW = (double)$day_30->payableECW;
        $payableProductCost = (double)$day_30->payableProductCost;
        $net_30 = $payableFrieght+$payableTax+$payableProductCost+$payableECW;

        $vendors[] = ['payableVendorId' => $payableVendorId, 'vendorCompany' => $vendorCompany, 'net_30' => $net_30,
        'net_60' => 0,'net_90' => 0, 'over_90' => 0];
        }



    $days_60 = DB::table('payables')
    ->select('vendors.vendorCompany',
    DB::raw('SUM(payables.payableProductCost) as payableProductCost'),
    DB::raw('SUM(payables.payableFrieght) as payableFrieght'),
    DB::raw('SUM(payables.payableTax) as payableTax'),
    DB::raw('SUM(payables.payableECW) as payableECW'),
    'payables.payableCompanyId', 
    'payables.payableVendorId')
    ->join('vendors', 'vendors.vendorId', '=', 'payables.payableVendorId')
    ->where('payables.payableCompanyId', auth()->user()->userCompanyId)
   // ->where('payables.payableReturn', 0)
    ->where('payables.payableIsDeleted', 0)
    ->where('payables.payableVendorId', $vendor_id)
    ->where('payables.proceedType', $payables_status)
    ->whereRaw('DATEDIFF(payables.payableInvoiceDate, CURDATE()) > -60')
    ->whereRaw('DATEDIFF(payables.payableInvoiceDate, CURDATE()) < -31') ->groupBy('payables.payableVendorId')
    ->get();


            foreach($days_60 as $day_60){
            $payableVendorId = $day_60->payableVendorId;
            $vendorCompany = $day_60->vendorCompany;
            $payableFrieght = (double)$day_60->payableFrieght;
            $payableTax = (double)$day_60->payableTax;
            $payableECW = (double)$day_60->payableECW;
            $payableProductCost = (double)$day_60->payableProductCost;
            $net_60 = $payableFrieght+$payableTax+$payableProductCost+$payableECW;

            
            $vendors[] = ['payableVendorId' => $payableVendorId, 'vendorCompany' => $vendorCompany, 'net_30' => 0,
            'net_60' =>
            $net_60, 'net_90' => 0, 'over_90' => 0];

           
            }


            $days_90 = DB::table('payables')
            ->select('vendors.vendorCompany',
            DB::raw('SUM(payables.payableProductCost) as payableProductCost'),
            DB::raw('SUM(payables.payableFrieght) as payableFrieght'),
            DB::raw('SUM(payables.payableTax) as payableTax'),
            DB::raw('SUM(payables.payableECW) as payableECW'),
            'payables.payableCompanyId', 
            'payables.payableVendorId')
            ->join('vendors', 'vendors.vendorId', '=', 'payables.payableVendorId')
            ->where('payables.payableCompanyId', auth()->user()->userCompanyId)
           // ->where('payables.payableReturn', 0)
            ->where('payables.payableIsDeleted', 0)
            ->where('payables.payableVendorId', $vendor_id)
            ->where('payables.proceedType', $payables_status)

            ->whereRaw('DATEDIFF(payables.payableInvoiceDate, CURDATE()) > -90')
            ->whereRaw('DATEDIFF(payables.payableInvoiceDate, CURDATE()) < -61') ->groupBy('payables.payableVendorId')
                ->get();

                foreach($days_90 as $day_90){
                $payableVendorId = $day_90->payableVendorId;
                $vendorCompany = $day_90->vendorCompany;
                $payableFrieght = (double)$day_90->payableFrieght;
                $payableECW = (double)$day_90->payableECW;
                $payableTax = (double)$day_90->payableTax;
                $payableProductCost = (double)$day_90->payableProductCost;
                $net_90 = $payableFrieght+$payableTax+$payableProductCost+$payableECW;

                
                $vendors[] = ['payableVendorId' => $payableVendorId, 'vendorCompany' => $vendorCompany, 'net_30' =>
                0, 'net_60' => 0, 'net_90' => $net_90, 'over_90' => 0];

                
                }


                $days_over_120 = DB::table('payables')
                ->select('vendors.vendorCompany',
                DB::raw('SUM(payables.payableProductCost) as payableProductCost'),
                DB::raw('SUM(payables.payableFrieght) as payableFrieght'),
                DB::raw('SUM(payables.payableTax) as payableTax'),
                DB::raw('SUM(payables.payableECW) as payableECW'),
                'payables.payableCompanyId', 
                'payables.payableVendorId')
                ->join('vendors', 'vendors.vendorId', '=', 'payables.payableVendorId')
                ->where('payables.payableCompanyId', auth()->user()->userCompanyId)
             //   ->where('payables.payableReturn', 0)
                ->where('payables.payableIsDeleted', 0)
                ->where('payables.payableVendorId', $vendor_id)
                ->where('payables.proceedType', $payables_status)

                ->whereRaw('DATEDIFF(payables.payableInvoiceDate, CURDATE()) < -121') ->groupBy('payables.payableVendorId')
                    ->get();

                    foreach($days_over_120 as $over_120){
                    $payableVendorId = $over_120->payableVendorId;
                    $vendorCompany = $over_120->vendorCompany;
                    $payableFrieght = (double)$over_120->payableFrieght;
                    $payableTax = (double)$over_120->payableTax;
                    $payableECW = (double)$over_120->payableECW;
                    $payableProductCost = (double)$over_120->payableProductCost;
                    $netover_120 = $payableFrieght+$payableTax+$payableProductCost+$payableECW;

                   
                    $vendors[] = ['payableVendorId' => $payableVendorId, 'vendorCompany' => $vendorCompany, 'net_30'
                    => 0, 'net_60' => 0, 'net_90' => 0, 'net_120' => 0, 'over_120' => $netover_120];

                    
                    }

                        $data['customers'] = $vendors;
                      $pdf = PDF::loadView('pdf.payables-vaged', $data);
                    return $pdf->stream();
                   
}


public function save_unpresented(Request $request){
   // dd($request->all());
   $invids = $request->all();
    if($request->invTypePayment == 'Payable'){
    if($request->getewayTypechange == 'card'){
        $this->save_debit_to_card($invids);

    }

    if($request->getewayTypechange == 'bank'){
      
 
           $this->save_debit_to_bank($invids);
    }

    Payable::whereIn('payableId', $request->invids)->update(['proceedType'=> $request->invTypechange]);
    }

    if($request->invTypePayment == 'Expense'){
        
        if($request->getewayTypechange == 'card'){
            $this->expense_debit_to_card($invids);
    
        }
    
        if($request->getewayTypechange == 'bank'){
          
     
              $this->expense_debit_to_bank($invids);
        }
    
      //  Payable::whereIn('payableId', $request->invids)->update(['proceedType'=> $request->invTypechange]);
      Expense::whereIn('expenseId', $request->invids)->update(['expenseStatusType'=> $request->invTypechange, 'expenseGateway' => $request->expenseGateway]);

        }
    return redirect()->back()->with('success','Transaction Successful.');;


}

public function save_debit_to_card($all_data){
   
    $invoices = Payable::whereIn('payableId', $all_data['invids'])->get();

  
    $bankEntry=[];
    $ttotalamount = $all_data['totalamount'];
 
     $reportBankDescription = '';
     $reportBankDate = '';
     $reportBankDebit = 0;
     $reportBankRefrence = '';
     $date = '';
    foreach($invoices as $invoice)
    {
    $invoiceId = $invoice->payableId;
        $date = date_create($all_data['unprecented_date']); 
 
         $reportBankDescription .= $invoice->payablesBankRecord.', ';
         $reportBankCategory = 'PURCHASE';
      
         $reportBankDebit = $reportBankDebit+(double)$ttotalamount[$invoiceId];
         $reportBankCredit = 0.0;
         $reportBankRefrence .= '('.$invoice->payableInvoiceNumber.')';
 
        
    }
 
    $unprecented_ccText = '';
  // $unprecented_cc = (int)$all_data['unprecented_cc'];
//    if($unprecented_cc > 0){
//     $unprecented_ccText = '<b style="color:red">includes '.auth()->user()->company->companyCurrency.''.$unprecented_cc.' CC Charges</b>';
//    }
    $card = new Reportingcc();
    
    $card->reportingccDescription = $reportBankDescription;
    $card->reportingccCategory = 'PURCHASE';
    $card->reportingccDebit = $reportBankDebit;
    $card->reportingccCredit = $reportBankCredit;
    $card->reportingccAllocation = 'Payable';
    $card->reportingccReference = $reportBankRefrence;
    $card->reportingccDate = date_format($date,"Y/m/d H:i:s");
    $card->reportingccCardId = (int)$all_data['unprecented_bank'];
    $card->reportingccCompanyId = auth()->user()->userCompanyId;
    $card->reportingccUserId = auth()->user()->userId;
    $card->reportingccDetail = implode(",",$all_data['invids']);
    $card->save();

   return $card;

}

public function save_debit_to_bank($all_data){
    
    $invoices = Payable::whereIn('payableId', $all_data['invids'])->get();

  
    $bankEntry=[];
    $ttotalamount = $all_data['totalamount'];
 
     $reportBankDescription = '';
     $reportBankDate = '';
     $reportBankDebit = 0;
     $reportBankRefrence = '';
     $date = '';
    foreach($invoices as $invoice)
    {
    $invoiceId = $invoice->payableId;
        $date = date_create($all_data['unprecented_date']); 
 
         $reportBankDescription .= $invoice->payablesBankRecord.', ';
         $reportBankCategory = 'PURCHASE';
      
         $reportBankDebit = $reportBankDebit+(double)$ttotalamount[$invoiceId];
         $reportBankCredit = 0.0;
         $reportBankRefrence .= '('.$invoice->payableInvoiceNumber.')';
 
        
    }
 
    $bank_entry = new ReportingBank();
    
    $bank_entry->reportBankDescription = $reportBankDescription;
    $bank_entry->reportBankCategory = 'PURCHASE';
    $bank_entry->reportBankDebit = $reportBankDebit;
    $bank_entry->reportBankCredit = $reportBankCredit;
    $bank_entry->reportBankAllocation = 'Payable';
    $bank_entry->reportBankRefrence = $reportBankRefrence;
    $bank_entry->reportBankDate = date_format($date,"Y/m/d H:i:s");
    $bank_entry->reportBankYear = (int)date_format($date,"Y");
    $bank_entry->bank_entry = (int)$all_data['unprecented_bank'];
    $bank_entry->reportBankCompanyId = auth()->user()->userCompanyId;
    $bank_entry->reportBankCreatedUserId = auth()->user()->userId;
    $bank_entry->reportBankDetail = implode(",",$all_data['invids']);
 
    $bank_entry->save();
   return $bank_entry;
 
 
 }
 
 public function expense_debit_to_bank($all_data){
    
    $invoices = Expense::whereIn('expenseId', $all_data['invids'])->get();
    
  
    $bankEntry=[];
    $ttotalamount = $all_data['totalamount'];
 
     $reportBankDescription = '';
     $reportBankDate = '';
     $reportBankDebit = 0;
     $reportBankRefrence = '';
     $date = '';
    foreach($invoices as $invoice)
    {
    $invoiceId = $invoice->expenseId;
        $date = date_create($all_data['unprecented_date']); 
 
         $reportBankDescription .= $invoice->expenseReference.', ';
         $reportBankCategory = 'EXPENSE';
      
         $reportBankDebit = $reportBankDebit+(double)$ttotalamount[$invoiceId];
         $reportBankCredit = 0.0;
         $reportBankRefrence .= '('.$invoice->expenseInvoiceNo.')';
 
        
    }
 
    $bank_entry = new ReportingBank();
    
    $bank_entry->reportBankDescription = $reportBankDescription;
    $bank_entry->reportBankCategory = 'EXPENSE';
    $bank_entry->reportBankDebit = $reportBankDebit;
    $bank_entry->reportBankCredit = $reportBankCredit;
    $bank_entry->reportBankAllocation = 'Payable';
    $bank_entry->reportBankRefrence = $reportBankRefrence;
    $bank_entry->reportBankDate = date_format($date,"Y/m/d H:i:s");
    $bank_entry->reportBankYear = (int)date_format($date,"Y");
    $bank_entry->bank_entry = (int)$all_data['unprecented_bank'];
    $bank_entry->reportBankCompanyId = auth()->user()->userCompanyId;
    $bank_entry->reportBankCreatedUserId = auth()->user()->userId;
    $bank_entry->reportBankDetail = implode(",",$all_data['invids']);
 
    $bank_entry->save();
   return $bank_entry;
 
 
 }                


 public function expense_debit_to_card($all_data){
   
    $invoices = Expense::whereIn('expenseId', $all_data['invids'])->get();

  
    $bankEntry=[];
    $ttotalamount = $all_data['totalamount'];
 
     $reportBankDescription = '';
     $reportBankDate = '';
     $reportBankDebit = 0;
     $reportBankRefrence = '';
     $date = '';
    foreach($invoices as $invoice)
    {
    $invoiceId = $invoice->expenseId;
        $date = date_create($all_data['unprecented_date']); 
        $reportBankDescription .= $invoice->expenseReference.', ';
        $reportBankCategory = 'EXPENSE';
         $reportBankDebit = $reportBankDebit+(double)$ttotalamount[$invoiceId];
         $reportBankCredit = 0.0;
         $reportBankRefrence .= '('.$invoice->expenseInvoiceNo.')';
 
        
    }
 
    $unprecented_ccText = '';

    $card = new Reportingcc();
    
    $card->reportingccDescription = $reportBankDescription;
    $card->reportingccCategory = 'EXPENSE';
    $card->reportingccDebit = $reportBankDebit;
    $card->reportingccCredit = $reportBankCredit;
    $card->reportingccAllocation = 'Payable';
    $card->reportingccReference = $reportBankRefrence;
    $card->reportingccDate = date_format($date,"Y/m/d H:i:s");
    $card->reportingccCardId = (int)$all_data['unprecented_bank'];
    $card->reportingccCompanyId = auth()->user()->userCompanyId;
    $card->reportingccUserId = auth()->user()->userId;
    $card->reportingccDetail = implode(",",$all_data['invids']);
    $card->save();

   return $card;

}

}




