<?php

namespace App\Http\Controllers\Reports;
use App\Http\Controllers\Controller;

use Illuminate\Http\Request;
use App\Models\PaymentGateway;
use App\Models\Reportingcc;
use App\Models\ReportingBank;
use App\Models\Bank;
use App\Models\ReportingPaypal;
use DB;

use Illuminate\Support\Facades\Hash;

class PaypalController extends Controller {
    /**
    * Create a new controller instance.
    *
    * @return void
    */

    public function __construct() {
        $this->middleware( 'auth' );
    }



public function transaction_details($id){
 
  $transaction = ReportingPaypal::where('paypalPaymentCompanyId', auth()->user()->userCompanyId)
  ->where('paypalPaymentId', $id)
  ->select('paypalPaymentDetail', 'paypalPaymentCategory')->first();
 
  $category = $transaction->paypalPaymentCategory;
  $detail = $transaction->paypalPaymentDetail;
  if($category == 'INCOME'){
     $invoices = $this->showInvoices($detail);
     return view('banks.partials.invoices', compact('invoices'));
  }
  if($category == 'PURCHASE'){
      $payables = $this->showPayables($detail);
      return view('banks.partials.payables', compact('payables'));
   }

   if($category == 'EXPENSE'){
      $expenses = $this->showExpenses($detail);
      
      return view('banks.partials.expenses', compact('expenses'));
   }
}


protected function showExpenses($reportBankDetail){
  $expenses = DB::table('expenses')
  ->select('expenses.expenseVendorId', 'expenses.expenseInvoiceNo', 'expenses.expenseId',
  'expenseEndDateTime', 'expenseDueDate',
  'expenseReference',
  DB::raw('SUM(DISTINCT expenses.expenseTax) as expenseTax'),
  DB::raw('SUM(expense_items.expenseItemQuantity*expense_items.expenseItemUnitCost) as total'))
  ->join('expense_items', 'expense_items.expenseItemExpenseId', '=', 'expenses.expenseId')

  ->where('expenses.expenseCompanyId', auth()->user()->userCompanyId)
  ->whereIn('expenses.expenseId', explode(',', $reportBankDetail))
  ->groupBy('expenses.expenseId')
  ->orderBy('expenses.expenseId', 'desc')
  ->get();

  return $expenses;

}

protected function showPayables($reportBankDetail){

  $payables = DB::table('payables')
  ->select('payables.payableId', 
  'payables.payableInvoiceNumber',
  'payables.payableTrackingNumber',
  'payables.payableInvoiceDate',
  'payables.payableProductCost', 
  'payables.payableFrieght', 
  'payables.payableTax',
  'payables.payableECW')
  ->where('payables.payableCompanyId', auth()->user()->userCompanyId)
  ->where('payables.payableIsDeleted', 0)
  ->whereIn('payables.payableId',  explode(',', $reportBankDetail))
      ->get();

      return $payables;

}

protected function showInvoices($reportBankDetail){
  

  $results = DB::table('invoices')
  ->select('invoices.invoiceId','invoices.invoiceSoId', 'invoices.invoiceSoSerial', 'invoiceBillingCompany',
  DB::raw('IFNULL(invoiceShippingCharges, 0) as invoiceShippingCharges'), 
  DB::raw('IFNULL(invoiceTaxValue, 0) as invoiceTaxValue'),
  DB::raw('IFNULL(invoiceChargeAmount, 0) as invoiceChargeAmount'),
  DB::raw('IFNULL(invoiceCreditCardCharges, 0) as invoiceCreditCardCharges'),
  DB::raw('SUM(invoice_items.invoiceItemQuantity*invoice_items.invoiceItemUnitCost) as total'))
  ->join('invoice_items', 'invoice_items.invoiceItemInvoiceId', '=', 'invoices.invoiceId')
  ->where('invoices.invoiceCompanyId', auth()->user()->userCompanyId)
  ->whereIn('invoices.invoiceId',  explode(',', $reportBankDetail))
  ->groupBy('invoices.invoiceId')
  ->orderBy('invoices.invoiceId', 'desc')
  ->get();
  
  return $results;
}

public function destroy($id)
{
 
  try {
    

    DB::beginTransaction();

    $transaction = ReportingPaypal::where('paypalPaymentCompanyId', auth()->user()->userCompanyId)
    ->where('paypalPaymentId', $id)
    ->select('paypalPaymentDetail', 'paypalPaymentCategory')->first();
      
      $details = $transaction->paypalPaymentDetail;
     
      $destroyed = $transaction->destroy($id);
  
      if ($destroyed) {
          if($transaction->paypalPaymentCategory == 'INCOME'){
              DB::table('invoices')->whereIn('invoiceId', explode(',', $details))->update(['invoiceStatusType'=>'default']);
          }
          if($transaction->paypalPaymentCategory == 'PURCHASE'){
              DB::table('payables')->whereIn('payableId', explode(',', $details))->update(['proceedType'=>'default']);
          }
          if($transaction->paypalPaymentCategory == 'EXPENSE'){
              DB::table('expenses')->whereIn('expenseId', explode(',', $details))->update(['expenseStatusType'=>'default']);
          }
     }
     DB::commit();

    return response()->json(['success' => true]);   
  
  } catch (\Throwable $e) {
      // Handle the exception here
      DB::rollback();
      echo "Error updating invoices: " . $e->getMessage();

  }
  
  



}

}