<?php

namespace App\Http\Controllers\Reports;
use App\Http\Controllers\Controller;

use Illuminate\Http\Request;
use App\Models\PaymentGateway;
use App\Models\Reportingcc;
use App\Models\ReportingBank;
use App\Models\Bank;
use App\Models\Deal;

use PDF;
use DB;
use Illuminate\Support\Facades\Hash;

class ProfitLossController extends Controller {
    /**
    * Create a new controller instance.
    *
    * @return void
    */
    use \App\Http\Controllers\Traits\Functions;

    public function __construct() {
        $this->middleware( 'auth' );
    }

    /**
    * Show the application dashboard.
    *
    * @return \Illuminate\Contracts\Support\Renderable
    */



    public function index()
    {
        $dealYearArray   = $this->yearsList();
        $dealMonthArray   = $this->monthsList();
        $departments   = $this->departments();

        $dealYear = request()->get('dealYear') ? request()->get('dealYear') : date("Y");
        $dealMonth = request()->get('dealMonth') ? request()->get('dealMonth') : date("m");
        return view('reports.profit-loss.index.ajax', compact('dealYearArray', 'dealMonthArray' , 'dealYear', 'dealMonth',  'departments'));
        
    }


    public function profit_loss_month(Request $request)
    {

$companyPrefix = auth()->user()->company->companyPrefix;
$dealYearArray   = $this->yearsList();
$dealMonthArray   = $this->monthsList();
$departments   = $this->departments();


 $rawQuery= '';




$rawQuery .=' dealCompanyId = '.auth()->user()->userCompanyId;


if(request()->get('onlysheet') == 'amazon'){

  $rawQuery .= ' AND dealPaymentMethod = "Amazon" ';
}
if(request()->get('sonumber')){
  $rawQuery = '';
  $rawQuery = 'dealSO = '.request()->get('sonumber');
  $rawQuery .=' AND dealCompanyId = '.auth()->user()->userCompanyId;
}

      $orders = Deal::select('dealSO' ,'dealPaymentMethod', 'dealTaxName', 'dealTaxValue', 'dealChargeType', 'dealChargeAmount')
      ->whereNotNull('dealSO')
      ->where('deals.dealRevised', 0)
      ->whereHas('saleorder', function ($query) {
        $dealYear = request()->get('dealYear') ? request()->get('dealYear') : date("Y");
        $dealMonth = request()->get('dealMonth') ? request()->get('dealMonth') : date("m");
        $rawQuery= 'closeOrder = 1';
        //year selection 
        if(!request()->get('sonumber')){

        if($dealMonth != 'all'){

          
        $rawQuery .= ' AND MONTH(salesorderMonthYear) = '.$dealMonth;
       
        }

        
        //month selection 
        $rawQuery .= ' AND YEAR(salesorderMonthYear) = '.$dealYear;

      }
        return $query->whereRaw($rawQuery);
    })
      ->has('creditInvoices')

    ->whereRaw($rawQuery)

      ->get();

//    $dealCreditCardChargesArray = [];
    $dealccAmazonArray = [];
    $dealtaxAmazonArray = [];
    $dealtaxAmazonDeductionArray = [];


 

      $all_records = [];
     
      $cinvr = 0;
      $cpayr = 0;
      foreach($orders as $order){

        $invoicesforcharges = [];
        $cc_amazonsum = [0];
        foreach($order->creditInvoices as $invoice){ $invoicesforcharges[] = $invoice->invoiceId; }
        
          
            $paypal_payments = DB::table('paypal_payment')
                    ->select('paypalPaymentCharges')
                    ->where('paypalPaymentDetail',implode(",",$invoicesforcharges))
                        ->get();
        foreach($paypal_payments as $paypal_payment){ $cc_amazonsum[] = $paypal_payment->paypalPaymentCharges; }
                      
   
        $so_record = [];
        $po_record = [];
        $addrows = 0;
        $whatincrease = '';
        $countInvoices = $order->creditInvoices->count(); 
        $countPayables = $order->debitPayables->count(); 
       $dealCreditCardCharges = $order->dealCreditCardCharges?$order->dealCreditCardCharges:0;
       $dealTaxName = $order->dealTaxName;
       $dealChargeType = $order->dealChargeType;

      // $paypalCharges = $order->paypal?$order->paypal->salesorderPaymentCharges:0;
      $paypalCharges = array_sum($cc_amazonsum);
       //$amazonTax = 0;

      // if($dealTaxName == 'Amazon Tax'){
      //   $amazonTax = $order->dealTaxValue?$order->dealTaxValue:0;

      // }

      // if($dealChargeType == 'Amazon Charges'){
      //   $paypalCharges = $order->dealChargeAmount?$order->dealChargeAmount:0;

      // }


       
        if($countInvoices > $countPayables)
        {
          $addrows = $countInvoices-$countPayables;
        
          $whatincrease = 'payables';

        }else{
          
          $whatincrease = 'invoices';
          $addrows = $countPayables-$countInvoices;
        }
        

        $invoices = [];

     

        foreach($order->creditInvoices as $keyi => $invoice):

        $invoiceReturn = 1;
        $isReturnText ='';
        if($invoice->invoiceType == 'return'){
          $invoiceReturn = -1;
          $isReturnText ='(Return)';

        }

        $invoice_frieght =  (double)$invoice->invoiceShippingCharges*$invoiceReturn;

        

        $invoice_tax = $invoice->invoiceTaxValue;



        $invoice_gross_sale = ((double)$invoice->invSum->total+(double)$invoice->invoiceChargeAmount+(double)$invoice->invoiceCreditCardCharges)*$invoiceReturn;
        
        $idate = date_create($invoice->invoiceEndDateTime);
        $saleorderdate = date_create($order->saleorder->salesorderMonthYear);

        $invoices['invoiceId'] =  $invoice->invoiceId;
        $invoices['thetype'] =  $invoice->invoiceDepartmentId;
        $invoices['month'] = date_format($saleorderdate,"M").$isReturnText;
        $invoices['invoice'] = $invoice->invoiceSoId.'-'.$invoice->invoiceSoSerial;
        $invoices['invoice_date'] =date_format($idate,"M,d Y");
        $invoices['reference'] = $invoice->invoiceReference;
        $invoices['customer'] =$invoice->invoiceBillingCompany; 
        $invoices['state'] =$invoice->invoiceBillingState; 
        $invoices['gross_sale'] =  (double)$invoice_gross_sale;
        $invoices['frieght'] =  (double)$invoice_frieght;
        $invoices['tax'] = (double)$invoice->invoiceTaxValue;

        $subtotal = ($invoice->invSum->total+$invoice_frieght+$invoice_tax+$invoice->invoiceChargeAmount+$invoice->invoiceCreditCardCharges)*$invoiceReturn;

        $invoices['invoice_total'] =$subtotal;
       

        if(!in_array($order->dealSO, $dealccAmazonArray)){
          $cc_amazon =  $paypalCharges;
          $dealccAmazonArray[] = $order->dealSO;
        }else{
        $cc_amazon =  0;
        }

        
       

     

        if($cc_amazon > 0){
          $cc_amazon = $cc_amazon*-1;
        }

        $invoices['cc_amazon'] =$cc_amazon;
        $deductTax = 0;
        // if(!in_array($order->dealSO, $dealtaxAmazonDeductionArray)){
         
        //   if($order->dealPaymentMethod == 'Amazon'){
        //     $deductTax = $invoice_tax;
        //   }
          
        //   $dealtaxAmazonDeductionArray[] = $order->dealSO;
        // }
       

        $invoices['net_sale_amount'] =$subtotal+$cc_amazon-$deductTax; 
        $so_record[] = $invoices;
     

      endforeach;

 
   if($whatincrease == 'invoices'):
    for($i = 1; $i <= $addrows; $i++):
      
      $invoices['thetype'] = '';
      $invoices['month'] = '';
      $invoices['invoice'] = '';
      $invoices['invoice_date'] ='';
      $invoices['reference'] = '';
      $invoices['customer'] = '';
      $invoices['state'] ='';
      $invoices['gross_sale'] = '';
      $invoices['frieght'] =  '';
      $invoices['tax'] = '';
      
      $invoices['invoice_total'] ='';

      $invoices['cc_amazon'] ='';
      $invoices['net_sale_amount'] ='';

      $so_record[] = $invoices;
      endfor;



    endif;
  
    $payables = [];
    foreach($order->debitPayables as $kp =>  $payable):
      $payableReturn = 1;
      if($payable->payableReturn == 1){
        $payableReturn = -1;
      }
      $payablesBankRecord = explode(",",$payable->payablesBankRecord);
      $pdate=date_create($payable->payableInvoiceDate);

      $payables['po_number'] = $payablesBankRecord[0];
      $payables['vendor'] = $payablesBankRecord[1];
      $payables['invoice_no'] = $payable->payableInvoiceNumber;
      $payables['pinvoice_date'] =date_format($pdate,"M,d Y");
      $payableProductCost = (double)$payable->payableProductCost*$payableReturn;
      $payableFrieght = (double)$payable->payableFrieght*$payableReturn;
      $payableTax = (double)$payable->payableTax*$payableReturn;
      $payableECW = (double)$payable->payableECW*$payableReturn;
         
      $payables['payable_product_cost'] =$payableProductCost;
      $payables['payable_frieght'] =$payableFrieght;
      $payables['payable_tax'] =$payableTax;
      $payables['payable_ecw'] =$payableECW;

      $payables['invoice_amount'] =$payableProductCost+$payableFrieght+$payableTax+$payableECW;

      $payables['payable_tracking'] = $payable->payableTrackingNumber;


      $payables['gross_profit'] =0;
            


      $po_record[] = $payables;

    
   
    endforeach;
          if($whatincrease == 'payables'):
          for($i = 1; $i <= $addrows; $i++):

            $payables['po_number'] = '';
            $payables['vendor'] = '';
            $payables['invoice_no'] = '';
            $payables['pinvoice_date'] ='';
            $payables['payable_product_cost'] ='';
            $payables['payable_frieght'] ='';
            $payables['payable_tax'] ='';
            $payables['payable_ecw'] ='';
              
            $payables['invoice_amount'] ='';

            $payables['payable_tracking'] = '';


            $payables['gross_profit'] =0;
                  
            $po_record[] = $payables;

          endfor;
          endif;

          
          foreach($po_record as $key => $po_recor){
           $all_records[] =  array_merge($so_record[$key],$po_recor);
          }
          
        //  $dealCreditCardChargesArray[] = $order->dealSO;
          
      }

 
      return response()->json($all_records);

    }



}
