<?php

namespace App\Http\Controllers\Reports;
use App\Http\Controllers\Controller;

use Illuminate\Http\Request;
use App\Models\Vendor;
use App\Models\Invoice;
use App\Models\Bank;
use App\Models\ReportingBank;
use App\Models\Customer;
use App\Models\PaymentGateway;
use App\Models\Reportingcc;
use App\Models\ReportingPaypal;


use Illuminate\Support\Facades\Hash;
use DB;
use PDF;
use Carbon\Carbon;
class ReceivableController extends Controller {
    /**
    * Create a new controller instance.
    *
    * @return void
    */

    public $customers = [];
    public $customer_invs = [];

    public function __construct() {
        $this->middleware( 'auth' );
    }

    /**
    * Show the application dashboard.
    *
    * @return \Illuminate\Contracts\Support\Renderable
    */
    use \App\Http\Controllers\Traits\Functions;


    public function get_aged($whereConditionArray)
    {
        $receivables_status = request()->get('receivables_status') ? request()->get('receivables_status') : 'default';




$receivableYear = request()->get('receivableYear') ? request()->get('receivableYear') : date("Y");
$receivableMonth = request()->get('receivableMonth') ? request()->get('receivableMonth') : date("m");


$rawQuery= '';


//year selection 
if($receivableMonth != 'all'){
$rawQuery .= 'MONTH(invoices.invoiceEndDateTime) = '.$receivableMonth.' AND ';
}
//month selection 
$rawQuery .= 'YEAR(invoices.invoiceEndDateTime) = '.$receivableYear;
if(request()->get('customeris')){
    
    $rawQuery = 'deals.dealUserId = '.request()->get('customeris');

}
$rawQuery .=' AND deals.dealCompanyId = '.auth()->user()->userCompanyId;


        $days = DB::table('invoices')
        ->select('deals.dealUserId', 'users.userCompany', 'deals.dealCompanyId',
        DB::raw('SUM(DISTINCT invoices.invoiceShippingCharges) as invoiceShippingCharges'),
        DB::raw('SUM(DISTINCT invoices.invoiceTaxValue) as invoiceTaxValue'),
        DB::raw('SUM(DISTINCT invoices.invoiceCreditCardCharges) as invoiceCreditCardCharges'),
        DB::raw('SUM(DISTINCT invoices.invoiceChargeAmount) as invoiceChargeAmount'),
        DB::raw('SUM(invoice_items.invoiceItemQuantity*invoice_items.invoiceItemUnitCost) as total'))
        ->join('deals', 'deals.dealSO', '=', 'invoices.invoiceSoId')
        ->join('invoice_items', 'invoice_items.invoiceItemInvoiceId', '=', 'invoices.invoiceId')
        ->join('users', 'users.userId', '=', 'deals.dealUserId')
        ->where('deals.dealRevised', 0)
        // ->where('invoices.invoicePaid', 0)
        ->where('invoices.invoiceStatusType', $receivables_status)
        ->whereRaw($rawQuery)
        ->whereRaw('DATEDIFF(invoices.invoiceEndDateTime, CURDATE()) > '.$whereConditionArray['min_day'])
        ->whereRaw('DATEDIFF(invoices.invoiceEndDateTime, CURDATE()) < '.$whereConditionArray['max_day']) 
        ->groupBy('deals.dealUserId')
        ->get();

        
            $customers = array();
            
            foreach($days as $day){
                $dealUserId = $day->dealUserId;
                $userCompany = $day->userCompany;
                $invoiceShippingCharges = (double)$day->invoiceShippingCharges;
                $invoiceTaxValue = (double)$day->invoiceTaxValue;
                $invoiceChargeAmount = (double)$day->invoiceChargeAmount;
                $invoiceCreditCardCharges = (double)$day->invoiceCreditCardCharges;
                // if(array_key_exists($dealUserId, $getTotal)){
                // $total = (double)$getTotal[$dealUserId];
                // }else{
                //     $total = 0;
                // }

                $total = (double)$day->total;
                $netvalue = $invoiceShippingCharges+$invoiceChargeAmount+$invoiceCreditCardCharges+$invoiceTaxValue+$total;
                
            

              

                if (!array_key_exists($dealUserId, $this->customers))
                {
                    $this->customers[$dealUserId] = ['dealUserId' => $dealUserId, 'userCompany' => $userCompany, 'net_30' => 0, 'net_60' => 0
                    , 'net_90' => 0, 'over_90' => 0];
                }

                switch ($whereConditionArray['dayis']) {
                    case 30:
                        $this->customers[$dealUserId]['net_30'] = $netvalue;
                      break;
                    case 60:
                        if (array_key_exists($dealUserId, $this->customers))
                        {
                            $this->customers[$dealUserId]['net_60'] = $netvalue;
                        }
                        else
                        {
                            $this->customers[$dealUserId]['net_60'] = $netvalue;
                        }
                      break;
                    case 90:
                        if (array_key_exists($dealUserId, $this->customers))
                        {
                            $this->customers[$dealUserId]['net_90'] = $netvalue;
                        }
                        else
                        {
                            $this->customers[$dealUserId]['net_90'] = $netvalue;
                        }
                      break;
                      case 91:
                        if (array_key_exists($dealUserId, $this->customers))
                        {
                            $this->customers[$dealUserId]['over_90'] = $netvalue;
                        }
                        else
                        {
                            $this->customers[$dealUserId]['over_90'] = $netvalue;
                        }
                      break;
                    default:
                      echo "-";
                  }

                
                     
                }

          
          
    }

    public function aged() {
        $banks = Bank::where('bankCompanyId',  auth()->user()->userCompanyId)->get();
        $paypals = PaymentGateway::where('paymentGatewayCompanyId', auth()->user()->userCompanyId)
        ->where('paymentGatewayType', 'Paypal')
        ->get();

        $receivables_status = request()->get('receivables_status') ? request()->get('receivables_status') : 'default';
        $customers = array();
        $whereConditionArray = [
            'min_day' => -30, 
            'max_day' => 3, 
            'isdual' => true,
            'dayis' => 30
        ];
          $this->get_aged($whereConditionArray);

        
                $whereConditionArray = [

                'min_day' => -60, 
                'max_day' => -31, 
                'isdual' => true,
                'dayis' => 60
            
            ];
            $this->get_aged($whereConditionArray);

            
                $whereConditionArray = [

                    'min_day' => -90, 
                    'max_day' => -61, 
                    'isdual' => true,
                    'dayis' => 90
                ];

                $this->get_aged($whereConditionArray);

                $whereConditionArray = [

                    'min_day' => -3000, 
                    'max_day' => -91, 
                    'isdual' => true,
                    'dayis' => 91
                ];

                $this->get_aged($whereConditionArray);

                        $customers = $this->customers;


                        $receivableYearArray   = $this->yearsList();
                        $receivableMonthArray   = $this->monthsList();



                        return view('reporting.receivables.aged', compact('receivableYearArray', 'receivableMonthArray', 'customers','banks', 'paypals'));
    }

//get ajax invoices detail


protected function single_invoice($whereConditionArray){
        
    $receivables_status = request()->get('receivables_status') ? request()->get('receivables_status') : 'default';

    $invoices = array();

    $days = DB::table('invoices')
    ->select('invoices.invoiceId','invoices.invoiceSoId', 'invoices.invoiceSoSerial','invoiceShippingCharges',
    'invoiceTaxValue','invoiceChargeAmount','invoiceCreditCardCharges', 'isCancel', 'invoiceType', 'invoiceReference',
    DB::raw('SUM(invoice_items.invoiceItemQuantity*invoice_items.invoiceItemUnitCost) as total'))
    ->join('invoice_items', 'invoice_items.invoiceItemInvoiceId', '=', 'invoices.invoiceId')
    ->join('deals', 'deals.dealSO', '=', 'invoices.invoiceSoId')
    ->where('invoices.invoiceStatusType', $receivables_status)
    //->where('invoices.invoicePaid', 0)
    ->where('deals.dealRevised', 0)

    ->where('deals.dealCompanyId', auth()->user()->userCompanyId)
    ->where('deals.dealUserId', $whereConditionArray['user_id'])
    ->whereRaw('DATEDIFF(invoices.invoiceEndDateTime, CURDATE()) > '.$whereConditionArray['min_day'])
    ->whereRaw('DATEDIFF(invoices.invoiceEndDateTime, CURDATE()) < '.$whereConditionArray['max_day'])
    ->groupBy('invoices.invoiceId')
    ->orderBy('invoices.invoiceId', 'desc')
    ->get();


               if(isset($days[0]->invoiceId)){

            foreach($days as $day){

                $invoiceId = $day->invoiceId;
                $invoiceShippingCharges = $day->invoiceShippingCharges;
                $invoiceTaxValue = $day->invoiceTaxValue;
                $invoiceChargeAmount = $day->invoiceChargeAmount;
                $invoiceCreditCardCharges = $day->invoiceCreditCardCharges;
                $total = $day->total;
                $netvalue = $invoiceShippingCharges+$invoiceChargeAmount+$invoiceCreditCardCharges+$invoiceTaxValue+$total;
                $invoiceSoSerial = $day->invoiceSoSerial;
                $invoiceIsCancel = $day->isCancel;
                $invoiceType = $day->invoiceType;
                $invoiceSoId = $day->invoiceSoId;
                $invoiceReference = $day->invoiceReference;
                
            

                if (!array_key_exists($invoiceId, $this->customer_invs))
                {
               
                    $this->customer_invs[$invoiceId] = ['invoiceId' => $invoiceId, 'invoiceSoSerial' => $invoiceSoSerial, 'invoiceReference' => $invoiceReference, 'invoiceIsCancel' => $invoiceIsCancel, 'invoiceType' => $invoiceType, 'invoiceSoId' =>
                    $invoiceSoId, 'net_30' => 0, 'net_60' => 0,'net_90' => 0, 'over_90' => 0];
                }

                switch ($whereConditionArray['dayis']) {
                    case 30:
                
                        if (array_key_exists($invoiceId, $this->customer_invs))
                        {
                            $this->customer_invs[$invoiceId]['net_30'] = $netvalue;
            
                        }
                        
    
                      
                      break;
                    case 60:
                        if (array_key_exists($invoiceId,  $this->customer_invs))
                        {
                            $this->customer_invs[$invoiceId]['net_60'] = $netvalue;
                            
                        }
                     
    
                      break;
                    case 90:
                        if (array_key_exists($invoiceId, $this->customer_invs))
                        {
                            $this->customer_invs[$invoiceId]['net_90'] = $netvalue;
                        }
                      
                      break;
                      case 91:
                        if (array_key_exists($invoiceId, $this->customer_invs))
                        {
                            $this->customer_invs[$invoiceId]['over_90'] = $netvalue;
                        }
                     
                      break;
                     
                     
                      break;
                    default:
                      echo "-";
                  }

            }

            }

}
    
    public function aged_invoices($id) {

     
        $receivables_status = request()->get('receivables_status') ? request()->get('receivables_status') : 'default';

        $invoices = array();




        $whereConditionArray = [
            'min_day' => -30, 
            'max_day' => 3, 
            'isdual' => true,
            'user_id'  => $id,
            'dayis' => 30
        ];
    
        $this->single_invoice($whereConditionArray);

        $whereConditionArray = [
            'min_day' => -60, 
            'max_day' => -31, 
            'isdual' => true,
            'user_id'  => $id,
            'dayis' => 60
        ];
    
        $this->single_invoice($whereConditionArray);

        $whereConditionArray = [
            'min_day' => -90, 
            'max_day' => -61, 
            'isdual' => true,
            'user_id'  => $id,
            'dayis' => 90
        ];
    
        $this->single_invoice($whereConditionArray);



        $whereConditionArray = [
            'min_day' => -3000, 
            'max_day' => -91, 
            'isdual' => true,
            'user_id'  => $id,
            'dayis' => 91
        ];
    
        $this->single_invoice($whereConditionArray);

        $invoices = $this->customer_invs;

                        return view('reporting.receivables.ajax.aged', compact('invoices', 'id'));
    }
  
    public function unprecented_invoices(Request $request) {
        $invs =  explode(',', $request->getinvs);
        $receivables_status = request()->get('receivables_status') ? request()->get('receivables_status') : 'default';

        $invoices = DB::table('invoices')
                    ->select('invoices.invoiceId', 
                    'invoices.invoiceSoId', 
                    'invoices.invoiceChargeAmount', 
                    'invoiceCreditCardCharges', 
                    'invoices.invoiceSoSerial', 
                    'invoices.invoiceDueDate', 
                    'invoices.invoiceStatusType',
                    'invoices.invoiceShippingCharges', 
                    'invoices.invoiceCreditCardCharges',
                    'invoices.invoiceTaxValue',
                    'invoices.isCancel',
                    'invoices.invoiceType',
                    DB::raw('SUM(invoice_items.invoiceItemQuantity*invoice_items.invoiceItemUnitCost) as total'))
                    ->join('invoice_items', 'invoice_items.invoiceItemInvoiceId', '=', 'invoices.invoiceId')
                    ->whereIn('invoices.invoiceId', $invs)
                    ->where('invoices.invoiceStatusType', $receivables_status)
                    ->groupBy('invoices.invoiceId')
                        ->get();
    return view('reporting.receivables.ajax.unpresented', compact('invoices'));

    }


    public function aged_pdf() {
        echo '<h1>Working on PDF. will available in 2-3 days</h1>';
        die;
        $banks = Bank::where('bankCompanyId', 1)->get();

        $receivables_status = request()->get('receivables_status') ? request()->get('receivables_status') : 'default';

        $customers = array();

        $days_30 = DB::table('invoices')
        ->select('deals.dealUserId', 'users.userCompany', 'deals.dealCompanyId', 'deals.dealUserId',
        DB::raw('SUM(invoices.invoiceShippingCharges) as invoiceShippingCharges'),
        DB::raw('SUM(invoices.invoiceTaxValue) as invoiceTaxValue'),
        DB::raw('SUM(invoice_items.invoiceItemQuantity*invoice_items.invoiceItemUnitCost) as total'))
        ->join('deals', 'deals.dealSO', '=', 'invoices.invoiceSoId')
        ->join('invoice_items', 'invoice_items.invoiceItemInvoiceId', '=', 'invoices.invoiceId')
        ->join('users', 'users.userId', '=', 'deals.dealUserId')
        ->where('invoices.invoiceStatusType', $receivables_status)
        ->where('deals.dealCompanyId', auth()->user()->userCompanyId)
       // ->where('invoices.invoicePaid', 0)
        ->whereRaw('DATEDIFF(invoices.invoiceEndDateTime, CURDATE()) > -30')
        ->whereRaw('DATEDIFF(invoices.invoiceEndDateTime, CURDATE()) < 0') ->groupBy('deals.dealUserId')
            ->get();

            foreach($days_30 as $day_30){
            $dealUserId = $day_30->dealUserId;
            $userCompany = $day_30->userCompany;
            $invoiceShippingCharges = $day_30->invoiceShippingCharges;
            $invoiceTaxValue = $day_30->invoiceTaxValue;
            $total = $day_30->total;
            $net_30 = $invoiceShippingCharges+$invoiceTaxValue+$total;

            $customers[$dealUserId] = ['dealUserId' => $dealUserId, 'userCompany' => $userCompany, 'net_30' => $net_30,
            'net_60' => 0,'net_90' => 0, 'over_90' => 0];
            }



            $days_60 = DB::table('invoices')
            ->select('deals.dealUserId', 'users.userCompany', 'deals.dealCompanyId', 'deals.dealUserId',
            DB::raw('SUM(invoices.invoiceShippingCharges) as invoiceShippingCharges'),
            DB::raw('SUM(invoices.invoiceTaxValue) as invoiceTaxValue'), DB::raw('SUM(invoiceItemQuantity) as
            qtyTotal'), DB::raw('SUM(invoice_items.invoiceItemQuantity*invoice_items.invoiceItemUnitCost) as total'))
            ->join('deals', 'deals.dealSO', '=', 'invoices.invoiceSoId')
            ->join('invoice_items', 'invoice_items.invoiceItemInvoiceId', '=', 'invoices.invoiceId')
            ->join('users', 'users.userId', '=', 'deals.dealUserId')
            ->where('invoices.invoiceStatusType', $receivables_status)
            ->where('deals.dealCompanyId', auth()->user()->userCompanyId)
           // ->where('invoices.invoicePaid', 0)
            ->whereRaw('DATEDIFF(invoices.invoiceEndDateTime, CURDATE()) > -60')
            ->whereRaw('DATEDIFF(invoices.invoiceEndDateTime, CURDATE()) < -31') ->groupBy('deals.dealUserId')
                ->get();


                foreach($days_60 as $day_60){
                $dealUserId = $day_60->dealUserId;
                $userCompany = $day_60->userCompany;
                $invoiceShippingCharges = $day_60->invoiceShippingCharges;
                $invoiceTaxValue = $day_60->invoiceTaxValue;
                $total = $day_60->total;
                $net_60 = $invoiceShippingCharges+$invoiceTaxValue+$total;

                if (array_key_exists($dealUserId, $customers))
                {
                $customers[$dealUserId]['net_60'] = $net_60;
                }
                else
                {
                $customers[$dealUserId] = ['dealUserId' => $dealUserId, 'userCompany' => $userCompany, 'net_30' => 0,
                'net_60' =>
                $net_60, 'net_90' => 0, 'over_90' => 0];

                }
                }


                $days_90 = DB::table('invoices')
                ->select('invoiceId', 'users.userCompany', 'deals.dealCompanyId', 'deals.dealUserId',
                DB::raw('SUM(invoices.invoiceShippingCharges) as invoiceShippingCharges'),
                DB::raw('SUM(invoices.invoiceTaxValue) as invoiceTaxValue'), DB::raw('SUM(invoiceItemQuantity) as
                qtyTotal'), DB::raw('SUM(invoice_items.invoiceItemQuantity*invoice_items.invoiceItemUnitCost) as
                total'))
                ->join('deals', 'deals.dealSO', '=', 'invoices.invoiceSoId')
                ->join('invoice_items', 'invoice_items.invoiceItemInvoiceId', '=', 'invoices.invoiceId')
                ->join('users', 'users.userId', '=', 'deals.dealUserId')
                ->where('invoices.invoiceStatusType', $receivables_status)
                ->where('deals.dealCompanyId', auth()->user()->userCompanyId)
              // ->where('invoices.invoicePaid', 0)
                ->whereRaw('DATEDIFF(invoices.invoiceEndDateTime, CURDATE()) > -90')
                ->whereRaw('DATEDIFF(invoices.invoiceEndDateTime, CURDATE()) < -61') ->groupBy('deals.dealUserId')
                    ->get();

                    foreach($days_90 as $day_90){
                    $dealUserId = $day_90->dealUserId;
                    $userCompany = $day_90->userCompany;
                    $invoiceShippingCharges = $day_90->invoiceShippingCharges;
                    $invoiceTaxValue = $day_90->invoiceTaxValue;
                    $total = $day_90->total;
                    $net_90 = $invoiceShippingCharges+$invoiceTaxValue+$total;

                    if (array_key_exists($dealUserId, $customers))
                    {
                    $customers[$dealUserId]['net_90'] = $net_90;
                    }
                    else
                    {
                    $customers[$dealUserId] = ['dealUserId' => $dealUserId, 'userCompany' => $userCompany, 'net_30' =>
                    0, 'net_60' => 0, 'net_90' => $net_90, 'over_90' => 0];

                    }
                    }


                    $days_over_90 = DB::table('invoices')
                    ->select('invoiceId', 'users.userCompany', 'deals.dealCompanyId', 'deals.dealUserId',
                    DB::raw('SUM(invoices.invoiceShippingCharges) as invoiceShippingCharges'),
                    DB::raw('SUM(invoices.invoiceTaxValue) as invoiceTaxValue'), DB::raw('SUM(invoiceItemQuantity) as
                    qtyTotal'), DB::raw('SUM(invoice_items.invoiceItemQuantity*invoice_items.invoiceItemUnitCost) as
                    total'))
                    ->join('deals', 'deals.dealSO', '=', 'invoices.invoiceSoId')
                    ->join('invoice_items', 'invoice_items.invoiceItemInvoiceId', '=', 'invoices.invoiceId')
                    ->join('users', 'users.userId', '=', 'deals.dealUserId')
                    ->where('invoices.invoiceStatusType', $receivables_status)
                    ->where('deals.dealCompanyId', auth()->user()->userCompanyId)
                 //   ->where('invoices.invoicePaid', 0)
                    ->whereRaw('DATEDIFF(invoices.invoiceEndDateTime, CURDATE()) < -91') ->groupBy('deals.dealUserId')
                        ->get();

                        foreach($days_over_90 as $over_90){
                        $dealUserId = $over_90->dealUserId;
                        $userCompany = $over_90->userCompany;
                        $invoiceShippingCharges = $over_90->invoiceShippingCharges;
                        $invoiceTaxValue = $over_90->invoiceTaxValue;
                        $total = $over_90->total;
                        $over_90 = $invoiceShippingCharges+$invoiceTaxValue+$total;

                        if (array_key_exists($dealUserId, $customers))
                        {
                        $customers[$dealUserId]['over_90'] = $over_90;
                        }
                        else
                        {
                        $customers[$dealUserId] = ['dealUserId' => $dealUserId, 'userCompany' => $userCompany, 'net_30'
                        => 0, 'net_60' => 0, 'net_90' => 0, 'over_90' => $over_90];

                        }
                        }
                        $data['banks'] = $banks;
                        $data['customers'] = $customers;
                        $pdf = PDF::loadView('pdf.receivables-aged', $data);
                        return $pdf->stream();
                    
    }



    public function save_unpresented(Request $request){

        if($request->invTypePayment == 'Income'){
            echo '1 Day Work Remaining';
            print_r($request->all());
            die;
        }

        if($request->invTypechange == 'unpresented'){

        }else if($request->invTypechange == 'credit' && $request->getewayTypechange == 'bank'){
           $invids = $request->all();
           $this->save_credit_to_bank($invids);
        }else if($request->invTypechange == 'credit' && $request->getewayTypechange == 'paypal'){
     
            $invids = $request->all();
            $this->save_debit_to_paypal($invids);
         }


        
         $invoice = Invoice::whereIn('invoices.invoiceId', $request->invids)->update(['invoiceStatusType'=> $request->invTypechange]);

         if($invoice) {
            return response()->json([
                'type' => 'success',
                'msg' => 'Transaction Successful.',
            ]);
        } else {
            return response()->json([
                'type' => 'error',
                'msg' => 'There was an error. Please try again.',
            ]);
        }
       // return redirect()->back()->with('success','Transaction Successful.');;

}
public function save_credit_to_bank($all_data){
    


   $invoices = Invoice::whereIn('invoices.invoiceId', $all_data['invids'])->get();
   $bankEntry=[];
   $ttotalamount = $all_data['totalamount'];

    $reportBankDescription = '';
    $reportBankDate = '';
    $reportBankCredit = 0;
    $reportBankRefrence = '';
    $date = '';
   foreach($invoices as $invoice)
   {
   $invoiceId = $invoice->invoiceId;
       $date = date_create($all_data['unprecented_date']); 

        $reportBankDescription ='Payment from '.$invoice->invoiceBillingCompany;
        $reportBankCategory = 'INCOME';
        $reportBankDebit = 0.0;
        $reportBankCredit = $reportBankCredit+(double)$ttotalamount[$invoiceId];
        $reportBankRefrence .= '('.$invoice->invoiceSoId.'-'.$invoice->invoiceSoSerial.')';

       
   }
   $unprecented_ccText = '';
     $unprecented_cc = (double)$all_data['unprecented_cc'];


   $bank_entry = new ReportingBank();
   
   $bank_entry->reportBankDescription = $reportBankDescription;
   $bank_entry->reportBankCategory = 'INCOME';
   $bank_entry->reportBankDebit = (double)$reportBankDebit;
   $bank_entry->reportBankCredit = (double)$reportBankCredit;
   $bank_entry->reportBankAllocation = 'Receivable';
   $bank_entry->reportBankCharges = $unprecented_cc;
   $bank_entry->reportBankRefrence = 'Invoice # '. $reportBankRefrence;
   $bank_entry->reportBankDate = date_format($date,"Y/m/d H:i:s");
   $bank_entry->reportBankYear = (int)date_format($date,"Y");
   $bank_entry->bank_entry = (int)$all_data['unprecented_bank'];
   $bank_entry->reportBankCompanyId = auth()->user()->userCompanyId;
   $bank_entry->reportBankCreatedUserId = auth()->user()->userId;
   $bank_entry->reportBankDetail = implode(",",$all_data['invids']);

   $bank_entry->save();
  return $bank_entry;


}


public function save_debit_to_paypal($all_data){
    

    
    $invoices = Invoice::whereIn('invoices.invoiceId', $all_data['invids'])->get();
    $bankEntry=[];
    $ttotalamount = $all_data['totalamount'];
    $getewayTypechange = $all_data['getewayTypechange'];
    
     $reportBankDescription = '';
     $reportBankDate = '';
     $reportBankDebit = 0;
     $reportBankRefrence = '';
     $date = '';
    foreach($invoices as $invoice)
    {
    $invoiceId = $invoice->invoiceId;
        $date = date_create($all_data['unprecented_date']); 
 
         $reportBankDescription ='Payment from '.$invoice->invoiceBillingCompany;
         $reportBankCategory = 'INCOME';
         $reportBankCredit = 0.0;
         $reportBankDebit = $reportBankDebit+(double)$ttotalamount[$invoiceId];
         $reportBankRefrence .= '('.$invoice->invoiceSoId.'-'.$invoice->invoiceSoSerial.')';
 
        
    }

    $unprecented_ccText = '';
    $unprecented_cc = (double)$all_data['unprecented_cc'];
 
    $minsone = -1;
    $totalminus =  (double)$unprecented_cc*$minsone;
   
   $card = new ReportingPaypal();
    
   $card->paypalPaymentDescription = $reportBankDescription;
   $card->paypalPaymentGateway = $getewayTypechange;
   $card->paypalPaymentCategory = 'INCOME';
   $card->paypalPaymentCharges =  $totalminus;
   $card->paypalTotalCharges = (double)$reportBankDebit;
   $card->paypalPaymentDebit = (double)$reportBankDebit-(double)$unprecented_cc;
   $card->paypalPaymentCredit = $reportBankCredit;
   $card->paypalPaymentAllocation = 'Receivable';
   $card->paypalPaymentReference =  'Invoice # '. $reportBankRefrence.''.$unprecented_ccText;
   $card->paypalPaymentDate = date_format($date,"Y/m/d H:i:s");
   $card->paypalPaymentCardId = (int)$all_data['unprecented_bank'];
   $card->paypalPaymentCompanyId = auth()->user()->userCompanyId;
   $card->paypalPaymentUserId = auth()->user()->userId;
   $card->paypalPaymentDetail = implode(",",$all_data['invids']);
   $card->save();

  return $card;
 
 
 }
 

public function aged_pdf_single($id) {
   
    echo '<h1>Working on PDF. will available in 2-3 days</h1>';
    die;
    $receivables_status = request()->get('receivables_status') ? request()->get('receivables_status') : 'default';




    $receivables_status = request()->get('receivables_status') ? request()->get('receivables_status') : 'default';

    $customers = array();

    $days_30 = DB::table('invoices')
    ->select('deals.dealUserId', 'users.userCompany', 'deals.dealCompanyId', 'deals.dealUserId',
    DB::raw('SUM(invoices.invoiceShippingCharges) as invoiceShippingCharges'),
    DB::raw('SUM(invoices.invoiceTaxValue) as invoiceTaxValue'),
    DB::raw('SUM(invoice_items.invoiceItemQuantity*invoice_items.invoiceItemUnitCost) as total'))
    ->join('deals', 'deals.dealSO', '=', 'invoices.invoiceSoId')
    ->join('invoice_items', 'invoice_items.invoiceItemInvoiceId', '=', 'invoices.invoiceId')
    ->join('users', 'users.userId', '=', 'deals.dealUserId')
    ->where('invoices.invoiceStatusType', $receivables_status)
    ->where('deals.dealCompanyId', auth()->user()->userCompanyId)
   // ->where('invoices.invoicePaid', 0)
    ->where('deals.dealUserId', $id)
    ->whereRaw('DATEDIFF(invoices.invoiceEndDateTime, CURDATE()) > -30')
    ->whereRaw('DATEDIFF(invoices.invoiceEndDateTime, CURDATE()) < 0') ->groupBy('deals.dealUserId')
        ->get();

        foreach($days_30 as $day_30){
        $dealUserId = $day_30->dealUserId;
        $userCompany = $day_30->userCompany;
        $invoiceShippingCharges = $day_30->invoiceShippingCharges;
        $invoiceTaxValue = $day_30->invoiceTaxValue;
        $total = $day_30->total;
        $net_30 = $invoiceShippingCharges+$invoiceTaxValue+$total;

        $customers[$dealUserId] = ['dealUserId' => $dealUserId, 'userCompany' => $userCompany, 'net_30' => $net_30,
        'net_60' => 0,'net_90' => 0, 'over_90' => 0];
        }



        $days_60 = DB::table('invoices')
        ->select('deals.dealUserId', 'users.userCompany', 'deals.dealCompanyId', 'deals.dealUserId',
        DB::raw('SUM(invoices.invoiceShippingCharges) as invoiceShippingCharges'),
        DB::raw('SUM(invoices.invoiceTaxValue) as invoiceTaxValue'), DB::raw('SUM(invoiceItemQuantity) as
        qtyTotal'), DB::raw('SUM(invoice_items.invoiceItemQuantity*invoice_items.invoiceItemUnitCost) as total'))
        ->join('deals', 'deals.dealSO', '=', 'invoices.invoiceSoId')
        ->join('invoice_items', 'invoice_items.invoiceItemInvoiceId', '=', 'invoices.invoiceId')
        ->join('users', 'users.userId', '=', 'deals.dealUserId')
        ->where('invoices.invoiceStatusType', $receivables_status)
        ->where('deals.dealCompanyId', auth()->user()->userCompanyId)
       // ->where('invoices.invoicePaid', 0)
        ->where('deals.dealUserId', $id)
        ->whereRaw('DATEDIFF(invoices.invoiceEndDateTime, CURDATE()) > -60')
        ->whereRaw('DATEDIFF(invoices.invoiceEndDateTime, CURDATE()) < -31') ->groupBy('deals.dealUserId')
            ->get();


            foreach($days_60 as $day_60){
            $dealUserId = $day_60->dealUserId;
            $userCompany = $day_60->userCompany;
            $invoiceShippingCharges = $day_60->invoiceShippingCharges;
            $invoiceTaxValue = $day_60->invoiceTaxValue;
            $total = $day_60->total;
            $net_60 = $invoiceShippingCharges+$invoiceTaxValue+$total;

            if (array_key_exists($dealUserId, $customers))
            {
            $customers[$dealUserId]['net_60'] = $net_60;
            }
            else
            {
            $customers[$dealUserId] = ['dealUserId' => $dealUserId, 'userCompany' => $userCompany, 'net_30' => 0,
            'net_60' =>
            $net_60, 'net_90' => 0, 'over_90' => 0];

            }
            }


            $days_90 = DB::table('invoices')
            ->select('invoiceId', 'users.userCompany', 'deals.dealCompanyId', 'deals.dealUserId',
            DB::raw('SUM(invoices.invoiceShippingCharges) as invoiceShippingCharges'),
            DB::raw('SUM(invoices.invoiceTaxValue) as invoiceTaxValue'), DB::raw('SUM(invoiceItemQuantity) as
            qtyTotal'), DB::raw('SUM(invoice_items.invoiceItemQuantity*invoice_items.invoiceItemUnitCost) as
            total'))
            ->join('deals', 'deals.dealSO', '=', 'invoices.invoiceSoId')
            ->join('invoice_items', 'invoice_items.invoiceItemInvoiceId', '=', 'invoices.invoiceId')
            ->join('users', 'users.userId', '=', 'deals.dealUserId')
            ->where('invoices.invoiceStatusType', $receivables_status)
            ->where('deals.dealCompanyId', auth()->user()->userCompanyId)
           // ->where('invoices.invoicePaid', 0)
            ->where('deals.dealUserId', $id)
            ->whereRaw('DATEDIFF(invoices.invoiceEndDateTime, CURDATE()) > -90')
            ->whereRaw('DATEDIFF(invoices.invoiceEndDateTime, CURDATE()) < -61') ->groupBy('deals.dealUserId')
                ->get();

                foreach($days_90 as $day_90){
                $dealUserId = $day_90->dealUserId;
                $userCompany = $day_90->userCompany;
                $invoiceShippingCharges = $day_90->invoiceShippingCharges;
                $invoiceTaxValue = $day_90->invoiceTaxValue;
                $total = $day_90->total;
                $net_90 = $invoiceShippingCharges+$invoiceTaxValue+$total;

                if (array_key_exists($dealUserId, $customers))
                {
                $customers[$dealUserId]['net_90'] = $net_90;
                }
                else
                {
                $customers[$dealUserId] = ['dealUserId' => $dealUserId, 'userCompany' => $userCompany, 'net_30' =>
                0, 'net_60' => 0, 'net_90' => $net_90, 'over_90' => 0];

                }
                }


                $days_over_90 = DB::table('invoices')
                ->select('invoiceId', 'users.userCompany', 'deals.dealCompanyId', 'deals.dealUserId',
                DB::raw('SUM(invoices.invoiceShippingCharges) as invoiceShippingCharges'),
                DB::raw('SUM(invoices.invoiceTaxValue) as invoiceTaxValue'), DB::raw('SUM(invoiceItemQuantity) as
                qtyTotal'), DB::raw('SUM(invoice_items.invoiceItemQuantity*invoice_items.invoiceItemUnitCost) as
                total'))
                ->join('deals', 'deals.dealSO', '=', 'invoices.invoiceSoId')
                ->join('invoice_items', 'invoice_items.invoiceItemInvoiceId', '=', 'invoices.invoiceId')
                ->join('users', 'users.userId', '=', 'deals.dealUserId')
                ->where('invoices.invoiceStatusType', $receivables_status)
                ->where('deals.dealCompanyId', auth()->user()->userCompanyId)
               // ->where('invoices.invoicePaid', 0)
                ->where('deals.dealUserId', $id)
                ->whereRaw('DATEDIFF(invoices.invoiceEndDateTime, CURDATE()) < -91') ->groupBy('deals.dealUserId')
                    ->get();

                    foreach($days_over_90 as $over_90){
                    $dealUserId = $over_90->dealUserId;
                    $userCompany = $over_90->userCompany;
                    $invoiceShippingCharges = $over_90->invoiceShippingCharges;
                    $invoiceTaxValue = $over_90->invoiceTaxValue;
                    $total = $over_90->total;
                    $over_90 = $invoiceShippingCharges+$invoiceTaxValue+$total;

                    if (array_key_exists($dealUserId, $customers))
                    {
                    $customers[$dealUserId]['over_90'] = $over_90;
                    }
                    else
                    {
                    $customers[$dealUserId] = ['dealUserId' => $dealUserId, 'userCompany' => $userCompany, 'net_30'
                    => 0, 'net_60' => 0, 'net_90' => 0, 'over_90' => $over_90];

                    }
                    }
                  
                    $data['customer'] = $customers[$id];
    
                    $data['id'] = $id;
                    $pdf = PDF::loadView('pdf.receivables-caged', $data);
                    return $pdf->stream();
                
}

public function customer_invoices($slug){

    $id = hex2bin($slug);
    $customer = Customer::where('userId', $id)->first();

    $invoices = DB::table('invoices')
    ->select('invoiceId', 
            'invoices.invoiceSoId', 
            'invoices.invoiceChargeAmount',  
            'invoices.invoiceSoSerial', 
            'invoices.invoiceDueDate', 
            'invoices.invoiceStatusType', 
            'deals.dealCompanyId', 
            'deals.dealUserId', 
            'invoices.invoiceShippingCharges', 
            'invoices.invoiceCreditCardCharges',
            'invoices.invoiceTaxValue',
            'invoices.invoiceType',
            DB::raw('SUM(invoiceItemQuantity) as qtyTotal'), 
            DB::raw('SUM(invoice_items.invoiceItemQuantity*invoice_items.invoiceItemUnitCost) as
                    total'))
    ->join('deals', 'deals.dealSO', '=', 'invoices.invoiceSoId')
    ->join('invoice_items', 'invoice_items.invoiceItemInvoiceId', '=', 'invoices.invoiceId')
    ->where('deals.dealCompanyId', auth()->user()->userCompanyId)
   // ->where('invoices.invoicePaid', 0)
    ->where('deals.dealUserId', $id)
    ->groupBy('invoices.invoiceId')
    ->paginate(30);
    return view('reporting.receivables.invoices', compact('customer','invoices'));

}


public function test_aged(){
           $receivables_status = request()->get('receivables_status') ? request()->get('receivables_status') : 'default';



         $totalItems = DB::table('invoices')
        ->select('deals.dealUserId', DB::raw('SUM(invoice_items.invoiceItemQuantity*invoice_items.invoiceItemUnitCost) as total'))
        ->join('deals', 'deals.dealSO', '=', 'invoices.invoiceSoId')
        ->join('invoice_items', 'invoice_items.invoiceItemInvoiceId', '=', 'invoices.invoiceId')
        ->where('deals.dealCompanyId', auth()->user()->userCompanyId)
       // ->where('invoices.invoicePaid', 0)
        ->where('invoices.invoiceStatusType', $receivables_status)
        ->whereRaw('DATEDIFF(invoices.invoiceEndDateTime, CURDATE()) > '.$whereConditionArray['min_day'])
         ->whereRaw('DATEDIFF(invoices.invoiceEndDateTime, CURDATE()) < '.$whereConditionArray['max_day']) 
        ->groupBy('deals.dealUserId')
        ->limit(700)
            ->get();

            $getTotal = [];

            foreach($totalItems as $tot){
                $dealUserId = $tot->dealUserId;
                $total = $tot->total;
                $getTotal[$dealUserId] = $total;

            }


        $days = DB::table('invoices')
        ->select('deals.dealUserId', 'users.userCompany', 'deals.dealCompanyId',
        DB::raw('SUM(invoices.invoiceShippingCharges) as invoiceShippingCharges'),
        DB::raw('SUM(invoices.invoiceTaxValue) as invoiceTaxValue'),
        DB::raw('SUM(invoices.invoiceCreditCardCharges) as invoiceCreditCardCharges'),
        DB::raw('SUM(invoices.invoiceChargeAmount) as invoiceChargeAmount'))
//        DB::raw('SUM(invoice_items.invoiceItemQuantity*invoice_items.invoiceItemUnitCost) as total'))
        ->join('deals', 'deals.dealSO', '=', 'invoices.invoiceSoId')
       // ->join('invoice_items', 'invoice_items.invoiceItemInvoiceId', '=', 'invoices.invoiceId')
        ->join('users', 'users.userId', '=', 'deals.dealUserId')
        ->where('deals.dealCompanyId', auth()->user()->userCompanyId)
        //->where('invoices.invoicePaid', 0)
        ->where('dealUserId', 2112)
        ->where('invoices.invoiceStatusType', $receivables_status)
         ->whereRaw('DATEDIFF(invoices.invoiceEndDateTime, CURDATE()) > '.$whereConditionArray['min_day'])
         ->whereRaw('DATEDIFF(invoices.invoiceEndDateTime, CURDATE()) < '.$whereConditionArray['max_day']) 
        ->groupBy('deals.dealUserId')
        ->limit(700)
            ->get();

//original
        // $days = DB::table('invoices')
        // ->select('deals.dealUserId', 'users.userCompany', 'deals.dealCompanyId', 'deals.dealUserId',
        // DB::raw('SUM(invoices.invoiceShippingCharges) as invoiceShippingCharges'),
        // DB::raw('SUM(invoices.invoiceTaxValue) as invoiceTaxValue'),
        // DB::raw('SUM(invoices.invoiceCreditCardCharges) as invoiceCreditCardCharges'),
        // DB::raw('SUM(invoices.invoiceChargeAmount) as invoiceChargeAmount'),
        // DB::raw('SUM(invoice_items.invoiceItemQuantity*invoice_items.invoiceItemUnitCost) as total'))
        // ->join('deals', 'deals.dealSO', '=', 'invoices.invoiceSoId')
        // ->join('invoice_items', 'invoice_items.invoiceItemInvoiceId', '=', 'invoices.invoiceId')
        // ->join('users', 'users.userId', '=', 'deals.dealUserId')
        // ->where('deals.dealCompanyId', auth()->user()->userCompanyId)
        // ->where('invoices.invoicePaid', 0)
        // ->where('invoices.invoiceStatusType', $receivables_status)
        // ->whereRaw('DATEDIFF(invoices.invoiceEndDateTime, CURDATE()) > '.$whereConditionArray['min_day'])
        // ->whereRaw('DATEDIFF(invoices.invoiceEndDateTime, CURDATE()) < '.$whereConditionArray['max_day']) 
        // ->groupBy('deals.dealUserId')
        //     ->get();


            dd($days);
}

}
