<?php

namespace App\Http\Controllers;

use App\Models\Deal;
use App\Models\DealItem;
use App\Models\ReturnOrder;
use App\Models\ReturnItem;
use Illuminate\Http\Request;


class ReturnController extends Controller {
    /**
    * Create a new controller instance.
    *
    * @return void
    */

    public function __construct() {
        $this->middleware('auth');
    }

    public function index()
    {
        

    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create($slug)
    {
        
        $order = Deal::where( 'dealSO', '=', hex2bin($slug) )->with( 'company' )->first();
        $dealItems = DealItem::where(['dealItemDealId' => $order->dealId, 'dealItemIsActive' => true])->get();
        $invoiceSoSerial = 1;
        $invoiceExists = ReturnOrder::where( 'returnSoId', '=', hex2bin($slug) )->exists();
        
       
               if($invoiceExists)
            {
                $invoice = ReturnOrder::where( 'returnSoId', '=', hex2bin($slug) )->orderBy('ireturnSoSerial', 'DESC')->limit(1)->get();
                $invoice = $invoice[0];
                $invoiceSoSerial = $invoice->invoiceSoSerial+1;
            }
           
            

         $invoiceItems = ReturnItem::select('returnItemItemId', 'returnItemQuantity')->where('returnSoId', hex2bin($slug))->get();
        $existingItems = array();
        foreach($invoiceItems as $item){
            $itemId = $item->invoiceItemItemId;
            if (array_key_exists($itemId, $existingItems))
            {
             
                $existingItems[$itemId] = $existingItems[$itemId]+$item->invoiceItemQuantity;
            }
            else
            {
                $existingItems[$itemId] = $item->invoiceItemQuantity;
            
            }


           
          
        }

       
        return view( 'orders.returns.create', compact( 'order' , 'dealItems', 'invoiceSoSerial', 'existingItems') );
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request, $soid)
    {

       

        $order = Deal::select('dealId', 'dealUserId')->where( 'dealSO', '=', hex2bin($soid) )->first();
        $request->validate( [
            
            'invoiceReference' => 'required',
                   'invoicePaymentMethod' => 'required',
                   'invoiceBillingCompany' => 'required',
                    'invoiceBillingContact' => 'required',
                    'invoiceBillingAddress' => 'required',
                    'invoiceBillingCity' => 'required',
                    'invoiceBillingState' => 'required',
                    'invoiceBillingZip' => 'required',
                    'invoiceBillingPhone' => 'required',
                    'invoiceBillingEmail' => 'required',
                    'invoiceShippingCompany' => 'required',
                    'invoiceShippingContact' => 'required',
                    'invoiceShippingAddress' => 'required',
                    'invoiceShippingCity' => 'required',
                    'invoiceShippingState' => 'required',
                    'invoiceShippingZip' => 'required',
                    'invoiceShippingPhone' => 'required',
                    'invoiceShippingEmail' => 'required',
                    'invoiceShippingType' => 'required',
                    'invoiceShippingCharges' => 'required',
                    'invoiceTaxName' => 'required',
                    'invoiceTaxValue' => 'required',
                    'invoiceDueDate' => 'required',
                    'invoiceEndDateTime' => 'required',
                    'invoiceTracking' => 'required',
                    'invoiceSerial' => 'required',
                    'invoiceSoSerial' => 'required',
                  
        ]);
        
        $invoiceSoSerial =$request->invoiceSoSerial;
        $invoiceTaxName =$request->invoiceTaxName;
        $invoiceTaxValue =$request->invoiceTaxValue;
          
        $invoiceShippingType =$request->invoiceShippingType;
        $invoiceShippingCharges =$request->invoiceShippingCharges;

        $invoiceDealId = $order->dealId;
        $invoiceUserId = $order->dealUserId;
        $invoiceSoId = hex2bin($soid);

            
           $createData = array(
                   'invoiceReference' => $request->invoiceReference,
                   'invoicePaymentMethod' => $request->invoicePaymentMethod,
                   'invoiceBillingCompany' => $request->invoiceBillingCompany,
                    'invoiceBillingContact' => $request->invoiceBillingContact,
                    'invoiceBillingAddress' => $request->invoiceBillingAddress,
                    'invoiceBillingCity' => $request->invoiceBillingCity,
                    'invoiceBillingState' => $request->invoiceBillingState,
                    'invoiceBillingZip' => $request->invoiceBillingZip,
                    'invoiceBillingPhone' => $request->invoiceBillingPhone,
                    'invoiceBillingEmail' => $request->invoiceBillingEmail,
                    'invoiceShippingCompany' => $request->invoiceShippingCompany,
                    'invoiceShippingContact' => $request->invoiceShippingContact,
                    'invoiceShippingAddress' => $request->invoiceShippingAddress,
                    'invoiceShippingCity' => $request->invoiceShippingCity,
                    'invoiceShippingState' => $request->invoiceShippingState,
                    'invoiceShippingZip' => $request->invoiceShippingZip,
                    'invoiceShippingPhone' => $request->invoiceShippingPhone,
                    'invoiceShippingEmail' => $request->invoiceShippingEmail,
                    'invoiceShippingType' => $invoiceShippingType,
                    'invoiceShippingCharges' => $invoiceShippingCharges,
                    'invoiceTaxName' => $invoiceTaxName,
                    'invoiceTaxValue' => $invoiceTaxValue,
                    'invoiceDueDate' => $request->invoiceDueDate,
                    'invoiceEndDateTime' => $request->invoiceEndDateTime,
                    'invoiceTracking' => $request->invoiceTracking,
                    'invoiceSerial' => $request->invoiceSerial,
                    'invoiceSoSerial' => $invoiceSoSerial,
                    'invoiceDealId' => $invoiceDealId,
                    'invoiceUserId' =>  $invoiceUserId,
                    'invoiceSoId' => $invoiceSoId,
                    'invoiceCreatedUserId' => auth()->user()->userId
                    
                     );
                     
                    $inv = Invoice::insertGetId($createData);
                   
                    $invoiceItemName = $request->invoiceItemName;
                    $invoiceItemDescription = $request->invoiceItemDescription;
                    $invoiceItemQuantity = $request->invoiceItemQuantity;
                    $invoiceItemUnitCost = $request->invoiceItemUnitCost;

                    foreach($request->invoiceItemItemId as $ke => $invoiceItem){

                    $createItemData = array(
                        'invoiceItemInvoiceId' => $inv,
                        'invoiceItemItemId' => $invoiceItem,
                        'invoiceItemName' => $invoiceItemName[$ke],
                         'invoiceItemDescription' => $invoiceItemDescription[$ke],
                         'invoiceSoId' => $invoiceSoId,
                         'invoiceItemQuantity' => $invoiceItemQuantity[$ke],
                         'invoiceItemUnitCost' => $invoiceItemUnitCost[$ke],
                         'invoiceItemCreatedUserId' => auth()->user()->userId
                      
                         
                          );
                          
                        InvoiceItem::insert($createItemData);

                         }

                         return redirect()->back()->with( 'success', 'Invoice Saved Successfully.' );

    }

    /**
     * Display the specified resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function show($slug)
    {   

   
    }

    
    public function edit($slug)
    {
        
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $slug)
    {
 
    }

    /**
     * Remove the specified resource from storage.
     *
   
     * @return \Illuminate\Http\Response
     */
    public function destroy(Request $request)
    {
        //
    }

  
}
