<?php

namespace App\Http\Controllers;

use App\Models\Permission;
use App\Models\Role;
use Illuminate\Http\Request;

class RoleController extends Controller
{
    public function index() {
        $roles = Role::paginate( 10 );
        //  dd( $vendors );
        return view( 'roles.index', compact( 'roles' ) );
    }

    public function create() {
        // $states = State::orderBy( 'stateName' )->get();
        return view( 'roles.create');
    }

    public function store( Request $request ) {

        $slug = str_replace(" ", "-", strtolower($request->name));

        $role = new Role();
		$role->slug = $slug;
		$role->name = $request->name;
		$role->save();


        if ( $role ) {
            return redirect()->back()->with( 'success', 'Role Saved Successfully.' );

        } else {
            return Redirect::back()->withErrors( [ 'msg' => 'There was some problem.' ] );
        }

    }

    public function edit( $id ) {
        $role = Role::find( $id );
        return view( 'roles.edit', compact( 'role' ) );
    }

    public function update( Request $request, $id ) {
        // dd( $request->all() );
        // Find the Permission
        $role = Role::find( $id );
        $slug = str_replace(" ", "-", strtolower($request->name));
        // Updating the Permission
        $role->update( [
            'name' => $request->name,
            'slug' => $slug,
        ] );

        // confirm message
        $request->session()->flash( 'msg', 'Role has been updated' );

        // Redirect
        return redirect()->route( 'role.index' );

    }

    public function rolePermissions ( $id ) {
        $role = Role::find( $id );
        $permissions = Permission::get();
        return view( 'roles.permissions', compact( 'role' , 'permissions') );
    }

}
