<?php
namespace App\Http\Controllers\Auth;
namespace App\Http\Controllers;


use Illuminate\Http\Request;
use App\Models\User;
use App\Models\Company;
use Auth;
use Session;
use DB;
class StatisticsController extends Controller
{

    public $payablestats = [];
    public $receivablesstats = [];
    
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Contracts\Support\Renderable
     */


    
  protected function payable_record($whereConditionArray){

    
    $payables_status =  'default';


    $days = DB::table('payables')
    ->select(
    DB::raw('SUM(payables.payableProductCost) as payableProductCost'),
    DB::raw('SUM(payables.payableFrieght) as payableFrieght'),
    DB::raw('SUM(payables.payableTax) as payableTax'),
    DB::raw('SUM(payables.payableECW) as payableECW'),
    'payables.payableCompanyId', 
    'payables.payableVendorId')
    ->where('payables.payableCompanyId', auth()->user()->userCompanyId)
    ->where('payables.payableIsDeleted', 0)
    ->where('payables.proceedType', $payables_status)
    ->whereRaw('DATEDIFF(payables.payableInvoiceDate, CURDATE()) >= '.$whereConditionArray['min_day'])
    ->whereRaw('DATEDIFF(payables.payableInvoiceDate, CURDATE()) <= '.$whereConditionArray['max_day'])
    ->get();
       
        foreach($days as $day){
          
            
            $payableFrieght = (double)$day->payableFrieght;
            $payableTax = (double)$day->payableTax;
            $payableECW = (double)$day->payableECW;
            $payableProductCost = (double)$day->payableProductCost;
            $netvalue = $payableFrieght+$payableTax+$payableProductCost+$payableECW;
            
            // if (!array_key_exists($payableVendorId, $this->vendors))
            // {
            // $this->vendors[$payableVendorId] = ['net_30' => 0,
            // 'net_60' =>  0, 'net_90' => 0, 'net_120' => 0, 'over_120' => 0];
            // }
      
            switch ($whereConditionArray['dayis']) {
                case 30:
                        $this->payablestats['net_30'] = $netvalue;
                  break;
                case 60:
                        $this->payablestats['net_60'] = $netvalue;
                  break;
                case 90:
                  $this->payablestats['net_90'] = $netvalue;
                  break;
                  case 120:
                    $this->payablestats['net_120'] = $netvalue;
                  break;
                  case 121:
                        $this->payablestats['over_120'] = $netvalue;
                  break;
                default:
                  echo "-";
              }
            
            }


  }

  public function dashboard_payables() {
 

    $payables_status = 'default';

  

    $whereConditionArray = [
        'min_day' => -30, 
        'max_day' => 3, 
        'isdual' => true,
        'dayis' => 30
    ];

    $this->payable_record($whereConditionArray);

  


    $whereConditionArray = [
        'min_day' => -60, 
        'max_day' => -31, 
        'isdual' => true,
        'dayis' => 60
    ];

     $this->payable_record($whereConditionArray);

            $whereConditionArray = [
                'min_day' => -90, 
                'max_day' => -61, 
                'isdual' => true,
                'dayis' => 90
            ];
        
    $this->payable_record($whereConditionArray);

    $whereConditionArray = [
                    'min_day' => -120, 
                    'max_day' => -91, 
                    'isdual' => true,
                    'dayis' => 120
                ];
            
   $this->payable_record($whereConditionArray);

                $whereConditionArray = [
                    'min_day' => -3000, 
                    'max_day' => -121, 
                    'isdual' => true,
                    'dayis' => 121
                ];
            
        $this->payable_record($whereConditionArray);
        $payablestats = $this->payablestats;
        return view('statistics.payable', compact('payablestats'));
}



protected function single_invoice($whereConditionArray){
        
    $receivables_status = 'default';

    $invoices = array();

    $days = DB::table('invoices')
    ->select('invoiceShippingCharges', 'invoiceTaxValue','invoiceChargeAmount','invoiceCreditCardCharges',
    DB::raw('SUM(invoice_items.invoiceItemQuantity*invoice_items.invoiceItemUnitCost) as total'))
    ->join('invoice_items', 'invoice_items.invoiceItemInvoiceId', '=', 'invoices.invoiceId')
    ->join('deals', 'deals.dealSO', '=', 'invoices.invoiceSoId')
    ->where('invoices.invoiceStatusType', $receivables_status)
    ->where('deals.dealRevised', 0)

    ->where('deals.dealCompanyId', auth()->user()->userCompanyId)
    ->whereRaw('DATEDIFF(invoices.invoiceEndDateTime, CURDATE()) > '.$whereConditionArray['min_day'])
    ->whereRaw('DATEDIFF(invoices.invoiceEndDateTime, CURDATE()) < '.$whereConditionArray['max_day'])
    ->get();

    // $days = DB::table('invoices')
    // ->select('invoiceShippingCharges', 'invoiceTaxValue','invoiceChargeAmount','invoiceCreditCardCharges',
    //          DB::raw('(SELECT SUM(invoiceItemQuantity*invoiceItemUnitCost) FROM invoice_items 
    //                    WHERE invoiceItemInvoiceId = invoices.invoiceId) as total'))
    // ->where('invoices.invoiceStatusType', $receivables_status)
    // ->where('invoices.invoiceCompanyId', auth()->user()->userCompanyId)
    // ->whereRaw('DATEDIFF(invoices.invoiceEndDateTime, CURDATE()) > '.$whereConditionArray['min_day'])
    // ->whereRaw('DATEDIFF(invoices.invoiceEndDateTime, CURDATE()) < '.$whereConditionArray['max_day'])
    // ->get();

            foreach($days as $day){

               
                $invoiceShippingCharges = (double)$day->invoiceShippingCharges;
                $invoiceTaxValue = (double)$day->invoiceTaxValue;
                $invoiceChargeAmount = (double)$day->invoiceChargeAmount;
                $invoiceCreditCardCharges = (double)$day->invoiceCreditCardCharges;
                $total = (double)$day->total;
                $netvalue = $invoiceShippingCharges+$invoiceChargeAmount+$invoiceCreditCardCharges+$invoiceTaxValue+$total;
            
                

                switch ($whereConditionArray['dayis']) {
                    case 30:
                            $this->receivablesstats['net_30'] = $netvalue;
                      break;
                    case 60:
                            $this->receivablesstats['net_60'] = $netvalue;
                      break;
                    case 90:
                            $this->receivablesstats['net_90'] = $netvalue;
                      break;
                      case 91:
                            $this->receivablesstats['over_90'] = $netvalue;
                      break;
                    default:
                      echo "-";
                  }

            }

            

}
    
    public function dashboard_receivables() {

     
        $receivables_status = 'default';


        $whereConditionArray = [
            'min_day' => -30, 
            'max_day' => 3, 
            'isdual' => true,
            'dayis' => 30
        ];
    
        $this->single_invoice($whereConditionArray);

        $whereConditionArray = [
            'min_day' => -60, 
            'max_day' => -31, 
            'isdual' => true,
            'dayis' => 60
        ];
    
        $this->single_invoice($whereConditionArray);

        $whereConditionArray = [
            'min_day' => -90, 
            'max_day' => -61, 
            'isdual' => true,
            'dayis' => 90
        ];
    
        $this->single_invoice($whereConditionArray);



        $whereConditionArray = [
            'min_day' => -3000, 
            'max_day' => -91, 
            'isdual' => true,
            'dayis' => 91
        ];
    
        $this->single_invoice($whereConditionArray);

        $receivablesstats = $this->receivablesstats;
        
        return view('statistics.receivables', compact('receivablesstats'));
   

    }

    
}
