<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Vendor;
use App\Models\State;
use Illuminate\Support\Facades\Hash;

class VendorController extends Controller {
    /**
    * Create a new controller instance.
    *
    * @return void
    */

    public function __construct() {
        $this->middleware( 'auth' );
    }

    /**
    * Show the application dashboard.
    *
    * @return \Illuminate\Contracts\Support\Renderable
    */

    public function index() {
        $vendors = Vendor::limit( 10 )
        ->get();
        //  dd( $vendors );
        return view( 'vendors.index', compact( 'vendors' ) );
    }

    public function create() {
        $states = State::orderBy( 'stateName' )->get();
        return view( 'vendors.create', compact( 'states' ) );
    }

    public function store( Request $request ) {
        $hashedPassword = Hash::make( '12345678' );
        // dd( $hashedPassword );

        $vendor = new Vendor();
        $vendor->vendorEmail = $request->vendorEmail;
        $vendor->vendorFirstName = $request->vendorFirstName;
        $vendor->vendorLastName = $request->vendorLastName;
        $vendor->vendorCompany = $request->vendorCompany;
        $vendor->vendorWebsite = $request->vendorWebsite;
        $vendor->vendorAddress = $request->vendorAddress;
        $vendor->vendorCity = $request->vendorCity;
        $vendor->vendorState = $request->vendorState;
        $vendor->vendorPostalCode = $request->vendorPostalCode;
        $vendor->vendorCountry = $request->vendorCountry;
        $vendor->vendorPhone = $request->vendorPhone;
        $vendor->vendorIsActive = true;
        $vendor->save();

        if ( $vendor ) {
            return redirect()->back()->with( 'success', 'Vendor Saved Successfully.' );

        } else {
            return Redirect::back()->withErrors( [ 'msg' => 'There was some problem.' ] );
        }

    }

    public function edit( $id ) {
        $vendor = Vendor::find( $id );
        $states = State::orderBy( 'stateName' )->get();
        return view( 'vendors.edit', compact( 'vendor', 'states' ) );
    }

    public function update( Request $request, $id ) {
        // dd( $request->all() );
        // Find the Customer
        $vendor = Vendor::find( $id );

        // Updating the Customer
        $vendor->update( [
            'vendorEmail' => $request->vendorEmail,
            'vendorFirstName' => $request->vendorFirstName,
            'vendorLastName' => $request->vendorLastName,
            'vendorCompany' => $request->vendorCompany,
            'vendorWebsite' => $request->vendorWebsite,
            'vendorAddress' => $request->vendorAddress,
            'vendorState' => $request->vendorState,
            'vendorPostalCode' => $request->vendorPostalCode,
            'vendorCity' => $request->vendorCity,
            'vendorCountry' => $request->vendorCountry,
            'vendorPhone' => $request->vendorPhone,
        ] );

        // confirm message
        $request->session()->flash( 'msg', 'Vendor has been updated' );

        // Redirect
        return redirect()->route( 'vendor.index' );

    }


}
