<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;

class UserTypeMiddleware
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure(\Illuminate\Http\Request): (\Illuminate\Http\Response|\Illuminate\Http\RedirectResponse)  $next
     * @return \Illuminate\Http\Response|\Illuminate\Http\RedirectResponse
     */
    public function handle(Request $request, Closure $next, ...$userTypes)
    {
        //return $next($request);
        $user = Auth::user();

        if (!$user) {
            return redirect('/login');
        }
    
        // Check if the user has one of the allowed userTypes
        if (in_array($user->userType, $userTypes)) {
            return $next($request);
        }
    
        abort(403, 'Unauthorized action.');
    }
}
