<?php

namespace App\Http\Requests;

use App\Http\Requests\Request;

class ActivityRequest extends Request
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'activityDealId' => 'required',
            'activityContactType' => 'required',
            'activityBody' => 'required',
            
            
        ];
    }

    /**
     * Get the error messages for the defined validation rules.
     *
     * @return array
     */
    public function messages()
    {
        return [
            'activityDealId.required' => 'Order is required',
            'activityContactType.required' => 'Type is required',
            'activityBody.required' => 'Text is required'
        ];
    }
}
