<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Company extends Model {

    protected $primaryKey = 'companyId';
    protected $table = 'company';
    protected $fillable = [
        'companyName',
        'companyLogo',
        'companyUrl',
        'companyAddress',
        'companyPhone',
        'companyPrefix',
        'companyColorCode',
        'companyCurrency',
        'companyInvoiceText',
        'companyCountryId',
        'companyBusinessType',
        'companyIsActive',
        'companyCreatedUserId',
        'companyModifiedUserId'
    ];

    public function users() {
        return $this->hasMany( 'App\Models\User', 'userId', 'companyId' );
    }

    public function country() {
        return $this->belongsTo( 'App\Models\Country', 'companyCountryId', 'countryId' );
    }

    // public function restorant() {
    //     return $this->belongsTo( 'App\Restorant' );
    // }

    public $timestamps = false;
}
