<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Customer extends Model {

    protected $primaryKey = 'userId';
    protected $table = 'users';
    protected $fillable = ['firstName', 'lastName', 'phone', 'email', 'userAddress', 'userCity', 'userState', 'userPostalCode', 'assign_limit'];

    public function company() {
        return $this->hasMany( 'App\Models\User', 'userId', 'companyId' );
    }

    public function receivables() {
        return $this->hasMany( 'App\Models\Receivable', 'userId', 'receivableCustomer' );
    }

    const CREATED_AT = 'userCreatedAt';
    const UPDATED_AT = 'userModifiedAt';
}
