<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Deal extends Model {

    protected $primaryKey = 'dealId';
    protected $table = 'deals';
    protected $guarded = [];

    public function saleorder() {
        return $this->belongsTo('App\Models\SalesOrder', 'dealSO', 'salesorderId');
    }

    public function created_users() {
        return $this->hasOne('App\Models\User', 'userId', 'dealCreatedUserId' );
    }
    public function modified_users() {
        return $this->hasOne( 'App\Models\User', 'userId', 'dealModifiedUserId' );
    }
    public function deal_users() {
        return $this->hasOne( 'App\Models\User', 'userId', 'dealUserId' );
    }
    public function company() {
        return $this->hasOne( 'App\Models\Company', 'companyId', 'dealCompanyId' );
    }

    public function customer() {
        return $this->hasOne( 'App\Models\User', 'userId', 'dealUserId' );
    }

    public function dealItems() {
        return $this->hasMany( 'App\Models\DealItem', 'dealItemDealId', 'dealId' );
    }

    public function attachments() {
        return $this->hasMany( 'App\Models\SaleAttachment', 'saleAttachmentDealId', 'dealId' );
    }


    public function invoices() {
        return $this->hasMany( 'App\Models\Invoice', 'invoiceSoId', 'dealSO' );
    }

    public function creditInvoices() {
        if((request()->get('onlysheet')) && (request()->get('onlysheet') > 0)){
            return $this->hasMany( 'App\Models\Invoice', 'invoiceSoId', 'dealSO' )
            ->where('invoiceDepartmentId', request()->get('onlysheet'));

        }
        return $this->hasMany( 'App\Models\Invoice', 'invoiceSoId', 'dealSO' );
    }


    public function defaultInvoices() {
        return $this->hasMany( 'App\Models\Invoice', 'invoiceSoId', 'dealSO' )->where('invoiceStatusType', 'default');
    }


    public function debitPayables() {
        return $this->hasMany( 'App\Models\Payable', 'payableSoId', 'dealSO' )->where('payableIsDeleted', 0);
    }

    public function paypal() {
        return $this->hasOne( 'App\Models\SalesorderPayment', 'salesorderPaymentSalesorderId', 'dealSO')->where('salesorderPaymentIsDeleted', 0);
    }


    


    public function defaultPayables() {
        return $this->hasMany( 'App\Models\Payable', 'payableSoId', 'dealSO' )->where(['proceedType' => 'default', 'payableIsDeleted' => 0]);
    }

    public function payables() {
        return $this->hasMany( 'App\Models\Payable', 'payableSoId', 'dealSO' )->where('payableIsDeleted', 0);
    }


    public function purchases() {
        return $this->hasMany( 'App\Models\Purchase', 'purchaseSoId', 'dealSO' );
    }

    const CREATED_AT = 'dealCreatedAt';
    const UPDATED_AT = 'dealModifiedAt';
}
