<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Expense extends Model {

    protected $primaryKey = 'expenseId';
    protected $table = 'expenses';
    protected $fillable = [];
    public function expenseItems() {
        return $this->hasMany( 'App\Models\ExpenseItem', 'expenseItemExpenseId', 'expenseId' );
    }

    public function hoa() {
        return $this->hasOne( 'App\Models\Hoav', 'hoavId', 'expenseHoaId' );
    }

    public function vendor() {
        return $this->hasOne( 'App\Models\Hoav', 'hoavId', 'expenseVendorId' );
    }
}
