<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Income extends Model {

    protected $primaryKey = 'incomeId';
    protected $table = 'incomes';
    protected $fillable = [];
    public function incomeItems() {
        return $this->hasMany( 'App\Models\IncomeItem', 'incomeItemIncomeId', 'incomeId' );
    }

    public function hoa() {
        return $this->hasOne( 'App\Models\Hoav', 'hoavId', 'incomeHoaId' );
    }

    public function vendor() {
        return $this->hasOne( 'App\Models\Hoav', 'hoavId', 'incomeVendorId' );
    }
}
