<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use DB;
class Invoice extends Model {

    protected $primaryKey = 'invoiceId';
    protected $table = 'invoices';
    protected $fillable = [];

    // public function vendor() {
    //     return $this->hasOne( 'App\Models\Vendor', 'vendorId', 'purchaseVendorId' );
    // }
    // public function modified_users() {
    //     return $this->hasOne( 'App\Models\User', 'userId', 'dealModifiedUserId' );
    // }
    // public function deal_users() {
    //     return $this->hasOne( 'App\Models\User', 'userId', 'dealUserId' );
    // }
    public function deal() {
        return $this->hasOne( 'App\Models\Deal', 'dealId', 'invoiceSoId' );
    }

    public function saleorder() {
        return $this->hasOne( 'App\Models\SalesOrder', 'salesorderId', 'invoiceSoId' );
    }

    public function invoiceItems() {
        return $this->hasMany( 'App\Models\InvoiceItem', 'invoiceItemInvoiceId', 'invoiceId' );
    }

    public function billingState() {
        return $this->hasOne( 'App\Models\State', 'stateCode', 'invoiceBillingState' );
    }

    public function shippingState() {
        return $this->hasOne( 'App\Models\State', 'stateCode', 'invoiceShippingState' );
    }

    public function itemsSum() {

    return $this->hasMany('App\Models\InvoiceItem', 'invoiceItemInvoiceId', 'invoiceId' )
                    ->select(DB::raw('SUM(invoiceItemQuantity*invoiceItemUnitCost) as total'));

}

public function invSum() {

    return $this->hasOne('App\Models\InvoiceItem', 'invoiceItemInvoiceId', 'invoiceId' )
                    ->select(DB::raw('SUM(invoiceItemQuantity*invoiceItemUnitCost) as total'));

}


public function payables() {
    return $this->hasMany( 'App\Models\Payable', 'payableSoId', 'invoiceSoId' );
}

function allsocount(){
    return $this->hasMany('App\Models\Invoice', 'invoiceSoId');
}

    public $timestamps = false;
}
