<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Order extends Model {

    protected $primaryKey = 'orderId';
    protected $table = 'orders';
    protected $fillable = [
        'orderCode', 'orderEmail', 'orderUserId', 'orderSaleRep', 'billingFirstName', 'billingLastName',
        'billingPhone', 'billingEmail', 'billingCompany', 'billingCountry', 'billingCity', 'billingState',
        'billingZipcode', 'billingAddress', 'shippingIsSame', 'shippingFirstName', 'shippingLastName',
        'shippingPhone', 'shippingEmail', 'shippingCompany', 'shippingCountry', 'shippingCity', 'shippingState',
        'shippingZipcode', 'shippingAddress', 'customerPoNumber', 'orderInstructions', 'paymentMethod', 'discountCode',
        'orderSubTotal', 'orderDiscount', 'shippingCost', 'orderTax', 'orderGrandTotal', 'currencyCode', 'currencySymbol',
        'currencyValue', 'paymentStatus', 'delieveryStatus', 'orderConfirmed', 'confirmViaCall', 'orderNote', 'orderIsDeleted',
        'orderCreatedAt', 'orderModifiedAt', 'orderShippingFedExName'
    ];

    public function users() {
        return $this->hasMany( 'App\Models\User', 'userId', 'companyId' );
    }

    // public function restorant() {
    //     return $this->belongsTo( 'App\Restorant' );
    // }

    public $timestamps = false;
}
