<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Purchase extends Model {

    protected $primaryKey = 'purchaseId';
    protected $table = 'purchase';
   protected $fillable = [
    'purchaseVendorId',
    'purchasePrice',
    'purchaseRecieved',
    'purchasePrice',
    'purchaseActualItems',
    'purchaseCount',
    'purchaseGroupBy',
    'purchaseIsDeleted',
    'purchaseEmailCount',
    'purcharseComments',
    'purchaseTracking',
    'purchaseSerial',
    'purchaseTax',
    'purchaseShipping',
    'purchasePyamentCard',
    'purchaseRevised'
];





    public function vendor() {
        return $this->hasOne( 'App\Models\Vendor', 'vendorId', 'purchaseVendorId' );
    }



    // public function modified_users() {
    //     return $this->hasOne( 'App\Models\User', 'userId', 'dealModifiedUserId' );
    // }
    // public function deal_users() {
    //     return $this->hasOne( 'App\Models\User', 'userId', 'dealUserId' );
    // }
    public function item() {
        return $this->hasOne( 'App\Models\DealItem', 'dealItemId', 'purchaseItemId' );     
    }


    public function itemname() {
        return $this->hasOne( 'App\Models\DealItem', 'dealItemId', 'purchaseItemId' )
        ->select('dealItemName');     
    }


    
    public function order() {
        return $this->hasOne( 'App\Models\Deal', 'dealSO', 'purchaseSoId' );
    }

 
    const CREATED_AT = 'purchaseCreatedAt';
    const UPDATED_AT = 'purchaseModifiedAt';
}
