<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class SalesOrder extends Model {

    protected $primaryKey = 'salesorderId';
    protected $table = 'salesorder';
    protected $guarded = [];

    public function created_users() {
        return $this->hasOne( 'App\Models\User', 'userId', 'salesorderCreatedUserId' );
    }
    public function modified_users() {
        return $this->hasOne( 'App\Models\User', 'userId', 'salesorderModifiedUserId' );
    }
    public function customer() {
        return $this->hasOne( 'App\Models\User', 'userId', 'salesorderCustomerId' );
    }
    public function deal() {
        return $this->hasOne( 'App\Models\Deal', 'dealId', 'salesorderDealId' );
    }

    // public function restorant() {
    //     return $this->belongsTo( 'App\Restorant' );
    // }

    public $timestamps = false;
}
