@extends('layouts.app')
@section('leftbar-orders-active', 'active')
@section('after-style')

<script src="https://cdn.ckeditor.com/4.14.0/standard/ckeditor.js"></script>

<style>
</style>
@endsection

@section('content-body')
<div class="content-body">
    <section>

        @if (\Session::has('success'))
        <div class="alert alert-success">
            <ul>
                <li>{!! \Session::get('success') !!}</li>
            </ul>
        </div>
        @endif
        <!-- first card end -->
        <!-- shipping billing card start -->
        <div class="row">
            <div class="col-md-8 offset-md-2">
                <div class="card">
                    <div class="card-content">
                            <h4 class="add_new_cust_heading">Update Company Details</h4>
                        <div class="card-body">
                            <form method="POST" action="{{ route("companies.update", [$company->companyId]) }}" enctype="multipart/form-data">
                                @method('PUT')
                                @csrf
                                <div class="form-body">
                                    <div class="row">
                                        <div class="col-md-7 col-12">
                                            <div class="form-group">
                                                <label for="companyName">Company Name</label>
                                                <input type="text" id="companyName" class="form-control"
                                                    placeholder="Company Name" value="{{ $company->companyName }}" name="companyName" required>
                                            </div>
                                        </div>
                                        <div class="col-md-5 col-12">
                                            <div class="form-group">
                                                <label>Business Type</label>
                                                <fieldset class="form-group mb-0">
                                                    <select class="form-control" id="companyBusinessType" name="companyBusinessType" required>
                                                        @foreach ($businessTypes as $businessType)
                                                        @if ($businessType == $company->companyBusinessType)
                                                        <option value="{{ $businessType }}" selected>
                                                        @else
                                                        <option value="{{ $businessType }}">
                                                        @endif
                                                        {{ $businessType }}
                                                        </option>
                                                    @endforeach

                                                    </select>
                                                </fieldset>
                                            </div>
                                        </div>
                                        <div class="col-md-6 col-12">
                                            <div class="form-group">
                                                <label> Logo URL</label>
                                                <input type="text" id="companyLogo" class="form-control"
                                                    placeholder="Company Logo URL" value="{{ $company->companyLogo }}" name="companyLogo" required>
                                            </div>
                                        </div>

                                        <div class="col-md-6 col-12">
                                            <div class="form-group">
                                                <label> Url</label>
                                                <input type="text" id="companyUrl" class="form-control"
                                                    name="companyUrl" value="{{ $company->companyUrl }}" placeholder="Company Url" required>
                                            </div>
                                        </div>
                                        <div class="col-md-12 col-12">
                                            <div class="form-group">
                                                <label> Address</label>
                                                <textarea id="companyAddress" class="form-control"
                                                    name="companyAddress"  required>{{ $company->companyAddress }}</textarea>
                                            </div>
                                        </div>
                                        <div class="col-md-4 col-12">
                                            <div class="form-group">
                                                <label> Phone</label>
                                                <input type="text" id="companyPhone" class="form-control"
                                                    placeholder="Company Phone" value="{{ $company->companyPhone }}" name="companyPhone" required>
                                            </div>
                                        </div>
                                        <div class="col-md-4 col-12">
                                            <div class="form-group">
                                                <label> Prefix</label>
                                                <input type="text" id="companyPrefix" class="form-control"
                                                    placeholder="Company Prefix" value="{{ $company->companyPrefix }}" name="companyPrefix" required>
                                            </div>
                                        </div>
                                        
                                        <div class="col-md-4 col-12">
                                            <div class="form-group">
                                                <label>Color Code</label>
                                                <input type="color" id="companyColorCode" class="form-control"
                                                    name="companyColorCode" value="{{ $company->companyColorCode }}" placeholder="Company Color Code" required>
                                            </div>
                                        </div>

                                        <div class="col-md-4 col-12">
                                            <div class="form-group">
                                                <label>Currency</label>
                                                <input type="text" id="companyCurrency" class="form-control"
                                                    placeholder="Company Currency" value="{{ $company->companyCurrency }}" name="companyCurrency" required>
                                            </div>
                                        </div>

                                        <div class="col-md-6 col-12">
                                            <div class="form-group">
                                                <label>Country</label>
                                                <fieldset class=" mb-0">
                                                    <select class="form-control" id="companyCountryId" name="companyCountryId" required>
                                                        @foreach ($countries as $country)
                                                            @if ($country->countryId == $company->companyCountryId)
                                                            <option value="{{ $country->countryName }}" selected>
                                                            @else
                                                            <option value="{{ $country->countryId }}">
                                                            @endif
                                                            {{ $country->countryName }}
                                                            </option>
                                                        @endforeach
                                                    </select>
                                                </fieldset>
                                            </div>
                                        </div>

                                        <div class="col-md-12 col-12">
                                            <div class="form-group">
                                                <label>Company Invoice Text</label>
                                                <textarea id="companyInvoiceText"  name="companyInvoiceText"  required>{{ $company->companyInvoiceText }}</textarea>
                                            </div>
                                        </div>

                                    </div>
                                </div>
                                <div class="col-md-8 offset-md-4">
                                    <button type="submit" class="btn submit-btn mr-1 mb-1 waves-effect waves-light">Update</button>
                                    <a href="{{ route('companies.index') }}" class="btn btn-outline-warning mr-1 mb-1 waves-effect waves-light">Back</a>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>

        </div>
        <!-- shipping billing card end -->

    </section>
</div>
@endsection


@section('after-scripts')


<script>

    CKEDITOR.replace("companyInvoiceText");

</script>


@endsection
