
@extends('layouts.app')
@section('leftbar-orders-active', 'active')

@section('content-body')

<div class="content-body">
      

        <div class="modal fade text-left" id="default" tabindex="-1" role="dialog" aria-labelledby="myModalLabel1" aria-hidden="true">
            <div class="modal-dialog modal-dialog-scrollable" role="document">
                <div class="modal-content">
                    <form action="{{ route('create-authorization-link') }}" method="POST">
                        @csrf
                    <div class="modal-header">
                        <h4 class="modal-title" id="myModalLabel1">Generate Credit Card Authorization Form</h4>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <div class="modal-body">
                       
                        <div class="row">
                            <div class="col-md-12 col-12 mb-3">
                                <label for="validationTooltip01">Company Name</label>
                                <input type="text" class="form-control" name="companyName"  required="">
                                
                            </div>
                          
                        </div>
                 
                    </div>
                    <div class="modal-footer">
                        <button type="submit" class="btn btn-primary" >Generate Link</button>

                    </div>
                </form>
                </div>
            </div>
        </div>
        <!-- Basic Modals end -->
    <section id="sale-order-datatable">
       
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-header">
                        <h4 class="card-title">Credit Card Authorizations</h4>
                        <button type="button" class="btn btn-success  waves-effect waves-light float-right btn-sm" data-toggle="modal" data-target="#default"><i class="feather icon-user-plus"></i> </button>
                    </div>
                    <div class="card-content">
                        <div class="card-body card-dashboard">
                            <div class="table-responsive">
                                <table class="table zero-configuration">
                                    <thead>
                                        <tr>
                                            <th>Name</th>
                                            <th>Access Link</th>
                                           
                                            <th>Attachments</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach ($links as $link)
                                            <tr>
                                                <td>{{ $link->companyName }}</td>
                                                <td>http://localhost:7000/credit-card-authorization/{{ $link->slug }} </td>
                                             
                                                <td>
                                                    @if($link->uploadPdf)
                                                    <a href="{{ route('credit-authorizations-attachments', $link->slug) }}" class="btn btn-warning btn-sm mr-1 mb-1 waves-effect waves-light">view</a>
                                                    @else 
                                                    -
                                                    @endif
                                                </td>
                                            </tr>
                                        @endforeach
                                    </tbody>
                                    <tfoot>
                                        <tr>
                                            <th>Name</th>
                                            <th>Access Link</th>

                                            <th>Attachments</th>
                                        </tr>
                                    </tfoot>
                                </table>
                                {{ $links->links('pagination::bootstrap-4') }}
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>
@endsection

@section('after-scripts')
    <script>
        $('#sale-order-datatable').DataTable();
    </script>
@endsection
