@extends('layouts.app')
@section('leftbar-orders-active', 'active')

@section('breadcrumbs')
    <div class="content-header-left col-md-9 col-12 mb-2">
        <div class="row breadcrumbs-top">
            <div class="col-12">
                <h2 class="content-header-title float-left mb-0">Paypal Transaction</h2>
               

            </div>
        </div>
    </div>
 
@endsection

@section('content-body')
@php

$categoryArray = ["INCOME", "PURCHASE", "EXPENSE"];

@endphp
<div class="content-body">
    <section id="sale-order-datatable">
 

       
      
        <div class="modal fade mt-3" id="detailbank" tabindex="-1" role="dialog" aria-labelledby="myModalLabel1" aria-hidden="true">
            <div class="modal-dialog modal-dialog-scrollable modal-lg" role="document">
                <div class="modal-content">
                  
                    <div class="modal-header">
                        <h4 class="modal-title" id="myModalLabel1"></h4>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <div class="modal-body">
                        <div class="table-responsive" >
                            <table class="table zero-configuration">
    
                            
                                <tbody id="detail-invoices">
        
        
                            </table>
                        </div>
                        <div id="code-input" class="text-center">
                           
                        </div>
                        <div class="modal-footer" id="modal-footer-detail">
                        </div>
                    </div>
                    
                </div>
            </div>
        </div>
        
       
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-header">
                        <h4 class="card-title">Paypal ~ <span>{{ $transactions[0]->gateway->paymentGatewayName }}</span></h4>
                      
                    </div>
                    <div class="card-content">
                        <div class="card-body card-dashboard">
                            <div class="table-responsive">
                                <table class="table zero-configuration">
                                    <thead>
                                        <tr>
                                            <th>Date</th>
                                            <th>Description</th>
                                            <th>Category</th>
                                            <th>Gross Amount</th>
                                            <th>Paypal Charges</th>
                                            <th>Debit</th>
                                            <th>Credit</th>
                                            <th>Allocation</th>
                                            <th>Refrence</th>
                                            <th></th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach ($transactions as $transaction)
                                            <tr>
                                                @php 
                                                $date = date_create($transaction->paypalPaymentDate);
                                                @endphp
                                                <td>{{ date_format($date,"M d,Y") }}</td>
                                                <td>{{ $transaction->paypalPaymentDescription}}</td>
                                                <td>{{ $transaction->paypalPaymentCategory}}</td>
                                                <td>{{ auth()->user()->company->companyCurrency.''.$transaction->paypalTotalCharges}}</td>
                                                <td>{{ auth()->user()->company->companyCurrency.''.$transaction->paypalPaymentCharges}}</td>
                                                <td>@if($transaction->paypalPaymentDebit){{ auth()->user()->company->companyCurrency.''.$transaction->paypalPaymentDebit }}@else - @endif</td>
                                                <td>@if($transaction->paypalPaymentCredit){{ auth()->user()->company->companyCurrency.''.$transaction->paypalPaymentCredit }}@else - @endif</td>
                                                <td>{{ $transaction->paypalPaymentAllocation }}</td>
                                                <td>{!! $transaction->paypalPaymentReference !!}</td>
                                                <td>
                                                   

                                                    <div class="btn-dropdown mr-1 mb-1">
                                                        <div class="btn-group dropdown actions-dropodown">
                                                            <button type="button"
                                                                class="btn btn-white px-1 py-1 dropdown-toggle waves-effect waves-light text-bold-600"
                                                                data-toggle="dropdown" aria-haspopup="true"
                                                                aria-expanded="false">
                                                                
                                                            </button>
                                                            <div class="dropdown-menu">
                                                           
                                                                <!-- <a class="dropdown-item" href="#"><i
                                                                        class="feather icon-file"></i>Archive</a> -->
{{--                                                                 
                                                                    <a class="dropdown-item" href="javascript:void(0)" data-toggle="modal" data-target="#editbank{{$transaction->paypalPaymentId}}" 
                                                                        >edit</a> --}}
                                                                        @if($transaction->paypalPaymentDetail)
                                                                    <a class="dropdown-item" href="javascript:void(0)" onclick="getBankDetails('{{$transaction->paypalPaymentId}}')" data-toggle="modal" data-backdrop="false" data-target="#detailbank"
                                                                        >Details</a>
                                                                        @endif
                                                            </div>

                                                    <div class="modal fade mt-3" id="editbank{{ $transaction->paypalPaymentId}}" tabindex="-1" role="dialog" aria-labelledby="myModalLabel1" aria-hidden="true">
                                                        <div class="modal-dialog modal-dialog-scrollable" role="document">
                                                            <div class="modal-content">
                                                                <form action="" method="POST">
                                                                    @csrf
                                                                <div class="modal-header">
                                                                    <h4 class="modal-title" id="myModalLabel1">Detail</h4>
                                                                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                                        <span aria-hidden="true">&times;</span>
                                                                    </button>
                                                                </div>
                                                                <div class="modal-body">
                                                                    <div class="row">
                                                                        <div class="col-md-12 mb-1">
                                                                            <label>Category</label>
                                                                            <select name="paypalPaymentCategory" class="form-control" >
                                                                           
                                                                                @foreach($categoryArray as $ca)
                                                                                <option value="{{ $ca }}" @if($transaction->paypalPaymentCategory == $ca) selected @endif>{{ $ca }}</option>
                                                                                @endforeach
                                                                            </select>
                                                                        </div>
                                                                        <div class="col-md-12 mb-1">
                                                                            <label>Allocation</label>
                                                                            <input type="text" name="paypalPaymentAllocation" required class="form-control" value="{{ $transaction->paypalPaymentAllocation }}" />
                                                                        </div>
                                                                        <div class="col-md-12 mb-1">
                                                                            <label>Refrence</label>
                                                                            <input type="text" name="paypalPaymentRefrence" required class="form-control" value="{{ $transaction->paypalPaymentReference }}" />
                                                                        </div>
                                                                        <div class="col-md-12">
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                                <div class="modal-footer">
                                                                    <button type="submit" class="btn btn-primary" >update</button>
                                                                </div>
                                                             </form>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    </td>
                                            </tr>
                                        @endforeach
                                    </tbody>
                                 
                                </table>
                                {{ $transactions->appends(request()->input())->links('pagination::bootstrap-4') }}

                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>
@endsection

@section('after-scripts')
    <script>
         $("#selected_bank").change(function() {
     this.form.submit();
});



function getBankDetails(reportCardId){
 
 
 
 $.ajaxSetup({
 headers: {
   'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
 }
 
 });
 
 $.ajax({
 type: "GET", 
 url: '/reporting/paypal/detail/'+reportCardId,
 beforeSend: function() {
   
   $("#detail-invoices").empty();
   $("#detail-invoices").text('loading...');
 
 },
 success: function(data) {
  
 $("#detail-invoices").empty();
 $("#detail-invoices").html(data);
 $("#modal-footer-detail").empty();
 $('#modal-footer-detail').html(`<button type="button" class="btn btn-danger" onclick="deleteTransaction(${reportCardId})">Delete Transaction</button>`)
 
 $("#code-input").empty();
 
 
 }
 });
 }
 
 
 const deleteTransaction = (reportBankId) => {
     $("#modal-footer-detail").empty();
 
     $('#code-input').html(` <h4>To confirm the deletion of this transaction, please type "DELETE". Please note that this action is irreversible. </h4>
                             <input type="text" id="code" onpaste="return false;" autocomplete="off" />
                             <input type="button" value="Confirm" class="btn btn-danger btn-sm" onclick="verifyCode(${reportBankId})"/>`)
     
 }
 
 const verifyCode = (reportBankId) => {
     
    
   var codeInput = $("#code").val();
   if (codeInput === "DELETE") {
     // Code is correct, proceed with delete action
    
     $.ajax({
                 url: '/reporting/paypal/delete-transaction/' + reportBankId,
                 type: 'DELETE',
                 data: {
                     _token: $('meta[name="csrf-token"]').attr('content')
                 },
                 success: function(response) {
                    // window.location.reload()
                     alert('Deleted, please close the tab!')
                 },
                 error: function(xhr) {
                     console.log(xhr.responseText);
                 }
             });
     // perform delete action here
   } else {
     // Code is incorrect, show error message
     alert("Incorrect code. Please try again.");
   }
   codeInput = ""; // Clear input field
 
 }
 
 



$(document).ready(function($) {
    $('#addpayable').on('submit', function(evt) {
        $('#addpayablebtn').remove();
    });
});

    </script>
@endsection
