@extends('layouts.app')
@section('leftbar-orders-active', 'active')

@section('breadcrumbs')
    <div class="content-header-left col-md-9 col-12 mb-2">
        <div class="row breadcrumbs-top">
            <div class="col-12">
                <h2 class="content-header-title float-left mb-0">Bank Transactions</h2>
               

            </div>
        </div>
    </div>
 
@endsection

@section('content-body')
@php

$categoryArray = ["INCOME", "PURCHASE", "EXPENSE"];

@endphp
<div class="content-body">
    <section id="sale-order-datatable">
        <div class="modal fade mt-3" id="detailbank" tabindex="-1" role="dialog" aria-labelledby="myModalLabel1" aria-hidden="true">
            <div class="modal-dialog modal-dialog-scrollable modal-lg" role="document">
                <div class="modal-content">
                  
                    <div class="modal-header">
                        <h4 class="modal-title" id="myModalLabel1"></h4>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <div class="modal-body">
                        <div class="table-responsive" >
                            <table class="table zero-configuration">
    
                            
                                <tbody id="detail-invoices">
        
        
                            </table>
                        </div>
                        <div id="code-input" class="text-center">
                           
                        </div>
                        <div class="modal-footer" id="modal-footer-detail">
                        </div>
                    </div>
                    
                </div>
            </div>
        </div>
        
        <div class="row">
            
                <div class="card">
                    <div class="card-header">
                        <h4 class="card-title">Credit Card ~ <span></span></h4>
                       
                    </div>
                    <div class="card-content">
                        <div class="card-body card-dashboard">
                            <div class="table-responsive">
                                <table class="table zero-configuration">
                                    <thead>
                                        <tr>
                                            <th>Date</th>
                                            <th>Description</th>
                                            <th>Category</th>
                                            <th>Debit</th>
                                            <th>Credit</th>
                                            <th>Allocation</th>
                                            <th>Refrence</th>
                                            <th></th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach ($transactions as $transaction)
                                            <tr>
                                                @php 
                                                $date = date_create($transaction->reportingccDate);
                                                @endphp
                                                <td>{{ date_format($date,"M d,Y") }}</td>
                                                <td>{{ $transaction->reportingccDescription}}</td>
                                                <td>{{ $transaction->reportingccCategory}}</td>
                                                <td>@if($transaction->reportingccDebit){{ auth()->user()->company->companyCurrency.''.$transaction->reportingccDebit }}@else - @endif</td>
                                                <td>@if($transaction->reportingccCredit){{ auth()->user()->company->companyCurrency.''.$transaction->reportingccCredit }}@else - @endif</td>
                                                <td>{{ $transaction->reportingccAllocation }}</td>
                                                <td>{!! $transaction->reportingccReference !!}</td>
                                                <td>
                                                   

                                                    <div class="btn-dropdown mr-1 mb-1">
                                                        <div class="btn-group dropdown actions-dropodown">
                                                            <button type="button"
                                                                class="btn btn-white px-1 py-1 dropdown-toggle waves-effect waves-light text-bold-600"
                                                                data-toggle="dropdown" aria-haspopup="true"
                                                                aria-expanded="false">
                                                                
                                                            </button>
                                                            <div class="dropdown-menu">
                                                           
                                                                <!-- <a class="dropdown-item" href="#"><i
                                                                        class="feather icon-file"></i>Archive</a> -->
                                                                
                                                                    
                                                                        @if($transaction->reportingccDetail)
                                                                    <a class="dropdown-item" href="javascript:void(0)" onclick="getBankDetails({{$transaction->reportingccId}})" data-toggle="modal" data-backdrop="false" data-target="#detailbank"
                                                                        >Details</a>
                                                                        @endif
                                                                       
                                                            </div>

                                                  
                                                    </td>
                                            </tr>
                                        @endforeach
                                    </tbody>
                                    <tfoot>
                                        <tr>
                                            <th>Date</th>
                                            <th>Description</th>
                                            <th>Category</th>
                                            <th>Debit</th>
                                            <th>Credit</th>
                                            <th>Allocation</th>
                                            <th>Refrence</th>
                                            <th></th>
                                        </tr>
                                    </tfoot>
                                </table>
                                {{ $transactions->appends(request()->input())->links('pagination::bootstrap-4') }}

                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>
@endsection

@section('after-scripts')
    <script>
 



function getBankDetails(reportCardId){



$.ajaxSetup({
headers: {
  'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
}

});

$.ajax({
type: "GET", 
url: '/reporting/card/detail/'+reportCardId,
beforeSend: function() {
  
  $("#detail-invoices").empty();
  $("#detail-invoices").text('loading...');

},
success: function(data) {
 
$("#detail-invoices").empty();
$("#detail-invoices").html(data);
$("#modal-footer-detail").empty();
$('#modal-footer-detail').html(`<button type="button" class="btn btn-danger" onclick="deleteTransaction(${reportCardId})">Delete Transaction</button>`)

$("#code-input").empty();


}
});
}


const deleteTransaction = (reportBankId) => {
    $("#modal-footer-detail").empty();

    $('#code-input').html(` <h4>To confirm the deletion of this transaction, please type "DELETE". Please note that this action is irreversible. </h4>
                            <input type="text" id="code" onpaste="return false;" autocomplete="off" />
                            <input type="button" value="Confirm" class="btn btn-danger btn-sm" onclick="verifyCode(${reportBankId})"/>`)
    
}

const verifyCode = (reportBankId) => {
    
   
  var codeInput = $("#code").val();
  if (codeInput === "DELETE") {
    // Code is correct, proceed with delete action
   
    $.ajax({
                url: '/reporting/card/delete-transaction/' + reportBankId,
                type: 'DELETE',
                data: {
                    _token: $('meta[name="csrf-token"]').attr('content')
                },
                success: function(response) {
                    window.location.reload()
                    
                },
                error: function(xhr) {
                    console.log(xhr.responseText);
                }
            });
    // perform delete action here
  } else {
    // Code is incorrect, show error message
    alert("Incorrect code. Please try again.");
  }
  codeInput = ""; // Clear input field

}



    </script>
@endsection
